/* logout.c - Panel applet to end current session.  */

#include "gnome.h"
#include "../panel_cmds.h"
#include "../applet_cmds.h"
#include "../panel.h"

#define APPLET_ID "Logout"

static PanelCmdFunc panel_cmd_func;

static void
logout (GtkWidget *widget, gpointer data)
{
  PanelCommand cmd;

  cmd.cmd = PANEL_CMD_QUIT;
  (*panel_cmd_func) (&cmd);
}

static void
destroyed (GtkWidget *widget, gpointer data)
{
  /* Nothing for now.  */
}

static void
create_instance (Panel *panel, char *params, int xpos, int ypos)
{
  PanelCommand cmd;
  GtkWidget *button;
  GtkWidget *pixmap;
  char *pixmap_name;
  
  pixmap_name=gnome_unconditional_pixmap_file("gnome-term-night.xpm");

  if(!pixmap_name)
    button = gtk_button_new_with_label (_("Log out"));
  else {
    button = gtk_button_new ();
    pixmap = gnome_create_pixmap_widget(panel->window,
				        button,
				        pixmap_name);
    g_free(pixmap_name);
    gtk_container_add(GTK_CONTAINER(button),pixmap);
    gtk_widget_show(pixmap);
  }

  gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (logout), NULL);
  gtk_signal_connect (GTK_OBJECT (button), "destroy", GTK_SIGNAL_FUNC (destroyed), NULL);

  cmd.cmd = PANEL_CMD_REGISTER_TOY;
  cmd.params.register_toy.applet = button;
  cmd.params.register_toy.id     = APPLET_ID;
  cmd.params.register_toy.xpos   = xpos;
  cmd.params.register_toy.ypos   = ypos;
  cmd.params.register_toy.flags  = APPLET_HAS_PROPERTIES;

  (*panel_cmd_func) (&cmd);


  cmd.cmd = PANEL_CMD_SET_TOOLTIP;
  cmd.params.set_tooltip.applet  = button;
  cmd.params.set_tooltip.tooltip = _("Log out");

  (*panel_cmd_func) (&cmd);
}

gpointer
applet_cmd_func (AppletCommand *cmd)
{
  g_assert (cmd != NULL);

  switch (cmd->cmd)
    {
    case APPLET_CMD_QUERY:
      return APPLET_ID;

    case APPLET_CMD_INIT_MODULE:
      panel_cmd_func = cmd->params.init_module.cmd_func;
      break;

    case APPLET_CMD_DESTROY_MODULE:
      break;

    case APPLET_CMD_GET_DEFAULT_PARAMS:
      return g_strdup("");

    case APPLET_CMD_CREATE_INSTANCE:
      create_instance (cmd->panel,
		       cmd->params.create_instance.params,
		       cmd->params.create_instance.xpos,
		       cmd->params.create_instance.ypos);
      break;

    case APPLET_CMD_GET_INSTANCE_PARAMS:
      return g_strdup("");

    case APPLET_CMD_ORIENTATION_CHANGE_NOTIFY:
      break;

    case APPLET_CMD_PROPERTIES:
      /* Any properties here?  Maybe the actual text?  */
      break;

    default:
      fprintf(stderr,
	      APPLET_ID " applet_cmd_func: Oops, unknown command type %d\n",
	      (int) cmd->cmd);
      break;
    }

  return NULL;
}
