/*
 * $Id: network_panel.c,v 1.7 1998/05/25 18:32:01 gregm Exp $
 * GXSNMP - An snmp managment application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Network list panel
 */
#ifndef lint
static char const copyright[] =
"@(#) Copyright (c) 1998 Gregory McLean";
#endif
static char const rcsid[] =
 "$Id: network_panel.c,v 1.7 1998/05/25 18:32:01 gregm Exp $";

#include <sys/types.h>
#include <gtk/gtk.h>
#include "main.h"
#include "network_panel.h"
#include "gui.h"

extern gxsnmp *app_info;

/*
 * Local variables for the network list panel
 *
 */
static netwk_panel    *net_list_panel = NULL;

static char *list_labels[] = {
  N_("Network"),
  N_("Broadcast"),
  N_("CIDR"),
  N_("Mask"),
  N_("Available Hosts"),
  N_("Active Hosts")
};

static int col_sizes [ELEMENTS (list_labels)];
#define PADDING 40

/*
 * Forward declarations for the network panel
 */
static void           create_net_list_panel        (void);
static gint           delete_net_list_panel        (GtkWidget    *widget,
						    GdkEvent     *e,
						    gpointer     data);
static void           close_net_list_cb            (GtkWidget    *widget,
						    gpointer     data);
static void           refresh_net_list_cb          (GtkWidget    *widget,
						    gpointer     data);

static void
create_net_list_panel ()
{
  GtkWidget    *button;
  GtkWidget    *frame;
  GtkWidget    *scrolled_window;
  GtkWidget    *w_box;
  GtkWidget    *table;
  GtkWidget    *bar;
  GtkWidget    *label;
  GtkWidget    *button_box;
  int          i, tmp;

  net_list_panel = (netwk_panel *)g_malloc (sizeof(netwk_panel));

  net_list_panel->window = gnome_app_new ("GXSNMP", _("Network List"));
  gtk_signal_connect (GTK_OBJECT (net_list_panel->window),
		      "delete_event",
		      GTK_SIGNAL_FUNC (delete_net_list_panel),
		      NULL);
  w_box = gtk_vbox_new (FALSE, 2);

  label = gtk_label_new (_("Known Networks"));
  gtk_box_pack_start (GTK_BOX (w_box), label, FALSE, FALSE, 0);

  bar = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (w_box), bar, FALSE, FALSE, 2);
  table = gtk_table_new (3, 3, FALSE);
  gtk_box_pack_start (GTK_BOX (w_box), table, TRUE, TRUE, 2);

  /*
   * Compute the minimum size needed to display xxx.xxx.xxx.xxx
   * plus some padding. 18 chars... The ip address + a space on either side
   */
  tmp = gdk_text_width (table->style->font,
			"1", 1);
  tmp = tmp * 18;                        
  for ( i = 0; i < ELEMENTS (list_labels); i++)
    {
      list_labels[i] = strdup (gettext(list_labels[i]));
      col_sizes[i] = MAX (tmp, gdk_string_width (label->style->font,
						 list_labels[i]));
#ifdef DEBUG_LAYOUT
      g_print ("Width of col %d is %d\n", i, col_sizes[i]);
#endif
    }
  net_list_panel->net_clist = gtk_clist_new_with_titles 
    (ELEMENTS (list_labels), list_labels);
  gtk_clist_column_titles_passive (GTK_CLIST (net_list_panel->net_clist));
  tmp = 0;
  for ( i = 0; i < ELEMENTS (list_labels); i++)
    {
      gtk_clist_set_column_width (GTK_CLIST (net_list_panel->net_clist), 
				  i, (col_sizes[i]));
      /*
       * Now we can compute the size of the window (to be able to at least
       * see most of the clist...
       */
      tmp += col_sizes[i];
    }
  gtk_widget_set_usize (net_list_panel->window, tmp + PADDING, 200);
  gtk_table_attach (GTK_TABLE (table), net_list_panel->net_clist, 0, 1, 0, 3,
		    GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 1);
  bar = gtk_vseparator_new ();
  gtk_table_attach (GTK_TABLE (table), bar, 1, 2, 0, 3,
		    GTK_FILL , GTK_FILL | GTK_EXPAND, 2, 1);
  button = gtk_button_new_with_label ("Layout");
  gtk_table_attach (GTK_TABLE (table), button,
		    2, 3, 0, 1,
		    GTK_FILL | GTK_SHRINK, GTK_SHRINK, 2, 1);
  button = gtk_button_new_with_label ("Layout #2");
  gtk_table_attach (GTK_TABLE (table), button,
		    2, 3, 1, 2,
		    GTK_FILL | GTK_SHRINK, GTK_SHRINK, 2, 1);
  button = gtk_button_new_with_label ("Layout #3");
  gtk_table_attach (GTK_TABLE (table), button,
		    2, 3, 2, 3,
		    GTK_FILL | GTK_SHRINK, GTK_SHRINK, 2, 1);
  bar = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (w_box), bar, FALSE, FALSE, 0);
  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (w_box), frame, FALSE, FALSE, 0);
  button_box = gtk_hbutton_box_new ();
  gtk_container_border_width (GTK_CONTAINER (button_box), 2);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (button_box), 3);
  gtk_container_add (GTK_CONTAINER (frame), button_box);
  button = gnome_stock_button (GNOME_STOCK_BUTTON_CLOSE);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (close_net_list_cb),
		      NULL);
  gtk_container_add (GTK_CONTAINER (button_box), button);
  gnome_app_set_contents (GNOME_APP (net_list_panel->window), w_box);
  gtk_widget_show_all (net_list_panel->window);
}

/*
 * Callback functions
 */
static void
close_net_list_cb (GtkWidget *widget, gpointer data)
{
  gtk_widget_hide (net_list_panel->window);
}

static void 
refresh_net_list_cb (GtkWidget *widget, gpointer data)
{
}

static gint
delete_net_list_panel (GtkWidget *widget, GdkEvent *e, gpointer data)
{
  if (net_list_panel)
    {
      gtk_widget_destroy (net_list_panel->window);
      g_free (net_list_panel);
      net_list_panel = NULL;
    }
  return TRUE;
}
/*
 * Global Standard panel functions.
 */
void
open_network_panel ()
{
  if (net_list_panel == NULL)
    create_net_list_panel ();
  else if (!GTK_WIDGET_VISIBLE (net_list_panel->window))
    gtk_widget_show (net_list_panel->window);
  reset_network_panel ();
}

void
destroy_network_panel ()
{
  if (net_list_panel != NULL)
    delete_net_list_panel (NULL, NULL, net_list_panel);
}

void
hide_network_panel ()
{
  if (net_list_panel->window)
    if (GTK_WIDGET_VISIBLE (net_list_panel->window))
      gtk_widget_hide (net_list_panel->window);
}

void
reset_network_panel ()
{
  refresh_net_list_cb (NULL, net_list_panel);
}

/*
 * Add network panel
 */

/*
 * Global panel functions (add network)
 */
void 
open_add_net_panel ()
{
}

void 
destroy_add_net_panel ()
{
}

void
hide_add_net_panel ()
{
}

void 
reset_add_net_panel ()
{
}

/* EOF */



