/*
 * KHeiseReg
 *
 * A utility to search for articles within the Heise register.
 *
 * Copyright (C) 2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KHEISEREG_H
#define KHEISEREG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qwidget.h>
#include <qstring.h>

#include <kmainwindow.h>
#include <kconfig.h>
#include <kaction.h>

#include "kheiseview.h"
#include "searchdlg.h"
#include "regfile.h"



class KHeiseReg: public KMainWindow
{
	Q_OBJECT
public:
	KHeiseReg(QWidget *parent = 0, const char *name = 0);
	virtual ~KHeiseReg();

protected:
	void readOptions();

	void initActions();
	void initMenuBar();
	void initToolBar();
	void initStatusBar();
	
public slots:
	void slotFileOpen();
	void slotFileQuit();
	
	void slotSearchSearch();

	void slotSettingsShowToolbar();
	void slotSettingsShowStatusbar();
	void slotSettingsSaveOptions();
	void slotSettingsConfigure();
		
	void slotStatusMsg(const QString &text);
	void slotStatusHelpMsg(const QString &text);
	void slotStatusItems(int items);

	void slotSearch(const RegMask &mask);


private:
	KConfig *config;

	KAction *fileOpen, *fileQuit;
	KAction *searchSearch;
	KToggleAction *settingsShowToolbar, *settingsShowStatusbar;
	KAction *settingsSaveOptions, *settingsConfigure;

	KHeiseView *view;
	SearchDlg *searchdlg;
};

#endif // KHEISEREG_H
