/*
 * KHeiseReg
 *
 * A utility to search for articles within the Heise register.
 *
 * Copyright (C) 2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CONFIGURE_H
#define CONFIGURE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qwidget.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qslider.h>

#include <kconfig.h>
#include <kdialogbase.h>


class Configure: public KDialogBase
{
	Q_OBJECT
public:
	Configure(QWidget *parent = 0, const char *name = 0);
	~Configure();

protected:
	void reset();

protected slots:
	virtual void accept();
	virtual void slotDefault();
	virtual void slotApply();

private slots:
	void slotFuzzyToggled(bool on);
	void slotBrowseMountPt();
	void slotExternalToggled(bool on);

private:
	KConfig *config;

	QCheckBox *gen_tooltips;

	QLineEdit *sea_bywords, *sea_authors, *sea_editors, *sea_editions, *sea_years;
	QCheckBox *sea_ctmag, *sea_ixmag, *sea_case_sensitive, *sea_fuzzy;
	QLabel *sea_min_threshold, *sea_max_threshold;
	QSlider *sea_threshold;

	QLineEdit *net_cturl, *net_ixurl;

	QLineEdit *ctrom_mountpt, *ctrom_browsercom;
	QCheckBox *ctrom_extbrowser;
};


#endif // CONFIGURE_H
