


#include <qcstring.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <qcanvas.h>
#include "qcanvasellipse_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QCanvasEllipseImp::QCanvasEllipseImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QCanvasEllipseImp::~QCanvasEllipseImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void QCanvasEllipseImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasEllipseImp *meth = new QCanvasEllipseImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void QCanvasEllipseImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_width_5, "width" },
        { Method_height_6, "height" },
        { Method_setSize_7, "setSize" },
        { Method_setAngles_8, "setAngles" },
        { Method_angleStart_9, "angleStart" },
        { Method_angleLength_10, "angleLength" },
        { Method_areaPoints_11, "areaPoints" },
        { Method_collidesWith_12, "collidesWith" },
        { Method_rtti_13, "rtti" },
	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasEllipseImp *meth = new QCanvasEllipseImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a QCanvasEllipse pointer from an Object.
 */
QCanvasEllipse *QCanvasEllipseImp::toQCanvasEllipse( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        QObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<QCanvasEllipse *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "QCanvasEllipse" )
        return 0;

    return op->toNative<QCanvasEllipse>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object QCanvasEllipseImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasEllipse_1:
             return QCanvasEllipse_1( exec, args );
             break;

         case Constructor_QCanvasEllipse_2:
             return QCanvasEllipse_2( exec, args );
             break;

         case Constructor_QCanvasEllipse_3:
             return QCanvasEllipse_3( exec, args );
             break;

         default:
             break;
    }

    QString msg = i18n("QCanvasEllipseCons has no constructor with id '%1'.").arg(id);
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Object QCanvasEllipseImp::QCanvasEllipse_1( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter QCanvas *
    return KJS::Object();

    QCanvas * arg0; // Dummy


    // We should now create an instance of the QCanvasEllipse object

    QCanvasEllipse *ret = new QCanvasEllipse(

          arg0 );


}

KJS::Object QCanvasEllipseImp::QCanvasEllipse_2( KJS::ExecState *exec, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

    // Unsupported parameter QCanvas *
    return KJS::Object();

    QCanvas * arg2; // Dummy


    // We should now create an instance of the QCanvasEllipse object

    QCanvasEllipse *ret = new QCanvasEllipse(

          arg0,
          arg1,
          arg2 );


}

KJS::Object QCanvasEllipseImp::QCanvasEllipse_3( KJS::ExecState *exec, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

    int arg3 = extractInt(exec, args, 3);

    // Unsupported parameter QCanvas *
    return KJS::Object();

    QCanvas * arg4; // Dummy


    // We should now create an instance of the QCanvasEllipse object

    QCanvasEllipse *ret = new QCanvasEllipse(

          arg0,
          arg1,
          arg2,
          arg3,
          arg4 );


}

KJS::Value QCanvasEllipseImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QCanvasEllipseImp::toQCanvasEllipse( self );

    switch( id ) {

    case Method_width_5:
        return width_5( exec, self, args );
        break;

    case Method_height_6:
        return height_6( exec, self, args );
        break;

    case Method_setSize_7:
        return setSize_7( exec, self, args );
        break;

    case Method_setAngles_8:
        return setAngles_8( exec, self, args );
        break;

    case Method_angleStart_9:
        return angleStart_9( exec, self, args );
        break;

    case Method_angleLength_10:
        return angleLength_10( exec, self, args );
        break;

    case Method_areaPoints_11:
        return areaPoints_11( exec, self, args );
        break;

    case Method_collidesWith_12:
        return collidesWith_12( exec, self, args );
        break;

    case Method_rtti_13:
        return rtti_13( exec, self, args );
        break;

    default:
        break;
    }

    QString msg = i18n( "QCanvasEllipseImp has no method with id '%1'." ).arg( id );
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Value QCanvasEllipseImp::width_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->width(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasEllipseImp::height_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->height(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasEllipseImp::setSize_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->setSize(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasEllipseImp::setAngles_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->setAngles(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasEllipseImp::angleStart_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->angleStart(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasEllipseImp::angleLength_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->angleLength(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasEllipseImp::areaPoints_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->areaPoints(  );
      return KJS::Value(); // Returns 'QPointArray'

}

KJS::Value QCanvasEllipseImp::collidesWith_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter const QCanvasItem *
    return KJS::Value();

    const QCanvasItem * arg0; // Dummy

      bool ret;
      ret = instance->collidesWith(
       arg0 );
      return KJS::Boolean( ret );

}

KJS::Value QCanvasEllipseImp::rtti_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->rtti(  );
      return KJS::Number( ret );

}


} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


