.\" $XFree86: xc/programs/makepsres/makepsres.man,v 1.3 2006/01/09 15:00:47 dawes Exp $
.TH MAKEPSRES 1 "13 May 1993" "Adobe Systems"
.SH NAME
makepsres \- Build PostScript resource database file.

.SH SYNOPSIS
.B makepsres
[
.I options
]
.I directory ...

.SH DESCRIPTION
.B makepsres
creates PostScript language resource database files.
Resource database files can be used to 
specify the location of resources that are used by the font selection 
panel and other Adobe software.
For a complete description of the 
resource location facilities in the Display PostScript system,
see Appendix A and Appendix B of "Display PostScript Toolkit
for X" in \fIProgramming the Display PostScript System with X.\fR
.LP
.B makepsres
creates a resource database file named 
.I PSres.upr
that contains all the resources in all the
.I directory
path names specified on the command line.
.RS .25in
.LP
If the list of directories contains 
.B \- , 
.B makepsres 
reads from 
.I stdin
and expects a list of directories separated by space, tab, or newline.
.LP
If the list of directories is empty, it is taken to be the current directory. 
.LP
If all specified directories have a common initial prefix, 
.B makepsres 
extracts it as a directory prefix in the new resource database file.
.RE
.LP
.B makepsres
normally acts recursively; it looks for resource files in subdirectories of 
any specified directory. This behavior can be overridden with the command 
line option 
.B \-nr.
.LP 
.B makepsres 
uses existing resource database files to assist in identifying files. By 
default, 
.B makepsres 
creates a new resource database file containing all of the 
following that apply:
.RS .25in
.LP
Resource files found in the directories on the command line.
.LP
Resource files pointed to by the resource database files in the directories on 
the command line.
.LP
Resource entries found in the input resource database files. These entries are 
copied if the files they specify still exist and are located in directories not 
specified on the command line.
.RE
.LP
If you run 
.B makepsres 
in discard mode (with the 
.B \-d 
option), it 
does not copy resource entries from the input resource database files. In that case, 
the output file consists only of entries from the directories on the command line. 
The input resource database files are only used to assist in identifying files. 
.LP
If you run 
.B makepsres 
in keep mode (with the 
.B \-k 
option), it 
includes in the output file all resource entries in the input resource database files, 
even entries for files that no longer exist or are located in directories specified on 
the command line.
.LP
.B makepsres
uses various heuristics to identify files. A file that is of a private 
resource type or that does not conform to the standard format for a resource file 
must be specified in one of the following ways:
.RS .25in
.LP
By running 
.B makepsres 
in interactive mode
.LP
By preloading the file into a resource database
file used for input
.LP
By beginning the file with the following line:
.LP
.RS .25in
%!PS-Adobe-3.0 Resource-<resource-type>
.RE
.RE

.SH OPTIONS
.TP
.BI \-o " filename"
Writes the output to the specified filename.
The construction "\fB\-o \-\fR"
writes to stdout. If the 
.B \-o 
option is not specified, 
.B makepsres 
creates a 
.I PSres.upr
file in the current directory 
and writes the output to that file.
.TP
.BI \-f " filename"
Uses information from the specified file to assist in resource typing. 
The file must be in resource database file format.
Multiple
.B \-f
options may be specified. The construction "\fB\-f \-\fR"
uses 
.I stdin
as an input file and may not be used if "\fB\-\fR"
is specified as a directory on the command line.
.TP
.BI \-dir " dirname"
Specifies that 
.I dirname
is a directory. Needed only in rare cases when
.I dirname
is the same as a command-line option such as 
.B \-nb.
.TP
.B \-d
Specifies discard mode. The resulting output file consists solely 
of entries from the directories on the command line.
.TP
.B \-e
Marks the resulting 
.I PSres.upr
file as exclusive.  This option 
makes the resource location library run more quickly since it does not have to 
look for other resource database files. It becomes necessary, however, to run 
.B makepsres 
whenever new resources are added to the directory, even if the 
resources come with their own resource database file.
.TP
.B \-i
Specifies interactive mode. In interactive mode, you
will be queried for the resource type of any encountered
file that
.B makepsres
cannot identify.  If
.B \-i
is not specified,
.B makepsres
assumes an unidentifiable file is not a resource file.
.TP
.B \-k
Specifies keep mode.
.TP
.B \-nb
If the output file already exists, do not back it up.
.TP
.B \-nr
Specifies nonrecursive mode. 
.B makepsres
normally acts recursively: it looks for 
resource files in subdirectories of any specified directory. If 
.B \-nr
is used, 
.B makepsres 
does not look in subdirectories for resource files.
.TP
.B \-p
Specifies no directory prefix.  If
.B \-p
is used,
.B makepsres
does not try to find a common directory prefix among the specified directories.
.TP
.B \-q
Quiet mode: ignores unidentifiable files instead of warning about them.
.TP
.B \-s
Specifies strict mode.  If
.B \-s
is used,
.B makepsres
terminates with an error if it encounters a file it cannot identify.

.SH EXAMPLES
.TP
.B "makepsres ."
Creates a resource database file that contains all the
resources in the current directory.
.TP
.B "makepsres \-i \-o local.upr /usr/local/lib/ps/fonts"
Runs 
.B makepsres
in interactive mode and creates a resource database file named
.I local.upr,
which contains all the resources in the directory
.I /usr/local/lib/ps/fonts.

.SH SEE ALSO
.LP
\fIProgramming the Display PostScript System with X\fR
(Addison-Wesley Publishing Company, Inc., 1993).

.SH AUTHOR
Adobe Systems Incorporated

.SH NOTES
PostScript and Display PostScript are trademarks
of Adobe Systems Incorporated which may be registered
in certain jurisdictions.
.LP
Copyright (c) 1989-1994 Adobe Systems Incorporated.  All rights reserved.

