#include <stdio.h>
#include <stdlib.h>
#include <openssl/lhash.h>
#include <openssl/bn.h>
#include <openssl/err.h>
#include <openssl/pem.h>
#include <openssl/x509.h>
#include <openssl/ssl.h>

static SSL_CTX *tls_ctx = NULL;
static SSL *tls_conn = NULL;

static int
tls_ssl_ctx_new (cert_file, key_file)
  const char *cert_file, *key_file;
{
  SSL_load_error_strings ();
  SSLeay_add_ssl_algorithms ();

  tls_ctx = SSL_CTX_new (TLSv1_client_method());
  if (!tls_ctx)
    return -1;

  SSL_CTX_set_options (tls_ctx, SSL_OP_ALL /* Work around all known bugs */); 

  if (cert_file)
    {
      if (SSL_CTX_use_certificate_file (tls_ctx, cert_file, 
					SSL_FILETYPE_PEM) <= 0)
	return -1;
      if (!key_file)
	key_file = cert_file;
      if (SSL_CTX_use_PrivateKey_file (tls_ctx, key_file, 
				       SSL_FILETYPE_PEM) <= 0)
	return -1;
      if (!SSL_CTX_check_private_key (tls_ctx))
	return -1;
    }

  SSL_CTX_set_verify (tls_ctx, SSL_VERIFY_NONE, NULL);

  return 0;
}

static int
tls_ssl_new(ctx, s)
  SSL_CTX *ctx;
  int s;
{
  SSL_SESSION *session;
  SSL_CIPHER *cipher;
  X509   *peer;

  tls_conn = (SSL *) SSL_new (ctx);
  if (!tls_conn)
    return -1;
  SSL_clear(tls_conn);

  if (!SSL_set_fd (tls_conn, s))
    return -1;

  SSL_set_connect_state (tls_conn);

  if (SSL_connect (tls_conn) <= 0)
    {
      session = SSL_get_session (tls_conn);
      if (session)
	SSL_CTX_remove_session (ctx, session);
      if (tls_conn)
	SSL_free (tls_conn);
      return -1;
    }

  return 0;
}

void
tls_negotiate (fd, cert_file, key_file)
     int fd;
     const char *cert_file, *key_file;
{
  if (tls_ssl_ctx_new (cert_file, key_file) == -1)
    return;

  (void) tls_ssl_new (tls_ctx, fd); /* Negotiation has done. */
}

int
tls_write(fd, buf, num)
     const char *buf;
     int fd, num;
{
  if (tls_conn) 
    return SSL_write (tls_conn, buf, num);
  return write (fd, buf, num);
}

int
tls_read(fd, buf, num)
     char *buf;
     int fd, num;
{
  if (tls_conn)
    return SSL_read (tls_conn, buf, num);
  return read (fd, buf, num);
}

int
tls_pending()
{
  return tls_conn && SSL_pending (tls_conn);
}
