/***************************************************************************
                             rmstruct.h
                             -------------------
    begin                : May 2001
    copyright            : (C) 2001 by Jorge Allyson Azevedo
                                       Milena Scanferla
                                       Magnos Martinello
                                       Daniel Sadoc
    email                : {allyson,milena,magnos,sadoc}@land.ufrj.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/******************************************************************************************************
 *																									  *
 * Reliable Multicast Protocol (rmcast.h)															  *
 *																									  *
 * Structures and type definitions.		                            								  *
 *																									  *
 * use tab spacing = 4																				  *
 *																									  *
 ******************************************************************************************************/


#ifndef MSTRUCT_H

#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>

#ifdef SOLARIS
#include <strings.h>
#endif

#ifndef SOLARIS        
#define SOCKLEN_TYPE       (socklen_t*)
#else
#define SOCKLEN_TYPE       
#endif



#define MSTRUCT_H

#ifdef SINGLE_NACK
    #define MAX_WINDOW_SIZE 64
#endif

#define MULTICAST 0
#define UNICAST 1


#define DATA_PACKET_TYPE     		1
#define RETRANSM_PACKET_TYPE 		2
#define NAK_PACKET_TYPE      		3
#define SM_PACKET_TYPE      		4 /* Retirar esse tipo e mudar os numeros seguintes */
#define LEAVE_GROUP_PACKET_TYPE     5
#define REFRESH_PACKET_TYPE         6
#define JOIN_REQUEST_PACKET_TYPE    7
#define JOIN_ACCEPT_PACKET_TYPE     8


/* #define MAX_NAK              100 // max number of Naks that can be sent for the same packet */


#define MAX_IP_STRING_SIZE  20


#ifndef TRUE

    #define TRUE  1
    #define FALSE 0

#endif


#ifdef RANDOM_TIMERS
/* Distributions available for the random timers */
    #define UNIFORM     1
    #define EXPONENCIAL 2
#endif

typedef unsigned char BYTE;


/*************** members info *****************************************/

struct SMEMBER_ID
{
    char ip[MAX_IP_STRING_SIZE]; /* ip address and... */
    int pid;     /* process id of the user */

};

typedef struct SMEMBER_ID MEMBER_ID;

struct SMEMBER_STATUS
{
    int first_rcv;    /* first packet received from a specific user */
    int last_rcv;     /* last packet received from a specific user */
    int last_seq_rcv; /* last packet received in the correct order 
                         from a specific user. Please, note that this
                         is also used as the base for the sliding window
                         used to restrict the sending of NACKs.  
                         See documentation for more details. */  
    int last_identified; /* last packet received, or to which a nack was sent */
    

#ifdef SINGLE_NACK
    int window_size;
    int window_mask[MAX_WINDOW_SIZE]; 
    int window_ini;
#endif
    
};

typedef struct SMEMBER_STATUS MEMBER_STATUS;


/************** session message information ***************************/

struct SSM_INFO 
{
    MEMBER_ID member_id;
    MEMBER_STATUS member_status;
};

typedef struct SSM_INFO  SM_INFO ;


/**************** data packet info *************************************/

struct SDATA_PACKET
{
    int sn;        /* sequence number */
    int data_size; /* number of data bytes */
    BYTE *data;    /* data to be sent or data received */
};

typedef struct SDATA_PACKET DATA_PACKET;


/**************** cache info ******************************************/

struct SCACHE_NODE
{
    DATA_PACKET data_pckt;
    struct SCACHE_NODE *next, *previous;  /* pointer to next 
                                             and previous nodes */
                                                 
};

typedef struct SCACHE_NODE CACHE_NODE;

struct SNAK_LIST
{
    int sn;
    int counter;
    int hasReceived;
    struct SNAK_LIST *previous;
    struct SNAK_LIST *next;
};

typedef struct SNAK_LIST NAK_LIST;

struct SCACHE
{
    int number_of_nodes; /* number of nodes currently cached received 
                            from a specific user */
    
    int active;          /* is the user actually working in the group? */
    
    SM_INFO sm_info;
    
    
    CACHE_NODE *first, *last, *last_inserted; 
    
                /* first and last point to the first and last nodes of the 
                list of packets received from a specific user,
                and last_inserted points to the last inserted packet node */                    
    
    NAK_LIST *nak_list; /* Pointer to nak list */
    
    struct SCACHE *next;
    
};

typedef struct SCACHE CACHE;

/*************** events information**************************************/

struct SEVENT_LIST
{
     MEMBER_ID *member_id;
    
     char action;      /*
                        * action to be executed
                        *     waiting to...
                        *     1: send a nak
                        *     2: receive a retransmission
                        *     3: retransmit
                        *     4: say someone cant enter
                        *     5: leave
                        */
     
    long timer_value;  /* time when this action will be executed */

    int sn;           /* sequence number of the message to retransmit (3)
                         or to be received (1 and 2) */
    
    struct timeval last_update_time; /* Last time when the timer was updated */
                         
    struct SEVENT_LIST *next;
};

typedef struct SEVENT_LIST EVENT_LIST;

/*************** packet information**************************************/

struct SRETRANSM_PACKET
{
    MEMBER_ID original_sender_id;
    DATA_PACKET data_packet;
};

typedef struct SRETRANSM_PACKET RETRANSM_PACKET; 


struct SNAK_PACKET
{
    MEMBER_ID requested_member_id;
    int sn;
#ifdef SINGLE_NACK
    int base_sn;
    int window_size;
    int hmask, lmask; /* higher and lower parts of the mask, respectively */
#endif
};

typedef struct SNAK_PACKET NAK_PACKET;



struct SREFRESH_PACKET
{
	int sn_of_last_msg_sent;	/* sequence number of last message sent */
};


typedef struct SREFRESH_PACKET REFRESH_PACKET;



struct SJOIN_ACCEPT_PACKET
{
	int port;	
};


typedef struct SJOIN_ACCEPT_PACKET JOIN_ACCEPT_PACKET;


struct SPACKET_INFO
{
    char type; /* the type of the packet */
    
    MEMBER_ID  sender_id; /* id of the sender of the packet */
    
    int packet_size; /* the size, in bytes, of the packet */

    union PACKET_DATA
    {
            DATA_PACKET data_packet;
            RETRANSM_PACKET retransm_packet;
            NAK_PACKET nak_packet;
            REFRESH_PACKET	refresh_packet;
            JOIN_ACCEPT_PACKET join_accept_packet;
    } packet_data;
};

typedef struct SPACKET_INFO PACKET_INFO; 

/************************************************************************/

#endif
