/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2003, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/wb.e,v 4.39 2003/02/25 01:17:42 william Exp $
 */

#ifndef _WB_E_
#define _WB_E_

#define WB_PACK 60000

typedef struct tagWBProgressInfo {
   struct ObjRec	*top_obj, *bot_obj;
   struct CmdRec	*first_cmd, *last_cmd, *cur_cmd;
} WBProgressInfo;

typedef struct WhiteBoardRec {
   int	do_whiteboard;

   char	send_fname[MAXPATHLENGTH];
   FILE *send_fp;
   int	send_socket;

   int	listening;

   char	listen_fname[MAXPATHLENGTH];
   FILE	*listen_fp;
   int	listen_socket;

   int	MCastSock;
   int	bd_commands;
   int	BlockRemoteCmdDepth;

   int	logical_clock;
   long	pid;

   int	dont_serialize; /* true will skip the call to SerializeCmd() */

   struct CmdRec	*first_cmd, *last_cmd, *cur_cmd;

   int	join_session_in_progress; /* there is current WB state info */
   WBProgressInfo	wbpi;
} *WhiteBoardPtr;

typedef struct WbMessage{
   char	WbCmd[WB_PACK];
}wbmsgPtr;

typedef struct tagSerializationInfo {
   struct SubCmdRec *subcmd;
   struct SelRec *top_sel; /* TopSel */
   struct SelRec *bot_sel; /* BotSel */
   int num_objs; /* NumObjs */

   int include_tgif_obj; /* recordCmdIncludeTgifObj */
   int new_colormap; /* recordCmdUsesNewColormap */
   int logical_clock; /* gstWBInfo.logical_clock */
   char *sender_process_id; /* just a pointer, gszLocalPID */

   struct SelRec *top_before; /* topSelBeforeInCmd */
   struct SelRec *bot_before; /* botSelBeforeInCmd */
   int *pos_before; /* stackingPosition */
   int count_before; /* stackingCount */
   int pos_before_has_ids; /* stackingPositionHasIds */
} SerializationInfo;

extern struct WhiteBoardRec	gstWBInfo;

extern int	cmdLineNoWhiteBoard;
extern int	cmdLineWhiteBoardListenOnly;

#ifdef _INCLUDE_FROM_WB_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_WB_C_*/

/* =================== Remote Related Functions =================== */

#ifdef _TGIF_WB2

extern void	PrintFullIDsOfObjects ARGS_DECL((char *psz_prefix));

extern int	WBHasReadData ARGS_DECL((int *pn_flag, int *pn_retry));
extern int	RecvWBData ARGS_DECL((
			int flag, /* *pn_flag of WBHasReadData() */
			char **ppsz_buf, int *pn_buf_sz));
extern void	TryHandleWBInputData ARGS_DECL((void));
extern int	SendWBData ARGS_DECL((char *pszWBData, int logical_clock));
//extern int	SendWBData ARGS_DECL((char *pszWBData));

#endif /* _TGIF_WB2 */

/* =================== Cmd Related Functions =================== */

extern char	*SerializeCmd ARGS_DECL((int CmdType, SerializationInfo*,
		                         int *pnAssignedLogicalClock));
extern void	SerializeFreeBuf ARGS_DECL((char *psz_buf));

extern int	ReadExtendedCmd ARGS_DECL((FILE *FP, char *Inbuf));
extern int	ReadExtendedCmdInfo ARGS_DECL((FILE *FP, char *Inbuf));
extern int	ReadCmd ARGS_DECL((FILE *FP, char *Inbuf));
extern int	ReadBeforeImage ARGS_DECL((FILE *FP, char *Inbuf));
extern int	ReadAfterPositions ARGS_DECL((FILE *FP, char *Inbuf));
extern int	ReadAfterImage ARGS_DECL((FILE *FP, char *Inbuf));
extern void	FindCmdInsertionPoint ARGS_DECL((struct CmdRec *cmd_to_insert,
				struct CmdRec **pp_immed_right_cmd));
extern void	CleanUpObsoletedWBCmds ARGS_DECL((struct CmdRec *));
extern void	ProcessRemoteCmd ARGS_DECL((char *psz_buf, int buf_sz));

/* =================== Handle New User Requests =================== */

extern void	HandleNewUserRequest ARGS_DECL((void));
extern void	WBCompleteJoin ARGS_DECL((void));

/* =================== Init and CleanUp Functions =================== */

extern void	CleanUpWhiteBoard ARGS_DECL((void));
extern int	InitWhiteBoard ARGS_DECL((void));

#ifdef _INCLUDE_FROM_WB_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_WB_C_*/

#endif /*_WB_E_*/
