/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2009, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/tgcwdl.e,v 1.6 2009/06/10 19:56:56 cvsps Exp $
 */

#ifndef _TGCWDL_E_
#define _TGCWDL_E_

#include "tidget.h"

#define HS_WIDTH  181
#define HS_HEIGHT 181
#define V_WIDTH   14
#define V_HEIGHT  181

#define ID_CWHEEL_DIALOG     101
#define ID_CWHEEL_HS_AREA    102
#define ID_CWHEEL_V_AREA     103
#define ID_CWHEEL_EDIT_R     104
#define ID_CWHEEL_EDIT_G     105
#define ID_CWHEEL_EDIT_B     106
#define ID_CWHEEL_EDIT_H     107
#define ID_CWHEEL_EDIT_S     108
#define ID_CWHEEL_EDIT_V     109
#define ID_CWHEEL_EDIT_CNAME 110
#define ID_CWHEEL_SELCOLOR   111
#define ID_CWHEEL_BTN_ADD    112
#define ID_CWHEEL_BTN_OK     113
#define ID_CWHEEL_BTN_CANCEL 114

typedef struct tagColorWheelInfo {
   int initialized;
   int mapped;

   unsigned int r, g, b, h, s, v;
   char color_str[40]; /* input and output */
   int hs_x, hs_y, v_y;
   Pixmap hs_pixmap;
   Pixmap v_pixmap;

   TidgetInfo *dialogbox_tidgetinfo;
} ColorWheelInfo;

extern ColorWheelInfo gColorWheelInfo;

#ifdef _INCLUDE_FROM_TGCWDL_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_TGCWDL_C_*/

extern void	ShowTdgtColorWheelDialogBox ARGS_DECL((void));
extern void	HideTdgtColorWheelDialogBox ARGS_DECL((void));

extern TidgetInfo	*CreateTdgtColorWheelDialogBox ARGS_DECL((Display*,
					Window));
extern void	DestroyTdgtColorWheelDialogBox ARGS_DECL((Display*,
				TidgetInfo*));
extern int	TdgtColorWheelDlgLoop ARGS_DECL((TidgetInfo*));

extern int	InitTdgtColorWheelDlg ARGS_DECL((void));
extern void	CleanUpTdgtColorWheelDlg ARGS_DECL((void));

#ifdef _INCLUDE_FROM_TGCWDL_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_TGCWDL_C_*/

#endif /*_TGCWDL_E_*/
