/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2009, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/tgisdl.e,v 1.7 2009/10/14 17:54:04 william Exp $
 */

#ifndef _TGISDL_E_
#define _TGISDL_E_

#include "tidget.h"

#define TGIS_COLS  16
#define TGIS_ROWS  13

#define ID_INSSYM_DIALOG     101
#define ID_INSSYM_SYM_AREA   102
#define ID_INSSYM_BTN_ADD    103
#define ID_INSSYM_BTN_OK     104
#define ID_INSSYM_BTN_CANCEL 105

typedef struct tagInsertSymbolInfo {
   int initialized;
   int mapped;

   XFontStruct *xfs;
   GC gc;

   int font_width, font_asc, font_des, font_height;
   int padding;

   int a_symbol_w, a_symbol_h;
   int pixmap_w, pixmap_h;

   int something_selected, selected_row, selected_col;

   int sym_x, sym_y;
   Pixmap sym_pixmap;

   Time last_click_time;

   TidgetInfo *dialogbox_tidgetinfo;
} InsertSymbolInfo;

extern InsertSymbolInfo gInsertSymbolInfo;

#ifdef _INCLUDE_FROM_TGISDL_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_TGISDL_C_*/

extern void	ShowTdgtInsertSymbolDialogBox ARGS_DECL((void));
extern void	HideTdgtInsertSymbolDialogBox ARGS_DECL((void));

extern TidgetInfo	*CreateTdgtInsertSymbolDialogBox ARGS_DECL((Display*,
					Window));
extern void	DestroyTdgtInsertSymbolDialogBox ARGS_DECL((Display*,
				TidgetInfo*));
extern int	TdgtInsertSymbolDlgLoop ARGS_DECL((TidgetInfo*));

extern int	InitTdgtInsertSymbolDlg ARGS_DECL((void));
extern void	CleanUpTdgtInsertSymbolDlg ARGS_DECL((void));

#ifdef _INCLUDE_FROM_TGISDL_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_TGISDL_C_*/

#endif /*_TGISDL_E_*/
