/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2011, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/tgtwb5xl.c,v 1.12 2011/05/22 23:44:01 william Exp $
 */

#ifndef _NO_TGTWB5

#define _INCLUDE_FROM_TGTWB5XL_C_

#include "tgifdefs.h"

#include "tgtwb5xl.e"

char *firstLargeTransTbl[] = {
   "5",   "",    "Punctuations",    "Symbols",
   "1",   "2",   "3",   "4",
   "Er",  "",    "",    "",
   "An",  "En",  "Ang", "Eng",
   "Ai",  "Ei",  "Ao",  "Ou",
   "A",   "O",   "E",   "Eh",
   "Y",   "W",   "Yu",  "",
   "Z",   "C",   "S",   "",
   "Zh",  "Ch",  "Sh",  "R",
   "J",   "Q",   "X",   "",
   "G",   "K",   "H",   "",
   "D",   "T",   "N",   "L",
   "B",   "P",   "M",   "F",
};

char *secondLargeTransTbl[] = {
   "5",   "",    "",    "",
   "1",   "2",   "3",   "4",
   "",    "",    "",    "",
   "an",  "en",  "ang", "eng",
   "ai",  "ei",  "ao",  "ou",
   "a",   "o",   "e",   "e",
   "i",   "u",   "u",   "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
};

char *thirdLargeTransTbl[] = {
   "5",   "",    "",    "",
   "1",   "2",   "3",   "4",
   "",    "",    "",    "",
   "an",  "n",   "ang", "ng",
   "ai",  "i",   "ao",  "u",
   "a",   "o",   "",    "e",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
};

char *fourthLargeTransTbl[] = {
   "5",   "",    "",    "",
   "1",   "2",   "3",   "4",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
};

char *singleExtention[] = {
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "i",   "u",   "",    "",
   "i",   "i",   "i",   "",
   "i",   "i",   "i",   "i",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
   "",    "",    "",    "",
};

char *pinyin_et_big5[] = {
   "A1",	"aafca3ab",
   "A2",	"b0daaafc",
   "A4",	"aafc",
   "Ai1",	"aec1ab73ae4aadfcab75a3afe44d",
   "Ai2",	"b1babd4aef63e1f4",
   "Ai3",	"b847c4a7c647d5d9cb48cef7ca64",
   "Ai4",	"b752c3aaa6e3c0c7c0f5b969bebcc940f957e4edd8a5e954f669eeb8ed54ef7cf4cfe44dee49",
   "An1",	"a677be62b167bfdaaef2bbcfa3b3c44fd8c0cbc8ea75cea6decadf72dfd6f54cce50",
   "An2",	"e0d8cfcdd875",
   "An3",	"adcdd47bd9a3d87e",
   "An4",	"b774aed7a9a4abf6c566b5daeeeeca43d3e0cbd8d1dbcf7dd3b0ebfed0eed4e9e8f8",
   "Ang1",	"bbeab5cba3b5",
   "Ang2",	"a9f9c957",
   "Ang3",	"dc42",
   "Ang4",	"af73eecc",
   "Ao1",	"a557a3b1cbfccf62",
   "Ao2",	"bcf5b1cebe43bfacb9c8ee67f7b4c652c3eff67de1bce676e6a9c16df36ce2b0eaa2e4bbe5ade757f06af0e6f26a",
   "Ao3",	"c3cdb6fecdbdd844",
   "Ao4",	"b6c6bf44b6f8bed2e94dd8b4caf3e9aedbe4e96a",
   "B1",	"a374",
   "Ba1",	"a44baec3a4daaccdaaddafb9d34aa57aa5b6d7d0a761c954c9f6",
   "Ba2",	"a9deb65bb959e8d9d06ef1e4dbfdc9a5db6ed05adbd9",
   "Ba3",	"a7e2b976dc6a",
   "Ba4",	"bd7daaa8c551c5f2afd2cad3c5f4a742d666",
   "Ba5",	"a761bd7db55daa49",
   "Bai1",	"d954",
   "Bai2",	"a5d5",
   "Bai3",	"a6cac25ca8d5c4fcdae9d579f478daf7",
   "Bai4",	"b1d1abf4d0f9e361d9c1f478cad1",
   "Ban1",	"af5aafebb768b4b3b97ba7e6bd49ee57ddbdccc1eb78",
   "Ban3",	"aa4faaa9c1f3a8c1afeaccc6b67ad349e3ed",
   "Ban4",	"a562bfeca6f1a7eaa9d5b2cca972c3a4c962ccadd5e4e0c1e4bf",
   "Bang1",	"c0b0a8b9b3c4b1f5f17deadbd157",
   "Bang3",	"ba5db86ae2c6bb48e9e8",
   "Bang4",	"b4cebd53c1bdb046b3c4c2e9aec7ed72dcebeaf5",
   "Bao1",	"a55dad4dad63bdc7cf52d6ddeb55cc55",
   "Bao2",	"b972d2fccd6e",
   "Bao3",	"ab4fc45fb9a1b3f9bdc8b8b6e8e9ccafe4d7e4e4d8bf",
   "Bao4",	"b3f8a9eabcc9c37ab05cc06aa753d3e5b95eeb58c5e1ecbcdbadde73d7c2efbcf26ff449",
   "Bei1",	"ad49aa4db464a8f5b84faddab4aed453acd7bb74db7cd5b5d9c1c9b8e373f3edf2d3",
   "Bei3",	"a55f",
   "Bei4",	"b351b3c6ad49a8a9bdfaadbfc175af56beceaeafa7b8b548bb5fe7c8aaf5daaae44fbe58d0feeac7d5cbd674dc58cfbad3f8e2c8efc0",
   "Ben1",	"a962b64eebe6cd49d5eb",
   "Ben3",	"a5bbaf63ad66",
   "Ben4",	"b2c2ca5ecaac",
   "Beng1",	"b159c15eca5bd54dcff4dc79e15ddaed",
   "Beng2",	"acc7",
   "Beng3",	"db66cd66da7dd4bee04f",
   "Beng4",	"c2dbdd7bcf6eb06ee067",
   "Bi1",	"b947cc59d44de344e7e6",
   "Bi2",	"bbf3",
   "Bi3",	"a4f1b5a7a9bcbbc0a450a85dcff9cc59d3bca7adcb70e65fcf44c9f5e7e7",
   "Bi4",	"a5b2b1cdb2a6bec0c1d7c27ab3acbbc0c175b9f4b9fab141c0c5bad1aa63addabdaaa7c8b9cdb470b940b45dbb74b0a1b0f1bae8bf7bcd71a4f1e958b844b64ef653c3cecf68e76ec2def1b9cc7ad54bd941ddd0d9f0d2a5e675edc3d06cc1a3eb7db647f4d9cdd3e0cdcefcd5b2cfc7b7f4e0e2e4d1e8c6f15df7c0dab7d8aab963decddf74e8d2caafe27de667cfddcc4cf372f7c6cf47ca5adfe5e1bfe358e3c9e857eae1ec74ee76f1d6f4caf67af97ecdb6d34bdefbe173e67ee971f14aedd6",
   "Bian1",	"c3e4bd73c340bdbfafa2f8fbe6dbe348da78e2d6cf5fdde4de74",
   "Bian3",	"abf3b653b0d0bdcad2f6dfcfd947e2f3",
   "Bian4",	"ab4bc5dcb94dbfebc547a858c47ccad9a5afa8bccae7e6ece74ba4cbd971cb5aecaae0cf",
   "Biao1",	"bcd0b343c5dfc3f0f674bda8e664e8f0f2bce149a840e2a4efecda6eea6cf4a2e4cdf9cde1e1ecb9f2c2dcadd449f0eae164f348e75bf26cf2cb",
   "Biao3",	"aaedbff6b144e3f7d0cfee74ed46e7e0",
   "Biao4",	"c5c0",
   "Bie1",	"e578c5bef9bd",
   "Bie2",	"a74ff144cbdbe1c1ee76ee6f",
   "Bie3",	"c3a7d7a1",
   "Bie4",	"b9fbedd6",
   "Bin1",	"bbabc0d8b16cc262beaad979c47dc1c7c378cbacf040f4c4f767e452c9a2d9d7f37ef279f8d3",
   "Bin4",	"c26cc64bbeaaece8c2c1f8d4f5ab",
   "Bing1",	"a74ca642d57cd1d9",
   "Bing3",	"bbe6a4feb85bac60aac3acb1cef4cdd4cc7def40bbd0d7aecddcd07ed2f7abccceb5",
   "Bing4",	"a8c3af66a8d6a67db4acd8d6ef78d452",
   "Bo1",	"acc1bcb7ade9b5d4b2dae567d2dcdeebd7b7f0d4f85bd471cf59f351cc69",
   "Bo2",	"a742b3d5ac66aa79ab6bb769b4f1bbe9c1a1b2e4a9adb2edbae4b2f2bdb3bb4bb959e8c1b960f5cef1d0e7f4d24af64ae463f157ec61e0fbf1aef566d5c5eeacc0d0ec60d063d1b4deaadfb4e877efccf063f2a1f952d3f6f97bf2ae",
   "Bo3",	"b65fc3b0d7b0",
   "Bo4",	"bcbdc0bcc3b0adbdc1a3f342c1a1c0d0c4f4f2b7cee0",
   "Bu1",	"d7e3d5aae8c2d16cf1d1",
   "Bu2",	"a4a3",
   "Bu3",	"b8c9aeb7ae48adf7a452e0ebe67b",
   "Bu4",	"a4a3b3a1a5aca842a9c6a747c3afb0f0b95ae74fedcbd1cacbec",
   "C1",	"a3a9",
   "Ca1",	"c0bfb767ecc0",
   "Ca3",	"f47d",
   "Ca4",	"f5c4",
   "Cai1",	"b271",
   "Cai2",	"a47eb05da7f7b5f4c5d7",
   "Cai3",	"b1c4b16daaf6b842bdf2baf9e073d4f2d9bdd4ea",
   "Cai4",	"bdb2b5e6d4caaaf6edda",
   "Can1",	"b0d1c05cf67c",
   "Can2",	"b4ddc5faba46e95b",
   "Can3",	"ba47e5a3d9a9e4fdf876",
   "Can4",	"c0e9b447c0f6df54ea44",
   "Cang1",	"bb61addcb7c9bfb5b3c9f6c1d861dd56",
   "Cang2",	"c2c3f974",
   "Cao1",	"bedec157ebd6dcd5",
   "Cao2",	"b1e4bcd1b9cbbaa8ee5dedf1e1a6",
   "Cao3",	"aff3e97bf55aca4a",
   "Cao4",	"c157bedecdabf2f1",
   "Ce4",	"a555b5a6b4fab0bcb45ab46cdf49d2c2d37cd6e1cee3dee3e5a8e3d1",
   "Cen1",	"b0d1e1add5b7",
   "Cen2",	"a7c2af4bd5bad348d158",
   "Ceng1",	"e4f8",
   "Ceng2",	"b4bfbc68e565e855def0",
   "Ceng4",	"f34f",
   "Ch1",	"a3a5",
   "Cha1",	"ae74b4a1a465b3e5eaf6dcd8c9eacb43d458ea6af160",
   "Cha2",	"ac64b9eeaff9b767e241eed0e2edd068ce51cda4",
   "Cha3",	"ebc1",
   "Cha4",	"b8d2a7c3ab62ae74c9fcd0aee3dccbb2c9cdd04c",
   "Chai1",	"a9eeb3a6ae74d85b",
   "Chai2",	"aee3b05bbeabd6c2dcd7",
   "Chai4",	"f2e3d3d9f6d7",
   "Chan1",	"c465d9c0f2eecba6e87ed8f8e956f5d0",
   "Chan2",	"c4f1c2cdc149c661c5febcebc3cac460bc60b3e6bf47e573b447f1edc0d5efedf464f75ef955eaa8f7efe0f7d9cdda52ebeede78e2ccf2b0f440f4e2",
   "Chan3",	"b2a3c3eac4c4b6d0eb41e543f6d8cbb1e1aeea4cbdd4f77ce56ff073e273edbaf7e4cafcf341",
   "Chan4",	"c462c4f3c35f",
   "Chang1",	"a9f7add2b273b140ec4bdb75c449adcef6d0ebf9d640daa8e3fb",
   "Chang2",	"aaf8b160b3f5b9c1bb6ec076b87ab9dff95ab175c07cb5e7ebf8e35e",
   "Chang3",	"b3f5bc74b4afbefbceebebf3",
   "Chang4",	"b0dbadd2ba5ab1a3d44aef43",
   "Chao1",	"a7dbb672b657b6d3cc70cca2d7cbb6cfeae2",
   "Chao2",	"b4c2bce9b15fbc4aaed0e5dcf148e471",
   "Chao3",	"a76eaaa3d2d8",
   "Chao4",	"d366",
   "Che1",	"a8aedacfd773",
   "Che3",	"a7e8e1e4f7d4",
   "Che4",	"b9fdbaabc2e1ba4db477a95cc94bd0b6dace",
   "Chen1",	"dcd2b560bd51d7ebe7edd9c7eeafe7e1dda7d4ae",
   "Chen2",	"b3afa849b1e1a6dab9d0a8b0ae57a7d5ae66bfdbde70d3b2e77de5e7d759d942dc71ee6af1def7bcc9afe5bd",
   "Chen3",	"d577eaa7eed1dff1e15eebbff0f5",
   "Chen4",	"b658bad9c5a8c468c640accfefb5f1f0f4c3efb8",
   "Cheng1",	"bad9bcb5bf65f2ded457ecf7ebb9daa5e9daf4fed261d4bfd9d1da67edb8d4f6f559",
   "Cheng2",	"a6a8b57ba9d3b2b1adbcb8dba765abb0c367bce1beeda5e0e64ad9b3e473d168d1d4dff4d0bad14cd5a3d9fed66dd775f55dd36fd749d957ceaee4a8dce6",
   "Cheng3",	"b378c1fed1add547dcf0",
   "Cheng4",	"bad9afafd457da67",
   "Chi1",	"a659b045c3a8b7f6b6e1b3f0a3a5d3fbc55eb2c7df5decaedcf7e1dbdaabee5ad6b2f5bdd6c3dbe9e7e2ea77f96af875f7c7",
   "Chi2",	"abf9a6c0bff0b9a3b0cda6a2bc55cbfbbdf3e357d3b3d7a8eac1d3ced07ad2c6cae1cb59d3a2aeebd1fad741dbe9e062e34ee577eea1d8f6",
   "Chi3",	"a4d8bea6aea2a760a8d7bfc9d9ddddb6d3bfcecacedece6ad85ee04ee4a4c9adf57b",
   "Chi4",	"a8aaafcda5b8b6bda577bf4bb3d7dcbfb1d5d2d5ccb8f555d1dee853c94ce06be460f7c2d44be6b7e0c9d0f4d5eadeceefc7dd72e5ae",
   "Chong1",	"a552bdc4a852b2eacaddbca5cfcfd072d245f0fbcff5",
   "Chong2",	"adabb152a6e4c2cecffad365e7c0dca3d3b5d6a1",
   "Chong3",	"c364",
   "Chong4",	"bdc4e0b6d96f",
   "Chou1",	"a9e2ea6fddb1eac5f46cd4db",
   "Chou2",	"b754a4b3c477baf7b953b859d6e8c543c3a5b1a8bb76bea9f841ecdbc357f0aaecd4d9d4daf6dbacece5e045ec50effdd1ee",
   "Chou3",	"a4a1c1e0e2e4ccd8cce4ca7cd770",
   "Chou4",	"afe4edc5b7cde268e57b",
   "Chu1",	"a558aaecc4d5f0f0",
   "Chu2",	"b0a3c078bc70be53c36fc2faafecc3dcde51f75deabedf71dfefe0bce3c1b8f9f6bdefc6f0f0e060e2c9",
   "Chu3",	"b342b7a1c078c2a6aa53bb75b4d8e9eaed47",
   "Chu4",	"b342c4b2af62b2d2c5f7c24ad0d4a9c5dd7ac0d3dbdce0a4ecf0c948cdcbcd4ddaa2e462de47e4f1edecd1cd",
   "Chua1",	"d9db",
   "Chuai2",	"e744",
   "Chuai3",	"b4a2",
   "Chuai4",	"bfe5e544",
   "Chuan1",	"acefa474f4fbcb4adeb8",
   "Chuan2",	"b6c7b2eee0a1dddcddf8ebafe5c7ebcc",
   "Chuan3",	"b3dda6dfd3b6",
   "Chuan4",	"a6eab3a9cb6bca40e455",
   "Chuang1",	"b5a1b3d0bd48a777e579e1d7e1ec",
   "Chuang2",	"a7c9bc6cbcb2e9bf",
   "Chuang3",	"c2f4b76de2b4",
   "Chuang4",	"b3d0c2f4b75bcbd4deaf",
   "Chui1",	"a76aaaa4",
   "Chui2",	"ababc2f1ba6cddb4b4d5b6abc1e8b4a8dddebd69d87cda50d45bdfc8bd78d8c2dfa1e2d5",
   "Chui4",	"a76aaaa4ebaa",
   "Chun1",	"ac4bddcfccd7ebcfda59f573d8c7ddc5f5aa",
   "Chun2",	"afc2ae42be4ab245e75dc44ce27aebdeb2e5e9a3f3d3",
   "Chun3",	"c4f8dd65ebbdd462dfd8",
   "Chuo1",	"c257",
   "Chuo4",	"baefbdf9c5c6d8bdb0e3d55bf259e85dd4d8dec5dc4ed15cca77d675eaabdb4de7efe9a8f5c5",
   "Ci1",	"b2abceb8bbdba3a9ae74dbeeec6c",
   "Ci2",	"b5fcc3e3b74fbacfb2a1bbdbafa8b2abaffddae7e8bfcf5ae959ed5bce4de8c0edf9",
   "Ci3",	"a6b9cbbdcf75d2afe06cd6a6",
   "Ci4",	"a6b8a8ebbde7b45aa6f8cbb5dbb4db6cc9f4d1efd3ccdaeb",
   "Cong1",	"a55ec16fb171a777e6a6e6a7bcd7f67be776f36be670d9d9e5c4bdb5ea7aee65eed8",
   "Cong2",	"b171c24fb246da7ad555e2a6e2ace7ebebefd4ddd4f0d54fe1c8",
   "Cong4",	"f6e6f0a8f0e5",
   "Cou4",	"b4eabfeadf73ddce",
   "Cu1",	"b2caf9d2d7c8",
   "Cu2",	"cf65cc75",
   "Cu4",	"ab50be4cc14cc3e0e754c2d9d660a8f2bff9bdecc1cdc3ebea6be7febcd8d5c7e4f6df42e9e1f1e2",
   "Cuan1",	"f5cdf94fe87d",
   "Cuan2",	"f6e3f6def5c3",
   "Cuan4",	"c2abbf79c679eabf",
   "Cui1",	"ba52b6cab15ae151e167eaa5f369e1fcb049",
   "Cui2",	"dcc5e1d0",
   "Cui3",	"bd41e7f1e2a8",
   "Cui4",	"bb41afdcbae9b17cb7f1b5d1d475b266d0c9d9e5bef5da58edb9eaefe363eaecdb51ed5a",
   "Cun1",	"a7f8b572",
   "Cun2",	"a673dbc6",
   "Cun3",	"a6a4c96b",
   "Cun4",	"a46fa654d047",
   "Cuo1",	"b762bcbcbd52c1cee3b5e84ff565",
   "Cuo2",	"e6afdac4f6c9dab5eecbb744e768",
   "Cuo3",	"e2cfd74ceaccdacd",
   "Cuo4",	"bff9b1b9aec0be56bcbccdf1adedd76bcde8d0e8f8a2e3c4",
   "D1",	"a378",
   "Da1",	"b766bfcab5aae5bccbded055",
   "Da2",	"b5aab946c5b6bbdebd44a9cdf2b8e8fdcc48d6d4d3afee54eb7cf662d862cbe3d67bcfaff158",
   "Da3",	"a5b4",
   "Da4",	"a46a",
   "Dai1",	"a762e2ca",
   "Dai3",	"a4efb665",
   "Dai4",	"a54eb161abddb355c0b9abe5ac70c24cb655ada4a46aacc5a9a7b665f7fbd4b4f8ced6ede1b7c9fbc9e0f467dc4ce06fedf2f140cf63dd73",
   "Dan1",	"b3e6bee1a4a6afd4c2b0e858cfe0d743d7f2cff2f048f0d5e145f2c0e4f5f1f4",
   "Dan3",	"c178af6ebcc2dcb3d350c9bfe5b8cd6cd3dbf964c964e9fe",
   "Dan4",	"a6fda5b9b248b34abdcfbee1bc75bcaab4e1b0dcbf46e97ee4eeb0e8e4fca5dbed76df44e0f8e96cf548e4dcdb79e0bae9bbcf5ccacce649cd43cd63dbd5d878e3abe3f4e545eca5f050e9e3f6eacd4c",
   "Dang1",	"b7edbeb4c54cc3cbed68f2aabbfdf2dfea40f2c4dd4e",
   "Dang3",	"c0c9c4d2bed7c66df7dcf8acd0de",
   "Dang4",	"b7edbfbabed7c0fae2eecc58dba5e07eed66d945dec2f05df061f66d",
   "Dao1",	"a44da56fc97bcdb1c9f7dd5be0ea",
   "Dao3",	"adcbae71bec9c3abb76fecead572eccbdef4",
   "Dao4",	"a8ecb944adcbbd5fb573c1d0b1a5bec9f941f4b1ed43db71f6f2",
   "De2",	"b16fbc77d5fc",
   "De5",	"aabab16f",
   "Dei3",	"b16f",
   "Deng1",	"b56ebf4ff4f1f068e053ea66e55d",
   "Deng3",	"b5a5dd75",
   "Deng4",	"be48c0fcc3deb9b9bc6ac145e54cebd3f549",
   "Di1",	"a743ba77a5c2d6f4f17acc77edadeed7d7bedb7de161e669",
   "Di2",	"aababcc4ad7da866b2c3bab0bb43b2fdb9deb9bfc3e9f0f8aadebab9f740f753edc1e77bdcabd5d2e660d074ecc9f95ff0aff2ca",
   "Di3",	"a9b3a9e8aaf3b643acbbafa1a5c2cbfbac6bcc73dbd3cbeecddbe3a3db63dc45caef",
   "Di4",	"a661b2c4a7ccabd2bbbcb8a6aababd6cbfcdae58dabbb4d0cb41cb6ae2f8e760ee61ebc2dde8da4de2ebd0a9d7f9e5cacafad3e8d5d4d649e0e6e15ae1a5d66bea69",
   "Dia1",	"dcdd",
   "Dian1",	"c441c571c5f6b7bfd569d859e6b6cee7eebae25cf968d865",
   "Dian3",	"c249a8e5b84bebfcd4e8daa9eb47",
   "Dian4",	"b971a9b1b7b5a86cb3feb9d4befdb17dc051a6fad5e0acbfb966f065cbf5d2c4f04aedaccdd9ced2d4dee7f7e94e",
   "Diao1",	"c04aade4a44eb649f3e7b84da570b16eeaa1daa4c44bc9ebd7a2e0eccdc9e5f4",
   "Diao3",	"ce78",
   "Diao4",	"bdd5b1bcb3a8a651a4ddeab4e773e04bc9b9e4e0",
   "Die1",	"af52",
   "Die2",	"b65ebdbabfd2bad0c57cada1b7deb3e3d2bcb5c0b5bbcdfdce53d8a2e3d7ebc0f56bdbf7cef2ce7bcee4d05dd079d2d2db45db54dbdddc78e747e7c5d944ddd1e1a4",
   "Ding1",	"a442b076a56dcb6fadaaa86ea4b1ca45c978d84dcdc7",
   "Ding3",	"b3bbb9a9adaae1b1e9eeee43",
   "Ding4",	"a977ad71b076bff5dee4d448d161d9ccd57ee2f4ef45db5fd472",
   "Diu1",	"a5e1e4b7",
   "Dong1",	"aa46a556a94ec35dd0a4e3d9d4c0d4f8cf6ccfb5d5e8dbaaf3f0",
   "Dong3",	"c0b4b8b3e95ce551",
   "Dong4",	"b0caac7dade1b4c9abf0afdbcedcd1afec69eef9",
   "Dou1",	"b3a3b0c2d3f2",
   "Dou3",	"a4e6a7ddb07eb042aa55d0f2d977",
   "Dou4",	"b0aba8a7b372b56bc475d75eb2e8e8c3e865d5c6d24dc5aa",
   "Du1",	"b3a3b7feb9caec47ebdc",
   "Du2",	"c5aabf57ac72c37cf941c270c37dc5eaf9c8c675c370ecbadeecf25ae7a6f75cf8d1f8d2f472",
   "Du3",	"bde4b0f4b840bf77a87bec45e3fed545",
   "Du4",	"abd7b4e7a87ba7aac1e1a7f9c5fbd6c4d868",
   "Duan1",	"baddad42d465d46bd8cd",
   "Duan3",	"b575",
   "Duan4",	"ac71c25fbd76c1ebe9e4df7cf8b8dde0dfe0e2f1f762",
   "Dui1",	"b0efe8bdded4",
   "Dui4",	"b9efb6a4a749b850efc8f2f7ed55f0b3f658eff4f264e976",
   "Dun1",	"b4b0c3dbbc5bb1acedabf7a3e3d5e9aaf4e8",
   "Dun3",	"acdac4bb",
   "Dun4",	"b979beb7acdeb677b950acdabf4ca850a779e851cd57caadcaf4c9b6cacee654d8ecf5a9df7b",
   "Duo1",	"a668ce47cefbd3a9",
   "Duo2",	"b9dcc54dd573e440d0ead974ddf2d469d5a7d76ad9e4db4df1c8f2ec",
   "Duo3",	"b8faa6b7d8a6ce57f3fef3c5d6a3e063",
   "Duo4",	"b46bbc5ab2ebb8f6a8efa946bfe2b9a4ce57e54fe56dcf4fd0c3d0c6abd7d7b2dbe7f3e3",
   "E1",	"aafcb0fedecba3add4f3cea3ebe8a3ae",
   "E2",	"c342b35fc35aae5aae40b8bfae6fd76dab58caa7ca78dacbb348e872cdd2d678d269dab8dac1e8e2",
   "E3",	"e44d",
   "E4",	"b463be6aab58b66ba4ccb94bc1eea7e3c673c345a763b46abeb5b36dcbaef5a7b0eeeba7b8b0ce4bb0d7d8dedd7eb8e3ec46e8b6d8a5f8edcce2d369d8aecac3f8ccf459cfeed2ded3c4dbe5dc47dce1dda6e3e1e968ec5ff4ba",
   "Ei1",	"a3b0",
   "En1",	"aea6b6e2a3b4",
   "En4",	"ddae",
   "Eng1",	"f1a2a3b6",
   "Er1",	"a3b7a8e0",
   "Er2",	"a8e0a6d3cfa5d053d36be077cbcad1e6d0c4ef6cefdfdb46d3b4d4a2ef7b",
   "Er3",	"bab8a6d5ac7cbbe7c2e2d2adec62f0b9e47acea9c974d1f0",
   "Er4",	"a447b64ccbb9cbd0cdfbe9c2db46d1fdd6acdbc0",
   "F1",	"a377",
   "Fa1",	"b56fa5efe2e5",
   "Fa2",	"a546a5efbb40bbd6b5adaf7cd3abd2caf0b2",
   "Fa3",	"aa6bbe76",
   "Fa4",	"aa6bb557",
   "Fan1",	"b566c2bdbfbbc2babc6ea67cefd9f5e5e0fee560f35af85d",
   "Fan2",	"a45ab7d0c163a67cbfbbc473c3bfbcd4f5fcea64cda8bc5cea4feaeef645f353f3abd6dab3abf463f4f6e144e9dcedf8f079f873cb47cf5ff268",
   "Fan3",	"a4cfaaf0e8e3",
   "Fan4",	"bd64ad53a5c7a5c6a6c6b6bab363aa78b1ebcfdbd6cbe46fc9d2d3e9dc4ae2b3e955",
   "Fang1",	"a4e8aadaa77baa44cba8d642dc62c943cb4b",
   "Fang2",	"a9d0a8bea7abaad5a77be8db",
   "Fang3",	"b358a7cfa5e9afbcadc0afe9ccc4cfd7e4dbf6c4",
   "Fang4",	"a9f1",
   "Fei1",	"ab44adb8b5e1b476b0d8a66de36ec050ef57f1b4f3d6f3b9d4dae3fd",
   "Fei2",	"aaced5f3b5ccdb78e3f3",
   "Fei3",	"adeabb42b4b4e3f2bddad55eb5e1cef9d9c6e249eabdd4cdef4b",
   "Fei4",	"bc6fb64faacdaa6da770b7f3a9ccd2c8aae8b151d0ebcd61d2e2eff7ed75ceedd057d0d5d0efe9b6efb3f24df0bcf4f0",
   "Fen1",	"a4c0afc9aae2aa5ea768b4d9cd6ad7f4dca8ccd0dc77cfefd364d3d8f556d5cfe8ec",
   "Fen2",	"bc58b549a857ccded9c8d3c7f346f1e3e56ee5fdf356efb4cab7cd5ad362e3cbf874cad2eafdf663",
   "Fen3",	"afbbecb6",
   "Fen4",	"a5f7a9c1bec4bcaba4c0c154e0f3f45ccaaecffde8dfe9c3eaebf078",
   "Feng1",	"adb7b8c1abcac2d7bac6ae70be57a4a5b26cb7acbfd8f65adfb1f5d3dea9d1cbd5d1cab2ed4ad467d8eff747f9b0f9cbda76",
   "Feng2",	"b37bc15fb6becab0da49d8b0dfa7e1ea",
   "Feng3",	"d477d7c5",
   "Feng4",	"a95ebbf1adc4bfd8c15febb4da63",
   "Fiao4",	"dffa",
   "Fo2",	"a6f2cbf3",
   "Fong4",	"cfd9",
   "Fou2",	"d04daae6d352dcc8",
   "Fou3",	"a75fa6ced9e1d26fe8ea",
   "Fu1",	"a4d2bda7bcc5b9e5a5edbea2dbfab36ccf53cfeae469b679e35bdb40d3d1dad8cbaaccfdcecdd169d760df66e8e5cc54eacaf275d6f0",
   "Fu2",	"aa41bad6a7dfaf42b2c5a5f1a9bbbfa3b454ab52a9d8d07ba5b1a7b7b5f6aadcbfe7bdbbb0cbdfecd04db265a4d2d3fad767a9ccd3bad5beb2d1d3acb5e8b2d9cbe0cf7bdf5ad758aae8d070dfa6ca6ccc6dd6cfdfb6d7b7ac74d9d2e651d64ecf52cfd5cc66ccd5ce59ceedcf47d679d77bebbee0edc95dccf7d2ead6fbe4caebadeca7efb0f3e8f57a",
   "Fu3",	"a9b2bb47bcbebbb2a86aa9f2adc1b079b2e3b5c6b340de58e546ccb9f3f5f064be66d3f4cc72f1c4ddc4ca6bdff0d3c5dc44a4f7",
   "Fu4",	"a4f7ad74b0fca549aafeb449b45fb0c6b3c5c2d0bdc6b8a1a94aad75bde1be74aafaad72c34cc1cce7b8ec7bd2e6d45eebcdf56eeed9e246ce60d062d7a7dfcae7b9e7c4cc54cea5dbbde6efeb50",
   "G1",	"a37c",
   "Ga1",	"b9c7c9ee",
   "Ga2",	"aaeebebfd0c1",
   "Ga4",	"a7bc",
   "Gai1",	"b8d3abb2d0c2b8f0d375cbb4ce79d36adad2daece055e05be0d3",
   "Gai3",	"a7ef",
   "Gai4",	"b7a7bb5ca4a2b674b540dd76d962f047",
   "Gan1",	"b0aea5cca47aacf1a878c0aaac61a958ccf4cbddaf69cb68a7fdcd7ad0a6df51e3e0e4e2d8f1",
   "Gan3",	"b4b1b750bbb0b1ecbef1b57ae641cd75cd78d3e3",
   "Gan4",	"b746c642b268d6e6caf8e0e8dbe3ba6df9a2d647f2a8d8f1",
   "Gang1",	"ade8bffbacfbb15ebaf5a9a3a87aa6aaa7fed35ccd74d069b3aadcefdeefd9bbd2fed4b6da6b",
   "Gang3",	"b4e4b15e",
   "Gang4",	"ba62",
   "Gao1",	"b0aabf7cbb49bf74afccaf6ff253b841f6cee252e2e9de5cf3a6",
   "Gao3",	"bd5ac5cdb764ba60bfa5aa58e1f7efe2df52",
   "Gao4",	"a769bba2d3fce870dad5de7b",
   "Ge1",	"adf4ba71b3cec246c0c1afdea4e0cb76aab8d9fdcfb7db5dde4fe4e5",
   "Ge2",	"aee6adb2b96abbd5b8afc066b5f0aba3bb4af4dddcd0e1eeada8e8b4dcede040b0acbbd7ceddcbccebcbef75d1ced3a8d943ea5cc2f0f87d",
   "Ge3",	"b8afd0f8d753e9a5ec7df3c0d6cd",
   "Ge4",	"add3a655bbccd0a8bae7",
   "Ge5",	"add3",
   "Gei3",	"b5b9",
   "Gen1",	"b8f2aeda",
   "Gen2",	"cdfe",
   "Gen3",	"a6e1",
   "Gen4",	"a5e5a6e1d3a3",
   "Geng1",	"a7f3afd1a9b0b865c3bcbde9d24ee6e5f3dadba9d958",
   "Geng3",	"b1f0afd5ae43df58f1c7ae47ef64d3f3d1c4",
   "Geng4",	"a7f3a5e5d87d",
   "Gong1",	"a475a4bda55ca8d1a7f0ae63aea5b060a47db047acf5c5c7aad0dffdcd74b3aaeac2dce3dd70d863a640dd5a",
   "Gong3",	"be64abfda845a640d2acc471d1e2a47bd1b1dbbbf4a3",
   "Gong4",	"a640a8d1b05ed050dda2",
   "Gou1",	"a579b7bea4c4b95fac65ccfbeabae6edccdbcdc5eae6",
   "Gou3",	"aaafce41cc63ac65ad65d6d6d051d3add7ad",
   "Gou4",	"b0f7c1caabafba63b6fcdd62b770b8e1bbb8ee7ad0e0ce6cb96fd855e6bef2a9f3a4d0f0",
   "Gu1",	"a968a974b664a942aa66a6f4dba3b5dda94bb347decce354c06cdbd4dc5ecd40d360e356b957ec7ec95acf54e0ccdc49ae61e555e9c6",
   "Gu2",	"b0a9f6bc",
   "Gu3",	"aad1a56ab9aab0a9a8a6bd5cb8eba559c5dbcb53acbab7c6afcbe14cb5fec1d4c35bc2a2edeaf053d361d7aac9e8b957cb46d5eccd60d146dd4ce242e3c3ed58eff0dd6bead3edfa",
   "Gu4",	"ac47a954c555b6b1b9b5c044a769a6f4deccd5c0e24cd65fd4c7d544d0e3d9cfdefa",
   "Gua1",	"a5caac41a8edbdbdbe68b5c1ef7ed1ebd3ecf3bcd067dfa2dae1dfb2e141e2dee6eaefcfe061edee",
   "Gua3",	"b9e8d46c",
   "Gua4",	"b1bea8f6bb6fdf68d6f1daeee047ac45ec6f",
   "Guai1",	"a8c4",
   "Guai3",	"a9e4cf5eac62",
   "Guai4",	"a9c7f24ac95be973f04d",
   "Guan1",	"a978c3f6c65bab61b4c3ace1c560bafaadbeb2f0e6b2c960f8da",
   "Guan3",	"badec05db2f0b55fdf46d745dec7ebdd",
   "Guan4",	"ba44b365c4e9c5f8e1e8bf64c67cab61c65bc963f6edf6f0def3f7ebf975d5e1d556d8f9f171f9ca",
   "Guang1",	"a5faafd6aca9d1e9d2aecd59d3a4e4b4ce5bd27c",
   "Guang3",	"bc73c278",
   "Guang4",	"b37dd1e9edefdb52f474",
   "Gui1",	"c26bb357c074bac0bbd3a663af5eacd4b3c8d8b5e5e2c244e5e4d0b8d6cad9ece174e1f0",
   "Gui3",	"b0adad79b8deacd1d46fb4bec973edc2cbc1ce56c9a3ce69e7a5d177d6bfdbb9dffee146",
   "Gui4",	"b651aedbc264b8f7e4f3de60c5edcccbcd50dae4cf40e56bf2efe5c5",
   "Gun3",	"ba75b34fc358e36cbe40d5a5e752",
   "Gun4",	"b4d2ed6b",
   "Guo1",	"b3a2c1e7c1b4b3fae14fd4f4d4ade162e9f1",
   "Guo2",	"b0eab9f6e77eef55ba51e3a2e741e2b6e1d5edc4",
   "Guo3",	"aa47bb71bccde3e2e84be35fb274d5fed55df665ebe9",
   "Guo4",	"b94c",
   "H1",	"a37e",
   "Ha1",	"aba2",
   "Ha2",	"b5f0",
   "Ha3",	"aba2",
   "Hai1",	"ab79b6d9cbe8",
   "Hai2",	"c1d9abc4c065e8b8",
   "Hai3",	"aefceec6d657",
   "Hai4",	"ae60a5e8c062b6d9aef3dccddaece4cf",
   "Han1",	"b66fc24db346e977dcaceca1d0fddec3e450e17b",
   "Han2",	"b448a774a8e7b25bc1facdd5a6bdca52ba6dd672d5c2e8a2d655",
   "Han3",	"b3dba875c944e755f344ecc7",
   "Han4",	"a94dba7ea6bda7f2b26bbed1bfabbed9aeabc058c9e4c376d846aec2e5c3e663d5a9ca43dabedb72d3e0be5ad7f7ef5fd141d254d5f6e0e4e3e7be67eb5fef46f170f246f2f9e875f6b9",
   "Hang1",	"c971",
   "Hang2",	"a6e6afe8aa43a75ce0deaeeccdcccdb3cdacd3b9ccc3d7d2e0d7e8da",
   "Hang3",	"d3fe",
   "Hang4",	"a6e6a859",
   "Hao1",	"bb55ecc3ee51",
   "Hao2",	"b8b9b240bba8c0a2c0dac4aeb8e8c07ac562b348b6e7f4a9e7dacdf3f64d",
   "Hao3",	"a66eb071",
   "Hao4",	"b8b9afd3af45b571c2eeb255a9fea66ef8afe650e6b8c556b952cffbd5fdde45e6bad144d1aef6aacef0edf3",
   "He1",	"b3dca8feb646ceab",
   "He2",	"a6f3a658a94daa65b2fcaed6b2b0a5ddbdc5a8f0c2f3bbd7ac54f7cfb255af72f2f2bb5cb8e8bbd2acf8de4ebfade7b2b6dff1eaada8ef50f5a6e0caec7df17bdb5dcc51ddfee2c2e3bbeabbeb5bf05ad2ccdd5ddde7e65dd3e6",
   "He4",	"b650a94dc562b3dcb2fcc07ebbaeb071b77bdccae2bada74eae4cbcbde77",
   "He5",	"a94d",
   "Hei1",	"b6c2bc4be648",
   "Hei3",	"b6c2",
   "Hen2",	"b2aacedae8b2",
   "Hen3",	"abdcacbd",
   "Hen4",	"abeb",
   "Heng1",	"a6ebadf3d750ebb0",
   "Heng2",	"beeeabedbfc5f9dad2b2f4c1aeecce64f76dddf3e44bebb0d968cbbc",
   "Heng4",	"beeed4a6e65adafb",
   "Hong1",	"c546aba1af4dc1a9d0b1caa1d96eda48ce46ebcee7e5eeeada60e4e1",
   "Hong2",	"acf5ac78a7bbc245ad69a5b0aa6cb052e862b6a3c664d041d354d363d247e4c2cb5edfd2d367c966cb52dadddc72eef8c9cecb6cd7cdda43db58e044e052e6dde974cd6fd07d",
   "Hong3",	"aba1dccf",
   "Hong4",	"c069a845e5feedfbeeed",
   "Hou1",	"f3f8",
   "Hou2",	"b555ab4ab3efbd6aeedbef53e2dfe4a5e6f5f56fdfdf",
   "Hou3",	"a771",
   "Hou4",	"abe1add4ab70a65ab06dc64dce5eb3fbd0bfdc5adafdcfac",
   "Hu1",	"a9bfa949a547b1abe2a3c0b8da70d9dbeaf0d77cca76ca4fe570e1a1ccc7e5f0d652cbf9ccd1d47dce7ad5f5f0e2c9c1d641",
   "Hu2",	"ad4ab4f2b3fdbdb9bd6baab0a9b7b8acc447b7e4ef4db1d8c35ba77aead1e7c1ee7debd9da70ddacf57ce5dad8c8caecf574d656e8dceb6df260ddede152f5af",
   "Hu3",	"aaeab55be271b0e4b35ccb5c",
   "Hu4",	"c540a4e1a4acbaadb1afb27dcc7cd2e9d343c9bcccb2b7b1a85bcc5ee46af4b3f851cce1e5eeccc8e171d4d7e16ce668eeb2df63eea6e77a",
   "Hua1",	"aae1b5d8bc4df872ebfb",
   "Hua2",	"b5d8b7c6a645b7e2c3cfbc4dbeecf77ef4f3c1c5b9bad4f5d840eb62",
   "Hua4",	"b8dca4c6b565b9babeecb5d8e554e1e3d4f5e55fcce7dffce5d4f070e645",
   "Huai2",	"c368b261abdeba69bdefcbbfcae4eb77eb76f454f266",
   "Huai4",	"c361a7a5e7e4d165ce45f7f2f7f6",
   "Huan1",	"c577f9c2f94ef5ddcb61f5ccf65be8ee",
   "Huan2",	"c1d9c0f4aed9f2b4f855c1ecf660bec8f66cb1fbaca7f8b2e058bf4ad37bdb7bcb77d1b3df6ce97ceeb3e953cfc2dca5",
   "Huan3",	"bd77b570e9ebdabae464",
   "Huan4",	"b4abb3eaabc6b177a4dbb7d8abb7b541bac8b8e6b1fbdc4de9a6e2a1d152f4dedebde449f5c6ea7c",
   "Huang1",	"afeeb757a877d0aac9daefbe",
   "Huang2",	"b6c0b461b471c2aebf58c144bdc0b7d7acd3b0c4b547b94eb6aae643bd68d874e74aeedaea49c341f576d8b1f0c1d45dedb5f86fd8cef3bfd8eedfcdef52e5b2e67df34c",
   "Huang3",	"c1c0abe9aeccb745aca9cca4e261e2bdf167de53e6b9",
   "Huang4",	"aeccdc41",
   "Hui1",	"a6c7b4a7bdf7abecb8d9b775bea3c0b2bc5ae7c3d95af16fde6be6f8d3dfe7c7cfa4e0d2f773f7b3cee5d86be341",
   "Hui2",	"a65eb06ab5eeaff5d3cacf77d6a4cec8f2c7",
   "Hui3",	"b77caeacbba3b7b4c0ecb8ecad6ba6e4d274e9e5ecfdf4d5",
   "Hui4",	"b77cb466b6d7c3b8bc7ab74ac2a9bba3b8ecb1e2b16bbfd0bceca563bfb7e9f4c0edb3f1d17dee50f2bef546e14ae5cdedbcf072f06ef0c0ed6ee55ee5a2e659f055f2faf75bf4fce9d8dd5fe050e549e756ea5bef51f668f677d06af05ff2ef",
   "Hun1",	"b142a9fcb8a7ec4ed55fe2e8d9e0d9d5d5f7ddbcdedf",
   "Hun2",	"bbeeb4fdc05fb256b7e9ddccef4cd9d0f1a8f7cbedd7f149",
   "Hun3",	"b256dee0",
   "Hun4",	"b256b4fdde54eba1d149e1c4be40d0dcb1fb",
   "Huo1",	"c1c5",
   "Huo2",	"aca1cbc3dc64dfaa",
   "Huo3",	"a4f5a5ebb9d9dc64",
   "Huo4",	"a9cec3acc0f2a94db462bad7c04eb366c1c5c0a4f4c9ecc4f4b9f769f27cefe6c0e2cff1f174d6bac0c3da46f3beeea5d1c5cb5dd2d0d56edcd1f043f07ef245f25ff452f5e0f84ff8cf",
   "Huo5",	"a94d",
   "I1",	"a3b8a3b0",
   "Ie1",	"a3ae",
   "J1",	"a3a1",
   "Ji1",	"bef7b0f2bf6ec15ac2ddbf45b8f1ae56c2fbc4c8a6d9bd5db0a7a95fb7eef9d6badfc146c3d5c5f9a44cc9f3a5e4ae6ac545bf59b458bc54bd42b452b551f6d2a8e4b4c1a97eae41b6d6edb0f8f4c27ef744f7f1e7d1eefbdbb5e4aeccd3c946c95cedcecdcaf4f8efdddef8e26ae5e3e7dff3f9f670f76cf7acf87ed340d0e9eef4f8e7f5df",
   "Ji2",	"a4ceafc5b7a5a759b6b0abe6c0bbaf65c479a64eb149bfe8afe1a7a3ae41b6faa856ab45a659b4c6c2c7bd43b7aaa7c4d344f6c0b761ddfbeebda5f9e3b0e3a1cdbfee44e7fadc6bcbb8d14bce63e9eff0d3e94fe64fef79e969cfa1cadfda53cce5e4afcfbff542dfe9d3d6d464d548d76edce7e1fee26fe3a9e758e9c7eb40f4dff66ecad5d1b9d5b8d6c5e8b1eb5cd7c7",
   "Ji3",	"b458b5b9a476c0bdafe1b475c0d9a44cb9a8cacdf0cad0e9d571ccfee7fdf7a9c950edb3c9cce5b0",
   "Ji4",	"ad70b04fac4aacf6bbdac47ea975b148a7dea7b2c0d9beafc3b4b1aab2bda7d2ba5bbeacc34dc356bd5ec545c2c9c66bc5b4c1aac067ede4c1bbc9abacade2dbe45becc1d8a7d8fce2b8f2a6aae7dfbdded3f278eaafef72f95cf3d7f7b6c95ec9bedb53dff7e345e44ce4ddea78ed40f044f1d4f1e9f241f460f570f5f9f7f5",
   "Jia1",	"ae61a55bb9c5a8ceb3c3ad7bcf45b350af6dd6d2cfc9dbf6ad58b8b5bfded740f5b3cd4acf6af153ecacda72dd58dea6ebb1a7a8",
   "Jia2",	"a7a8aeb5c055dfe6b2f3af48b1aed3f7d17cdbcbdf49dff8e868d5b3e071d755d140e4a6d6b3caf6e4c4e8b3f1d2",
   "Jia3",	"b0b2a5d2b8ebb95bcc61ad4bd97ae248e2ddecf8d8cacfd2d8f5ddd9ae4c",
   "Jia4",	"bbf9b0b2ac5bbe72b6f9b8ebbd5bc9b2",
   "Jian1",	"b6a1bacab0eda679adddaad3c17da66cabc1b7cebd70c271baa5bae0c4e8b5d5ccb1f179da66ddecbfa1b4e6ea4ae3b6f6b4dd5edea5f6fdd7cfc669f3c2dc65f954f7aef6abf5cfe66ceb46d959ddb8c9dbdba2dca9dfd1e8e6ef54f27ef3b7f3eaf462f8bcd55ad668efab",
   "Jian3",	"c2b2bedfb0c5b4eec0cbb47ac3b5bbfcc650ac5ab863e6f9eeaae1d6eebff756d7d6d8aca65ff575d1c9da51c2a5d8d2f0a5f949ddc1deb9",
   "Jian4",	"a8a3abd8b0b7baa5a5f3b6a1bacac1e4c5b2bd62bc43c4a5c5b3bde2bdeebfcfb7b7c2cbc05eb878c271b9b0c265b6a2cf74d0d0cfbdd1e5ddd4d2b6f468bceeed7daff2e7d7e25de6e2f572e75eec44ee5ef0d9f4abf956",
   "Jiang1",	"b14ea6bfc3a6bbf8bcdfabb8c1a4d3deed4cc5b7ee6ced45d373f058cd6fe37e",
   "Jiang3",	"c1bfbcfabdb1bcd5f3a7e743",
   "Jiang4",	"adb0a64bc2e6b16ab14eb5bcedcfcf7af0ece1b0becad54cdbc9",
   "Jiao1",	"b1d0a5e6bda6c5bab54abc62ada5b8f8bce5b5ebbfbcc147b4d4d374abbbc242e0fae5a9ca4df86bea4eb8e5f860f4f7ef77f86ae153e9a1eaf1edb6ee64f6c7e568f0c8",
   "Jiao2",	"c45a",
   "Jiao3",	"b87da8a4c3bac5cdb6d3c142b5b1abbbcbb3bbe5b2aeb9aeb6cfb8fbbbc7acbef051e4efdadef0c6e1f3e5b9d1bff7e5ecf2e2aee4f2f340dea2",
   "Jiao4",	"b1d0a573aed5b8fbc4b1c3e2b5a2f6f5c3e7e975e943e569ced5e1f5d2abf8c9de5dd2fae150e64ef4d3",
   "Jie1",	"b5f3b1b5acd2b6a5b4a6b0bab6d8d86ee96eb5b2d9f4ee4edbc3d478d9acdb61e7a8f57e",
   "Jie2",	"b860bce4b3c7b1b6badca754ba49b5b2aa4ebe65b8d7aee5b7fbb050cdfcabfabd7ec0cdaedca46df04bdaf4d455c25ed0cccbd5d4d0dddabad4ef6acac6e251ca44dbc3d8e0d1eff3c0de66e0c5f543d3d6d3f0d4fadd50dde5e05fe7f8e9ade9f6eee6f9a7cccdd1b9e367efc4e572",
   "Jie3",	"a96ab8d1a96eecfbd4e3",
   "Jie4",	"acc9adc9a4b6a7d9c2c7a9a1acceaae3bb7cb8d1d47ad86ecd6bd3c8e2c7eb7acaa5cac9c9b2cff0d1a3d358dad2f950f2b6",
   "Jin1",	"a4b5aaf7b854ac7aa4e7a479b5acc3ccace1aefbad6fd3d7dad4e2d3db7ed2b4d156d357e56ad564",
   "Jin3",	"baf2b6c8c041c2d4bea8c2d1bd40c444e5d3e158e5f2d4bbe1cbdb6aceaf",
   "Jin4",	"b669aaf1bac9b854aecabea8aefbab6cc2d1c275e1b6beb6e0dabfa7b6c8f0b0cab5f652dd48dda8cdafea68ebb5ecd3e25de4e9e763ea6eecc2ed53f045c9bbde61",
   "Jing1",	"b867baeba8cac5e5b7fab2f4b4b9b5d7b9b8aef9c448aff0b1dcb865f5b4e352f3dbcacad4e1d5a8f1d3f3d9f6d1f8e8c9b0d561",
   "Jing3",	"b4bac4b5a4abc056a8c0e4eabf5bbca9cdf0ed6dc964d64cece1e9baf2e4ea58",
   "Jing4",	"b771b3bac3e8c052b9d2b262c476b377ae7cb974ab6cd0e1d748b56ae2cbd0c8e8b0df45d4d1d5c8cddfd0e4dfbce9a7d179",
   "Jiong1",	"ced3cbf7e8cc",
   "Jiong3",	"b57ead7edea3ccf9cd52d6e7eb75ca6ae662caa8e6bbacb3e571edd4",
   "Jiu1",	"aac8b4aab3eeb9a7f147da47e5d6dd79c956c9f2ca42d0afd96adbaef9c4",
   "Jiu3",	"a445a45bb073a868ad76a862adb4aac8",
   "Jiu4",	"b44ea873b1cfc2c2b8a4a6ddac5eaab9a953e0f0f86cb45cd1b5e5aaf3ccf3f2",
   "Ju1",	"a97ea9ebbe73aa71af6ab349aaaeadd1a8aebff7e3fad075dbedd35fdb5ed4d4d9b9db4cd4f9d2c7daa1e0d5d5fadfc6eca2f3e1cee9d963e3dee7fce07c",
   "Ju2",	"a7bdc1f9b5e2beefb1c5bbb1aedcd1b7f17cab5dcbd6e842e876f1d5f5a4d9bed64bd644f9b5cfbed5b6dc56dea7e07be35ce7f0f3e5f5f6f7cad84aef5e",
   "Ju3",	"c17caf78a943b2f7aa71c4d4f5d1df4cebc4e3afd9bccf40d2fdd7c3dbf8e7b7",
   "Ju4",	"bedaa579a8e3a5a8bc40bb45add1a9dab65abff7c4dfb964acb2dbd6c1d8add0c2a3bdf5c1fcccfbad55eab2f4e4c0abd2eee3d4e17ef65fca5cd575d6decc4ecca5d6eba8acd6fecc5dd4c5d77ee8c8e9f2f0f2f4d7cd48da5ee94bda6c",
   "Juan1",	"aebdae53c359aefec54fb0e9f7f8d5afa8add74fdff9",
   "Juan3",	"b1b2a8f7d4afdb64eded",
   "Juan4",	"adc2a8f7b2b2b868b96dd1a6af58b0e9ea5ddabfdedadafedc52ceb2ebdfdb4ae8b5ec72",
   "Jue1",	"e4feb6d8e5b1",
   "Jue2",	"a84dc4b1b5b4c0efb1b8c45ab35ab3d6bcfbc3ddbfb9b155c5ccadcfa7e0bebbf477d7c6a8a4a46eaab2b9bbe9c8f5dac3d4efc2c5a9cd69b87dede9eb54f9abf7dbd5c1e644bea1f9aad7d8c5edd852d8e0e6b5f96ef4f2f9c1f7e9d1c2cdb8d654dc69d3c0d7ced7d3e0f6e57cf0d0f7d8f85af86ed4b3d5def6f9",
   "Jue3",	"c3dd",
   "Jue4",	"adcf",
   "Jun1",	"ad78a767a7a1b676e2e1cbf0ecb1d764f1cbd5c9d3cdd3d5ec59c074deea",
   "Jun3",	"b57ee3e4",
   "Jun4",	"ab54b5dfb070ae6db5a4b96dc0e0c240bfb8af43d673daadd64dd1b8e8c5e359e95dd5accaa3f1dcdfcee76a",
   "K1",	"a37d",
   "Ka1",	"a940b3d8aba2e0c7",
   "Ka3",	"a564ab79ca61",
   "Ka4",	"b3d8f3c1",
   "Kai1",	"b67db47bd67ccbb4",
   "Kai3",	"b3cdb46eb7a2b75fb3cfb05af15adce5f16deed2f3ace1f8e074",
   "Kai4",	"b46eb75ab474ab79d1f5d271d46eeccd",
   "Kan1",	"a55ab3f4b0c9b760acddf7ced8dc",
   "Kan3",	"ace5a8d4a7a2ae72c265d9dcf4dcddfaefe8d4b9c942f1a9",
   "Kan4",	"acddc0fdb0c9f545f8f9eaa9d0abe165f7a6f4a5",
   "Kang1",	"b164ba42c152f36ee274e179",
   "Kang2",	"a6aa",
   "Kang3",	"ba42",
   "Kang4",	"a4aea7dcaaa1a5eac9c2caa9cb66dc7acba7dc70",
   "Kao1",	"c975",
   "Kao3",	"a6d2af4eabfed1dccaf7edf6cfa2",
   "Kao4",	"be61be52bab9",
   "Ke1",	"acecac5fa8e8b4cac1fbad56bd4fbd57b348bdc1b661b85cb85ecfc8d2dbf2acee48cea4e0b3e5efdea8d8e8",
   "Ke2",	"ab79b4df",
   "Ke3",	"a569b4f7d0f8a956cc65d4c6d975e95fe0ce",
   "Ke4",	"abc8bdd2a8e8a74aab67b3d8b7c2abf1b6dfe245bd79c34ed5dff1b2dda4cbd9cdf2",
   "Ken3",	"aad6b0d9bec1c0b5c569f3fbe056ebfa",
   "Ken4",	"d576d6b6dbcf",
   "Keng1",	"a77cdac8c3f4d65ea75ca8c2def2e8a1d15bd1c6eee8",
   "Keng3",	"d1c6",
   "Kong1",	"aac5b153adc3e34fd554b851d5e3ebf2",
   "Kong3",	"aea3a4d5adc3",
   "Kong4",	"aac5b1b1eefc",
   "Kou1",	"e1e0e1becdc3d7bcf363",
   "Kou3",	"a466",
   "Kou4",	"a6a9b146a56ee74db3a7f6b6dae5a746ccaae26ee6beedca",
   "Ku1",	"adfaac5cb85dbe75dbf2ced8d1f1cbd2f3a9d05ce9c6",
   "Ku3",	"ad57b7b1",
   "Ku4",	"ae77bfc7bbc5f441cd7de2e0d3e7",
   "Kua1",	"b8d8a66ace66d3a1d1d5cbba",
   "Kua3",	"abb1cbbae4b3",
   "Kua4",	"b8f3afe3ec6d",
   "Kuai1",	"ce4ad87b",
   "Kuai3",	"e3c7",
   "Kuai4",	"a7d6b6f4b77cb85fc0ccbc44ebd7e9f8c17ae944ea61bbfbf8dbe4d3f856d5d7",
   "Kuan1",	"bc65c662f2c1",
   "Kuan3",	"b4daedb7b1fb",
   "Kuang1",	"a64aaed8b5a8e046a8f1cec6cf6f",
   "Kuang2",	"a867bba5f1db",
   "Kuang3",	"cdea",
   "Kuang4",	"aa70c471c36daed8b2b5f14bdbe8c252f5e7daefefc9f269e576",
   "Kui1",	"c1abbf73b2aff377cbd1d1a7f54aeee5d378f0b1d86bf5c9f74a",
   "Kui2",	"bbedbaccabb6b47db8aab666dd74c4dcf3b8ddc0dc55ec5ae6fcddeeefe1d9f9d850ddeff8f7f9be",
   "Kui3",	"b3c8e069e0dfde79f0fccea1",
   "Kui4",	"b75cbcecb9bcf558c34ab3e7c2b1dcfbf07ce5a6edbdeb44ed7ee5ebe9ccf4f4e542e5b7f560d6b7e76c",
   "Kun1",	"a9f8b158a95bb562c043b54fe7c3d5adf3cbdb74f1b1b9a6d563d663",
   "Kun3",	"aeb9b869d1a8b1eee8a7dcf2df40dacadff3f7cd",
   "Kun4",	"a778b574d265",
   "Kuo3",	"e9ab",
   "Kuo4",	"ac41c258c1efb9f8f54ae272b5f2ce62f37af6fa",
   "L1",	"a37b",
   "La1",	"a9d4b0d5b3e2cf58eefdd6f7db69",
   "La2",	"ab66c3e5c9ed",
   "La3",	"b3e2f2d9",
   "La4",	"c3bec4faf84ebbb6ab66db4bb8a8f3c4e2dcddb7ddeb",
   "La5",	"b0d5",
   "Lai2",	"a8d3b5dcb174d5e9f1b0e35dd4fbd7ecebe4f3c9d9b7d54af3e0d4a8",
   "Lai4",	"bfe0c4eec375c5a3b7fde7ecf4bbd15f",
   "Lan2",	"c4f5c478c2c5c4e6c464c469c4b0b0fdb450c1f1f7fcf8c2c4e3c5d3f8f3f9a4f5d9f8aef2fdf8c6",
   "Lan3",	"c4fdc369c5f3c656c66ce949f8f6f8b0e85ff1fbf958d25f",
   "Lan4",	"c4eac0ddc66cf953eff9eccc",
   "Lang1",	"d86a",
   "Lang2",	"ada6af54b459bdb8b7e3b277b77ddad6d75bdfe2d5b0df47e863cdddd171d1f9",
   "Lang3",	"aed4e8a6dac5ceacd1a2e44ed648dcf1",
   "Lang4",	"aef6d14ae3ac",
   "Lao1",	"bcb4",
   "Lao2",	"b3d2a863c0f7e5fcbc47f152d248f4f9f062f0bbe563",
   "Lao3",	"a6d1abbea8d0d1ddcfc1f357ce4ce9c9e47bcec4d379",
   "Lao4",	"b3d2b5b8af4fb954e16ff355e9d4e0f2",
   "Le4",	"bcd6a955b0c7a6d8ccf8d14da57bc952d1bbc97dc9aad2e3f7afc9a4d142cda7",
   "Le5",	"a446",
   "Lei1",	"b0c7",
   "Lei2",	"b970f5ecbeddb9e3c54ac3bdc15df5eded44e6aef24ff276f641f764f7d2f8f2",
   "Lei3",	"b2d6c253c077baaaa6d4bd55c1a2e04cf2d2e5eaf04ff057daf5eaa4f973e6b4f24ff254f47cf5d8f757f97ce8bcf47bf74bf945",
   "Lei4",	"c3feb25cb2d6beddf5e8e474e4b6f7d0f7f4f8b6",
   "Leng2",	"b857d4f7d9b1ee55bdb7d0cdb7ab",
   "Leng3",	"a74e",
   "Leng4",	"b468e844b7ab",
   "Li1",	"adf9",
   "Li2",	"c2f7bcfebea4b1f9c658c2e7bcf9bfa9bba9c67ab270ba76f6e8af57f2d4b8c4c4f9f9cfe175ee71f5b6d5bce5faedd0eb49e5f8cdf9f7f0dcc6b3ededccf14ef9cef7d1f6dbf6dff678e17de5cbf0dbf3d1f3eef6e0c452db7af84df875d34ef7c7",
   "Li3",	"a7f5a8bdb8ccb27ac2a7f9d8adf9af40c355ae5bab5abf43c5ddc4bfc4f9f8d7be59df55e054ce7ef8f4",
   "Li4",	"a44fa5dfa751c452befac363a8d2bee4b2fabc46c079c472b2c9bb59c645c377c4d7c1f5c474a64fafefaedfb758ab57b567c27eb2c1a9d1b0e6c5b0b27cdbe0f1f2b7ccc4f7f455cd42f5e6f252f765f274ef67d2aaf473eabcd06bd145c976f760b07ab0acf471d2f5e2d4f848cc6cc9f1c5cff4a1d0b2eca4cfedeff2d2dad560d7a9d864df53e374e3eff056f248f272f4bef646f6baf6caf6e2f755f7bef8a9f978f9add1e4d259dceeddb9e7a4efb9f24bf843f8b3f979d164",
   "Lia3",	"adc7",
   "Lian2",	"b373c170bca6b747bdacbaa7c3aec549c5bfb9dde6a3a9a9ee72e155f154f569de49f2e7e5d1ede0f0dee443e6c2befcede5edf7f0fdf4d4f6dae95a",
   "Lian3",	"c179f14ceae9e1f1dcb6f2bd",
   "Lian4",	"bd6dc1e5c5cab7d2c3ecc0d4c0c4c46bb7aff2f0d9efea46f5fded4bee56dfb5d8a9",
   "Liang2",	"a87db1e7b671c2b3b244b864bcd9d9cae378e847ef59",
   "Liang3",	"a8e2adc7c352e379e3f8",
   "Liang4",	"b671ab47bdccbdf8d867b4bdb244d479e457da4ed1a2",
   "Liao1",	"bcba",
   "Liao2",	"b2e1bc64bff1c0f8b9e9bcbab9b1bce3bc49c2b7f4efe556e679f863efc3f7bae3aae27be1e5f0eee1a7e1cce56ce5bfeab6eaedf067f376f553f673f551",
   "Liao3",	"a446c141e764e5a4d442bee9e46df0c2",
   "Liao4",	"b9f9aec6c141bf52c9d5e1e6cd53ee62e6d3",
   "Lie1",	"aba8",
   "Lie4",	"a643af50a648b5f5c279b1caa8e6c663f761ac7bd37edee1efd4e064ce75d3ead74adbb6dfeee8beecbdef71efa5f271",
   "Lin2",	"aa4cc17bbe46b24fc5ecc5efc04dc143b559bfeee562bf4dbf5ae360c3e1e5fbb7f7ed73ed7ad559e9b9df69f778dee8e353ed6ff076e0fcf07af350f442f4e9",
   "Lin3",	"bbfebecfe96fecf5dbabdcb1e36a",
   "Lin4",	"a75bc66ec4a9b8eee9c0ec4dda65",
   "Ling1",	"a9f0",
   "Ling2",	"b973acc2c646b961c4d6b3aeade2b5d9b2e2b2dcad64a744baf0d5e6b2dec06fcbf1b34dd2beaa7ed757f4e1dc46ebf6c4e7cf61f9bbdedcd2e5dbdee849eefaf3c7f8c8cc64ac53e9fbcbe5cc41cc42cc52cd65d2cbcbefd676d6d8e441f5f3ccb0d4e2e8cdee53f9bcd4c2",
   "Ling3",	"bbe2c0adcc76",
   "Ling4",	"a54fa574cfb6",
   "Liu1",	"b7c8",
   "Liu2",	"bc42ac79af64b2b8af5bba68c273bd46bbbfd97ef561f365f675f6bfefcdeedcaca6f15edd46efc1dd55f2d6dbc4efacf6bedfd4f6b1dd57",
   "Liu3",	"ac68e371e6f1b967e0e3cfd6",
   "Liu4",	"a4bbb3b0b7c8c348c2fccbfdd6fcf379dd61dce8eebc",
   "Long2",	"c073b6a9c5a2c456c5a4c46ec467c14bf25ded74f453f5e2f450f1fdc4eff4b8f846f844f375f8cbf8d0f750f752f9b8efb7f6d5f74d",
   "Long3",	"c3f7c36cc362",
   "Long4",	"dbc1d0f1f240d5b1",
   "Lou1",	"ba4f",
   "Lou2",	"bcd3b9c6b0fac1b2c55cdcbce76fe1bde27eede7e66ef0e4edf0f54bf7bdea79",
   "Lou3",	"c14dba4fe15ce1a8",
   "Lou4",	"ba7cadaec553c3f3bf62",
   "Lu1",	"c250",
   "Lu2",	"bf63c4aac366c4a4c46cc660c379c674f847f1f6f9b7d66af743f746c644f6fef456f1f3f247f74ff742",
   "Lu3",	"be7cb8b8bedbbab1b3bfc372f2c5eaadf666f373e769efd7f25b",
   "Lu4",	"b8f4b3b0bffdb3c0c553b8efb853b84cb4e2c453c64fbcaef146dc4fe275e078b6cee9f0f6fced69ca46def7bf72edbbe85ef1b3d5f1daa3ded7eaaccc74db77e753ebf5ce5af370f3d4e1dcd6b5dedee1b5e66ae7f9ee46ee5cf2abf3ddd5fbe163f0fa",
   "Lu:2",	"c66abe5bc371f2d1e1cfe5f6e742",
   "Lu:3",	"a766aec8bc69ab51be54b9f0c15cc1b9b0fabb4de27ef4a4d5cdd3f9cee2df65ecbbd6c0",
   "Lu:4",	"abdfbaf1b276bc7bc26fd8e9e6fef84adb77dfd0ecbf",
   "Lu:an2",	"c5cbc570",
   "Lu:an3",	"f6dc",
   "Lu:e4",	"b2a4b1b0e86ee1e6efd3",
   "Luan2",	"c572c671c67dc665f943f96bf7e1f7dff8baf9cc",
   "Luan3",	"a75a",
   "Luan4",	"b6c3ee4a",
   "Lun1",	"b1c1",
   "Lun2",	"addbbdd7bdfcb25fb15ba8dabafab1c1d4acdef1ec43d565d84bdba1e846d9c3e3ee",
   "Lun3",	"df41",
   "Lun4",	"bdd7de6a",
   "Luo1",	"c56f",
   "Luo2",	"c3b9c1b3c5dac672c5dec659c55bc56fc57ac4d8f2f4e1e7f7e2e76dc3f1f8e3cbd3",
   "Luo3",	"bb72ea73f5f0f2dde3cceecf",
   "Luo4",	"b8a8c064aca5b5b8bbdcaf4fb954eff6babaaba3af5ff942dbcad6b8ef70efa1ceaa",
   "M1",	"a376",
   "Ma1",	"b6fdb6dcc0a8",
   "Ma2",	"b3c2b7f2b9c0bbf2c1b0e673",
   "Ma3",	"b0a8bfc2bd58babfde62b6dcf156f6c5e14d",
   "Ma4",	"bd7ce6ccd858e259",
   "Ma5",	"b9c0b6dcc1b0",
   "Mai2",	"ae49c5b5f0b4",
   "Mai3",	"b652e547f868",
   "Mai4",	"bde6b3c1c1daafdfe4f4e7b1",
   "Man2",	"c65ac443bf66c2dabaa9f54ff0e3c5c1e6a4d1abe1cae5d8f6a5f6a4",
   "Man3",	"baa1ae5ef8b4",
   "Man4",	"ba43baa9b0d2bdafb9f7e170c3eec167e15be672ea42dcbbe2cd",
   "Mang2",	"a6a3a87eafedaabcaa5dcabedac9ca51d0f6cab1a841cd76e86cd160d65ddab3dfe7ef5cf4c0f878d042",
   "Mang3",	"b2f5c1afe2a5c9f9d178dac7db5ce169",
   "Mao1",	"bfdf",
   "Mao2",	"a4f2ad54a5d9bbecc1e3d1d1ee69cdbbe7bae8d5d8cbd8a8d35dd7f6e55cf5a3ccdad7dcda55",
   "Mao3",	"a566cef6aa7dad67",
   "Mao4",	"b455ab5fbbaab654ad5ab7e8c0b7d1d1acfed8b9ddd5cfe4e2e7cdbbd7c0de41e748dfc0e85a",
   "Mei2",	"a853b7d1acdcaa54b1f6b443b2f9be60aab4c5f0b7b0b544d8ddd0a3e2fbdc53d8abdebbd751e871ca7adf75e15fecddf44b",
   "Mei3",	"acfca843c1e2d25adcf6d9edd8c3d1c0ea54",
   "Mei4",	"a966b441b44bac4ed2cebe79b7e8aa7ab04cdab6e4c9de71e7ae",
   "Men1",	"b465",
   "Men2",	"aaf9adccb1bfe5d2ebeaeab0dbaff9c7",
   "Men3",	"e5c8",
   "Men4",	"b465bf54c256",
   "Meng2",	"bb58b7f9b5dec3a9c261c0dbc263c36aecdcbf5fea7bf4b6ad6aefdacd70f2a4efeae0d6d766e8f7eb45ebd5eec4f777f960",
   "Meng3",	"b272bb67bb53bff8c36af4c8ece7dec1",
   "Meng4",	"b9daa973f771f178",
   "Mi1",	"ab7dbd4e",
   "Mi2",	"b067c0b1c1bcc46ac3fbc153c247edddf46ef7f3cbcdf5b2eec5f8c7efe4f5f2f6e1f6f1f7e6efaaf95e",
   "Mi3",	"a6ccc3fbabdaaec5d6a9e477d9f7dfbee76bed51f6e9",
   "Mi4",	"b14bbb65afb5afa6b356aa63a851c1c4cc57beaddce2e96de8f2f2bbdd59e2b7a6cdcea2e258e26de74cf643e147",
   "Mian2",	"b4d6baf8af76d8b6d4ede7aaf251f27af476",
   "Mian3",	"a74bab6abd71b0c3ae59c053b542a85cb0c1cfe2df5fc94dcde9d94dd879f1c9",
   "Mian4",	"adb1c4d1",
   "Miao1",	"d870",
   "Miao2",	"ad5db479bacbf85e",
   "Miao3",	"acedb4f9c2c6c2e4bd7aaa48ace0d9e7aa57e6da",
   "Miao4",	"a7aebc71c15bcfc6",
   "Mie1",	"aba7c941aacb",
   "Mie4",	"b7c0bdb0f647c14ef642efc5dbd0dda9ee47efcbeff1f47af977",
   "Min2",	"a5c1a9a2aab3e6e8ded0d0a2cc78ccc9e0c3ccc5ec42d35eec4acc7ed4feddc3",
   "Min3",	"b1d3bca7b67bbbd4a9d7aa7ba5d7b543b75de0efbf49d6d0cee8ca6ee4ecf06addbce65e",
   "Ming2",	"a9faa657bbefbbcabfc1addfbd50ba5caffab955de48e3b2e0a5cf79e240dcf3ee79e051e2bb",
   "Ming3",	"d6aece71dd6f",
   "Ming4",	"a952ba5c",
   "Miu1",	"d0f3",
   "Miu4",	"c2d5",
   "Mo1",	"ba4e",
   "Mo2",	"bcd2bf69bcafbda4c155c55dbcb1c2d3c4a8f5c2e172f2d7f6a2",
   "Mo3",	"a9d9",
   "Mo4",	"a5bdb2f6c071ba7aa853bda4b9e6adafaa5cafdfaa6aafb0ad5bc55abea5b8e7bf69ea70e4c0ccebf3b1e46ef5ebf177efbbd6afea7ef2d7e5c9cefef26dcc45c945e4b1f368f0f1d6e0dbbedbc5e14be166e1cef0c5f6a3d772dffbedd5e14d",
   "Mo5",	"bbf2",
   "Mou2",	"bfd1b2b6c15ba6c8cbc6e7baeededbbfefadcfa8e4b5efa4cbedce4e",
   "Mou3",	"ac59c94ee45e",
   "Mu2",	"bcd2e5f5",
   "Mu3",	"a5c0af61a864a969a9e6cfbce0beabbecea8d2e4",
   "Mu4",	"a4eca5d8b9f5aaaabc7db9d3b6d2bf70b7fcbcc7a84ead60f5addde6e8afe0bbcd56cbf8d241d3bee1b3f17ed771",
   "N1",	"a37aa3b4",
   "Na2",	"aeb3d1b2ced4e7e3",
   "Na3",	"a8baadfe",
   "Na4",	"a8baafc7a76fb35bb675b1ccae52cdb0d3d4d7decab4d7d1e8ded6d5",
   "Nai2",	"ecd7e5ba",
   "Nai3",	"a444a5a4b069a6bbeccea960ccedd443ca4e",
   "Nai4",	"ad40a960eb71e8f3cf55d0d2eb6ed9f2ebe5",
   "Nan1",	"a65fc9c6",
   "Nan2",	"ab6ea86bc3f8b3e4b7a3cf49ddc6eba4c9cfdfd9d778",
   "Nan3",	"b369f7d9e7bcd9f5df76d96b",
   "Nan4",	"c3f8d8c9",
   "Nang1",	"f8ee",
   "Nang2",	"c56e",
   "Nang3",	"c4e4f8eff8f5",
   "Nang4",	"f9d4",
   "Nao1",	"d16f",
   "Nao2",	"bcb8c4c2bef8a94cda71ccacf2f8f7a4e960effef2b3f6eff1f9",
   "Nao3",	"b8a3b46fb7ea",
   "Nao4",	"be78d5ef",
   "Ne1",	"a94f",
   "Ne5",	"a94f",
   "Nei3",	"be6badfedb4e",
   "Nei4",	"a4ba",
   "Nen4",	"b9e0",
   "Neng2",	"afe0f0a4e8f4",
   "Neng4",	"c0d7",
   "Ng1",	"a3b6",
   "Ni2",	"aa64a5a7a967add9c04fa9cbd665e3eae84ed7edf3f3f1caf3cdf8a4f944d2f3cd5de7d3d4dcd646a94fcd62d16bdbf5e0b7f3ec",
   "Ni3",	"a741a970c0c0f2a5e8f6b1ddceeecbf4cf46f0aeefe4ccbbd06fe4d2eef6f650",
   "Ni4",	"b066b7c4b0cebfb0aa64b845bccad8fdf6b5f6b7e17ceacfd0b4d4cc",
   "Nian2",	"a67ec248d6dfce70",
   "Nian3",	"b1c9bcbfc25ba9e0bdfbbd56af47edcddbf9f655f3ce",
   "Nian4",	"a9c0b0e1d5f9f5bca4dcf5b8",
   "Niang2",	"ae51c45d",
   "Niang4",	"c643",
   "Niao3",	"b3beb8cdecd0bec5dcf5e772eb73",
   "Niao4",	"a7bf",
   "Nie1",	"aebae845f76e",
   "Nie2",	"d07c",
   "Nie4",	"c45ec2ecc65cc2bfc668af49c4d9f8a5afe5c941efbfeaf4f16edca1c56ad976f9aef741c4f4cd73dd51e458eab7f458f751f9c0f6dd",
   "Nin2",	"b17a",
   "Nin3",	"cee6",
   "Ning2",	"b9e7beaec0f1c07bc266daacc0bef95df76bd8d1f4b2ecd1",
   "Ning3",	"c0be",
   "Ning4",	"c0d7a6f0",
   "Niu1",	"a7ac",
   "Niu2",	"a4fb",
   "Niu3",	"afc3a7e1b673a7d7cb63cd55d770",
   "Niu4",	"a9ed",
   "Nong2",	"b941bf40c177bbfabebac2aaf2ebf4e5f9b9f854",
   "Nong4",	"a7cb",
   "Nou2",	"f4b0ed63",
   "Nou4",	"bfaef155dcd9f4d1",
   "Nu2",	"a5a3be71cc56d6d9e3ca",
   "Nu3",	"a756a9b8d2df",
   "Nu4",	"abe3",
   "Nu:3",	"a46bd046d7fd",
   "Nu:4",	"a7d7d17ed3d0d1d7",
   "Nu:e4",	"ad68bac4eba6",
   "Nuan3",	"b778ef4eb7dcd9f6",
   "Nuo2",	"aebfae52f5c0d57bd5ca",
   "Nuo3",	"e9d6",
   "Nuo4",	"bfd5c0b6c47addabd1bde0a3ece2eacb",
   "O1",	"b3e1a3ac",
   "O2",	"ae40",
   "Ou1",	"bcdabf5ebcdeb9c3f0ddc5c3a3b2e1d3b0cfe665e75ff250",
   "Ou2",	"caa1",
   "Ou3",	"b0b8c3c2b9c3bda2ca7eda42df78eaf9",
   "Ou4",	"b9c3e278bebe",
   "P1",	"a375",
   "Pa1",	"ad77b8b4b0d4d3c1d372",
   "Pa2",	"aaa6a5b6b55dafd2aa49d7da",
   "Pa4",	"a9c8a9accacbd7bd",
   "Pai1",	"a9e7b0d4",
   "Pai2",	"b1c6b550b172add6f06cd9d3",
   "Pai3",	"f478cdeb",
   "Pai4",	"aca3b4fbeecedfd5",
   "Pan1",	"bcefc36bcfe3",
   "Pan2",	"bd4cbd59c2cfafebad44ba6ec2daeda8bdedf3a3dd5cead9cefdeff8e3d2dcfde1d9dbf0",
   "Pan3",	"cbfe",
   "Pan4",	"a750ab71acdfaf60a9e9d7b5ccf1f94bdbe2d84ede64cb58cfb8e4cb",
   "Pang1",	"a5e3bd53b7bc",
   "Pang2",	"aec7c365bb48bfc0b74be3aecdf7cabedca7d3efd178eab8db59",
   "Pang3",	"dcdfeae5",
   "Pang4",	"ad44",
   "Pao1",	"a9dfd74b",
   "Pao2",	"b354a948a753b0cca9b4e8f0cfb2f5bee4c6acb6d2bd",
   "Pao3",	"b65d",
   "Pao4",	"aa77afa5acb6af70cc43ecb3e8d7",
   "Pei1",	"ad46a941a7a5e85bcf42cc5fd14ed3cf",
   "Pei2",	"b0f6bddfb3adbb70cdd6dee5d9e3d849d379",
   "Pei3",	"daa6cef1",
   "Pei4",	"b074a8d8a84baf5ce8aecc6ed1cfd253c5afce72d6fbc9b5",
   "Pen1",	"bc51e9de",
   "Pen2",	"acd6da4bdfe1",
   "Pen3",	"cbebf07bd6fd",
   "Peng1",	"af79b269a9e1cc7be2a7bceaca71e0d0cec2dbfce8c7eaa6",
   "Peng2",	"aa42b45ebceabdb4bfb1b84eb4d7c450c14ff0becba2d5f2f1bdded2ec40d0d6e84cdcbdec58ef68e57ee5e9f84c",
   "Peng3",	"b1b7d6a5",
   "Peng4",	"b849d4b8d56bd9ae",
   "Pi1",	"a7e5a9dca4c7bc41c552cfecb351a541cbf2a7a5ca60cd5fafc4d2efb965e8efccaed6f8dc6dece0e47ce8c9e8d3",
   "Pi2",	"a5d6af68b5cab55caa4abb74b0e0ac73b0f1a85deeb7ab40f2bcbd7dafc4d7efb3b2c567b965e3a8cf69cbadd7afe3ebcd68d341dc66ebedec77ee66f270ccecd666f2d3f7d7",
   "Pi3",	"a75fa4c7a5d4b56cf1f1d0a1a5f6c979c9c8d4fde7de",
   "Pi4",	"c4b4c550bbf7b742a7beb940c27df049e9a4e9eded57d5edd95ce276f8e5e8d6f059",
   "Pian1",	"bd67b0beabf3bda1dfcfd8bedbece8baf5ab",
   "Pian2",	"ab4bafe2c063ebabebc5dde1ec6b",
   "Pian4",	"a4f9c446b94d",
   "Piao1",	"c4c6ba7de1c9ee5ff0b7dcb8ecf1ede6f6a8",
   "Piao2",	"bf5db9e2d641",
   "Piao3",	"ba7dd767c165bf67d5dcf470e1e1f14ff26ef6ba",
   "Piao4",	"b2bcba7db6d1c559e1c0edbff54ee75b",
   "Pie1",	"bf68ba4ac97e",
   "Pie3",	"ba4a",
   "Pin1",	"abf7abb9f2a3d263",
   "Pin2",	"b368c378c057c649c0a7f1f5f279",
   "Pin3",	"ab7e",
   "Pin4",	"b875a6c9",
   "Ping1",	"a5e2ae5cd2dde8b9ee7b",
   "Ping2",	"a5adb27ebeccb5fbabccc4abb5d3a957ac69ccf2ceb0cf6edafce075cde5cfcccb6ed06dd0b7cbe9e34ddb5bdbb2b6bed3b1dfa9cfb0",
   "Ping3",	"daed",
   "Po1",	"aa69bce2a959ab40f4facfded6f8",
   "Po2",	"b143be49ed78efe5",
   "Po3",	"bbe1ade5a572d6db",
   "Po4",	"af7dada2be7aacc4aa79a6b5b2cbc3e6cc6ad273e3ba",
   "Pou1",	"ade5ca7d",
   "Pou2",	"d568b8cfcaebd1bc",
   "Pou3",	"ade5dec0d9abd4e0",
   "Pu1",	"bcb3a4b2be51bc50a5b7dab1f35fccb7eda3",
   "Pu2",	"b9b2beebb8b2bb5ab5d0a6b5c3dab2e3c0e4bf5cab6db340e3bcf0d6e472b07af4f5f359f4afe54e",
   "Pu3",	"b4b6aefaae48c3d0ae45b7c1d650e9e8f4eae656bba7",
   "Pu4",	"bcc9be51c272c36ee745",
   "Punctuations",	"a141a142a143a144a145a146a147a148a149a14aa14ba14ca14da14ea14fa150a151a152a153a154a155a156a157a158a159a15aa15ba15ca15da15ea15fa160a161a162a163a164a165a166a167a168a169a16aa16ba16ca16da16ea16fa170a171a172a173a174a175a176a177a178a179a17aa17ba17ca1a1a1a2a1a3a1a4a1a5a1a6a1a7a1a8a1a9a1aaa1aba1ac",
   "Q1",	"a3a2",
   "Qi1",	"a443a964b4dbb1adbaa3b4cfb17eb259ac6db5d6bca1b7cbcb50e7d5d7e9d4d3f8dce14ef550d551e24ee6c5d0cece48d1e1c1c6d0e2d4a7d54ed5c3e0f5e368eaa3ec51f1c1f3dcd972",
   "Qi2",	"a8e4b4c1bbf4a95fba58c34dace8b4d1b852f9d6aac2b154b561a7c1aa5bb558c451c55fb2a5c2c0ace9afcfb24ed7d7aa4be375f1afb04ef4bfa7a6c042d1d2db6de3dbd4c3e159f4c5e0e0ece3f4b7d3ced7ddf0adf35df3d5f567d3bdebf7d5a4cac8dee9db44d843c951d3c3def8e4dee7fbef6bf3def3dff7e7f963ed59",
   "Qi3",	"b05fb1d2b05aa45ebaf6a7fbbd5de376c9d7d9c9d973cb7dd4e5ca55cdbccaa6",
   "Qi4",	"a5f8aef0beb9a854b1f3abb4ace4aa5fa8b4b057c9fdbecdbd72ab45dfc2bf6cd1edb474a964f2e6f364cd79d3bdc9e1d9e8c961ebaed9e9e6acf879",
   "Qia1",	"d574",
   "Qia3",	"a564dc61",
   "Qia4",	"abeaaca2ceb1d94bd5dd",
   "Qian1",	"a464b95dbe45c3b1b26fc1bec5d2b44fa561a6e9c648c4cab75edcc2e1c7ba53eb72d049cac0cb4cc164cba1d952c9e7efe3f66ad4eedf6df243f44ef4d2f774c9d1c9e2ef49efabf256",
   "Qian2",	"ab65bffab0aebce7c072b958b040bae3b678d57ad8c4d961ea48ccb5f1bff5d5efafcae5caf5cac5e279dfb0e8ebf3b4f6acc9b0cc46d3c6d7e1e24b",
   "Qian3",	"bbbab24cc4fef4ade256e5afc9e2e3f0",
   "Qian4",	"a4edba70adc5dd67d37db9d5cdc0d853dccbe5dec164eac6e366d9cee3c8e848",
   "Qiang1",	"ba6ab5c4c2f2aacab6e6b76dc3f2f366e3d6eebeccc2e2d2d9aaf142ebe1cd7be1acb14ee2c5eea8",
   "Qiang2",	"b16ac0f0c1a5a9cff9d9e952c0cec962e27cf5fbe970beca",
   "Qiang3",	"b16ab76dee75eaaadcc4e168c166",
   "Qiang4",	"b6e6f5eed476e2c4",
   "Qiao1",	"ba56c1eabef5bcc0c3dfeda6f354e54be96bf074f1baf664f374dcece470e94aec6ad175dc57e8b7",
   "Qiao2",	"bef4c140b9b4b3ecbef6c2bcbcaceb4cedaec3d7f06bf34eea56e142e548e558f34be9b0",
   "Qiao3",	"a5a9aea8b473c44eb3b6ea4ee8b7",
   "Qiao4",	"c2bcc2acab4eae6bc054bba6bcc0b4dfd173e9a9f4d8",
   "Qie1",	"a4c1cb50",
   "Qie2",	"ad58a6f7ca47",
   "Qie3",	"a542",
   "Qie4",	"a4c1c5d1a963a9c4b467aeb2e6d7c1e6abb4e1f9e7f5f3d2dbb7e368f0b5d25e",
   "Qin1",	"bfcbab49b4dcd3daef5dbc6bdf5cf25ce86a",
   "Qin2",	"b6d4b55eafb3b856bee0aae0ecfeecdfbeb2cdc1eb5edc74dd41e5c2d368e0dde9fdcad0cdadd3c6d7e1dca4",
   "Qin3",	"b9eccccfd8d4e9b7ee60caabef48",
   "Qin4",	"a847bcc3d0f7db6b",
   "Qing1",	"b24dab43bbb4b6c9adebb242bb66b3bcc44ad4abd9e6cb67d7f0",
   "Qing2",	"b1a1b4b8c0bab6c9c0d2d0edd5dae5e0d5de",
   "Qing3",	"bdd0b3bce1b8",
   "Qing4",	"bc79c16abfcbd0e1e376f0e7bf6be653cb4df76ae4bed5a2deedf2ba",
   "Qiong1",	"cb7caac6e4a9",
   "Qiong2",	"bd61c3a3cb7caac6e072dbbcd946ca54ea63f2c8e6bdde72d6cce076f2d5d1e0d7d5dadfe9d5dfb3",
   "Qiu1",	"aceeaaf4a543b34cc2fec4cff5aedddfcbfadfc7d45ae6e6d8cfe75febbbc074cecfe7bdf0ccf644",
   "Qiu2",	"a844b279a57da4b3ada9b8cae07db241aa73f7b5d7e4cddec958e6a5df5bca4dcdc8e7a3e447e453dab9e867d84eecb8d0b0c9a6c9f0b1fcd444de75d076d35ad747d75cd8d9dcc1dfe4ec79f1ccd5db",
   "Qiu3",	"eac9",
   "Qu1",	"b0cfa97dc558c1cdc2dfb9f2a6b1b349c2a3d7b6e5beb5f1ca5dafa3d058cc60d2e7cbdcc942ccb6cdd8e8a5ec76f3e2f85cd6e5ec71",
   "Qu2",	"b4eba757c454c5fcf0d1c2a3f7ecc0f3f6e7f5f8edaaeaf8cefadc43eca9d6fadfc9e057e979ee6bf1e7f3fdf5d6f6e4f745f8bef951d061cee9d5f8dba7efa8",
   "Qu3",	"a8faa6b1b0f9c654cfa6d6e5",
   "Qu4",	"a568bdecb0f9baa3f2f3eef1da40ecb2ca6df1e1",
   "Quan1",	"b0e9d1aad9afcebcdafad557",
   "Quan2",	"a5fec576ac75b8e0aeb1bbcdb2acf9afbb6cdae2a8f7affef1bbd2a1e079a8dea4fcbdf4eec7ced1d4cfda68e041ec68f5caf6d4f8bdce74debee070ead2f9a3",
   "Quan3",	"a4fce365aab6accad66ef946cb51b0e9",
   "Quan4",	"c455a8e9d2a2d279daf3",
   "Que1",	"afcac2f6e3c5",
   "Que2",	"bf61",
   "Que4",	"ab6fbd54c44eb3b6a9c4c2f6ba65dd7cabf1b4dfc1f0e1c3d14fdaccdee7e6c1f05bdad0ded6e269f5e1",
   "Qun1",	"d7e7e45fd16e",
   "Qun2",	"b873b8c8d167",
   "R1",	"a3a7a3b7",
   "Ran2",	"b54dbf55be77d7a3d7a4d7b9",
   "Ran3",	"ac56a554be77ad5ccfd3e9cfcbe4cc49e17b",
   "Rang2",	"c463c5a1f6f8f1eef45bc57bf1ebf46df5f1f8c4f9b6f7f7",
   "Rang3",	"c457c45bc463f5dc",
   "Rang4",	"c5fdf44a",
   "Rao2",	"c4c7eafebc63bef8c2ccf0d2",
   "Rao3",	"c25a",
   "Rao4",	"c2b6ebd0e8ab",
   "Re3",	"b753d86fad59",
   "Re4",	"bcf6d9fc",
   "Ren2",	"a448a5f4a4afa4d0d351a449cdc6e4b9",
   "Ren3",	"a7d4b85aaff6db50d9c2d1f4d765",
   "Ren4",	"a5f4bb7ba462b6b9b8eeb062b04dacf7a7b3d1a1a551d3ddb6b4cb60efa6c9d8cb74d7e0",
   "Reng1",	"a5b5",
   "Reng2",	"a4b4cb72dc7d",
   "Reng3",	"a5b5",
   "Ri4",	"a4e9d3d2e4d4dc73",
   "Rong2",	"ae65ba61bfc4b7bbb5b3bab2a6a5bb54c2e8aff1ba5fdb41c0afe2cecb78d243cfc0f267d376d653f4c6effcdd44e260eb79ec63ec6ef6a9f7b7",
   "Rong3",	"a4beaff1e9e6d85fdc44",
   "Rou2",	"ac58b47cf1a5bfe4ebcaddd6c9a8dfd7eee2c2fdf3b6f5a2d8c6e7acf571",
   "Rou3",	"e6dfeee1d34dde6e",
   "Rou4",	"a6d7",
   "Ru2",	"a670bea7c0a9aff8c4afc07dc0e1dbccf4cbefa7dae3f07df65dd1b2f0b8e4a7efdcc277ceb4eb51",
   "Ru3",	"a8c5a6bcb064ece9a46bcbc7",
   "Ru4",	"a44ab064bfc8c0a9aff8cf76ead0e3bdde50e0a6dd40dcd9",
   "Ruan2",	"d8a3eccae5b5",
   "Ruan3",	"b36ea8bfc4afd052e7abf041e6e4f27dccd2",
   "Rui2",	"eb42e36fd4eb",
   "Rui3",	"bfb6e9d0f075d8fbd5bd",
   "Rui4",	"b7e7be55cdbabacdd3c2e8fbccd9cb55",
   "Run1",	"da69",
   "Run4",	"bcedb67ce9db",
   "Ruo4",	"ad59ae7ae6d9b0b4f26bdc59bf78e3c0ddd8c564",
   "S1",	"a3aa",
   "Sa1",	"bcbbc965",
   "Sa3",	"c578bcbbe0dccf73",
   "Sa4",	"c2c4a4cad7d9bbe3efd6e4d6e4bc",
   "Sai1",	"c4ceb87cd242d96c",
   "Sai4",	"c1c9b6ebe4e6",
   "San1",	"a454b0d1e5f7f44df6a6",
   "San3",	"b4b2b3caf06fc158f4ed",
   "San4",	"b4b2dc7b",
   "Sang1",	"b3e0aee1",
   "Sang3",	"b6daf3a8ddbae6caf162eb7b",
   "Sang4",	"b3e0",
   "Sao1",	"bfb4c4ccc162b76bedebdd69de52f3aef8d9",
   "Sao3",	"b1bdb741d4b5",
   "Sao4",	"b1bded4de6b1",
   "Se4",	"a6e2b6ebb7e6a7a3b6dec0dfc2a8e9ecf4dbf64fe4a3ed6cdf70ea5af775e9fc",
   "Sen1",	"b4cbe778e5dbdf69ee78e1b4edc8",
   "Seng1",	"b9acf7a5",
   "Sh1",	"a3a6",
   "Sha1",	"b1fea846afbdace2b2efb7d9c354b8c6a7fcdaaff36ae8dde5d9d2a3d546e1e9e771dacd",
   "Sha2",	"d4a3",
   "Sha3",	"b6cc",
   "Sha4",	"b7d9c04bb748dcd3ddf7e351e37cdb67d86c",
   "Shai1",	"bf7a",
   "Shai3",	"bbebf2b5",
   "Shai4",	"c5ceaecdeef3b1fe",
   "Shan1",	"a473aeb0ad6da7fca752acc0c3bbad51bab4bce8b65ca96baadfd073ddb5ba55c168eab1d57dda5bcfc4d6d3dcc9",
   "Shan3",	"b07bd445dedbd9a5e7ce",
   "Shan4",	"b5bdaeb0a6c2bed5bfafc2b5e854bab4b053b3e6c4baaab7c5ebf562e54de951d56ce1dfeeade552d7fcf2dcd3e4e4e7",
   "Shang1",	"b0d3b6cbbcdcc2d2b4f6e2b9e74eee59f0daf6a7",
   "Shang3",	"bde0aecea457",
   "Shang4",	"a457a97cf5dcce73c967",
   "Shang5",	"bb6e",
   "Shao1",	"bf4eb579b1e9dfa5aeb4d17adfead776df4bddbeef65e466f1cdeb4b",
   "Shao2",	"a840bbe0a8a2a463cfd0c9cacfb9",
   "Shao3",	"a4d6",
   "Shao4",	"a4d6b2d0adefaaf2a56cca73ca6fd7b8dabce64c",
   "She1",	"b0f8bbadce61ed42f0e0",
   "She2",	"b344a6deacc6ca65a4b0d960e0ae",
   "She3",	"b1cbaad9",
   "She4",	"aac0b35dae67af41aad9c4e1b36abef9c565cdf8d669f5d4e751f1a6f1b7ac42b8add1c8f2e8",
   "Shei2",	"bdd6",
   "Shen1",	"a8adb260a6f9a5d3b2d4a944ab48b0d1ae57b2f1d2c0cbc2d045dfdee04dec67ea50af7ecf5dcf6bc9d9cfcad05bca58cc50d170d2d1",
   "Shen2",	"afabacc6",
   "Shen3",	"a848bc66c254c26ee7dcf75acfe8ab7bd4f2ed7bcba9f754",
   "Shen4",	"b756b5c7baafacc6b8c2a847dfb8ddd2b2e9ccbdcdece87a",
   "Sheng1",	"a5cdc16eb3d3a4c9acb9aa40b563b2c6b0a5cd4ee0c8f1e6caa2cd64da54da64f3ef",
   "Sheng2",	"c3b7bf49e97af4d0f8d8de68",
   "Sheng3",	"acd9d2d6cbcee6ded466",
   "Sheng4",	"b3d3b2b1b874b3d1dd4fadbcc1cbc96fdbeb",
   "Shi1",	"a5a2ac49ae76b8d6c0e3b7c3b7e0abcda3a6bdbebc4eaaeba472e3b9dfade4e3d0b9da4fd6eaf6b0de69f6c6e6d6ee77f948eb6b",
   "Shi2",	"a451a4b0a5dbaec9b9eaadb9ac42bb6bbad3ae67b4a3e3c2da41f6adb6f6d2e8f1e5e0c6e24dd9f3de63f3f6d8d3",
   "Shi3",	"a8cfa96ca576be70a5daabcba8a8",
   "Shi4",	"a5abac4fa8c6a540a468b6d5c3d1abc7a5dcb8d5b5f8a6a1a4f3be41c4c0b9a2a8cdbb7db375b6ddabeea54bac55a8cfc1b1b749bebdabf8b361d8bab862afe7b8fdebacdbeabc5dcae6e9f5eba8f64be0b0d969e4add0fce6fae8a4eeb0eec3f066f56cf5bae06dd272d8edd8f6dbd7dd72e7c9f8c0",
   "Shi5",	"b0cd",
   "Shou1",	"a6acd3a7",
   "Shou2",	"bcf4",
   "Shou3",	"a4e2adbaa675d953e746",
   "Shou4",	"a8fcb0e2b9d8c37eb1c2bd47acbcbafe",
   "Shu1",	"aed1bfe9aeedb5ceaedeb2a8bdadbccfd356a7e7efd2ce67e5cce1ddc95fcce6d0c7df59c0cfcff6d7dff3f1f2cf",
   "Shu2",	"a8fbbcf4b251b9d1c5abb145b5e0d2edf2edd4c8d65ae461f8e2f9a5",
   "Shu3",	"bcc6b9abc4ddb4bbb870c1a6b8beb6c1f04ce661c3c5f9c9d4e7f649f2adf772",
   "Shu4",	"b34ebcc6bef0a7f4ad7ab870bdddb2a8aea4b166c0c6b9d6baa4b0bfa6a7e640df6fccf5dff2e0b4d8d7f1ecf36ff57d",
   "Shua1",	"a8ead47cef6d",
   "Shua3",	"ad41",
   "Shuai1",	"ba4cb049eacef5c7",
   "Shuai3",	"a5cf",
   "Shuai4",	"b276abd3c1acce4fedd2",
   "Shuan1",	"aeeaadacac43",
   "Shuan4",	"b252",
   "Shuang1",	"c2f9c1f7c45cf8bbf9b4f7b9f5c8f6f6",
   "Shuang3",	"b26eb9d7e5e6e2b4e1d4eadc",
   "Shuang4",	"f466",
   "Shui2",	"bdd6db4f",
   "Shui3",	"a4f4",
   "Shui4",	"bba1baceb57cb8c0d174d258dff5",
   "Shun3",	"acdedde3a76dd970ebb7",
   "Shun4",	"b6b6b5cfc0feeb48f3c3ea76",
   "Shuo1",	"bba1",
   "Shuo4",	"aed2bad3c37bbcc6c5e0dcdeb276c1acabd3dd7da671e254e6d8e3b7a463d5d6dd78e67cf161",
   "Si1",	"a571abe4b4b5b5b7a870bcb9bc72c5eebc52a3aae642e6ebd454e37af1abe6cdd3b8ddf1eed6e140cd47eb57e0c2cdefdbd2e253e340e3f1e6c8eea9f0cff6c2f87c",
   "Si3",	"a6ba",
   "Si4",	"a57ca6fcbde7b6e0b97da678b876aac1ab53a6f8aa72a478b2e0ecbea971d6cebe6fa8e1d25dcf4ec9fad1fbe059ee41d249",
   "Song1",	"aa51c350b253b743a7d8db70ce65b15dea43d0dbdeeee3dd",
   "Song3",	"c171bca3aeaadadcdcc0dd6ee1a9ef5b",
   "Song4",	"b065a7bab97cb35ebb77",
   "Sou1",	"b76ac442e0aabb60dd60de59c349deaeeec8dcdbf15cf55e",
   "Sou3",	"adeeb9bec3c1c25de6bceea7f5e4",
   "Sou4",	"b9c2",
   "Su1",	"c4acb564b670bf71c5c8f45a",
   "Su2",	"ab55",
   "Su4",	"b644b374afc0b5c2b14ab6eca667b5afb7b9e8c4e1c2bdb6e448dd68e3a5eea2b6e8e9cbcd41d250e646c150e75ce5cfe853f77bf859f865dd42c9a7e25acfa9d1e3d857de4de5a5e879eadef2cde0f4",
   "Suan1",	"bbc4b56dd2a9",
   "Suan3",	"e8fa",
   "Suan4",	"bae2bb5bdf48",
   "Sui1",	"c1f6b86bea41b846d768de42d6aad267d143d163d76fde44",
   "Sui2",	"c048b6a6f173",
   "Sui3",	"c5e8e967f261f172f8cf",
   "Sui4",	"b7b3b945b848c14ac047afa9c0e6bdd9ded9f060ed67ecf4f2eaf661c2e3d4bde7e8ed48edd8f05ef249f2b1f544",
   "Sun1",	"ae5db6b8bb5edeacddbbe25fedfeeb4e",
   "Sun3",	"b76cb5abba67f069f168",
   "Sun4",	"bcf2e1d2",
   "Suo1",	"c159b1f4b2efadf6ae50bf75b6dbd854d566bb62d5c4f0f7d761e456e1da",
   "Suo3",	"a9d2afc1c2eababee6a8dcd4e1e2f163f540",
   "Suo4",	"d7e2",
   "Symbols",	"a1ada1aea1afa1b0a1b1a1b2a1b3a1b4a1b5a1b6a1b7a1b8a1b9a1baa1bba1bca1bda1bea1bfa1c0a1c1a1c2a1c3a1c4a1c5a1c6a1c7a1c8a1c9a1caa1cba1cca1cda1cea1cfa1d0a1d1a1d2a1d3a1d4a1d5a1d6a1d7a1d8a1d9a1daa1dba1dca1dda1dea1dfa1e0a1e1a1e2a1e3a1e4a1e5a1e6a1e7a1e8a1e9a1eaa1eba1eca1eda1eea1efa1f0a1f1a1f2a1f3a1f4a1f5a1f6a1f7a1f8a1f9a1faa1fba1fca1fda374a375a376a377a378a379a37aa37ba37ca37da37ea3a1a3a2a3a3a3a4a3a5a3a6a3a7a3a8a3a9a3aaa3aba3aca3ada3aea3afa3b0a3b1a3b2a3b3a3b4a3b5a3b6a3b7a3b8a3b9a3baa3bba3bca3bda3bea3bf",
   "T1",	"a379",
   "Ta1",	"a5a6a54ca66fa865b6f2eb7ccda2e6cf",
   "Ta3",	"b6f0e247f158",
   "Ta4",	"bdf1ba66c1cfc3a1ddadbbbdecc5c4becceedcd6bed8bbbef66bf159f16cebfdeefef3a1f6aed04fd5f0d85ae26be7dbf76fbaaacdd0ed4ef9d5",
   "Tai1",	"ad4cad61",
   "Tai2",	"a578bb4fa9efbbe4ad61cdd7b660c269c2cacfb1e8ceec7ce8f5ecd5f4a6cafbd2f0",
   "Tai4",	"a4d3ba41aef5a84fdc67ed60de5eca79d856",
   "Tan1",	"b367c579c575c5f5a77ecec0ccbed752e364b1b4",
   "Tan2",	"bdcdbc75b7f0bce6c3d3c0c8bec2bee8c2bbb5f7d7e8ebe0ec5cf77af4ecd0cbf35ef347d4dfe5a1f2c6e9c5f6ccf867",
   "Tan3",	"a95ab4e0b352f2e9cad8edafdb65f34ae154ede8e5abebd8e3f6",
   "Tan4",	"b1b4b9c4bcdbbad2acb4e7eed4bcda45e6f3",
   "Tang1",	"b4f6c3edf8e9f141e7b0",
   "Tang2",	"b0f3bf7dadf0b6edbda3c1aeb4c5c1deb765c3edde46eb5dbac1eeb9e1fde5e8e2b5e2c1f15ff378e9d9e3b1e6c9ebc3edfdf6b3",
   "Tang3",	"add5bdf6c56cb249a9aed55cf9bff166f7daf8aaf8b1f8f8",
   "Tang4",	"bdebbf53f4e7e1f2",
   "Tao1",	"b1c7c0dcb7cac5b9c3fccc71b86cead6ddb0dd6de24fdd5be37bdd45e3e6",
   "Tao2",	"b06baee7b3b3b5e5b25ec0dcb0deacabc276c268cbd7ce42e370e4c3e860f1b5ebebec66def6ec41",
   "Tao3",	"b051",
   "Tao4",	"ae4d",
   "Te4",	"af53bc7ccad6cad7e869d3e2f0c9",
   "Teng2",	"af6bc4cbc3c3c4f0c1c3bcf0eb66ead7",
   "Ti1",	"b1e8bdf0ade7d649",
   "Ti2",	"c344b4a3b3dab3f6bfe1ebdbe2fddad7bd7bd377f3bbb6acf5a5d94ecdf6eee0d456ebbceea9f578d8eae2e3e7afeb4af867",
   "Ti3",	"c5e9ca5edf57",
   "Ti4",	"b4c0b1a7aef7b150aeadab63be4fc0a1d0d7ee4be5f3e3fcd956f4a8f1bcd552e7c2b37cf1cf",
   "Tian1",	"a4d1b24bd0ddcc5adc5fd4ec",
   "Tian2",	"a5d0b2a2b6f1abefc2f5accbe6d4ccfacfe5d9ebdbb0e6c3",
   "Tian3",	"bb51a9bdcf66b5c9c053d5eee4cee7e9d562d3c9d9a7ded1",
   "Tian4",	"d56dde6ce2d0",
   "Tiao1",	"ac44d6bdcec9ceb9ef6f",
   "Tiao2",	"b1f8bdd5d6d1a8d9ad7cbb6de8d4cc67d071f5bbf7b2ec55ca4cf16be066d2eb",
   "Tiao3",	"ac44b2c0e04bce77eccf",
   "Tiao4",	"b8f5b2b7f8fdd1d8b8d0be66daf8eab5d36d",
   "Tie1",	"b64ba9abcca3",
   "Tie3",	"c54ba9abf852e0fd",
   "Tie4",	"a9abc34bd7a6",
   "Ting1",	"c5a5c655a5c5d5b9ca4bcdaa",
   "Ting2",	"b0b1ae78a7caab46b8bbbe5eb440d9ead76cc9efdf4de7bbe6fbdfacf5b9ddcae257e8a8d8ebdf5e",
   "Ting3",	"aebcb8a5cb6db1f2ec5bd670d74de86fd658c96ecdee",
   "Ting4",	"c5a5",
   "Tong1",	"b371abf0e766d6a2cfb5e66bcfc3",
   "Tong2",	"a650b5a3bbc9aee4bce0c0fba7cdca63b9adabd0cbbef0a2e9b3eaf3edb1ede2d6bbe9bfe9e7e677d3a6d275d268e0cbe4d0c969e0acd3ebdaeadaf0e9bdea59eafaef6ef1e8f6ecce40e04a",
   "Tong3",	"b2ceb5a9b1edd1b6ce54df4ace6f",
   "Tong4",	"b568dbc2ba45f749",
   "Tou1",	"b0bdd8c1",
   "Tou2",	"c059a7ebdea4d7f3",
   "Tou3",	"efaecc44d359dc6ff5f5",
   "Tou4",	"b37ae9b2",
   "Tou5",	"c059",
   "Tu1",	"a872f1ddd260d5a1e1a4",
   "Tu2",	"b9cfb37eacf0ae7bb6eeb14fa559b2fed25ca745bbc6dec8dad9df7ed172dfabf1ddd1cccca8eeece459d5d3da4cdf50e3ade6abef62f577f7bbf7c9dd53e1b9e2a2f7c4",
   "Tu3",	"a467a652d841cb7ad147",
   "Tu4",	"a8dfa652b5e9f3e6d4cb",
   "Tuan1",	"b4f8de7eebb2",
   "Tuan2",	"b9cee1dec47be277dcc7e1c6f371f861e5e5",
   "Tuan4",	"cebde7ca",
   "Tui1",	"b1c0e761f2ce",
   "Tui2",	"c05af2a7e8aaf1c2e9d3e0f9f352c9de",
   "Tui3",	"bb4ccded",
   "Tui4",	"b068b8c0ef61eb61",
   "Tun1",	"a75de9b4d474d24bccce",
   "Tun2",	"a4d9a779b362b6bbc176d7dbe8e1cadccdb5caa4ced7",
   "Tun3",	"c9f8caa4e2d8",
   "Tun4",	"bfc6eb61",
   "Tuo1",	"b2e6a9eca6abb055d8adcbc9d1bec9eccd7ecd4be0e5cde7dbe1e4df",
   "Tuo2",	"be6daafbb9a4aa62a6efc06bb659e9d1cc40d6e3dc5dd2d9ca57ec73cc5be2f6e4c7f7a2f965e0aed7b2d84f",
   "Tuo3",	"a7b4bef2e5bbd549e557",
   "Tuo4",	"a9ddb3e8ac6cf6fbf4bddbfbddfdd1fe",
   "U1",	"a3b2a3b9a3ba",
   "U:1",	"a3ba",
   "W1",	"a3b9",
   "Wa1",	"ab7ab5ecabf5badaa94bb445cf71ca48de43d2fbd6cae270",
   "Wa2",	"abbd",
   "Wa3",	"a5cbca5f",
   "Wa4",	"c4fbdcdae3a6",
   "Wai1",	"ac6e",
   "Wai3",	"afe6",
   "Wai4",	"a57e",
   "Wan1",	"c657c573bddcade6b2f0bb64c9bde655",
   "Wan2",	"a7b9aab1b978a459a6c5d04bcba3d64ad4cecac1caea",
   "Wan3",	"b1dfb84aaebea97bb0fbae59b570bbb5b2f0d246bb64dec4db60da7bec56baedd9a1e377f1c3d0cad74eded8e864dac2dfcb",
   "Wan4",	"b855aab1b5c3b17bc9c3e6f6cadac9badf64c945ee63d567e7f3",
   "Wang1",	"a84ccabfa471",
   "Wang2",	"a4fda460",
   "Wang3",	"a9b9baf4aa50aac9b1a6c353bdfeefebca49d9a4db76db52",
   "Wang4",	"a7d1a66bb1e6a9f4a4fde1fbcdcdd75a",
   "Wei1",	"abc2b451b0b9b7dbdfbbdc7eb66ad26bdddbda44e2efd94fd96ddfdadc7cde5ae050e7a9e7d0ed61",
   "Wei2",	"acb0b3f2b74ca64db0dfbafbb1a9b948adb3c1a8c4deaee9c1f2c0e5b163dd52b457c949d9f8de57dc51eee3ef74e65ccfaaf4cce861f66ff262eff4f04ef6e5",
   "Wei3",	"a965a7c0b0b6bd6eb5e4bdd3b8abb7f5b554de6df6d6e0d4ae55f1a4d8d0aca8deb3f0a9f0b6f671c243e6c7dfafe8bbddc2d67ee0e9ddf0d24cdfa4cdb7eee7ce7cf1f7d87ad8f7df79e3e5e4e8e770d542d6b7e843f7de",
   "Wei4",	"acb0a6eca5bcc351bdc3a8fdb0b0bfd7ad47b3debca2c1fdb14cb4f4acc8bdabf74ce7b3f6eebff2f6d6f37de6c4eae0c1baee42d8bce3e8f2d8f362db73e674ec5ef0f6f759f763bf71ec75ecde",
   "Wen1",	"b7c5bd45eec1b6f3f3b3e2eaeeb4e267",
   "Wen2",	"a4e5bb44afbeb041aab3b6b2ec4ccd54cdb2daa7ec4aeef2efb2e4d9e8e0e8e4",
   "Wen3",	"c3ada76ba646cbead5d5",
   "Wen4",	"b0ddbb44afbfa4e5a85aa7eea74bddaff46fcab9",
   "Weng1",	"afceb6e4eb6ff6c8ec53",
   "Weng3",	"bb63de5be1f6d266e6bfeae7dce9",
   "Weng4",	"c27ccfd8f8eaf2b9",
   "Wo1",	"badbadd8b4f5b8b1da73e841",
   "Wo3",	"a7dad4d6d5a6",
   "Wo4",	"b4a4aad7a855b4ecba57c653d8f2d5e2d451ed52da5f",
   "Wu1",	"abceaf51a6c3a6bea664bb7ab6e3a7c5c2ebe0a9cf72e264a3b9b463a9f3cafed0c5d46ad6c8df77ef7aeb68",
   "Wu2",	"b54ca764a75eb1efa7c5bfbeadf8b8bcbb7aa4f0a460d65ceaf0f1dfc4d3d3f5e86be866d16dd24fd66ccde1f1c5d762f869d264eda1f2fe",
   "Wu3",	"a4ada4c8aa5abb52ab56a5eec44dbcadbc61e64be575c9aecadedee6ed71ddb3d4a4aeb8dd54cd6dd0dae9ddf656",
   "Wu4",	"a4c5aaabb0c8b463bb7eaea9b1e0c3faa5b3c2ebb6f5a461c445b9edb063cb42d8b8f5adb0eecb57cdd1ebd2e874c9d6c9e5de7ccdf5d651dcaaca56d34fcd7ccdbed4c1d7e5dab2f3f7f4bacac4e4fae767",
   "X1",	"a3a3",
   "Xi1",	"a6e8a7c6a76cc4e2bc48c4ebb57db178b7cbaa52c1b5bab3c148bda5b4cfc2e7bc5ea4bcb552b4b7bfaab2a5c466b9afbb68caedbf51ae4fcfe6f94cc3d6b1e3d5d8c1d1e9caf445b258ded5ae44b26dd85ddd63cec5eab3dae8e451f151f87bd244d257e652ed5ef6f3cfdcf65cdd47f172d1a9dac0d6b4f8bff972e250e9e0f46bd677eb65cde6cebecebfd15dd16ac1c6d769db6fdcbee5dfeb6aeeb5eeb6f1d8f55cf9c3d0bed5d0d949e8f9f547e44deda7",
   "Xi2",	"b2dfa9f5aea7ae75b1a4b740bffcc5a7bab6bb56c1b7c0cae444eef5e3fce1afeb67f7b1db4be5d5da62f0dff169d1f6d9b6e3cde6b3ea5fee4ff37bf552f679e7a4",
   "Xi3",	"b3dfac7eb170c3a2c4cee1a2e775f8a6cf56f0bdeddcf8fef143f971c943d2a7eba9edc7dfc4e2abe9b1",
   "Xi4",	"b2d3c0b8ab59a874c3b4a469a6c1bbd8bef9f1beb5bfcda5cdfdf8a8df62cdaee0abf151f1adde67e7cdf65cbcf3db57aabff972c96dcca7d7fbf15bd7fae05dd3fde2bfe7cfeb4decb5eea3f0bacc79ceced962e2f9f7cc",
   "Xia1",	"bd4dbdbccac2e0e1eed5",
   "Xia2",	"b776ae6cc1d2c1f8ab4caf55aeb5a758a945b949dac6aaadb7e5b1d7c35cac6ad6c1aca2dfa3e2f5f3badda1d27acbcfd6dceadad2bbb0a2e6c0ebbaec78ee45",
   "Xia4",	"a455ae4cc07eb748b776ede1cb79d1f8f367f6b2",
   "Xian1",	"a5fda550b1c8c241c5d6bee6a96bf443e9a2f75fe479aac4ef44cf5bcb49f3b2e957c96ac977c9d0ccdccae0e647f96cace6dcb9e148e3d0ee73f447f7fdd2b9",
   "Xian2",	"bde5b6a2b6fbab77c4d0a9b6bbceb2cdbc5ff9dcb243b0e5b2ecb67eed77eba3d77de5a7f870d4e6dfbad056dbb8e6f2ea47f479f871d4a1",
   "Xian3",	"c049c5e3c241c57ec4f6bbd1effbe06ee964b8c3ce68dd4bf1feea60ed64f7e8dae6f850d240d276eedddda3f87af8ebd7d4f242e342",
   "Xian4",	"bfa4b27bbd75adadbecbc46db872b3b4b8a2c060b8c3b341c4c5cde4b9b7ae73d5abdabdeeb1f657e87cd262f265df56d162e5b6ebecce76",
   "Xiang1",	"b66dacdbadbbbd63b4f0c1b8c65eb45bf9b3e6e7eb52c4ecf7eef5d2dfb9f448",
   "Xiang2",	"b8d4b2bbadb0b5beabd6",
   "Xiang3",	"b751c554a8c9bbe8c557f3d0f959d1d6",
   "Xiang4",	"abd1a656acdbb9b3b6b5b648bef3c251e9b8f0cedfddeeeff0c7f0d7f541b66dced0e64df85f",
   "Xiao1",	"aef8be50bfbdc374ae64b370c4dbc2adb576be5dadfdc5bbb1faf74ecf4aef69eca6e4f9df60b9cce263e646d26ee6a1d3b7dfeadab0e57dca41cbe2edb4cf6dd251dab4dfbfe45deaeaf0a7f457f564f7e3f947d175d4aadadbf672f0e2",
   "Xiao2",	"bec7cf6dd342d7f1",
   "Xiao3",	"a470bee5df4ec151eea7",
   "Xiao4",	"aed5afbaa7b5aec4bbc3bc53a876b3cbcec1ea53e45a",
   "Xie1",	"a8c7b7b2c3c8e7b2da74e7cddcce",
   "Xie2",	"a8f3be63b1d7afd9bfd3a8b8b0babe65aeb5daf4c4e2c25ebc45f5e9f648d746dd71c9c0e7bece5ccedbd044d15af9a1dd6addb2debae2c3ed5f",
   "Xie3",	"bc67a6e5",
   "Xie4",	"c1c2b1f1acaaae68c26dbed3a8f8aa6ec3c9b8d1b150c1b6ba6babb4c062e972d9f1c1dbc0e8b7a4daf2edfcb2d8d8b7e963e9f7f263ea5ef8c3cb5fd2c9f1a1e4daef5ad44cecfbf3fcca67cab6cff8e24aec57e561d65bd95bf6d3f8c5",
   "Xin1",	"a4dfb773a8afc17eaa59be4ec4c9f8cab2f1cd51ddf5aae4a9fdb360dc63cfe7d860e574cae3cabbe946",
   "Xin2",	"b44de856ccdfe9aff0d8",
   "Xin3",	"c9b3",
   "Xin4",	"ab48c65daae4da5cf4b5eaf2c9c7cabbde76ca58",
   "Xing1",	"bfb3ac50b556b87bc4c9b469ef58de7adebcd060d153dfe8ee7cf9b2",
   "Xing2",	"a6e6a7ceabaca644a8b7b0a4b2bae478ef4fcbb6d278cfadd36ee87bed50",
   "Xing3",	"acd9bff4ececd9fb",
   "Xing4",	"a6e6bfb3a9caa9afa96da7f6adc6b1a2d3aed4d2d763d5e5",
   "Xiong1",	"a553a5fbafdda4bfa649aca4cae2ce46cecc",
   "Xiong2",	"b6afbab5e05c",
   "Xiong4",	"e5c0dbdb",
   "Xiu1",	"add7a5f0b2dbb2e7aba6cebae05aec70f3afefa2e2aae5eddb56d3aae4b8e774eeebe2ad",
   "Xiu3",	"a6b4b14aeac8",
   "Xiu4",	"a871c2b8c4c3b353b6e5b14aafe4f9d7d671b7cda9a6d2b5c9a7e268e7cceb69",
   "Xu1",	"b6b7bbddb5eac5bdbc4ebc56a6a6ad45b058a653e9dfcd77e559f4acd1fccaf9cbe6ddd7ecd2f768cf64d0d8e346e6e9e7adeb53f7a1f7a8d1d5d8f3d963e6e0",
   "Xu2",	"ae7d",
   "Xu3",	"b35caeddb7d6aba6e048d0dfcc4ad9faeba5ebdae859d2b7d872",
   "Xu4",	"a7c7c4f2bb57bafcb1d4b5b6a6b0abf2a8f9b3a4b442af62acaec9eecbc4dd66e2a9f2ccb97acdb9f0ace8d8d46db1e5dbd8f95bd277cca1d154df43ed7ce4b0cd45cef3e2e2",
   "Xuan1",	"abc5b061b3d9deb1b8a9b779c0a5e4ebbfdcdce4e953d955f2bfeb7ed94aaecfeedff6c3d5ccb7dcdfc5d950ca69cccce86dd8c5eaaee7a1f2e0f475",
   "Xuan2",	"a5c8b1dbc461ba78e6a2c27bca66cc4bd66fcfcbe17ae7d6c1d9bfa4dfed",
   "Xuan3",	"bfefcdfad26a",
   "Xuan4",	"acafb5baba78af74ccf0b4e8b1dbd6adddc9e5c0b962d7b1e77cef60ec54f361ceecddddd7b4edd1f758f845",
   "Xue1",	"c1a7b975bebbe966ca7b",
   "Xue2",	"bec7a5def8e6f4cde460ed62ed4fe950",
   "Xue3",	"b3b7f7ab",
   "Xue4",	"a6e5b3b7a5deab64e065ccefee7ecc5cd7b3",
   "Xun1",	"beb1c2c8c274e2c0c548ce7defdbd64fed65f4aef0a1e765b3d4f27b",
   "Xun2",	"b44da8b5b8dfb460a6afb9a5bcf1d2b1f0c3acacaffbabe0cecbce7dd1ecea4bc27bd04ad0bdf858e262e5b4cce8ce4fea67e9ceeb43e540",
   "Xun4",	"b054b056a8b3bbb9aeeeb9a5abe0b453a6c4bfb8e541cbc0bcf2f1a3d3edf1da",
   "Ya1",	"a772c0a3be7ec06ea9e3a458d9b2b7dad4ef",
   "Ya2",	"a4faaadeb250b8c5b048a9e3ccd6cb62f3fac9b7d4c4",
   "Ya3",	"a8c8b0d7b6aed56fc9c4cacfeb56dca6a5d4",
   "Ya4",	"a8c8b359cdcecfebb4e3d4d5d95debe2db47aaeec959ca50cd67da6fe34bf9d3",
   "Yai2",	"b156deddd4a9d4e4",
   "Yan1",	"b7cfb26ab254aeefbe4dab7cafdaa961b4f3b5d2b9e4bf50e759ec49b9bdd4fcf4b4e46be2b1da6dd2b8d460ecd6f35cb5cb",
   "Yan2",	"ace3a8a5c343c459a9b5aa75aaa2c0f9c651a9a5bae1c3b2c046a7b0e3e9c0d1d4bad877dd77e2f2e372d7eec5c9f7d5dde9f8fae8a9d15edc6ed667eb5aef4af1f8f5b1f7d3d77ad8e5",
   "Yan3",	"b2b4ba74b1bbad6cb66eb0b3ab5ef5dec56bc64cd0e6cebbdf6acb56f7d6d951d966da4ae7a7f97dce6be5acd9b0f1fcf56ac5c4da7ccdf4f1efddf4caf1f5bfd7f5d8dad94cdb62e0d1e3f9e7c6f5a1f5b5f8abd558ebc8ef56f6cd",
   "Yan4",	"c5e7bf50b9bdaecbb6adae62b254c676bf56abdbb3f7b578ab7cc360adf1c5e4ace3f840bfceaa75f9a9da5dc66fc5acd869f9d0f46ad845f6bbf1fcef76f849b54bcd5bce6df86dddeaf451ece6d4e9dcb5e8ede945f55bf7fec641f976d77ad978",
   "Yang1",	"a5a1afb1ac6fc06dbbdfaa74cbf6d066cf4bca62cc47d6efe0bde0d9",
   "Yang2",	"b7a8b6a7b4adac76a6cfa8cbaf4cbac5c1edabe2c347b77ab7d5ce52ceefe2fedbb1deb4d2b3f4fdd8dff8e4d6b1d8bb",
   "Yang3",	"be69a5f5aef1c46fbbdfc957efd5cc62cfb4ccbfd67defd0e3e3",
   "Yang4",	"bccbbe69ae7eba79a9c2b7d5efeed6f2",
   "Yao1",	"ad6eb879a4d4a7afc1dca45ca65bb3e9d86dcff7dfb7d7cc",
   "Yao2",	"b76ec1c1b3f3bbbbabc0acabbabdb9aeb263c061f3add85cedd9e566dd64d9e2deaddbfea4f8ce5db15ce4a2d2b0cf57d662f6afaad4dcf8d26cbd60dce0dd6cba6ff672",
   "Yao3",	"ab72afb7afe6a4d4cceaaa48d2f8d6c9f7c5cabcccb3d0a5d2d3d450de4ae255f3b5cac7dd45e3cf",
   "Yao4",	"ad6ec3c4c4a3c260c65fc563a9edeffad7c4e4c8f0a3e446d040dae0dfd3e678f34d",
   "Ye1",	"ad43bc4ff7f9a3ae",
   "Ye2",	"b7ddad43b7a6b278d95eeced",
   "Ye3",	"a45db3a5a74dd4b1e2b2",
   "Ye4",	"b77eb8adadb6a95dab7cbfd6abfbc5e2bff3ea4deda2ecebae67bee7f1acde6feee4f667ea45f165d44fd9dfe965e9ac",
   "Yi1",	"a440b3fca6e7a8ccc2e5a5ecb4a5beb3baacd661aba9a3b8e2fceddff1e0e9b5e476ccfcf7c3d9dadc54c9c9de55e349ea57cfabd848dbbae176ea62efdeefe9f877e95e",
   "Yi2",	"bff2bac3b2bea979a9c9abbcbbf6a669bdcbafd8b64db97eab78dbdfa85ec05bc255ddcbb2ada665ecdad6d7d1dfc96cd166cf70edc6b059d3e1d3eecb44cf51dbcdd441cea7d6abdb42e0c0ecd9cbb7cfd4d0ade4abce4dcec3dba6ccf3aeebd2bfd7bbdb43dbb3ddbfe068e265e66fe6d6eb6cef47f0ebf64cf8df",
   "Yi3",	"a548a477a441adcab4c8a86fc3c6f2c3ada3d077b0c0d1b0ba59eb63c9e6d441dcafd0c0f8a3f3aaecf6e0bfa8b2d05ef05cd578d848d8e4d9a8f4da",
   "Yi4",	"b74eb871a9f6c4b3a5e7af71b2a7c3c0bbf5bed0c4b6b247a7d0c16cacccbcddb668a8b6a7edb877c3b6b7b8bf7eb663b8daa67aa748b2ddacfdc5e6b1b3c574b8c7c172a6b2abb3bb69b5c5a6e7a4c2c16bd1bac2efc56dabd9a8dbc940a47ca6e3e97dbeb0e948eceeedf5d1a5e6b0c968e143d4b7e961abd4e9b5cb40cf41e9e2af4ae666eaf7f94af554e8f1dcb2d0faed5cf2c9f345ecd8ca59e66dca70ecf3dccce1bbf65ef1a2f4e6f4e3d6f6c9a9c9ddccddca68cf7ee9f9cb7bea55cfceccb4f5f7cde2da61ed5dd9a6d151d7f8d1c3d1f7d4b0d6f5d84cd9dedbf3dff6e16ee36de3a4e4c1e5dde65be75ae94cea6deeb0f2aff45eceb3e5cef37cf8ddf967",
   "Yin1",	"a65dadb5b3b1abc3aeefaff4b9feaef4e2dad866d8a1d8fee2fadaf1dbc7eef0ec65e4a1e3d3eba2ce58f54dcfa7d468ddf6ecc6eef7f54cf6cbe1ed",
   "Yin2",	"bbc8a775b147b25dbbc2c569c0d1c3f9abadb9dbd2a4efbdd543e7ddf0bfd4d9c955cdc2dc6cd148d27bd468d779e5f1e750efe7f864f36d",
   "Yin3",	"a4deb6bcc1f4a4a8c57db043a776e0dbd355c169f8c1e7f2ee58e4d5dc68ed41ed56f5f4d34c",
   "Yin4",	"a64cb6bcc1f4bdaead4ee1bae34ae978da57d150da79e1fae475",
   "Ying1",	"c0b3ad5ec64ec0a6c561c4e5c174b7ebc678c458c4a2c5d5f44cc4eddcfcf277eadfde7df1a7e6adeefbe2f7f5e3ddc8e7bfda56eb74d463ec52f5faf651f7faf5b0",
   "Ying2",	"c0e7aaefc3c7bfc3c4b9acd5bcfcbfa2c373e26cbec6b6f7bab7b7adefeff25ef96df45deeabf244f444f446f0a6",
   "Ying3",	"bc76b4babf6fe5f9f6f4b072f45fcfe9d5bbd256",
   "Ying4",	"c0b3b577ac4ddcf9efeff16ae1efe454",
   "Yo1",	"adf2",
   "Yong1",	"b6c4b165b96cbed6bec3f7eac173e156f360ba48f776b06ff5cbf175dcdcf5d7bbc1e8fce9e9ee52e2afebd4",
   "Yong2",	"b6c4d871f1aad851e5e1dcfedd4de178",
   "Yong3",	"a5c3aa61b5faab69bed6bfe3b4e9b8baa869bec3b176c173ab4de45cd155dceae6ceaf46d1a4e4ac",
   "Yong4",	"a5cea6feeec9",
   "You1",	"c075bc7eabd5b179cbe7a7f1f5efe0eef24ef14defcaccabefbaeff3f5ead7ab",
   "You2",	"a5d1b4e5b943a4d7aa6fb66cb553b7dfb95cebc9acd0d7a5eb4fceeae7a2d7cad7e6ddcdbe7bc9accb4fd25bd461d2f4d75f",
   "You3",	"a6b3a4cda8bbb2fbbcf8c24bd04ecd4fe47dcc6bd176cdc4d744e5d0",
   "You4",	"a453a56ba5aebba4a6f6ac63b956afa7a6b3abc9a8ddabaac35eca72ce6ecd5cceaddbe6ecabcaf0cfbbd3f1",
   "Yu1",	"b24aa8b1b7efacfaa3bade40e350c9e3cda6d6a7",
   "Yu2",	"a9f3b472b3bdae54be6ca45fbaaea4a9b74da745acf2b7aeb94fb8b7ab5cc1d6b7ecb4fcb6a8aad8b5cdaabbbddbebc6d370a666c26abfccdaaeb5e3d8e1e34ca7b1d967ddf9acebf659dca2b3b8cafdd9bfcb69e6eee6f4bdc2bdc9decfdfa8d2a8ca53f042dad1f4aad7fed8e3da42dc5cdf7de2e6e8ace9f3eafbee6df0dcf1cef1d7f4bcf8e0f961d0acd4a5d8a4d8b2e0d7e6d1f44ff56df8ec",
   "Yu3",	"bb50bb79ab42a4a9a6d0c0aca674aceab168c5c5bebeae46b0ebe6d5dcbacde3b1d6e940dde2deb7c94fdfccebb3d459d6bcd97bdc5bdd4aedc9f4c2efd8f0cb",
   "Yu4",	"a87cb94ab977a5c9b1fdb0ecb3ebb755c541babbbca4af44b8ceb7d4b44abf6dbb50e0b1bfddb173c67bc67ebfd9c2a1ada7b6bfac52b7b6a8a1b14cbcf7ab5cae6ea6d6b9e1d17bdcaef7a7a8a6f866c0eee3daae4bbb79bac7d9b5bf48dac3acebdf67ee40ebd1ec48ec4ff1d9d9add5e7ea52e67af071f1c0ee4df77dd553eca3e873d252f5b7d1e7d2e1f2a2cce9f9ace467d1acdefde3b4e4fbe8e7f150f3b0f9c6f9d1e1d8d7c1e36be777ebf1",
   "Yuan1",	"addeb257c070bbf0a97bd2d7dfebf3d8cb75ebf0d8fad9d6e3b3e3f5f6cfdfdbe3ece442e8d1f1faf469",
   "Yuan2",	"adeca4b8adfbb6e9b6eabd74b7bdb4a9b444b04bb7e1abaea84ac1d5acb8e947efb1dcf4f258cdb4b545c4cdd346eae3e7b5cbabe7b4cabadfc5eb60d3bbccd4e25bde5fdd43da75deabe244e3bef164f4e0f5a8",
   "Yuan3",	"bbb7cc53",
   "Yuan4",	"b07cc440abe8ad62bbb7b444deb6ba40d964e7cbc970eeaee343e8fe",
   "Yue1",	"acf9a4eae941e6dcda5f",
   "Yue4",	"a4ebb656bcd6aeaebe5cb866c544a9a8c0aec4a3c65fc260c3c4e0b5bba1a647f465c5d4e9c4f5dbcda3f6f7f654b063f962efb6cd5eaab5c97cccf6dc76caf2d3cbf5fef9c5",
   "Yun1",	"b777ba72ead5f349e16aeb64",
   "Yun2",	"b6b3a4aaa4c3a9fbafd0aae5afc6e2beb861de65e658cfdaeac0cb4ee2bce8a3eafccab3c9b4ead4d75de0a8cce3cfe1",
   "Yun3",	"a4b9b96be266cb65f176eb70cae9ebb6e465dc75cbb0",
   "Yun4",	"b942c3fda5a5bcf7c4adb759c1dfd940b777f3a5dc50edf4cce0e6e3f579adfb",
   "Z1",	"a3a8",
   "Za1",	"b2cfa560cbdfd473e14eccc0e0c4",
   "Za2",	"c2f8aba5af7bb0aff8cdeda9",
   "Zai1",	"a861aee2ab76d9eeebb8",
   "Zai3",	"a54aae5fd8e6b8fceacd",
   "Zai4",	"a662a641b8fc",
   "Zan1",	"c2aff4ee",
   "Zan2",	"aba5b0afe6e1",
   "Zan3",	"cedff6e3d4f1cef5f8b7d873f5c1d965f8b5",
   "Zan4",	"c3d9bcc8c667c3f5c5d0f7e0f766f9b1f6ebf6d9f96f",
   "Zang1",	"c5bcc542c5d8d27dbb4e",
   "Zang3",	"e8ca",
   "Zang4",	"c2c3c5a6b8aeae4e",
   "Zao1",	"be44c156f0fedcb7",
   "Zao2",	"c677",
   "Zao3",	"a6adb4c7befec4a6b044ed6af2b2",
   "Zao4",	"b379a86dc0eabeb8e1d1c4b7a85fc4bccb71f4d6f054",
   "Ze2",	"ab68b364bedcbf41b9c9afb6d756a951e1b2b2c8f0f3d0b5d8e7dfc1f0e9f2e1b8e9f2e5",
   "Ze3",	"abe7",
   "Ze4",	"a4b7b0bccccac97adada",
   "Zei2",	"b8e9",
   "Zen3",	"abe7",
   "Zen4",	"f2fb",
   "Zeng1",	"b4bfbc57bca8ede3c2b9eda4e9c1eda5f779ea65",
   "Zeng4",	"c3d8ed70",
   "Zh1",	"a3a4",
   "Zha1",	"b4eda4e3b3e5ddd3ac64f966cf48ea74ccbccee1e5d7f0e1",
   "Zha2",	"a4e3a5beb2cfb968acb5e8adeed4d0f5e35ad7acf343f9a8",
   "Zha3",	"af77b4edec7aca75d078",
   "Zha4",	"ba5eac5dacb5b642a545b763b34ba951e3dca65cde4bafa4eecaec7ad2c6edc0",
   "Zhai1",	"ba4bc24ebbf4d1c7",
   "Zhai2",	"a676bb43",
   "Zhai3",	"afb6cc68",
   "Zhai4",	"b6c5b9ebb2bdb364ea71d6b9",
   "Zhan1",	"b8e2aa67c2a4c0d6c04cd1d0c4b8f8d6dbd1eec2d1eaf8def853a565cbe1f676e0b9dbdaee4cf4ce",
   "Zhan3",	"ae69b1d9b7f8c1d3ddaab9f1da7ef8d5e85ce4cce9cdf052eebbe55ae25ee9d2",
   "Zhan4",	"a6fbbed4afb8bcc8a565b4ccc5b8b4efbaecf145c5d9eb59f358e84ad44e",
   "Zhang1",	"b169b3b9b9fcba73bcccbcfdbabce16be5c6e468c1adf7aae1c5dcb4e160f6a1e852",
   "Zhang3",	"aaf8b478baa6c953ef41",
   "Zhang4",	"a456a54db162bbd9bde3b5c8a7fabaa6b9f3bf60e1a3c9e9ea7dd048",
   "Zhao1",	"b4c2a9dbac4ca56cb5dbbc4ab078e8cfe0b8aed0cfdfeee9cc4f",
   "Zhao2",	"b5db",
   "Zhao3",	"a7e4aa68a4f6dba8e2d1",
   "Zhao4",	"b7d3bbafa56cb86ea5fcbb46b640aed0d345c267acb7e4bdcfc5b4cde355f3e4ce55d97de9bc",
   "Zhe1",	"be42c1b1d5aee177",
   "Zhe2",	"a7e9adf5ba50c4e0c1b7c2d6bbb3ba4bc2e1e1cdb8bde6c6c947f842d5aef1c6cb73d551cff3f0edd0a7f8e1f94df273",
   "Zhe3",	"aaccbdeaebe3",
   "Zhe4",	"b36faefdbda9c5c2cf43a676ecfad270ee5b",
   "Zhe5",	"b5dbbe42d5aee177",
   "Zhen1",	"af75b077acc3ad73b0bbbad5b772bd65af7abac2bfb2b7a9ba64b645e3b8deb0de4ce2ecd065eed3f97ad8cce8d0f0abe6d0e9d7e657deb2e0a2d8d5e3bfeec0f4a7f6b8d8b3",
   "Zhen3",	"b645aa45af6cdc48d2c1d7bfbfa6e6d2d6ecf568d2d4f7c8f35bccbacae8d347df61dad3ddc7eaddecb4",
   "Zhen4",	"c2edb07daeb6be5fbbacaed3aa45be7dd95fd7f2d6a8ae57cde0ced6d1dadfe3d5b4e44ae5bd",
   "Zheng1",	"aaa7a9babb5db843bc78b1c3bae5a5bfa9c3b275bffeb157bdd8c470e0b2d26deac3cc4dcfb3d4c9d742a442d2cf",
   "Zheng3",	"bee3ac40c9a1e5b3cda9",
   "Zheng4",	"be47a5bfc3d2ac46b5fdaf67b1c3b456",
   "Zhi1",	"a4a7aabeb0a6c2b4a4e4aa4ba5c4a575a773aadbafd7aacfbb6aace9b1f7afada4f3cf4ca3a4ad4fecaea567dda5cffcdbf4aa7ce8e8cb5bd2f2e243d059d3dcd9d8",
   "Zhi2",	"aabdc2bebde8adc8b4d3b0f5b4dec259abbfcbbbf0f9ee68c5add1e8d4b2def9ba54eddecf50da6ad6c7efd1e4d8e57ae9beeae8efcef0cddbcedebfe55bf748",
   "Zhi3",	"a575abfcafc8a4eea6aea77dbc78ace9b36bace7aba4cf4ce0adcec7cb54cbafaae9dcb0dc40d2c5d1d3ca74caaaf2dad1f2d643de56",
   "Zhi4",	"a6dca8eeaa76a7d3bb73ad50b86db4bcafb4bb78b858bde8abcfbd6fbc6dbaa2bcb0b2bfaaa5b2a9b96ec3d1ece4b569b8fef563cc6fd446aabedd49cadbd1e8c5aeb5edf0f4f7c1cbdaf84bcba4ceb6d8f4d664d67ae2d9d6e9f2f5d0bbe47ed45fe06ae850e878f257d7baf67ed5f4d2a6f47ed36ce6fdee70ced9cfa3e445ceb7ecadd0b3d6f9db55ec64d2ece042eca8",
   "Zhong1",	"a4a4c4c1b2d7a9bec1e9b04aa7d8acd8ee6ec9b1cab8e779cf60dea1cad4d371cd58f7ed",
   "Zhong3",	"bad8b87eb6efbfe6ade0",
   "Zhong4",	"a4a4bad8adaba5f2b2b3d8d8b546cb64d3d3d45cd8afe6f0",
   "Zhou1",	"a950b667a67bac77a6e0b5b0e7eab0e7ed79f64ee07ad876f1b8efa3cf7cd645e4aad2bad550e84dcbc5d4db",
   "Zhou2",	"b662a96f",
   "Zhou3",	"a9aaa879dee2f3ca",
   "Zhou4",	"b1debd4ba97aacf4bfa8ab60a947edd9e2d7c3b3ce43d440e4f0cca6ad48e942e8cb",
   "Zhu1",	"af5da6b6bdd1aee8bddeb5efaffcb2b9b8ddbbcba8dccf78eff5d0bcf255f24cd6bec3c5daf9dbc8e7d2ef7df640e3d8ef73f2d0",
   "Zhu2",	"a6cbbf76b376c0ebf2e2b5aeaac7a5bac4bdd754b662d2f9e762d043dbeff7b0f8adf9a6d37aeac4",
   "Zhu3",	"a544c4ddb54ec5f1b64ab25ac666b5dbecafa9d6dec9f8f0d2e0d847f8a7ce5fd35bf8f1cd46d2cd",
   "Zhu4",	"a6edb5dba755aa60afacbe6eb5f9ac57b345c5b1cfaead52a6eebae6aa56d6e2e37dc972cf4dd6f3e0e7d2c3d777e0afd6e4d8f0dbf1dc4be5ececb0efe0cf67e7d9",
   "Zhua1",	"a7ecbee2ef66ecf9",
   "Zhua3",	"a4f6",
   "Zhuai1",	"abfb",
   "Zhuai3",	"e06d",
   "Zhuai4",	"abfb",
   "Zhuan1",	"b14dbf6aad42c346e157e46cf7addcc7e16de6aaedbef7b8e740f0c4",
   "Zhuan3",	"c2e0c4da",
   "Zhuan4",	"b6c7c1c8bd66bcb6f2fcf557b9b6deb5edd3df7b",
   "Zhuang1",	"b8cbb2f8bccea7a9f9dbc9dcd5ce",
   "Zhuang3",	"ae4e",
   "Zhuang4",	"aaaca7a7bcb2f9bad659",
   "Zhui1",	"b06cc040b4d5ab41f1b6f3ebdfa1efa9",
   "Zhui3",	"cd44",
   "Zhui4",	"baf3bc59c2d8ead8b46dec5de2f0e3a7f770",
   "Zhun1",	"bdcea4d9aad2cffecdcfcabdd7c9",
   "Zhun3",	"b7c7ade3d447d4ade362",
   "Zhun4",	"defc",
   "Zhuo1",	"aebbaee0b267b4cdedb2",
   "Zhuo2",	"a8f4ad5fbf42a9e5c0deb075a860b5dbb0d6c54ec0c2b55ae7d8d0d3e5c1d97cd5bfd9b8da5ae3dfe840f7bfc9dfc9feac48e6cbeab9d255d9baf0e8ebe7d47edf6beceff4c7c9cad0ecf461",
   "Zi1",	"b8eaaff7b4fea773abbaab74a7b6bfd4b8edaf59a3a8bdfdb264c568bafdb446dae7c068d8dbdba4eecdf5acecb7c9d3e9facd72e0a7f3cfc045e05ed9c4e4baf3e9f3f9d1f3d353d540d6c6f2db",
   "Zi2",	"a46c",
   "Zi3",	"a46ca54ab5b5b1eaacf3b7bad054b8e4d6d7d2f1d064d3a5c9c5cb45cb7ece49cda1d842e049",
   "Zi4",	"a6dba672aea1ba7bd6b0b446d0e7db49db48caeed0d1d27e",
   "Zong1",	"a976c2dcc161baeeb4c4c34ff0eff3bdf3c6e6f7e671d0d9d948da77e347e749d8e2e7b6",
   "Zong3",	"c160e1ebb6cde670df7ae3ce",
   "Zong4",	"c161baeabaeeb171ea72cef8",
   "Zou1",	"b951eea4c1dde7d4b0e7d570db68b3b5f55ff3c8d9c5e369d9b4d7eadcfaf3f4f8a1f969",
   "Zou3",	"a8ab",
   "Zou4",	"abb5c64ab47e",
   "Zu1",	"afb2e3c6",
   "Zu2",	"a8acb1daa8f2b9bed56ad541ebc7d0fbdcc3e7f6",
   "Zu3",	"b2d5afaaaafdab5bb641cfd1e4c5",
   "Zuan1",	"c670f970",
   "Zuan3",	"c4a1c670f940f8fcf5c1",
   "Zuan4",	"c1c8c670f7ddf9b1",
   "Zui1",	"b0efd470df6ee1abf8b9",
   "Zui3",	"bc4cf046e043e1aaecc8ed5a",
   "Zui4",	"b3ccb86fbe4becfcbfbfd9a2ed49d6eedef5ebf4e550e962",
   "Zun1",	"b44cbfedbeeae54af4ebe564f06df862e553",
   "Zun3",	"bcc1e4f7e54ae0f1f2f6",
   "Zun4",	"ab54a660d1c1f857e4b2ea51",
   "Zuo2",	"ac51a740afa4d9cbdf4fdefedfc3",
   "Zuo3",	"a5aaa6f5f077",
   "Zuo4",	"b0b5a740a7a4ae79dc60afaec677ac67cca9d05fcddadfdcd159",
   NULL
};

char *pinyin_gb2312[] = {
   "A1",	"b0a2b0a1bac7dfb9ebe7efb9",
   "A2",	"b0a1bac7e0c4",
   "A3",	"b0a1bac7",
   "A4",	"b0a1bac7",
   "A5",	"b0a2b0a1bac7",
   "Ai1",	"b0a7b0a3b0a4b0a5b0a6dedfefcd",
   "Ai2",	"b4f4b0a4b0a8b0a9dedf",
   "Ai3",	"b0a5b0aab0abe0c8f6b0",
   "Ai4",	"b0aeb0acb0adb0a5b0a6b0afe0c8e0c9e6c8e8a8ead3edc1",
   "An1",	"b0b2b3a7b9e3b0b0b0b1dacfe2d6e8f1f0c6",
   "An3",	"b0b3dbfbdeeeefa7",
   "An4",	"b0b8b0b4b0b6b0b5f7f6b0b7e1ed",
   "Ang1",	"b0b9",
   "Ang2",	"b0ba",
   "Ang4",	"b0bb",
   "Ao1",	"b0bcb0be",
   "Ao2",	"b0bdb0beb0bfcff9e0bbe2dae5dbe9e1f1faf2fcf7a1f7e9",
   "Ao3",	"b0c0ded6e6c1",
   "Ao4",	"b0c4b0c2b0c1b0c3dbeaded6e1aee6f1f6cb",
   "Ba1",	"b0cdb0cbb0c5b0c9b0c8b0c6b0c7b0cab0cce1b1f4ce",
   "Ba2",	"b0cbb0ceb0cfdcd8ddc3f7c9",
   "Ba3",	"b0d1b0d0eed9",
   "Ba4",	"b0d1b0d5b0d2b0d3b0d4b0d6e5b1f6d1",
   "Ba5",	"b0c9b0d5",
   "Bai1",	"eafe",
   "Bai2",	"b0d7",
   "Bai3",	"b0d9b2aeb0d8b0dab0dbdee3",
   "Bai4",	"b0ddb0dcb0dedfc2",
   "Ban1",	"b0e0b0e3b0e4b0e1b0dfb0e2f1a3f1ad",
   "Ban3",	"b0e6b0e5f4b2dae6dbe0eed3",
   "Ban4",	"b0ecb0ebb0e9b0e7b0e8b0eab0ed",
   "Bang1",	"b0eeb0efb0f0e4ba",
   "Bang3",	"b0f1b0f3b0f2",
   "Bang4",	"b0f7b0f5b0f8b0f2b0f4b0f6b0f9ddf2",
   "Bao1",	"b0fcc5dab0fbb0fab0fdb0fee6dfecd2f6b5",
   "Bao2",	"b1a1b1a2",
   "Bao3",	"b1a3b1a6b1a4b1a5dde1f0b1f1d9",
   "Bao4",	"b1a8b1a9b1acb1a7b1aab1abc5d9c6d8c6d9f5c0",
   "Bei1",	"b1afb1b3b1adb1aeb1b0dae9dbfdddc9f0c7",
   "Bei3",	"b1b1",
   "Bei4",	"b1bbb1b8b1b6b1b3b1b4b1b2b1b5b1b7b1b9b1bad8c3dafdddede3a3edd5f1d8f6cdf7b9",
   "Bei5",	"b1dbdfc2",
   "Ben1",	"b1bceadaefbc",
   "Ben3",	"b1beb1bddbce",
   "Ben4",	"b1bcb1bfbabbdbd0",
   "Beng1",	"b1c0b1c1e0d4",
   "Beng2",	"b1c2",
   "Beng3",	"b1c1",
   "Beng4",	"b0f6b1c1b1c3b1c4b1c5eab4",
   "Bi1",	"b1c6",
   "Bi2",	"b1c7dda9",
   "Bi3",	"b1c8b1cab1cbd9c2d8b0b1c9dfc1e5feeff5f4b0",
   "Bi4",	"b1d2b1d8c3d8b1dcb1d5b1d9b1d0b1ddb1dab1d6b1ccb1cdb1ceb1cfb1d1b1d3b1d4b1d7b1dbb7f7c3dadbfddcc5dceaddc9deb5dfd9e1f9e2d8e3b9e4e4e5a8e5f6e6bee6d4e8b5eadaeeafeee9f1d4f3d9f3ebf3f7f4c5f5cff7c2",
   "Bian1",	"b1dfb1e0b1deecaeecd4edbef2f9f3d6f6fd",
   "Bian3",	"b1e1b1e2d8d2eddcf1b9f1db",
   "Bian4",	"b1e3b1e4b1e7b1e6b1e9b1e5b1e8dbcddcd0e2ede3eae7c2",
   "Bian5",	"b1df",
   "Biao1",	"b1eab1ebb1ecc9d7e6f4e8bceca9ecadefdaeff0f1a6f7d4",
   "Biao3",	"b1ede6bbf1d1",
   "Biao4",	"f7a7",
   "Bie1",	"b1eeb1efb1f1",
   "Bie2",	"b1f0f5bf",
   "Bie3",	"b1f1",
   "Bie4",	"b1f0",
   "Bin1",	"b1f6b1f5b1f2b1f3b1f4d9cfe1d9e7cde7e3e9c4efd9",
   "Bin4",	"e9ebb1f7ebf7f7c6f7de",
   "Bing1",	"b2a2b1f8b1f9e9c4",
   "Bing3",	"b1feb1fbb1fab1fcb1fdc6c1d9f7dafb",
   "Bing4",	"b2a2b2a1def0",
   "Bo1",	"b0e3b2a5b2a8b2a6b0feb2a3b2a4b2a7e2c4f5c0",
   "Bo2",	"b0d9b2a9b2b5b2b4b2aeb2aab0d8b1a1b2abb2acb2adb2afb2b0b2b1b2b2b2b3c6c7d8c3d9f1ede7eee0f0bef5db",
   "Bo3",	"f4a4f5cb",
   "Bo4",	"b0d8b1a1e9deeafef4a4eba2",
   "Bo5",	"b2b7e0a3",
   "Bu1",	"e5cdeaceeedf",
   "Bu2",	"b2bbf5b3",
   "Bu3",	"b2b9b2b6b1a4b2b7b2b8dfb2",
   "Bu4",	"b2bbb2bfb2bcb2bdc6d2b2beb2bab2c0eab3eed0",
   "Ca1",	"b2f0b2c1e0ea",
   "Ca3",	"ede5",
   "Cai1",	"b2c2",
   "Cai2",	"b2c6b2c5b2c4b2c3",
   "Cai3",	"b2c9b2cab2c7b2c8",
   "Cai4",	"b2c9b2ccb2cb",
   "Can1",	"b2ceb2cde6ee",
   "Can2",	"b2d0b2cfb2d1",
   "Can3",	"b2d2f7f5",
   "Can4",	"b2d2b2d3b2f4e5eee8b2f4d3",
   "Cang1",	"b2d6b2d7b2d4b2d5d8f7",
   "Cang2",	"b2d8",
   "Cao1",	"b2d9b2da",
   "Cao2",	"b2dbb2dce0d0e4eef3a9f4bd",
   "Cao3",	"b2dd",
   "Ce4",	"b2dfb2e1b2e2b2deb2e0e2fc",
   "Cen1",	"b2ce",
   "Cen2",	"e1afe4b9",
   "Ceng1",	"e0e1",
   "Ceng2",	"d4f8b2e3",
   "Ceng4",	"b2e4",
   "Cha1",	"b2eeb2e5b2e6b2ead4fbe0eae2c7e8beefca",
   "Cha2",	"b2e9b2ecb2e8b2e6b2e7b2eab2ebe2aae9abe9b6e9df",
   "Cha3",	"b2e6efeff1c3",
   "Cha4",	"b2eec9b2b2e6b2edb2efe3e2e6b1e8bef1c3",
   "Chai1",	"b2eeb2f0eece",
   "Chai2",	"b2f1b2f2d9ad",
   "Chai4",	"f0fbf2b2",
   "Chan1",	"b2f3b2f4eae8",
   "Chan2",	"b5a5b2f5b2f6b2f7b2f8e2dce4fde5a4e5eee6bfecf8efe2f3b8f5f0",
   "Chan3",	"b2fab2fbb2f9d9e6dac6dddbe6f6",
   "Chan4",	"b2fce2e3e5f1",
   "Chang1",	"b2fdb2fed8f6ddc5e3d1e6bdf6f0",
   "Chang2",	"b3a4b3a1b3a3b3a5ccc8b3a2b3a6c9d1dcc9e1e4e6cf",
   "Chang3",	"b3a1b3a7b3a8e3aeeac6eba9",
   "Chang4",	"b3a9b3aab3abdbcbe2ea",
   "Chao1",	"b3acb3aeb3adb3b3b4c2bdcbe2f7eccc",
   "Chao2",	"b3b1b3afb3b0b3b2eacb",
   "Chao3",	"b3b3b3b4",
   "Chao4",	"f1e9",
   "Che1",	"b3b5edba",
   "Che3",	"b3dfb3b6",
   "Che4",	"b3b7b3b9b3b8b3badbe5",
   "Chen1",	"b3bbded3e0c1e8a1",
   "Chen2",	"b3c2b3bfc9f2b3c1b3bcb3bdb3beb3c0b3c8dac8e5b7",
   "Chen3",	"edd7",
   "Chen4",	"b3c6b3c3b3c4b3d3dadfe9b4f6b3",
   "Chen5",	"d8f7",
   "Cheng1",	"b3c6b3c5b3d3e0e1e8dfeeaaeef5f2c9",
   "Cheng2",	"b3c9b3ccb3d0b3c7caa2b3cab3cbb3cfb3cdb3ced8a9b3c8dbf4e8c7ebf3eef1f1cef5a8",
   "Cheng3",	"b3d1b3d2f1ce",
   "Cheng4",	"b3c6b3d3",
   "Chi1",	"b3d4f3d7b3d5dfeae0cde6caedf7f0b7f2bff3a4f7ce",
   "Chi2",	"b3d6b3d8b3d9b3dbb3d7b3dadbe6dcafdcddf3f8f5d8",
   "Chi3",	"b3dfb3dcb3ddb3def1ddf4f9",
   "Chi4",	"b3e0b3e1b3e2b3e3d9d1dfb3e0b4e1dce2c1ebb7f1a1",
   "Chong1",	"b3e4b3e5d3bfdcfbe2e7e3bff4a9f4be",
   "Chong2",	"d6d6d6d8b3e7b3e6",
   "Chong3",	"b3e8",
   "Chong4",	"b3e5efa5",
   "Chou1",	"b3e9f1ac",
   "Chou2",	"b3efb3eab3f1b3eeb3ebb3ecb3edb3f0d9b1e0fce3b0f6c5",
   "Chou3",	"b3f2b3f3",
   "Chou4",	"b3f4",
   "Chu1",	"b3f6b3f5e9cb",
   "Chu2",	"b3fdb3f7b3f8b3f9b3fab3fbb3fcdbbbf2dcf5e9",
   "Chu3",	"b4a6b4a2b4a1b3fee8c6e8faf1d2",
   "Chu4",	"b4a6b4a5d0f3b4a3b4a4d8a1e2f0e3c0e7a9f7ed",
   "Chuai1",	"b4a7def5",
   "Chuai3",	"b4a7",
   "Chuai4",	"b4a7e0a8e0dcebfaf5df",
   "Chuan1",	"b4a8b4a9e7ddebb0",
   "Chuan2",	"b4acb4abb4aae5d7f4ad",
   "Chuan3",	"b4ade2b6",
   "Chuan4",	"b4aeeecb",
   "Chuang1",	"b4b4b4b0b4af",
   "Chuang2",	"b4b2b4b1",
   "Chuang3",	"b4b3",
   "Chuang4",	"b4b4e2eb",
   "Chui1",	"b4b5b4b6",
   "Chui2",	"b4b7b4b8b4b9d7b5daefe9a2e9b3",
   "Chun1",	"b4bab4bbf2ed",
   "Chun2",	"b4bfb4bcb4bdb4beddbbf0c8",
   "Chun3",	"b4c0",
   "Chuo1",	"b4c1f5d6",
   "Chuo4",	"b4c2e0a8eaa1f6ba",
   "Ci1",	"b2eeb4c3b4ccdfda",
   "Ci2",	"b4cad7c8b4c7b4c8b4c4b4c5b4c6b4c9dcebecf4f0cbf4d9",
   "Ci3",	"b4cb",
   "Ci4",	"b4ceb4cdb4cccbc5",
   "Cong1",	"b4d3b4cfb4d0b4d1b4d2dccae6f5e8aee8c8",
   "Cong2",	"b4d3b4d4e4c8e7fd",
   "Cou4",	"b4d5e9a8eaa3ebed",
   "Cu1",	"b4d6",
   "Cu2",	"e1dee9e3",
   "Cu4",	"b4d9d7e4b4d7b4d8ddfde2a7f5a1f5bef5ed",
   "Cuan1",	"b4dad9e0dfa5efe9",
   "Cuan2",	"d4dc",
   "Cuan4",	"b4dbb4dcece0",
   "Cui1",	"cba5b4ddb4deb4dfe9c1f6bf",
   "Cui3",	"e8ad",
   "Cui4",	"b4e2b4e0b4e1b4e3b4e4ddcddffde3b2eba5",
   "Cun1",	"b4e5f1e5",
   "Cun2",	"b4e6b6d7",
   "Cun3",	"e2e2",
   "Cun4",	"b4e7",
   "Cuo1",	"b4e8b4e9b4eaf5e3",
   "Cuo2",	"e1cfeff3f0eef0fbf5ba",
   "Cuo3",	"b4e9ebe2",
   "Cuo4",	"b4ebb4edd8c8b4ecefb1",
   "Da1",	"b4f0b4eedec7dfd5f1d7e0aa",
   "Da2",	"b4efb4f2b4f0b4f1e2f2e6a7edb3f3cef7b0f7b2",
   "Da3",	"b4f2",
   "Da4",	"b4f3",
   "Da5",	"cbfef0e3",
   "Dai1",	"b4fdb4f4dfbe",
   "Dai3",	"b4feb4f5b4f6",
   "Dai4",	"b4f3b4fab4fdb4f8b4fbb4f7b4feb4fcb4f9b5a1dca4dfb0e1b7e5cae6e6e7aae7e9f7ec",
   "Dan1",	"b5a5b5a4b5a3b5a2b5a6d9d9e9e9edf1f0f7f1f5f3ec",
   "Dan3",	"b5a3b5a7b5a8eae6f0e3f0f7",
   "Dan4",	"b5abcaafb5a3b5adb5a9b5afb5aeb5aab5acb5b0ddcce0a2e5a3f0f7",
   "Dang1",	"b5b1eef5f1c9",
   "Dang3",	"b5b3b5b2dad4",
   "Dang4",	"b5b1b5b2b5b4b5b5dbcaddd0e5b4edb8",
   "Dao1",	"b5b6dfb6e2e1ebae",
   "Dao2",	"dfb6",
   "Dao3",	"b5bcb5bab5b9b5b8b5b7b5bb",
   "Dao4",	"b5bdb5c0b5b9b5c1b5beb5bfe0fcece2f4ee",
   "De2",	"b5c3b5c2efbd",
   "De5",	"b5c4b5d8b5c3b5d7",
   "Dei3",	"b5c3",
   "Deng1",	"b5c7b5c6b5c5e0e2f4a3",
   "Deng3",	"b5c8eaad",
   "Deng4",	"b3ceb5cbb5c5b5c9b5cae1d8ede3efeb",
   "Di1",	"cce1b5cdb5ccb5ced8b5e0d6efe1f4c6",
   "Di2",	"b5c4b5d2b5d0b5cfb5d1b5d3b5d4b5d5d9e1ddb6e0d6eaebefe1",
   "Di3",	"b5d6b5d7d8b5daaedbe6e8dcedc6f7bedba1",
   "Di4",	"b5c4b5d8b5dab5dcb5dbb5ddb5d9b5dedad0e6b7e7b0e9a6eddaedfb",
   "Dia3",	"e0c7",
   "Dian1",	"b5dfb5e0b5e1e1dbf1b2",
   "Dian3",	"b5e3b5e4b5e2d8bcf5da",
   "Dian4",	"b5e7b5eab5eeb5ecb5e5b5e6b5e8b5e9b5ebb5eddae7dbe3e7e8eee4f1b0f4a1",
   "Diao1",	"b5efb5f0b5f1b5f2b5f3f5f5f6f4",
   "Diao3",	"c4f1",
   "Diao4",	"b5f7b5f4b5f5b5f6eef6efa2",
   "Die1",	"b5f8b5f9f5da",
   "Die2",	"b5fab5fbb5fcb5fdb5fed8fddbecdca6dee9e0a9ebbaf0acf1f3f5def6f8",
   "Ding1",	"b6a1b6a2b6a3b6a4d8eae7e0eeaef0dbf1f4f4fa",
   "Ding3",	"b6a5b6a6f4fa",
   "Ding4",	"b6a8b6a9edd6b6a4b6a7e0a4ebebeefa",
   "Diu1",	"b6aaeefb",
   "Dong1",	"b6abb6acdfcbe1b4ebb1f0b4",
   "Dong3",	"b6adb6aeedcf",
   "Dong4",	"b6afb6b0b6b1b6b2b6b3b6b4dbede1bcebcbebd8edcf",
   "Dou1",	"b6bcb6b5ddfaf3fb",
   "Dou3",	"b6b7b6b6b6b8f2bd",
   "Dou4",	"b6c1b6bab6b7b6b9b6bbf1bc",
   "Du1",	"b6bcb6bde0bd",
   "Du2",	"b6c0b6c1b6d9b6beb6bfe4c2e8fcebb9f7c7f7f2",
   "Du3",	"b6c4f3c6b6c3b6c2b6c7",
   "Du4",	"b6c8b6c5b6c9b6c6b6c7b6cadcb6f3bc",
   "Duan1",	"b6cb",
   "Duan3",	"b6cc",
   "Duan4",	"b6ceb6cfb6cdb6d0e9b2ecd1f3fd",
   "Dui1",	"b6d1",
   "Dui4",	"b6d4b6d3b6d2b6d8eda1edadedd4efe6",
   "Dun1",	"b6d6b6d8b6d5b6d7ede2efe6",
   "Dun3",	"edeff5bb",
   "Dun4",	"b6d9b6dbb6dcb6dab6dde3e7ecc0edbb",
   "Duo1",	"b6e0b6deb6dfdfcdf1d6",
   "Duo2",	"b6c8b6e1eeecf5e2",
   "Duo3",	"b6e2b6e3b6e4dfe1e7b6",
   "Duo4",	"b6e2b6e5b6e6b6e7b6e8b6e9cdd4e3f5e8de",
   "E1",	"b0a2e5ede6b9",
   "E2",	"b6eeb6ecb6eab6ebb6edb6efb6f0c5b6ddadefb0",
   "E3",	"b6f1",
   "E4",	"b6f1b6f2b6f4b6f3b6f5b6f6d8acdaccdbd1dcc3dde0dfc0e3b5e3d5e9eeebf1efc9f0caf2a6f6f9",
   "E5",	"dfc0",
   "Ei2",	"dac0",
   "Ei3",	"dac0",
   "Ei4",	"dac0",
   "En1",	"b6f7ddec",
   "En4",	"def4",
   "Er2",	"b6f8b6f9f0b9f6dc",
   "Er3",	"b6fbb6fab6fcb6fde5c7e7edeeef",
   "Er4",	"b6feb7a1d9a6",
   "Fa1",	"b7a2",
   "Fa2",	"b7a3b7a6b7a5b7a4b7a7dbd2",
   "Fa3",	"b7a8edc0",
   "Fa4",	"b7a2b7a9",
   "Fan1",	"b7adb7aab7acb7abdeace1a6",
   "Fan2",	"b7b1b7b2b7bab7b3b7aeb7afb7b0deacdec0ecdcf5ec",
   "Fan3",	"b7b4b7b5",
   "Fan4",	"b7b8b7b7b7b6b7bab7b9e8f3eeb2",
   "Fang1",	"b7bdb7bcb7bbb7c1dafae8caeed5",
   "Fang2",	"b7c0b7bfb7bbb7beb7c1f6d0",
   "Fang3",	"b7c3b7c4b7c2e1ddf4b3",
   "Fang4",	"b7c5",
   "Fei1",	"b7c7b7c9e7b3b7c6b7c8e5faece9f2e3f6adf6ee",
   "Fei2",	"b7cae4c7ebe8",
   "Fei3",	"b7c6b7cbb7cce3ade9bcecb3f2e3f3f5f4e4",
   "Fei4",	"b7d1b7cfb7ceb7cdb7d0dcc0e1f4efd0f0f2",
   "Fen1",	"b7d6b7d7b7d2b7d5b7d3b7d4e7e3",
   "Fen2",	"b7d8b7d9b7dae8fbf7f7",
   "Fen3",	"b7db",
   "Fen4",	"b7d6b7ddb7dcb7deb7dfb7e0d9c7e5aff6f7",
   "Feng1",	"b7e7b7e1b7e2b7e5b7e3b7e4b7e6b7e8b7e9dbbaddd7e3e3edbf",
   "Feng2",	"b7eab7ebb7ec",
   "Feng3",	"b7eddff4",
   "Feng4",	"d9bab7efb7eeb7ecddd7",
   "Fo2",	"b7f0",
   "Fou3",	"b7f1f3be",
   "Fu1",	"b7f2b7f3b7f4b7f5dfbbeffbf4eff5c3f5c6",
   "Fu2",	"b7feb8a3b7f2b8a1b7f0b7fbb8a5e6dab7f9b7fcb7f6b7f7b7f8b7fab7fdb8a2b8a4d9ebd9ecdbaedcbddcc0dcdedcf2ddb3ddcae1a5e2f6e5f5e7a6e7a8e8f5ecf0edc9edeaeeb7effbf2b6f2ddf2f0",
   "Fu3",	"b8aeb8b8b8a8b8a9b8abb8a6b8a7b8aab8acb8adb8afded4e4e6edeb",
   "Fu4",	"b7feb8b6b8b1b8b4b8bab8bdb8bbb8b8b8beb8b0b8b2b8b9b8b3b8b5b8b7b8bcb8bfb8c0e6e2eae7f0a5f2f3f6d6f6fb",
   "Fu5",	"b8c0",
   "Ga1",	"bfa7bcd0b8c2b8ecd9a4eab8",
   "Ga2",	"b8c1b8c2d4fee6d9eec5",
   "Ga3",	"b8c2e6d8",
   "Ga4",	"dece",
   "Gai1",	"b8c3daebdbf2eae0",
   "Gai3",	"b8c4",
   "Gai4",	"b8c5b8c7b8c6b8c8bde6d8a4eaae",
   "Gan1",	"b8c9b8cab8cbb8ccb8cdb8cec7acdbe1dcd5decfe3efedb7f0e1f4fb",
   "Gan3",	"b8d2b8cfb8cbb8d0b8d1dfa6e4f7e9cf",
   "Gan4",	"b8c9b8d3e4c6e7a4eaba",
   "Gang1",	"b8d5b8d4b8d6b8d7b8d8b8d9b8dcbfb8eeb8",
   "Gang3",	"b8dbb8da",
   "Gang4",	"b8d6b8dcedb0f3e0",
   "Gao1",	"b8dfb8ddb8deb8e0b8e1b8e2d8bae9c0",
   "Gao3",	"b8e5b8e3b8e4debbe7c9e9c2eabd",
   "Gao4",	"b8e6b8e0dabedbacefaf",
   "Ge1",	"b8f1b8e7b8e8b8e9b8eab8ebb8ecb8edb8eebfa9d2d9d8eedbd9e6fcf1cb",
   "Ge2",	"b8f1b8efb8f3b8f0b8f4b8e9b8ecb8f2d8aadcaae0c3eba1ebf5efd3f2a2f7c0",
   "Ge3",	"b8f6b8f7bacfb8f0b8c7dbc1f4b4",
   "Ge4",	"b8f6b8f7b8f5edd1f2b4",
   "Gei3",	"b8f8",
   "Gen1",	"b8f9b8fa",
   "Gen2",	"dfe7",
   "Gen3",	"f4de",
   "Gen4",	"d8a8dda2f4de",
   "Geng1",	"b8fcb8fdb8fbb8fee2d9",
   "Geng3",	"b9a1b9a2b9a3beb1dfece7aef6e1",
   "Geng4",	"b8fc",
   "Gong1",	"b9a4b9abb9b2b9a9b9a6baecb9a5b9acb9a7b9a8b9aab9adebc5f2bcf6a1",
   "Gong3",	"b9aeb9afb9b0e7ee",
   "Gong4",	"b9b2b9a9b9b1",
   "Gou1",	"b9b5bee4b9b3b9b4d8fee7c3e8dbf3f4f7b8",
   "Gou3",	"b9b6b9b7e1b8e8dbf3d1",
   "Gou4",	"b9b9b9bbb9bab9b4b9b8dab8e5dce6c5eaedecb0",
   "Gu1",	"b9c0b9bcb9bdb9beb9bfb9c1b9c2b9c3b9c7ddd4dfc9e9efecb1f0b3f2c1f4fef5fd",
   "Gu2",	"b9c7",
   "Gu3",	"b9c9b9c4b9c5b9c8b9c6b9c7bcd6d8c5daace3e9eaf4ebfbecb1eeadeeb9eedcf0c0f2c1f7bd",
   "Gu4",	"b9cbb9cdb9c0b9cab9cce1c4e8f4eaf6efc0f0f3f6f1",
   "Gua1",	"c0a8b9ceb9cfdfc9e8e9ebd2f0bb",
   "Gua3",	"b9d1b9d0dfc9",
   "Gua4",	"b9d2b9d3d8d4dab4",
   "Guai1",	"b9d4dee2",
   "Guai3",	"b9d5",
   "Guai4",	"b9d6",
   "Guan1",	"b9d8b9d9b9dbb9dab9d7c2dad9c4ddb8f1e6f7a4",
   "Guan3",	"b9dcb9ddddb8",
   "Guan4",	"b9dbb9dfb9dab9deb9e0b9e1dee8e4caeec2f0d9",
   "Guang1",	"b9e2dfdbe8e6ebd7",
   "Guang3",	"b9e3e1ee",
   "Guang4",	"b9e4e8e6",
   "Gui1",	"b9e6b9e9b9e5b9e7b9e8b9eab9ebbffee6a3f0a7f6d9",
   "Gui3",	"b9ecb9edb9eeb9efd8d0e2d1e5b3ead0f3fe",
   "Gui4",	"b9f3b9f0b9f1b9f2b9f4c8b2d8dbe8edeac1f7ac",
   "Gun3",	"b9f5b9f6d9f2e7b5eddef6e7",
   "Gun4",	"b9f7",
   "Guo1",	"b9fdb9f9b9f8ced0dbf6dfc3e1c6f1f8f2e5",
   "Guo2",	"b9fad9e5dee2e0feebbd",
   "Guo3",	"b9fbb9fce2a3e9a4f2e4",
   "Guo4",	"b9fd",
   "Ha1",	"b9feeefe",
   "Ha2",	"b8f2cfba",
   "Ha3",	"b9fe",
   "Ha4",	"b9fe",
   "Hai1",	"bad9bfc8e0cb",
   "Hai2",	"bbb9baa2baa1",
   "Hai3",	"baa3ebdcf5b0",
   "Hai4",	"baa6baa4baa5baa7",
   "Han1",	"baa8baa9f1fcf2c0f7fd",
   "Han2",	"baabbaafbaacbaadbab9baaabaaedaf5eacfecca",
   "Han3",	"bab0bab1e3db",
   "Han4",	"bababab4bab6bab2bab5bab9bab3bab7bab8ddd5defee5abf2a5",
   "Hang1",	"babb",
   "Hang2",	"d0d0babdbabcbfd4e7ace7f1f1fe",
   "Hang4",	"d0d0cfefe3ec",
   "Hao1",	"ddefdeb6e0e3",
   "Hao2",	"bac5bac0bac1babebabfbad1e0c6e5a9f2ba",
   "Hao3",	"bac3bac2",
   "Hao4",	"bac3bac5bac4bac6b8e4e5b0eabbf0a9f2ab",
   "He1",	"bac8bac7daade0c0",
   "He2",	"bacdbacfbacebad3bacbbac9bacabaccbad0bad1bad2bad4dbc0e3d8e6fceac2eec1f2a2f2c2f4e7",
   "He4",	"bacdbacebad8bac9bad5bac8bad6bad7cfc5dbd6",
   "Hei1",	"badabad9e0cb",
   "Hen2",	"badb",
   "Hen3",	"badcbadd",
   "Hen4",	"bade",
   "Heng1",	"bae0badf",
   "Heng2",	"d0d0bae2bae1bae3debfe7f1e8ec",
   "Heng4",	"bae1",
   "Hng5",	"badf",
   "Hong1",	"bae4bae5bae6d9eadeb0",
   "Hong2",	"baecbae8bae9bae7baeabaebd9e4dda6deaee3c8e3fc",
   "Hong3",	"bae5",
   "Hong4",	"bae5daa7deae",
   "Hou3",	"baf0",
   "Hou4",	"baf3baf2baeebaf1dca9e1e1e5cbf6d7",
   "Hu1",	"baf4baf5cfb7baf6bafddffce3b1e4efe9f5ecc3",
   "Hu2",	"bacdbafabacbbafebaf7baf8baf9bafbbafcbafdbba1e0f1e2a9e9ceecb2eccef0c9f5adf5faf7bdf0c0",
   "Hu3",	"bba2bba3e4b0e7fa",
   "Hu4",	"bba4bba5bba7bba2bafdbba6d9fce1b2e2efece6ece8eceff0adf0d7f3cb",
   "Hua1",	"bbafbbaabba8bba9edb9",
   "Hua2",	"bbaabbaebbedbba9bbabbbace6e8eefc",
   "Hua4",	"bbafbbaabbaebbb0bbade8eb",
   "Huai2",	"bbb3bbb1bbb2bbb4f5d7",
   "Huai4",	"bbb5",
   "Huai5",	"bbae",
   "Huan1",	"bbb6e2b5",
   "Huan2",	"bbb9bbb7bbb8dba8ddc8e0f7e4a1e5bee7d9efccf7df",
   "Huan3",	"bbba",
   "Huan4",	"bbbbbbbcbbc0bbc3bbbdbbbebbbfbbc1bbc2dbbcdfa7e4bde4f1e5d5f6e9",
   "Huang1",	"bbc5bbc4ebc1",
   "Huang2",	"bbc6bbcabbcdbbc7bbc8bbc9bbcbbbccdaf2e1e5e4d2e4eae5d8e8abf1a5f3a8f3f2f6fc",
   "Huang3",	"bbcebbcfbbd0bbd1",
   "Huang4",	"bbce",
   "Hui1",	"bbd3bbd6bbd4bbd2b6e9bbd5dab6dfd4e3c4e7f5eacdf2b3f7e2",
   "Hui2",	"bbd8bbb2bbd7dceee4a7",
   "Hui3",	"bbd9bbdaf2b3",
   "Hui4",	"bbe1bbe3bbddbbdbbbe6bbdfbbdcbbdebbe0bbe2bbe4bbe5c0a3dcf6dea5dfdce0b9e4abe5e7e7c0e8ededa3f3b3",
   "Hun1",	"bbe9bbe8bbe7e3d4",
   "Hun2",	"bbecbbeabbebe2c6e7f5",
   "Hun4",	"bbecdabbe4e3",
   "Huo1",	"bbedd8e5dfabefc1f1eb",
   "Huo2",	"bacdbbee",
   "Huo3",	"bbf0bbefe2b7eed8",
   "Huo4",	"bacdbbf5bbf2bbf1bbf6bbedbbf4bbf3debde0ebefecf3b6",
   "Ji1",	"c6e4bbfac6dabbf9bcb8bbfdbca4bca8c6e6bca3bbfcbbf8bca7bbf7bbfbbbfebca1bca2bca5bca6bca9d8a2d8c0d8dedbd4dcb8dfb4dfd2dff3e5ece7dce7e1eae5eaf7ecb4edb6eebfeffaf3c7f5d2",
   "Ji2",	"bcb0bcb6bcb4bcaabcabbcafbcb1bcaeb8efbde5e1a7bcb2bcadbcacbcb3bcb5bcb9d8bdd9a5dab5ddf0deaae1d5e9aee9eaeaabf1a4f3c5",
   "Ji3",	"bcc3b8f8bcbabcb8bccdb8efbcb7bcb9dee1eaaaf2b1f7e4",
   "Ji4",	"bcc6bcc3cfb5bccabcccbcc7bcbcbccdbcc4f4dfbcbebcc8c6ebbcc1bcc0bcbbbcbdbcbfbcc2bcc5bcc9bccbd9cadcc1dcf9dfe2e4a9e6f7eae9f0a2f5d5f6abf6ddf6eaf7d9",
   "Jia1",	"bcd3bcd2bccebcd1bcd0bccfc7d1d0aed9a4dde7e4a4e5c8e7ecefd8f0e8f3d5f4c2f5ca",
   "Jia2",	"bcd0bcd4bcd5dba3eaa9eda2eef2f1caf2cc",
   "Jia3",	"bcd9bdc7bdc9bdc5bcd7bcd6bcd8bdc1bdc2bdc3bdc4bdc6bdc8bdcabdcbd8c5d9aeded8e1b5e1e8e4d0ebb8ebcef0a8f0fd",
   "Jia4",	"bcdbbcd9bcddbcdcbcdabcde",
   "Jia5",	"bcd2",
   "Jian1",	"bce4bce0bce1bda5bce6bce8bce2c7b3bcdfbce3bce5bce7bce9bceabda6ddd1ddf3def6e4d5e7cceaa7eaf9f0cff6e4f7b5",
   "Jian3",	"bcecbcf5bcf2bcf3bcedbcf4bcebbceebcefbcf0bcf1dad9e0eee5bfe5c0e8c5eaafedfaefb5f1d0f3c8f4e5f5c2",
   "Jian4",	"bda8bce4bcfebcfbbce0bda1bda5bcf8bcf6bda3bcf7bcf9bcfabcfcbcfdbda2bda4bda6bda7d9d4dac9e9a5eaf0eba6ebecefb5f5dd",
   "Jiang1",	"bdabbdadbda9bdaabdacbdaedcfce7d6ede4f4f8",
   "Jiang3",	"bdb2bdb1bdafbdb0f1f0",
   "Jiang4",	"bdabc7bfbdb5bae7bdacbdb3bdb4e4aee7adeaf1f4dd",
   "Jiao1",	"bdccbdbbbdbabdb8bdb9bdb6bdb7bdbcbdbdbdbebdbfd9d5dcb4dcfae6aff0d4f2d4f5d3f6de",
   "Jiao2",	"bdc0bdc3e1bd",
   "Jiao3",	"bdc7bdc9bdc5ded8bdc1bdc2bdc3bdc4d9aef0a8ebb8e1e8bdc6bdc8e4d0bdcabdcb",
   "Jiao4",	"bdccd0a3bdcfbef5bdd0bdc0bdcdbdcebdd1e0dde1bde1e8f5b4",
   "Jie1",	"bdd3bde1bddabdd7bdd6bdd4bdd2bdd5bface0aee0b5f0dc",
   "Jie2",	"bde1bddabdd8bde0bddcbdd9bdddbddfbddbbdded9cadaa6dab5ded7e6bce6dde8eeedd9f2a1f4c9f6da",
   "Jie3",	"bde2bde3",
   "Jie4",	"bcdbbde2bde7bdecbde9bde5bde8bde4bde6bdeabdebf2bbf7ba",
   "Jie5",	"bcd2bcdb",
   "Jin1",	"bdf1bdf0bdfbbdf2bdedbdeebdefbdf3f1c6f1e6",
   "Jin3",	"bea1bdf4bdf6bdf5bdf7dae1ddc0e2cbe2dbe8aae9c8",
   "Jin4",	"bdf8bdfcbea1bdf6bdfbbdfabdf9bdfdbdfebea2dda3e0e4e6a1e7c6eae1eaee",
   "Jing1",	"beadbeabbeaabea9bea6bea3bea4bea5bea7bea8beacddbce3feebe6ecba",
   "Jing3",	"beafbeb0beaebeb1d8d9d9d3dae5e3bdebc2",
   "Jing4",	"beadbeb9beb3beb4beb2bebbbeb6beb5bea2beb7beb8bebae2b0e5c9e5f2e6baebd6f6a6",
   "Jiong1",	"ece7",
   "Jiong3",	"bebcbebde5c4eac1",
   "Jiu1",	"bebfbec0bebee0b1e3cef0aff4f1f7dd",
   "Jiu3",	"bec5bec3bec6bec1bec2bec4",
   "Jiu4",	"becdbec9bec8bec7becabecbbeccbeced9d6e8d1e8eaf0d5",
   "Ju1",	"beddb3b5c7d2bed3bee3bee2bed0becfbed1bed2bed4dcdadee4e8a2e9a7efb8f1d5f4f2f6c2f7b6",
   "Ju2",	"bed6bddbbed5e9d9efb8",
   "Ju3",	"bed9bedab9f1bed7bed8dcece8dbe9b7f5e1f6b4",
   "Ju4",	"beddbedfbedebee3bee7bedcbee4bee2bee0bedbbedabee5bee1bee6d9c6daaadcc4e5e1e5f0e9b0eaf8ecabeed2f1c0f4f2f5b6f6c4",
   "Juan1",	"bee8c8a6bee9beeae4b8eec3efd4",
   "Juan3",	"beedefc3",
   "Juan4",	"beedbfa1c8a6beebbeecbeeedbb2e1fae8f0f6c1",
   "Jue1",	"beefe0b5e0d9",
   "Jue2",	"bef6bdc7bef4bef8bef5bdc5bef2bdc0bef0bef1bef3bef7d8cad8e3dadcdbc7dea7e0e5e1c8e2b1e6dee7e5e8f6e9d3ecdfefe3f5eaf5fb",
   "Jue3",	"f5ea",
   "Jue4",	"bef3",
   "Jun1",	"befcbef9befdb9eabefabefbf1e4f3def7e5",
   "Jun4",	"bfa2bfa1befabefebfa3bfa4bfa5dedc",
   "Ka1",	"bfa7bfa6dfc7",
   "Ka3",	"bfa8bfa9d8fbdfc7ebcc",
   "Kai1",	"bfaabfabefb4",
   "Kai3",	"bfaebfacbfadd8dcdbeedddce2fdeef8efc7",
   "Kai4",	"e2e9",
   "Kan1",	"bfb4bfafbfb0bfb1eaacede8",
   "Kan3",	"bfb2bfb3bcf7d9a9dda8e3db",
   "Kan4",	"bfb4c7b6e3dbeeab",
   "Kang1",	"bfb5bfb6bfb7e3ca",
   "Kang2",	"bfb8",
   "Kang4",	"bfb9d8f8bfbabfbbe3caeed6",
   "Kao1",	"e5ea",
   "Kao3",	"bfbcbfbdbfbee8e0",
   "Kao4",	"bfbfeafbeeed",
   "Ke1",	"bfc6bfc2bac7bfc0bfc1bfc3bfc4bfc5e0bee7e6e9f0eea7eeddeffdf0e2f1bdf2a4f2f2f7c1",
   "Ke2",	"bfc7bfc8f2a4",
   "Ke3",	"bfc9bfc0bfcae1b3e9f0",
   "Ke4",	"bfc9bfcbbfcdbfcebfcce0bee3a1e4dbe6ece7bcebb4efbef2c2",
   "Ken3",	"bfcfbfd0bfd1bfd2f6b8",
   "Ken4",	"f1cc",
   "Keng1",	"bfd3bfd4efac",
   "Kong1",	"bfd5d9c5e1c7f3ed",
   "Kong3",	"bfd6bfd7d9c5",
   "Kong4",	"bfd5bfd8",
   "Kou1",	"bfd9dcd2edee",
   "Kou3",	"bfda",
   "Kou4",	"bfdbbfdcdea2dfb5f3d8",
   "Ku1",	"bfdebfddbfdfd8dadca5f7bc",
   "Ku3",	"bfe0",
   "Ku4",	"bfe2bfe3bfe1e0b7e7ab",
   "Kua1",	"bfe4",
   "Kua3",	"bfe5d9a8",
   "Kua4",	"bfe6bfe7bfe8",
   "Kuai3",	"d8e1",
   "Kuai4",	"bbe1bfecbfe9bfeabfebdba6dfe0e1f6e4abebda",
   "Kuan1",	"bfedf7c5",
   "Kuan3",	"bfee",
   "Kuang1",	"bfefbff0bff2dab2dfd1",
   "Kuang2",	"bff1dabf",
   "Kuang3",	"dec5",
   "Kuang4",	"bff6bff3bff2bff4bff5daf7dbdbe6feeadc",
   "Kui1",	"bff7bff8bff9bffae3a6",
   "Kui2",	"bffbbffcbffdd8b8d9e7daf3def1e0ade5d3ead2eea5f2f1",
   "Kui3",	"bffef5cd",
   "Kui4",	"e3b4c0a1c0a2c0a3d8d1dddee0b0f1f9f3f1",
   "Kun1",	"c0a4c0a5e7fbefbff5abf6eff7d5",
   "Kun3",	"c0a6e3a7e3cd",
   "Kun4",	"c0a7",
   "Kuo4",	"c0a8cacac0a9c0abc0aae8e9f2d2",
   "La1",	"c0adc0acc0aec0b2e5e5",
   "La2",	"c0adc0aeeab9edc7",
   "La3",	"c0adc0ae",
   "La4",	"c0adc2e4d8ddc0b0c0afc0b1f0f8",
   "La5",	"c0b6c0b2",
   "Lai2",	"c0b4c0b3e1c1e1e2e4b5efaa",
   "Lai4",	"c0b5e4feeae3edf9f1aef4a5",
   "Lan2",	"c0bcc0b6c0b7c0b8c0b9c0bac0bbc0bdc0bee1b0ecb5efe7f1dc",
   "Lan3",	"c0c0c0c2c0c1c0bfe4ede9adeebd",
   "Lan4",	"c0c4c0c3",
   "Lang1",	"e0a5",
   "Lang2",	"c0c8c0c9c0c5c0c6c0c7e3cfefb6effcf2eb",
   "Lang3",	"c0ca",
   "Lang4",	"c0cbc0c9ddb9ddf5e3cf",
   "Lao1",	"c0cc",
   "Lao2",	"c0cdc0cedfebe1c0efa9f0ecf5b2",
   "Lao3",	"c0cfc0d0c0d1c1cae8e1eeee",
   "Lao4",	"c2e7c2e4c0d2c0d3c0d4dfebf1ec",
   "Le1",	"c0df",
   "Le4",	"c0d6c0d5dfb7d8ece3eef7a6",
   "Le5",	"c1cb",
   "Lei1",	"c0d5c0de",
   "Lei2",	"c0d7c0dbc0d8c0ded9fae6d0e7d0e9db",
   "Lei3",	"c0dbc0d9c0dac0dcc0dddab3f1e7",
   "Lei4",	"c0e0c0dbc0dec0dfc0e1f5aa",
   "Lei5",	"e0cf",
   "Leng1",	"c0e2",
   "Leng2",	"c0e2c0e3dca8",
   "Leng3",	"c0e4",
   "Leng4",	"e3b6",
   "Li1",	"c1a8",
   "Li2",	"c0ebc0f6c0e5c0e8c0e6c0e7c0e9c0eac0ecc1a7ddf1debce0ace6cbe6eae7caeebef0bff2dbf3bbf6e2f7f3",
   "Li3",	"c0edc0efc0eec0f1c1a8c0f0d9b5e3a6e5a2e5cee6b2efaef3bbf5b7f7af",
   "Li4",	"c0fbc1a6c1a2c0fdc0fac0f8c0f6d9b3c0f7ddb0c1a5c0f2c0f3c0f4c0f5c0f9c0fcc0fec1a1c1a3c1a4d8aadbaadbdedcc2debadfbfe0a6e1fbe4e0e8c0e8dde9f6ece5edc2eebaf0ddf0dff2c3f3d2f3f6f4cff5c8f6a8",
   "Li5",	"c1a8c1a7",
   "Lia3",	"c1a9",
   "Lian2",	"c1aac1acc1aec1abc1adc1afc1b0c1b1dec6e5a5eca1f1cdf3b9f6e3",
   "Lian3",	"c1b3c1b2ddfce7f6f1cf",
   "Lian4",	"c1b7c1b6c1b4c1b5e4f2e9ace9e7",
   "Liang2",	"c1bfc1bcc1bac1b8c1b9c1bbdcaeddb9e9a3f5d4",
   "Liang3",	"c1bdc1a9f7cb",
   "Liang4",	"c1bfc1bec1c2c1c1c1b9c1c0f5d4f6a6",
   "Liao1",	"c1c3c1cc",
   "Liao2",	"c1c6c1c5c1c3c1c4c1c7c1c8c1c9c1cce0dae2b2e5bce7d4f0d3",
   "Liao3",	"c1cbc1c7c1cadea4eec9",
   "Liao4",	"c1cbc1cfc1cec1c3c1ccc1cddecdeec9",
   "Lie1",	"dfd6",
   "Lie3",	"c1d1dfd6",
   "Lie4",	"c1d0c1d2c1d1c1d3c1d4d9fddbf8dee6e4a3f4f3f5f1f7e0",
   "Lie5",	"dfd6",
   "Lin2",	"c1d6c3d8c1d9f7ebc1dac1d5c1d7c1dbc1dcdff8e1d7e5e0eaa5eeacf4d4c1d8",
   "Lin3",	"c1dde2dee3c1e9dd",
   "Lin4",	"c1dcc1dec1dfddfeeca2f5ef",
   "Ling1",	"c1e0",
   "Ling2",	"c1eec1e3f1f6c1e4c1e9c1eac1e8c0e2c1e1c1e2c1e5c1e6c1e7dbb9dcdfe0f2e3f6e7b1e8dae8f9eab2f2c8f4e1f6ec",
   "Ling3",	"c1eec1ecc1eb",
   "Ling4",	"c1edc1eedfca",
   "Liu1",	"c1efecd6",
   "Liu2",	"c1f7c1f4c1f5c1f6c1f0c1f1c1f2c1f3e4afe5dee6f2ecbcefd6f6cc",
   "Liu3",	"c1f8e7b8efb3",
   "Liu4",	"c1f9c2bdc2b5c1efc1f3e5deefd6f0d2",
   "Lo5",	"bfa9",
   "Long1",	"c2a1",
   "Long2",	"c2a1c1fdc1fac1fbc1fcc1fedcd7e3f1e7e7e8d0ebcaedc3f1aa",
   "Long3",	"c1fdc2a2c2a3c2a4dbe2",
   "Long4",	"c5aa",
   "Lou1",	"c2a7",
   "Lou2",	"c2a5c2a6d9cddde4e0b6f1eff2f7f7c3",
   "Lou3",	"c2a7c2a8e1d0",
   "Lou4",	"c2b6c2a9c2aaefcef0fc",
   "Lou5",	"e0b6",
   "Lu1",	"dfa3e0e0",
   "Lu2",	"c2acc2abc2adc2aec2afdbe4e3f2e8d3e9f1ebcdf0b5f4b5f6d4",
   "Lu3",	"c2b3c2abc2b0c2b1c2b2e9d6efe5",
   "Lu4",	"c1f9c2b7c2b6c2bcc2bdc2ccc2b8c2b5c2b4c2b9c2bac2bbc2bedea4e4cbe4f5e5d6e8b4e9fbeaa4f0d8f3fc",
   "Lu5",	"e9f1ebaa",
   "Lu:3",	"c2c3c2c0c2c4c2c1c2c2c2c5c2c6d9cddedbebf6eff9f1da",
   "Lu:4",	"c2cac2c9c2c7c2ccc2cbc2c8",
   "Lu:5",	"c2bfe3cce9b5",
   "Luan2",	"c2cdc2cec2cfc2d0d9f5e6aee8eff0bdf6c7",
   "Luan3",	"c2d1",
   "Luan4",	"c2d2",
   "Lue:3",	"c2d3",
   "Lue:4",	"c2d4c2d3efb2",
   "Lun1",	"c2d5",
   "Lun2",	"c2dbc2d6c2d7c2d9c2d8c2d5c2dae0f0",
   "Lun4",	"c2db",
   "Luo1",	"c2dec2e4dedb",
   "Luo2",	"c2dec2dfc2dcc2ddc2e0c2e1c2e2e2a4e9a1ebe1efdd",
   "Luo3",	"c2e3d9c0d9f9f1a7",
   "Luo4",	"c2e7c2e4c2e5bfa9c0d3c2e6dcfddefbe3f8e4f0e7f3edd1f6c3",
   "Luo5",	"c2de",
   "M2",	"dfbc",
   "Ma1",	"c4a6c2e9c2e8c2ecc4a8e6d6",
   "Ma2",	"c2e9c2f0f3a1",
   "Ma3",	"c2edc2ebc2eac2f0c2ece1ef",
   "Ma4",	"c2ecc2eedfe9e8bf",
   "Ma5",	"c3b4c2f0c2ef",
   "Mai2",	"c2f1f6b2",
   "Mai3",	"c2f2dda4",
   "Mai4",	"c2f4c2f3c2f5c2f6dbbd",
   "Man1",	"f2a9",
   "Man2",	"c2f1c2f7c2f8c2f9c2fbc3a1f7a9f7b4",
   "Man3",	"c2faf2fd",
   "Man4",	"c2fcc2fdc2fbc2fec3a1dcace1a3e7cfecd7efdc",
   "Mang2",	"c3a6c3a4c3a2c3a3c3a5daf8edcb",
   "Mang3",	"c3a7e4ddf2fe",
   "Mao1",	"c3a8",
   "Mao2",	"c3abc3a8c3a9c3aac3acdce2eaf3ecb8f3b1f7d6",
   "Mao3",	"c3adc3aee1b9e3f7eac4",
   "Mao4",	"c3b3c3b0c3b1c3afc3b2d9f3e8a3eba3edaeeea6",
   "Me5",	"c3b4f7e1",
   "Mei2",	"c3bbc3b6c3bdc3bcc3b5c3b7c3b8c3b9c3bac3d3ddaee1d2e2ade4d8e9b9efd1f0cc",
   "Mei3",	"c3c0c3bfc3bee4bc",
   "Mei4",	"c3c1c3c2c3c3c3c4c3d5f1c7f7c8",
   "Men1",	"c3c6",
   "Men2",	"c3c5ded1eecd",
   "Men4",	"c3c6eccbedaf",
   "Men5",	"c3c7",
   "Meng1",	"c3c9",
   "Meng2",	"c3c9c3a5c3c8c3cac3cbddf9deabebfcede6f2b5f4bf",
   "Meng3",	"c3c9c3cdc3ccdbc2e3c2f2ecf3b7f4bb",
   "Meng4",	"c3cec3cf",
   "Mi1",	"c3d0dfe4",
   "Mi2",	"c3d4c3d1c3d2c3d3c3d5c3d6dec2e2a8ecf2f7e3f7e7",
   "Mi3",	"c3d7f4cdc3d0c3d2d8c2e5f4ebdf",
   "Mi4",	"c3d8c3dcc3d9c3dac3dbc3dddad7e0d7e3e8e5b5f4e9",
   "Mian2",	"c3dfc3dec3e0",
   "Mian3",	"c3e2c3e3c3e1c3e4c3e5e3e6e4c5e4cfebefededf6bc",
   "Mian4",	"c3e6",
   "Miao1",	"dff7",
   "Miao2",	"c3e7c3e8c3e9f0c5",
   "Miao3",	"c3eac3ebc3ece5e3e7bfe8c2edb5edf0",
   "Miao4",	"c3eec3ede7d1",
   "Mie1",	"d8bfdfe3",
   "Mie4",	"c3f0c3eff3baf3fa",
   "Min2",	"c3f1dce5e1bae7c5e7e4e7eb",
   "Min3",	"c3f4c3f2c3f3c3f5c3f6e3c9e3fdedaaf6bcf7aa",
   "Ming2",	"c3fbc3f7c3fac3f9c3cbc3f8daa4dcf8e4e9ead4eea8",
   "Ming3",	"f5a4",
   "Ming4",	"c3fc",
   "Miu4",	"c3fde7d1",
   "Mo1",	"c3fe",
   "Mo2",	"cedec4a3c4a6c4a5c3fec4a1c4a4c4a7c4a2dad3e2c9e6c6f7e1",
   "Mo3",	"c4a8",
   "Mo4",	"cdf2c3bbc4a9c3b0c4aac4acc4a5bad1bad9c2f6c4a8c4abc4adc4aec4afc4b0dcd4ddebe9e2efd2eff7f1a2f1f2f5f6f5f8",
   "Mou1",	"dfe8",
   "Mou2",	"c4b1c4b2d9b0e7d1edf8f2d6f2faf6ca",
   "Mou3",	"c4b3",
   "Mu2",	"c4a3eba4",
   "Mu3",	"c4b8c4b6c4b7c0d1c4b4c4b5",
   "Mu4",	"c4bfc4bec4bbc4bcc4c2c4b2c4b9c4bac4bdc4c0c4c1d8efdbe9dcd9e3e5eee2",
   "N2",	"e0c5",
   "N3",	"e0c5",
   "N4",	"e0c5",
   "Ng2",	"e0c5",
   "Ng3",	"e0c5",
   "Ng4",	"e0c5",
   "Na1",	"c4cfc4c7",
   "Na2",	"c4c3efd5",
   "Na3",	"c4c7c4c4",
   "Na4",	"c4c7c4c9c4d8c4c5c4c6c4c8ebc7f1c4dee0",
   "Na5",	"c4c4c4c5",
   "Nai3",	"c4cbc4c4c4cac4ccdcb5",
   "Nai4",	"c4cec4cdd8bed9a6ddc1e8cd",
   "Nan1",	"e0eee0ef",
   "Nan2",	"c4cfc4d1c4d0e0abe9aa",
   "Nan3",	"ebeef2eff4f6",
   "Nan4",	"c4d1",
   "Nang1",	"c4d2e0ec",
   "Nang2",	"c4d2e2ce",
   "Nang3",	"dfade2ceead9",
   "Nao1",	"d8ab",
   "Nao2",	"c5acc4d3dfcee2aeedd0eef3f2cd",
   "Nao3",	"c4d4c4d5dbf1e8a7",
   "Nao4",	"c4d6c4d7",
   "Ne2",	"c4c4",
   "Ne4",	"c4d8c4c5daab",
   "Ne5",	"c4d8c4c5",
   "Nei3",	"c4c4c4d9",
   "Nei4",	"c4dac4c7",
   "Nen4",	"c4dbeda5",
   "Neng2",	"c4dc",
   "Ni1",	"c4dd",
   "Ni2",	"c4e1c4d8c4e0c4dec4dfdbe8e2a5e2f5eeeaf6f2",
   "Ni3",	"c4e3c4e2ecbbecf2",
   "Ni4",	"c4e0c4e4c4e5c4e6c4e7c4f2d9a3eac7edabedfe",
   "Nian1",	"c4e9c4e8",
   "Nian2",	"c4ead5b3f0a4f6d3f6f3",
   "Nian3",	"c4ebc4ecc4ede9fd",
   "Nian4",	"d8a5c4eec4f0dbfe",
   "Niang2",	"c4f0c4ef",
   "Niang4",	"c4f0",
   "Niao3",	"c4f1dce0e6d5f4c1",
   "Niao4",	"c4e7c4f2ebe5",
   "Nie1",	"c4f3",
   "Nie4",	"c4f4c4f5c4f6c4f7c4f8c4f9d8bfdaeddec1e0bff2a8f4abf5e6",
   "Nin2",	"c4faeda5",
   "Ning2",	"c4fec4fbc4fcc4fdc5a1dcd1dfcce5b8f1f7",
   "Ning3",	"c5a1",
   "Ning4",	"c4fec5a1c5a2d8fa",
   "Niu1",	"e6a4",
   "Niu2",	"c5a3",
   "Niu3",	"c5a6c5a4c5a5e1f0e2ee",
   "Niu4",	"ded6",
   "Nong2",	"c5a9c5a7c5a8d9afdfe6",
   "Nong4",	"c5aa",
   "Nou4",	"f1f1",
   "Nu2",	"c5abe6dbe6e5",
   "Nu3",	"c5ace5f3e6c0",
   "Nu4",	"c5ad",
   "Nu:3",	"c5aeeecf",
   "Nu:4",	"eda4f4ac",
   "Nuan3",	"c5af",
   "Nue:4",	"c5b0c5b1",
   "Nuo2",	"c4c8c5b2d9d0",
   "Nuo4",	"c5b5c5b3c5b4def9dff6efbb",
   "Ou1",	"c7f8c5b7c5b9c5b8c5bddaa9eab1",
   "Ou3",	"c5bcc5bac5bbf1ee",
   "Ou4",	"c5bbc5bde2e6",
   "Pa1",	"c5c9dde2b0c7c5bec5bf",
   "Pa2",	"c5c0b0c7b0d2e8cbeed9f3e1",
   "Pa4",	"c5c2c5c1",
   "Pa5",	"c5c3",
   "Pai1",	"c5c4",
   "Pai2",	"c5c5c5c6c5c7d9bd",
   "Pai3",	"c5c5c6c8",
   "Pai4",	"c5c9c5c8dde5dfdf",
   "Pan1",	"c5cbb7acb0e2c5ca",
   "Pan2",	"b0e3c5ccc5cdc5d6e3ddf3b4f5e7",
   "Pan4",	"c5d0c5cec5cfc5d1ded5e3faf1c8f1e1",
   "Pang1",	"b0f2c5d2e4e8",
   "Pang2",	"c5d4c5d3b0f5b0f2e1dde5ccf3a6",
   "Pang3",	"c5d5",
   "Pang4",	"c5d6",
   "Pao1",	"c5dac5d7c5ddebe3",
   "Pao2",	"c5dac5dcc5d8c5d9c5dbdecbe1f3e2d2",
   "Pao3",	"c5dc",
   "Pao4",	"c5dac5ddf0e5",
   "Pei1",	"c5dec5dff5ac",
   "Pei2",	"c5e2c5e3c5e0c5e1efc2",
   "Pei4",	"c5e4c5e5c5e6e0ceecb7f6ace0fa",
   "Pen1",	"c5e7",
   "Pen2",	"c5e8e4d4",
   "Pen4",	"c5e7",
   "Peng1",	"c5eac5e9c5ebc5ece0d8e2f1",
   "Peng2",	"c5f2c5f3c5edc5eec5ecc5efc5f0c5f1c5f4dca1f3b2",
   "Peng3",	"c5f5",
   "Peng4",	"c5f6",
   "Pi1",	"c5fac5fbbbb5b1d9c5f7c5f8c5f9c5fcd8a7dafce0e8e7a2eeeb",
   "Pi2",	"c6a4c5fdc5fec6a1c6a2c6a3dae9daf0dbafdbfddcb1dcc5e8c1eebceeebf1d4f2b7f2e7f5f9",
   "Pi3",	"b7f1c6a6c5fcc6a5d8f2dbdcdfa8dfc1e2cff1b1f1e2",
   "Pi4",	"b1d9c6a9c6a7c6a8e4c4e6c7eea2",
   "Pian1",	"c6acc6aab1e2c6abeafaf4e6",
   "Pian2",	"b1e3e6e9e7c2ebddf5e4",
   "Pian3",	"dad2",
   "Pian4",	"c6acc6ad",
   "Piao1",	"c6aec6afd8e2e7cef3aa",
   "Piao2",	"c6b0c6d3e6ce",
   "Piao3",	"c6afddb3e7cee9e8eea9",
   "Piao4",	"c6b1c6afe0d1e6f4",
   "Pie1",	"c6b2c6b3ebad",
   "Pie3",	"c6b2d8afdcd6",
   "Pin1",	"c6b4ded5e6b0",
   "Pin2",	"c6b5c6b6c6bbe6c9f2ad",
   "Pin3",	"c6b7e9af",
   "Pin4",	"c6b8eaf2",
   "Ping1",	"c6b9d9b7e6b3",
   "Ping2",	"c6bdc6c0c6bec6bfb7ebc6bac6bbc6bcc6c1e8d2f6d2",
   "Po1",	"c6c2b2b4c6c4c6c3c6d3dae9e3f8eab7eec7",
   "Po2",	"b7b1c6c5dbb6f0ab",
   "Po3",	"d8cfeedef3cd",
   "Po4",	"c6c6c6c8c6c7c6c9c6d3e7ea",
   "Pou1",	"c6ca",
   "Pou2",	"d9f6dee5",
   "Pou3",	"dee5",
   "Pu1",	"c6ccc6cbc6cde0db",
   "Pu2",	"b8acc6cdc6cec6cfc6d0c6d1d9e9e5a7e8b1efe4",
   "Pu3",	"c6d5c6d2b1a4c6d4c6d7c6d3c6d6e4dfebabefe8f5eb",
   "Pu4",	"b1a9b1a4c6ccc6d8c6d9",
   "Punctuations",	"a1a2a1a3a1a4a1a5a1a6a1a7a1a8a1a9a1aaa1aba1aca1ada1aea1afa1b0a1b1a1b2a1b3a1b4a1b5a1b6a1b7a1b8a1b9a1baa1bba1bca1bda1bea1bfa9a8a9a9a9aaa9aba9aca9ada9aea9af",
   "Qi1",	"c6dfc6dac6e1c6dbc6debca9c6dcc6ddc6e0c6e2c6e3ddc2e0d2e8e7e9caeca5f5e8",
   "Qi2",	"c6e4c6ecc6e6c6efc6e7c6ebc6e5ecf7c6e8c6e8c6eac6edc6eed8c1d9b9dbdfdccedcf9ddbddeade4bfe6ebe7f7e7f9eac8f1fdf2d3f2e0f4ebf7a2f7e8e1aac6e9",
   "Qi3",	"c6f0c6f3c6f4c6f2bbfcc6f1dcbbe1a8e7b2e8bdf4ec",
   "Qi4",	"c6fbc6f7c6f8c6fac6f9c6ebc6f5c6dec6f6c6fcc6fdd8bddddde3e0edacedd3",
   "Qia1",	"c6fed9a4ddd6f1ca",
   "Qia3",	"bfa8",
   "Qia4",	"c7a2c7a1f7c4",
   "Qian1",	"c7a7c7a9c7a8c7aac7a3c7a4c7a5c7a6c7abd9dddae4dcb7e1a9e3a5e5b9e5bae5bdeda9",
   "Qian2",	"c7b0c7aec7b1c7acc7adc7afdda1dee7eaf9eed4f2aff3e9f7dc",
   "Qian3",	"c7b2c7b3c7b4e7d7ebc9",
   "Qian4",	"c7b7c7b5c7b6c7b8cfcbd9bbdccddce7e3bbe8fd",
   "Qiang1",	"bdabc7b9c7c0c7bac7bbc7bce3deeaa8efbaefcfefeaf2def5c4",
   "Qiang2",	"c7bfc7bdc7bee6cde9c9",
   "Qiang3",	"c7bfc7c0efeaf1dff4c7",
   "Qiang4",	"c7baeaa8ecc1f5c4",
   "Qiao1",	"c7c1c7c2c7c4c7c3c8b8d8e4e7d8edcdf5ce",
   "Qiao2",	"c7c5c7c8c7c7bdb6c7c6c7ccdadbdcf1e1bde3bee9d4f7b3",
   "Qiao3",	"c7c9c7c4c8b8e3b8",
   "Qiao4",	"bfc7c7cac7cbc7ccc7cdc7cec7cfdabddadb",
   "Qie1",	"c7d0",
   "Qie2",	"c7d1d9a4",
   "Qie3",	"c7d2",
   "Qie4",	"c7d0c6f6c7d3c7d4dba7e3abe3bbe6aaeafcefc6f3e6f4f2",
   "Qin1",	"c7d7c7d5c7d6f4c0",
   "Qin2",	"c7dac7d8c7d9c7dbc7dcc7dddccbe0bae0dfe2dbe4dae9d5efb7f1e6f1fbf2fb",
   "Qin3",	"c7de",
   "Qin4",	"c7dfdeecdfc4",
   "Qing1",	"c7e0c7e5c7e1c7e3c7e4c7e2e0f5f2dff6eb",
   "Qing2",	"c7e9c7e6c7e7c7e8e9d1f7f4",
   "Qing3",	"c7ebc7eadcdcf6a5",
   "Qing4",	"c7ecc7d7ede0f3c0f3e4f4ec",
   "Qiong2",	"c7eec7eddaf6dce4f1b7f2cbf3ccf5bcf6c6",
   "Qiu1",	"c7f1c7efb9eac7f0e4d0e9b1f2c7f6fa",
   "Qiu2",	"c7f3c7f2b3f0c7f4c7f5c7f6d9b4dbcfe1ece5cfe5d9eae4f2b0f2f8f4c3f7fc",
   "Qiu3",	"f4dc",
   "Qu1",	"c7f8c7fdc7f7c7fac7fcc7f9c7fbdab0e1abeaefeceef2d0f4f0f7f1",
   "Qu2",	"f1b3c7fedbbedea1debee1e9e8b3ebacebd4ede1f0b6f3bdf6c4",
   "Qu3",	"c8a1c7fac8a2c8a3dcc4",
   "Qu4",	"c8a5c8a4e3d6eaef",
   "Qu5",	"d0e7",
   "Quan1",	"c8a6e3aa",
   "Quan2",	"c8abc8a8c8aac8a7c8a9c8acc8addab9dcf5e9faeefdf2e9f3dcf7dc",
   "Quan3",	"c8aee7b9eeb0",
   "Quan4",	"c8afc8b0",
   "Que1",	"c8b1c8b2e3da",
   "Que2",	"c8b3",
   "Que4",	"c8b7c8b4c8b5c8b6c8b8e3d7e3daeda8",
   "Qun1",	"e5d2",
   "Qun2",	"c8bac8b9f7e5",
   "Ran2",	"c8bbc8bcf2c5f7d7",
   "Ran3",	"c8bec8bddcdb",
   "Rang1",	"c8c2",
   "Rang2",	"c8bfecfcf0a6",
   "Rang3",	"c8c0c8c1c8c2ecfc",
   "Rang4",	"c8c3",
   "Rao2",	"c8c4dce9e6ace8e3",
   "Rao3",	"c8c5c8c6e6ac",
   "Rao4",	"c8c6",
   "Re3",	"c8c7c8f4dff6",
   "Re4",	"c8c8",
   "Ren2",	"c8cbc8cec8cac8c9",
   "Ren3",	"c8ccdcf3effe",
   "Ren4",	"c8cec8cfc8cdc8d1c8d2c8d0d8f0ddd8e2bfe9edf1c5",
   "Reng1",	"c8d3",
   "Reng2",	"c8d4",
   "Ri4",	"c8d5",
   "Rong2",	"c8dac8ddc8d9c8dec8d6c8d7c8d8c8dbc8dce1c9e1f5e9c5ebc0f2ee",
   "Rong3",	"c8df",
   "Rou2",	"c8e1c8e0f4dbf5e5f7b7",
   "Rou4",	"c8e2",
   "Ru2",	"c8e7c8e3c8e4c8e5c8e6deb8e0e9e5a6efa8f1e0f2ac",
   "Ru3",	"c8e8c8e9c8ea",
   "Ru4",	"c8ebc8ecddeae4b2e4e1e7c8",
   "Ruan3",	"c8edc8eeebc3",
   "Rui2",	"dea8",
   "Rui3",	"c8ef",
   "Rui4",	"c8f0c8f1dcc7e8c4eea3f2b8",
   "Run4",	"c8f3c8f2",
   "Ruo4",	"c8f4c8f5d9bcf3e8",
   "Sa1",	"c8f6d8edeafd",
   "Sa3",	"c8f6c8f7",
   "Sa4",	"d8a6c8f8ebdbecaa",
   "Sai1",	"cbbcc8fbc8f9c8fae0e7",
   "Sai4",	"c8fcc8fb",
   "San1",	"c8fdc8feeba7",
   "San3",	"c9a2c9a1e2ccf4d6f6b1",
   "San4",	"c9a2",
   "Sang1",	"c9a5c9a3",
   "Sang3",	"c9a4defaeddff2aa",
   "Sang4",	"c9a5",
   "Sao1",	"c9a6c9a7e7d2e7d8ebfdf6fe",
   "Sao3",	"c9a8c9a9",
   "Sao4",	"c9a8c9d2dca3ebfdf0fe",
   "Se4",	"c9abc8fbc9aac9acd8c4efa4f0a3",
   "Sen1",	"c9ad",
   "Seng1",	"c9ae",
   "Sha1",	"c9b3c9b2c9b1c9afc9b0c9b4c9b7c9bceafdefa1f0f0f4c4f6e8",
   "Sha3",	"c9b5",
   "Sha4",	"c9b3cfc3c9b6c9b7dffee0c4eca6f6ae",
   "Shai1",	"c9b8f5a7",
   "Shai3",	"c9ab",
   "Shai4",	"c9b9",
   "Shan1",	"c9bdf4aec9bac9bbc9bcc9bec9bfc9c0c9c8d5a4dbefdccfe4fae6a9ebfeeeccf5c7f7d4",
   "Shan3",	"c9c1b2f4b5a7c9c2",
   "Shan4",	"b5a5c9c6b5a7c9bbc9c3c9c4c9c5c9c7c9c8c9c9d8dfdaa8dbb7e6d3e6f3ecf8eeccf0def3b5f7ad",
   "Shang1",	"c9ccc9cbccc0c9cae9e4ecd8f5fc",
   "Shang3",	"c9cfc9cdc9cedbf0",
   "Shang4",	"c9cfc9d0e7b4",
   "Shang5",	"c9d1",
   "Shao1",	"c9d4c9d5c7cac9d2c9d3f2d9f3e2f4b9",
   "Shao2",	"c9d6c9d7c9d8dce6e8bc",
   "Shao3",	"c9d9",
   "Shao4",	"c9d9c9d4c9dcd5d9c9dbc9d3c9dadbbfe4fb",
   "She1",	"c9ddc9dee2a6eeb4",
   "She2",	"d5dbc9e0c9dfd9dc",
   "She3",	"c9e1",
   "She4",	"c9e7c9e8c9e6c9e4c9e1c9e3c9e2c9e5d8c7e4dceca8f7ea",
   "Shei2",	"cbad",
   "Shen1",	"b2cec9edc9eac9eec9ecc9e9c9ebc9efc9f0dab7ddb7f4d6",
   "Shen2",	"cab2c9f1c9f5",
   "Shen3",	"c9f3c9f2c9f4dac5dfd3e4c9eff2",
   "Shen4",	"c9f5c9f7c9f6c9f8ddd8e9a9ebcff2d7",
   "Sheng1",	"c9fac9f9c9fdcaa4c9fcc9fbf3cf",
   "Sheng2",	"c9fee4c5",
   "Sheng3",	"caa1edf2",
   "Sheng4",	"caa2caa4caa5b3cbcaa3e1d3eac9",
   "Shi1",	"caa6caa7caa9caaccaa8caabcaaacaadd0eadde9f5a7f6f5",
   "Shi2",	"caaecab1cab5cab2cab6cab3caafcab0cab4dbf5ddaaecc2f6e5",
   "Shi3",	"cab9cabccab7cabbcab8cabaf5b9",
   "Shi4",	"cac7cac2cabfcad0cabecabdcacfcac0cad4cad3cacacac6cacdcad2cbc6cacbcac4cacecacccac1cac3cac5cac8cac9cad1d6c5dad6ddaadfb1e9f8eadbeee6f3a7f3c2f3df",
   "Shi5",	"d6b3b3d7",
   "Shou1",	"cad5",
   "Shou2",	"caec",
   "Shou3",	"cad6cad7cad8f4bc",
   "Shou4",	"cadccadacadbcad9cadecadde1f7e7b7",
   "Shu1",	"cae9cae4cae2cae6d9bfcae0cae8cae1cadfcae3cae5cae7ddc4def3e6ade7a3eba8ecaff1e2",
   "Shu2",	"caeccaeacaebdbd3eff8",
   "Shu3",	"cafdcaf4caf0caeecaedcaefcaf1caf2caf3",
   "Shu4",	"cafdcaf5caf6caf7caf8caf9cafacafbcafccafecba1d3e1d8ade3f0e4f8ebf2",
   "Shua1",	"cba2e0a7",
   "Shua3",	"cba3",
   "Shua4",	"cba2",
   "Shuai1",	"cba5cba4",
   "Shuai3",	"cba6",
   "Shuai4",	"c2cacba7f3b0",
   "Shuan1",	"cba8cba9e3c5",
   "Shuan4",	"e4cc",
   "Shuang1",	"cbabcbaae3f1e6d7",
   "Shuang3",	"cbac",
   "Shui2",	"cbad",
   "Shui3",	"cbae",
   "Shui4",	"cbb5cbb0cbaf",
   "Shun3",	"cbb1",
   "Shun4",	"cbb3cbb2cbb4",
   "Shuo1",	"cbb5",
   "Shuo4",	"cafdcbb6cbb7cbb8ddf4def7e5f9e9c3eee5",
   "Si1",	"cbbecbbdcbb9cbbccbbfcbbacbbbd8cbdbccdfd0e4f9e7c1efc8f0b8f2cf",
   "Si3",	"cbc0",
   "Si4",	"cbc4cab3cbc6e3f4cbc2cbc1cbc3cbc5cbc7cbc8d9b9d9eee3e1e6a6e6e1ecebf1eaf3d3",
   "Si5",	"b2de",
   "Song1",	"cbc9daa1ddbfe1c2e1d4e2ece4c1",
   "Song3",	"cbcacbcbe3a4f1b5",
   "Song4",	"cbcdcbcccbcecbcfcbd0",
   "Sou1",	"cbd2cbd1e0b2e2c8e4d1ecacefcbf2f4",
   "Sou3",	"cbd3dbc5deb4e0d5eea4",
   "Sou4",	"cbd3cbd4",
   "Su1",	"cbd5cbd6f6d5",
   "Su2",	"cbd7",
   "Su4",	"cbd9cbd8cbdfcbf5cbdecbdccbe0cbdacbdbcbddd9eddad5ddf8e0bce3bae4b3f3f9f6a2",
   "Suan1",	"cbe1e2a1",
   "Suan4",	"cbe3cbe2",
   "Sui1",	"cbe4c4f2ddb4e5a1edf5eea1",
   "Sui2",	"cbe6cbeccbe5cbe7",
   "Sui3",	"cbe8",
   "Sui4",	"cbeacbeccbe9cbebcbedcbeedac7e5e4ecdd",
   "Sun1",	"cbefdda5e1f8e2b8",
   "Sun3",	"cbf0cbf1e9bef6c0",
   "Suo1",	"cbf5c9afcbf4cbf2cbf3e0c2e0cae6b6e8f8eafdedfcf4c8",
   "Suo3",	"cbf9cbf7cbf8cbf6dfef",
   "Symbols",	"a1c0a1c1a1c2a1c3a1c4a1c5a1c6a1c7a1c8a1c9a1caa1cba1cca1cda1cea1cfa1d0a1d1a1d2a1d3a1d4a1d5a1d6a1d7a1d8a1d9a1daa1dba1dca1dda1dea1dfa1e0a1e1a1e2a1e3a1e4a1e5a1e6a1e7a1e8a1e9a1eaa1eba1eca1eda1eea1efa1f0a1f1a1f2a1f3a1f4a1f5a1f6a1f7a1f8a1f9a1faa1fba1fca1fda1fea2e5a2e6a2e7a2e8a2e9a2eaa2eba2eca2eda2eea8c5a8c6a8c7a8c8a8c9a8caa8cba8cca8cda8cea8cfa8d0a8d1a8d2a8d3a8d4a8d5a8d6a8d7a8d8a8d9a8daa8dba8dca8dda8dea8dfa8e0a8e1a8e2a8e3a8e4a8e5a8e6a8e7a8e8a8e9",
   "Ta1",	"cbfbcbfccbfdcca4cbfae4e2e5ddeee8f5c1",
   "Ta3",	"cbfecca1f7a3",
   "Ta4",	"cdd8cca4e9bdcca2cca3e3cbe4f0edb3e0aa",
   "Tai1",	"cca8cca5cca6",
   "Tai2",	"cca8cca6cca7dba2deb7e6e6ecc6f5ccf6d8",
   "Tai3",	"dfbe",
   "Tai4",	"ccabccaccca9ccaaccadebc4eed1",
   "Tan1",	"ccb0ccafccb2ccb1ccae",
   "Tan2",	"ccb8ccb3b5afccb7ccb4ccb5ccb6dbb0e5a3eabcefc4efe2f1fb",
   "Tan3",	"ccb9ccbaccbbecfeeee3",
   "Tan4",	"ccbdccbcccbeccbf",
   "Tang1",	"ccc0cccbefa6efdbf1edf4ca",
   "Tang2",	"ccc3ccc6ccc7ccc1ccc2ccc4ccc5e2bce4e7e8a9e9ccefdbf3a5f3abf5b1",
   "Tang3",	"ccc8ccc9cccad9cee0fb",
   "Tang4",	"cccbcccc",
   "Tao1",	"cccfcccdccceccd0dfb6e8baece2f7d2",
   "Tao2",	"ccd3ccd4ccd5ccd1ccd2d8bbdffbe4ac",
   "Tao3",	"ccd6",
   "Tao4",	"ccd7",
   "Te4",	"ccd8dfafecfdedabefab",
   "Tei1",	"dfaf",
   "Teng2",	"ccdaccd9ccdbccdcebf8",
   "Ti1",	"cce5ccddccdeccdfcce0",
   "Ti2",	"cce1cce2cce3cce4dce8e7b0e7bef0c3f5ae",
   "Ti3",	"cce5",
   "Ti4",	"cce6cce8cce7cce9cceaccebd9c3e3a9e5d1e7b0f1d3",
   "Tian1",	"cceccced",
   "Tian2",	"cceeccefb5e8ccf0ccf1e3d9eeb1eee4",
   "Tian3",	"ccf2ccf3e3c3e9e5",
   "Tian4",	"dedd",
   "Tiao1",	"ccf4d9acecf6",
   "Tiao2",	"b5f7ccf5ccf6dce6f2e8f3d4f6b6f6e6f7d8",
   "Tiao3",	"ccf4f1bb",
   "Tiao4",	"ccf7ccf8f4d0",
   "Tie1",	"ccf9ccfbddc6",
   "Tie3",	"ccfaccfb",
   "Tie4",	"ccfbf7d1",
   "Ting1",	"ccfdccfccda1ccfe",
   "Ting2",	"cda5cda3cda2cda4dcf0dde3e6c3f2d1f6aa",
   "Ting3",	"cda7cda6e8e8eeaeeefa",
   "Ting4",	"e8e8",
   "Tong1",	"cda8b6b2e0cc",
   "Tong2",	"cdaccdafcda9b6b1cdaacdabcdadcdaed9a1d9dadbeddcede1bce4fcedc5",
   "Tong3",	"cdb3cdb0b6b1cdb1cdb2",
   "Tong4",	"cdaccda8cdb4e2fa",
   "Tou1",	"cdb5",
   "Tou2",	"cdb6cdb7f7bb",
   "Tou3",	"eed7",
   "Tou4",	"cdb8",
   "Tu1",	"cdbbcdb9cdba",
   "Tu2",	"cdbecdbccdbdcdbfcdc0ddb1ddcbf5a9",
   "Tu3",	"cdc1cdc2eeca",
   "Tu4",	"cdc2cdc3dca2ddcb",
   "Tuan1",	"cdc4",
   "Tuan2",	"cdc5ded2",
   "Tuan3",	"eeb6",
   "Tuan4",	"e5e8",
   "Tui1",	"cdc6dfaf",
   "Tui2",	"cdc7",
   "Tui3",	"cdc8",
   "Tui4",	"cdcbcdc9cdcaecd5",
   "Tun1",	"cdccead5",
   "Tun2",	"b6dacdcdcdcee2bdebe0",
   "Tun3",	"d9db",
   "Tun4",	"cdca",
   "Tuo1",	"cdd0cdd1cdcfd8b1",
   "Tuo2",	"b6e6cdd2cdd3cdd4cdd5d9a2dbe7e3fbe8dee9d2edc8eee8f5a2f5c9f6be",
   "Tuo3",	"cdd7cdd6e2d5",
   "Tuo4",	"cdd8c6c7cdd9e8d8f3ea",
   "Wa1",	"cddbcddab0bccddccddde6b4",
   "Wa2",	"cdde",
   "Wa3",	"cddfd8f4",
   "Wa4",	"cddfcde0ebf0",
   "Wa5",	"cddb",
   "Wai1",	"cde1",
   "Wai3",	"e1cb",
   "Wai4",	"cde2",
   "Wan1",	"cde5cde3cde4d8e0f2ea",
   "Wan2",	"cdeacde6cde8cde7cde9dcb9e6fd",
   "Wan3",	"cdedcdeccdebc3e4cdeecdefcdf0cdf1ddb8ddd2e7bae7feebe4eeb5",
   "Wan4",	"cdf2c2fbcdf3",
   "Wang1",	"cdf4decc",
   "Wang2",	"cdf5cdf6cdfcc3a2",
   "Wang3",	"cdf9cdf8cdf7d8e8e3afe9fef7cd",
   "Wang4",	"cdfbcdf5cdf9cdfacdfccdfd",
   "Wei1",	"ceafcea3cdfecea2cea1ceaed9cbdaf1dddadeb1e1cbe5d4ecd0",
   "Wei2",	"ceaaceaccea7cea8cea9cea5cea4cea6ceabdbd7e0ede0f8e1a1e1cde3c7e3ede4b6",
   "Wei3",	"ceafcea8ceb0ceb2ceb1ceadceaeceb3dac3daf3e2abe4a2e6b8e7e2e8b8ecbff0f4f4baf6db",
   "Wei4",	"ceaacebbceb4cec0cebdceb6d2c5cebfceb5ceb7ceb8ceb9cebacebccebee2aceaa6",
   "Wen1",	"cec2cec1",
   "Wen2",	"cec4cec5cec3cec6e3d3e8b7f6a9",
   "Wen3",	"cec8cec7cec9d8d8",
   "Wen4",	"cecacec6e3ebe8b7",
   "Weng1",	"cecccecb",
   "Weng3",	"ddee",
   "Weng4",	"cecddeb3",
   "Wo1",	"e0b8e0de",
   "Wo2",	"c5b6",
   "Wo4",	"c5b6",
   "Wo1",	"cecececfced0ced1d9c1ddabe0b8",
   "Wo3",	"ced2",
   "Wo4",	"ced5e4d7ced3ced4ced6e1a2ebbfedd2f6bb",
   "Wu1",	"ceddcedbb6f1ced7d8a3ced8ced9cedacedcdaf9dbd8ecb6",
   "Wu2",	"cedecee2cdf6cee0cedfcee1cee3cee6dfede4b4f2daf7f9",
   "Wu3",	"cee5cee7cee4cee9cee8cee6ceead8f5e2d0e2e4e2e8e5c3e5fceaf5f0c4",
   "Wu4",	"cef1ceefcef0b6f1cef3ceebd8a3cef2cedaceecceedceeedae3dccce5bbe6c4e6f0e8bbecc9f0cdf0edf6c8",
   "Xi1",	"cef7cfa3cfa2cefccfa4cef6cefdcefecfa6c0b0cfa7cfa1c6dccef4cef5cef8cef9cefacefbcfa5cfa8cfa9cfaacfabd9d2d9e2dbaddce7ddbedec9dff1e4bbe4c0e9d8ead8eca4eca8ece4f0aaf1b6f2e1f3a3f3acf4b8f4cbf4d1f4e2f5b5f5e8f7fb",
   "Xi2",	"cfafcfb0cfaecfadcfb1daf4eaea",
   "Xi3",	"cfb2cfb4e1e3cfb3dddfddfbe5efe7f4ecfb",
   "Xi4",	"cfb5cfb8cfb7cfb6e2bee3d2ecf9f4aa",
   "Xia1",	"cfb9cfbadfc8",
   "Xia2",	"cfbfcfbbcfbccfbdcfbecfc0cfc1e1f2e5dae8a6e8d4edccf0fdf7ef",
   "Xia4",	"cfc2cfc3cfc4bba3cfc5f3c1",
   "Xian1",	"cfc9cfc8cfcacfc6cfc7cfcbddb2e5dfebafececf4ccf5a3f5d1",
   "Xian2",	"cfcdcfd3cfd0cfcccfcecfcfcfd1cfd2e6b5f0c2f0ef",
   "Xian3",	"cfd5cfd4cfb4cfcacfb3d9fedebae1fdecdef2b9f3daf5d0",
   "Xian4",	"cfd6cfdebcfbcfdfcfd7cfdccfddcfd8cfd9cfdacfdbdcc8e1adf6b1",
   "Xiang1",	"cfe0cfe3cfe4cfe7cfe1cfe2cfe5cfe6dcbce6f8e7bdddd9",
   "Xiang2",	"bdb5cfeacfe9cfe8e2d4",
   "Xiang3",	"cfeccfebcfede2c3f6dff7cf",
   "Xiang4",	"cfeecff2cfe0cff1cff3cfefcff0f3ad",
   "Xiao1",	"cffbcffacff4cffccff7cff5cff6cff8cff9d0a4dfd8e4ece5d0e6e7e7afe8c9e8d5f2d9f3eff7cc",
   "Xiao2",	"cffde1c5",
   "Xiao3",	"d0a1cffef3e3",
   "Xiao4",	"d0a3d0a7d0a6d0a2d0a4d0a5",
   "Xie1",	"d0a9d0a8d0aad0ab",
   "Xie2",	"d0add0b2d2b6d0b3d0afd9c9d0acd0aed0b0d0b1dbc4dfa2e7d3f2a1",
   "Xie3",	"d0b4d1aa",
   "Xie4",	"bde2d0bbd0b4d0b5d0b6c6f5d0b8d0b7d0b9d0bad0bcd9f4dbc6deafe2b3e2dde4cde5ace5e2e7a5e9bfe9c7f5f3",
   "Xin1",	"d0c2d0c4d0bdd0c0d0c1d0bed0bfd0c3dcb0eabfeca7f6ce",
   "Xin2",	"d1b0efe2",
   "Xin4",	"d0c5d0bed0c6d8b6",
   "Xing1",	"d0c7d0cbd0c8d0c9d0ca",
   "Xing2",	"d0d0d0ced0cdd0ccd0cfdaeadcfee2bcedca",
   "Xing3",	"caa1d0d1dfa9",
   "Xing4",	"d0d4d0cbd0d2d0d5d0d3dcf4e3ac",
   "Xiong1",	"d0d6d0d7d0d8d0d9d0dadcba",
   "Xiong2",	"d0dbd0dc",
   "Xiu1",	"d0ded0ddd0dfdfdde2cae2d3f0bcf5f7f7db",
   "Xiu3",	"cbded0e0",
   "Xiu4",	"d0e4cbded0e3b3f4d0e1d0e2d0e5e1b6e4e5",
   "Xu1",	"d0ebd0e8d3f5d0e9d0e6d0e7d0eadbd7e7efedb9edecf1e3",
   "Xu2",	"d0ec",
   "Xu3",	"d0eddabce4b0e8f2f4daf5af",
   "Xu4",	"d0f8d0eed0f2d0f6d0f7d0f0d0f3d0efd0f1d0f4d0f5dbc3e4aae4d3ece3",
   "Xu5",	"dea3",
   "Xuan1",	"d0fbd0f9d0fad9d8dacedde6deefead1ecd3",
   "Xuan2",	"d0fdd0fcd0fee4f6e8aff0e7",
   "Xuan3",	"d1a1d1a2",
   "Xuan4",	"c8afd0fdd1a3d1a4e3f9e4d6e9b8ecc5eddbeee7efe0",
   "Xue1",	"d1a6cff7d1a5",
   "Xue2",	"d1a7d1a8e0e5edb4f5bd",
   "Xue3",	"d1a9f7a8",
   "Xue4",	"d1aadaca",
   "Xun1",	"d1abbbe7d1acdbf7deb9e2b4ead6f1bff5b8",
   "Xun2",	"d1afd1b0d1b2d1add1aed1b1dba8dcf7e1bee2fee4ade4b1f6e0",
   "Xun4",	"d1b6d1b5d1b8d1b7bfa3d1acd1b3d1b4d9e3dea6e1df",
   "Ya1",	"d1b9d1c5d1bad1bbd1bdd1bcd1bed1c6dbebe8e2",
   "Ya2",	"d1bfd1c0d1c1d1c2d1c3d1c4d8f3e1ace7f0edfd",
   "Ya3",	"d1c5c6a5c7c6f0e9f1e2",
   "Ya4",	"d1c7d1b9e5c2d1c8d4fedeebe6abebb2edbc",
   "Ya5",	"d1bd",
   "Yan1",	"d1ccd2f3d1c9d1cad1cbd1cdd1e0dbb3ddcee1c3e2fbe3d5e4cee6ccebd9ebe7",
   "Yan2",	"d1d4d1d0d1cfd1d3d1d8d1d7d1d2d1d5c7a6d1ced1d1d1d6dae7dcbee3c6e5fbe9dcf3db",
   "Yan3",	"d1ddd1dbd1d9d1dad1dcd8c9d8dfd9b2d9c8d9f0dbb1e7fceebbf7caf7faf7fc",
   "Yan4",	"d1d0d1e9d1e7d1d8d1cad1ded1dfd1e0d1e1d1e2d1e3d1e4d1e5d1e6d1e8d8cddadde4d9eacceccdf5a6f7d0",
   "Yang1",	"d1ebd1ead1ecd1ede3f3f7b1",
   "Yang2",	"d1f3d1eed1efd1f4d1f0d1f1d1f2e1e0ecbeecc8f2d5",
   "Yang3",	"d1f8d1f6d1f5d1f7",
   "Yang4",	"d1f9eda6d1fae2f3ecc8f7b1",
   "Yao1",	"d2aad4bcd1fbd1fcd1fdd8b2dfbae7db",
   "Yao2",	"d2a4d2a6ccd5d2a1bdc4d1fed2a2d2a3d2a5d8b3e1e6e7f2e9f7ebc8efa2f4edf7a5",
   "Yao3",	"d2a7d2a8e1cae8c3f1ba",
   "Yao4",	"d2aad2abd2a9c5b1d4bfead7f0ce",
   "Ye1",	"d2aed2acd2add2b4",
   "Ye2",	"d2aed2afd0b0dedeeef4",
   "Ye3",	"d2b2d2b0d2b1",
   "Ye4",	"d2b5d2b9d2b6bba9d1cad2b3d2b4d2b7d2b8d2bad7a7d8ccdacbdafeeacaecc7",
   "Yi1",	"d2bbd2bdd2c0d2c2d2c1d2bcd2bed2bfd2cedfdee0e6e2a2e4f4eca5f7f0",
   "Yi2",	"d2cbd2c7d2c9d2c6d2c5c9dfd2c3d2c4d2c8d2cad2ccd2cddab1dbdddce8dfd7e1dae2c2e2f9e5c6eaddedf4f0ea",
   "Yi3",	"d2d4d2d1d2c2d2d2ceb2b6ead2ced2cfd2d0d2d3dcd3e5c6ecbdeec6f4aff4fd",
   "Yi4",	"d2e9d2e2d2d7d2dad2e6d2d5d2e0d2e5d2ebd2dbb0acd2c2d2ecd2ddd2e3d2d6d2edd2ead2dfd2e7d2d8d2d9d2dcd2ded2e1d2e4d2e8d8d7d8e6d8eed8fdd9abdbfcdcb2deb2dec4dec8dedadfaedfbde0c9e0e6e1bbe2f8e3a8e9ece9f3ecdaefd7efeef0f9f1aff1b4f2e6f4e8f4e0d2eee6e4e7cbd2ef",
   "Yin1",	"d2f2d2f4d1ccd2f5d2f3d2f1d2f0d2f6dca7e0b3e4a6e4ceebb3eef7",
   "Yin2",	"d2f8d2f7d2f9d2fadbb4dbdfdbf3e1fee2b9f6aff6b8",
   "Yin3",	"d2fdf1abd2fbd2f3d2fcd2fedfc5f2be",
   "Yin4",	"d3a1d2fbd2f1d8b7dce1f1bf",
   "Ying1",	"d3a6d3a2d3a4d3a3d3a5d3a7ddbadefce0d3e2dfe7f8e8acf0d0f3bf",
   "Ying2",	"d3aad3add3afd3aed3a8d3a9d3abd3acd9f8dce3dcfeddd3ddf6e4dee4ebe5ade9ba",
   "Ying3",	"d3b0d3b1dbabf1a8f2a3",
   "Ying4",	"d3a6d3b3d3b2ebf4",
   "Yo1",	"d3fdd3b4e0a1",
   "Yo5",	"d3b4",
   "Yong1",	"d3b5d3b6d3b7d3b8d3b9d3badbd5dcade3bce7dfefdef7abf7d3",
   "Yong2",	"e0af",
   "Yong3",	"d3c0d3c2d3bfd3bbd3bed3bcd3bdd3c1d9b8f0ae",
   "Yong4",	"d3c3d3b6",
   "You1",	"d3c5d3c7d3c4d3c6d8fcdfcf",
   "You2",	"d3c9d3ced3cdd3cad3c8d3cbd3ccddafddb5decce8d6e9e0f0e0f2c4f2f6f2f8f4edf6cf",
   "You3",	"d3d0d3d1d3cfd8d5ddacebbbeef0f7ee",
   "You4",	"d3d0d3d6d3d7d3d2d3d3d3d5d3d4d9a7e0f3e5b6e8d6f2caf7f8",
   "Yu1",	"d3f5d3d8d3d9e6faecb6f0f6",
   "Yu2",	"d3dad3ebd3e8d3e0d3e6d3e2d3e9d3e3d3e4d3def4a8d3dfd3dbd3dcd3ddd3e1d3e5d3e7d8aedac4ddc7deede1cee1fce2c5e6a5e8a4eaecebe9eca3f1bef2f5f3c4f4a7f6a7",
   "Yu3",	"d3ebd3efd3e8d3ead3eed3ecd3edd3f0d8f1d9b6e0f4e0f6e2d7f0f5f1c1f6b9",
   "Yu4",	"d3ebd3fdd3efd4a4d4a3d3f5d3f6d3f2d3ead3f1d3fed3fbb9c8d3fcdacdd3f9d3faceb5cebed3f3d3f4d3f7d3f8d4a1d4a2d4a5d4a6d6e0d8b9ddd2ddf7e2c0e3d0e5fdeac5eccfecd9ecdbedb2eedaf0c1f0d6f2e2e5f7",
   "Yuan1",	"d4a7d4a8d4a9edf3f0b0f3ee",
   "Yuan2",	"d4b1d4aad4add4b0d4b4d4b2d4aed4b5d4abd4acd4afd4b3dcabdcbee0f7e3e4e6c2e9daebbcf3a2f6bd",
   "Yuan3",	"d4b6",
   "Yuan4",	"d4bad4b8d4b9d4b7dbf9def2e6c2e8a5",
   "Yue1",	"d4bcd4bb",
   "Yue4",	"cbb5d4c2d4bdc0d6d4c4d4bed4bfd4c0d4c1d4c3d9dfe5aee8dde9d0ebbeeee1",
   "Yun1",	"d4ceebb5",
   "Yun2",	"d4b1d4c6d4c8d4c5d4c7dcbfe7a1eac0f3de",
   "Yun3",	"d4cad4c9e1f1e9e6",
   "Yun4",	"d4b1d4cbbef9d4cdd4ccd4ced4cfd4d0dba9e3a2e3b3e8b9ecd9",
   "Za1",	"d4d1d4faded9dfc6",
   "Za2",	"d4d3d4d2d4db",
   "Za3",	"d5a6",
   "Zai1",	"d4d4d4d6d4d5e7de",
   "Zai3",	"d4d8d4d7d7d0e1cc",
   "Zai4",	"d4dad4d9d4d8",
   "Zan1",	"f4a2f4d8",
   "Zan2",	"d4db",
   "Zan3",	"d4dcded9eac3f4f5",
   "Zan4",	"d4ded4dde8b6f6c9",
   "Zan5",	"d4db",
   "Zang1",	"d4dfd5e0eab0",
   "Zang3",	"e6e0",
   "Zang4",	"b2d8d4e0d4e1deca",
   "Zao1",	"d4e2d4e3",
   "Zao2",	"d4e4",
   "Zao3",	"d4e7d4e5d4e6d4e8d4e9e7d8",
   "Zao4",	"d4ecd4ead4ebd4edd4eed4efdff0",
   "Ze2",	"d4f2d4f0d4f1d4f3d5a6d8d3dff5e0fde5c5f3d0f3e5f4b7",
   "Ze4",	"b2e0d8c6eabe",
   "Zei2",	"d4f4",
   "Zen3",	"d4f5",
   "Zen4",	"dada",
   "Zeng1",	"d4f6d4f8d4f7e7d5eec0",
   "Zeng4",	"d4f9d7dbe7d5eab5efad",
   "Zha1",	"b2e9d4fcd4fad4fbd5a6deeadfb8dfeee9abf7fe",
   "Zha2",	"d5a8d4fad4fdd4fed5a1d5a2e0a9",
   "Zha3",	"d5a3edc4",
   "Zha4",	"d5a8c0afd5a4d5a5d5a6d5a7d5a9d7f5dfb8dfe5f0e4f2c6",
   "Zhai1",	"b2e0d5aad5ab",
   "Zhai2",	"d5acd4f1b5d4",
   "Zhai3",	"d5ad",
   "Zhai4",	"d5aebcc0d5afedcef1a9",
   "Zhan1",	"d5bcd5b4d5b0d5b1d5b2d5b3dadeecb9",
   "Zhan3",	"d5b9d5b5d5b6d5b7d5b8def8",
   "Zhan4",	"d5bcd5bed5bdb2fcd5bad5bbd5bfd5c0",
   "Zhang1",	"d5c5d5c2d5c4d5c1d5c3dbb5e2afe6d1e8b0f3af",
   "Zhang3",	"b3a4d5c7d5c6d8eb",
   "Zhang4",	"d5cdd5c7d5cfd5c9d5ccd5cbd5c8d5cad5cee1a4e1d6",
   "Zhao1",	"d7c5d5d0b3afd5d1b3b0dffaeec8",
   "Zhao2",	"d7c5",
   "Zhao3",	"d5d2d5d3d7a6",
   "Zhao4",	"d5d5d5d9d5d7d5d4d5d6d5d8daafe8fef3c9",
   "Zhe1",	"d5dbd5daf2d8",
   "Zhe2",	"d5dcd5dbd5ddd5dedad8dfa1e9fcedddf2d8",
   "Zhe3",	"d5dfd5e0f1def4f7",
   "Zhe4",	"d5e2d5e1d5e3e8cff0d1",
   "Zhe5",	"d7c5",
   "Zhei4",	"d5e2",
   "Zhen1",	"d5e6d5ebd5e4d5ecd5ead5e5d5e7d5e8d5e9dde8e4a5e4dae8e5e9a9e9bbebd3ecf5f3f0",
   "Zhen3",	"d5efe7c7d5edd5eee9f4eeb3f0a1",
   "Zhen4",	"d5f3d5f2d5f1d5f0dbdaeae2ebdef0b2",
   "Zheng1",	"d5fdd5f9b6a1d5f7d6a2d5f5d5f4d5f6d5f8d5fae1bfe1e7eedbefa3f3ddf6eb",
   "Zheng3",	"d5fbd5fc",
   "Zheng4",	"d5fed5fdd6a4d6a3d6a2d5f5d5fad6a1dabaefa3",
   "Zhi1",	"d6aed6bbd6b8d6a7d6aacacfd6afd6a5d6a6d6a8d6a9d6abd6acd6add6c0d8b4e8d9ebd5ecf3",
   "Zhi2",	"d6b8d6b5d6b0d6b4d6b1d6b2d6b3d6b6dbfadefdf4eaf5c5f5dc",
   "Zhi3",	"d6bbd6b8d6b9d6bdd6bcd6b7d6badcc6e1e7e5ebe8d7e9f2ecedede9f5a5",
   "Zhi4",	"d6c1d6c6d6c2d6aad6ced6cacab6d6bed6c7d6c3d6c9d6c8d6bfd6c0d6c4d6c5d6cbd6ccd6cdd6cfdaecdba4e0f9e2e5e5e9e6efe8cee8e4e9f9eadeebf9eff4f0baf0ebf2cef5d9f5f4f6a3",
   "Zhong1",	"d6d0d6d5d6d3d6d2d6d1d6d4e2eceff1f3aef4b1",
   "Zhong3",	"d6d6d6d7daa3f5e0",
   "Zhong4",	"d6d0d6d6d6d8d6dad6d9",
   "Zhou1",	"d6ded6dcd6ddd6dbd6dfd6e0dffa",
   "Zhou2",	"d6e1e6a8edd8",
   "Zhou3",	"d6e2d6e3",
   "Zhou4",	"d6e8d6e6d6e1d6e4d6e5d6e7dda7e6fbe7a7ebd0f4a6f4edf4fc",
   "Zhu1",	"d6eed6e9d6ecd6ead6ebd6edd6efd9aadba5dcefe4a8e4f3e9c6e9cdeef9",
   "Zhu2",	"caf5d6fed6f0d6f1d6f2f0f1f3c3f4b6f5ee",
   "Zhu3",	"d6f7caf4d6f3d6f4d6f5d6f6e4bef1d2f7e6",
   "Zhu4",	"d6fad7a2d7a1d6fed7a3d6f8d7a4d6f9d6fcd6fbd6fdd8f9dcd1e8ccecc4f0e6f3e7f4e3",
   "Zhua1",	"ceced7a5",
   "Zhua3",	"d7a6",
   "Zhuai1",	"d7a7",
   "Zhuai3",	"d7aa",
   "Zhuai4",	"d2b7d7a7e0dc",
   "Zhuan1",	"d7a8d7a9f2a7",
   "Zhuan3",	"d7aa",
   "Zhuan4",	"d7aab4abd7acd7abd7addff9e2cde3e7",
   "Zhuang1",	"d7b0d7afd7aed7b1",
   "Zhuang3",	"deca",
   "Zhuang4",	"d7b4d7b2d7b3b4b1d9d7edb0",
   "Zhui1",	"d7b7d7b5d7b6e6edf6bf",
   "Zhui4",	"d7b9d7b8d7bae3b7e7c4",
   "Zhun1",	"cdcdd7bbebc6f1b8",
   "Zhun3",	"d7bc",
   "Zhuo1",	"d7bfd7c0d7bdd7bed9bee4c3eccc",
   "Zhuo2",	"d7c5d6f8bdc9dfaad7c3d7c1d7c2d7c4d7c6d7c7dac2e4b7e5aaecfaedbdefed",
   "Zi1",	"d7cad7c9d7c8d7cbd6a8d7ccd7cdd7ced7d0dad1dfdae1d1e6dce7bbeaa2eadfefc5f4d2f4f4f5fef6a4f6b7f6f6f7da",
   "Zi3",	"d7d3d7cfd7d0d7d1d7d2dcebe6a2e8f7eff6f1e8f3caf6a4",
   "Zi4",	"d7d4d7d6d7d5eda7edf6",
   "Zong1",	"d7dad7d9d7dbd7d7d7d8e8c8ebea",
   "Zong3",	"d7dcd9cc",
   "Zong4",	"d7ddf4d5",
   "Zou1",	"d7dedac1daeedbb8e6e3f6ed",
   "Zou3",	"d7df",
   "Zou4",	"d7e0d7e1",
   "Zu1",	"d7e2ddcf",
   "Zu2",	"d7e3d7e5d7e4efdf",
   "Zu3",	"d7e9d7e6d7e8d7e7d9de",
   "Zuan1",	"d7eaf5f2",
   "Zuan3",	"d7ebe7da",
   "Zuan4",	"d7acd7eadfac",
   "Zui1",	"b6d1",
   "Zui3",	"bed7d7ecf5fe",
   "Zui4",	"d7eed7efd7eddea9",
   "Zun1",	"d7f0d7f1e9d7f7ae",
   "Zun3",	"dfa4",
   "Zuo1",	"d7f7e0dc",
   "Zuo2",	"d7f7d7f2d7c1f3d0",
   "Zuo3",	"d7f3d7f4b4e9",
   "Zuo4",	"d7f7d7f6d7f9d7f8d4e4d7f5f5a1dff2ebd1e2f4ecf1dae8",
   NULL
};

#endif /* ~_NO_TGTWB5 */
