/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2009, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/auxtext.e,v 1.5 2009/01/09 22:25:29 william Exp $
 */

#ifndef _AUXTEXT_E_
#define _AUXTEXT_E_

extern GC	rotateGC;
extern Pixmap	textBackingBitmap;
extern Pixmap	textBackingBgBitmap;
extern Pixmap	textBackingPixmap;
extern int	textBackingBitmapW;
extern int	textBackingBitmapH;
extern int	doubleQuoteDoubleQuote;
extern int	groupedTextEditable;

extern struct SelRec	* outerSel, * innerSel;

#ifdef _INCLUDE_FROM_AUXTEXT_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_AUXTEXT_C_*/

extern void	GetStrSizeInfo ARGS_DECL((struct DynStrRec *, int *w,
		                          int *lbearing, int *rbearing));
extern int	GetNumberOfMiniLines ARGS_DECL((MiniLinesInfo*));
extern int	IsHex ARGS_DECL((char, int*));
extern int	InputOctalString ARGS_DECL((char *pszBuf, int *pnBufSize));
extern int	CharIsCntrlINS ARGS_DECL((XKeyEvent*, KeySym));
extern int	CharIsShiftINS ARGS_DECL((XKeyEvent*, KeySym));
extern int	CharIsCntrlShiftINS ARGS_DECL((XKeyEvent*, KeySym));
extern int	CharIsESC ARGS_DECL((XKeyEvent*, char*, KeySym, int *pnHasCh));
extern int	CharIsCRorLF ARGS_DECL((XKeyEvent*, char*, KeySym,
		                        int *pnHasCh));
extern int	CharIsDEL ARGS_DECL((XKeyEvent*, char*, KeySym, int *pnHasCh));
extern int	CharIsBS ARGS_DECL((XKeyEvent*, char*, KeySym, int *pnHasCh,
                                    int LeftIsBS));
extern int	CharIsBSorDEL ARGS_DECL((XKeyEvent*, char*, KeySym,
		                         int *pnHasCh, int LeftIsBS));
extern int	CharIsTAB ARGS_DECL((XKeyEvent*, char*, KeySym, int *pnHasCh));
extern int	CharIsHome ARGS_DECL((XKeyEvent*, char*, KeySym, int *pnHasCh));
extern int	CharIsEnd ARGS_DECL((XKeyEvent*, char*, KeySym, int *pnHasCh));
extern int	CharIsCntrlSpace ARGS_DECL((XKeyEvent*, char*, KeySym,
		                            int *pnHasCh));
extern void	TranslateKeys ARGS_DECL((char *, KeySym *));
extern void	SetTextOBBox ARGS_DECL((struct ObjRec *, int Just,
		                        int W, int H, int LBearing,
		                        int RightExtra, int Rotate));
extern void	SetTextBBox ARGS_DECL((struct ObjRec *, int Just,
		                       int W, int H, int LBearing,
		                       int RightExtra, int Rotate));
extern void	SetTextOrigBBoxes ARGS_DECL((struct ObjRec *, int Just,
		                             int W, int H, int LBearing,
		                             int RightExtra, int Rotate));
extern int	UpdTextBBox ARGS_DECL((struct ObjRec *));
extern int	PixelOnOff ARGS_DECL((XImage *, int Col, int Row, int Scale));
extern void	MakeCachedTextBitmap ARGS_DECL((struct ObjRec *));
extern void	CleanOuterInnerSel ARGS_DECL((void));
extern void	UpdateOuterInnerSel ARGS_DECL((struct ObjRec *));
extern struct ObjRec	* FindTextObj ARGS_DECL((int XOff, int YOff,
			                         struct ObjRec *ObjToBeFound));
extern void	UnlinkCurTextFromInnerSel ARGS_DECL((void));
extern void	AdjAncestorsBBox ARGS_DECL((void));
extern void	DumpTextObj ARGS_DECL((FILE *, struct ObjRec *));
extern int	NeedToCacheMiniLines ARGS_DECL((MiniLinesInfo*));
extern int	NeedsToCacheTextObj ARGS_DECL((struct ObjRec *));
extern void	SaveString ARGS_DECL((FILE *, char *));
extern void	SaveDoubleByteString ARGS_DECL((FILE *, char *));
extern void	SaveMiniLines ARGS_DECL((FILE*, MiniLinesInfo*));
extern void	SaveTextObj ARGS_DECL((FILE *, struct ObjRec *));
extern void	SaveHexString ARGS_DECL((FILE *, char *));
extern char	* ReadString ARGS_DECL((char *));
extern StrSegInfo	* CreateStrSegFromString ARGS_DECL((char*,
			                                    StrBlockInfo*));
extern StrBlockInfo	* CreateStrBlockFromString ARGS_DECL((char*,
			                                      MiniLineInfo*));
extern MiniLineInfo	* CreateMiniLineFromString ARGS_DECL((char*,
			                                      MiniLineInfo**,
			                                      MiniLineInfo**));
extern struct ObjRec	* FormTextObjectFromFile ARGS_DECL((FILE *, int AbsX,
			                                    int AbsBaselineY));
extern void	RepaintFirstStr ARGS_DECL((struct ObjRec *, char *));

#ifdef _INCLUDE_FROM_AUXTEXT_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_AUXTEXT_C_*/

#endif /*_AUXTEXT_E_*/
