/*
	Copyright (C) 1995	Edward Der-Hua Liu, Hsin-Chu, Taiwan
*/

#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include "protocol.h"

char *strcat(char *dest, const char *src);

static void p_err(char *fmt,...)
{
  va_list args;
  
  va_start(args, fmt);
  fprintf(stderr,"%s:", "clisock.c");
  vfprintf(stderr, fmt, args);
  va_end(args);
  fprintf(stderr,"\n");
  exit(-1);
} 


#define BSIZE (64*1024)
static u_char *bf;
int ofs;
static FILE *fw;

void init_f(char *file)
{
char fname[100];
if (!(bf=malloc(BSIZE))) {
		puts("malloc err");
}
strcpy(fname, file);
strcat(fname, ".out");
if ((fw=fopen(fname,"w"))==NULL) {
	p_err("Cannot create %s", fname);
}
ofs=4;  /* reserved for header */ 
}

void upload_keyword(KeySym kk, char *str)
{
	memcpy(bf+ofs, &kk, 4);
	ofs+=4;
	if (kk) {
		int len=strlen(str);
		strcpy(bf+ofs, str);
		ofs+=len+1;
	}
	if (ofs>BSIZE) puts("ph file size too large > 64K");
}

void write_phr()
{
*(int *)bf=ofs;
fwrite(bf,1,ofs,fw);
fclose(fw);
}
