package App::Manoc::CatalystRole::ObjectURL;
#ABSTRACT: Catalyst plugin for Manoc CSRF support

use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION
use namespace::autoclean;
with 'Catalyst::ClassData';

use Scalar::Util qw(blessed);

__PACKAGE__->mk_classdata( '_manoc_object_action' => {} );

__PACKAGE__->mk_classdata( '_manoc_api_object_action' => {} );


sub setup_finalize {
    my $app = shift;
    $app->next::method(@_);

    foreach my $name ( $app->controllers ) {
        my $controller = $app->controller($name);
        if ( $controller->can('class') && $controller->can('view') ) {
            my $class = $controller->class;
            $class =~ /^ManocDB::(.*)$/ or next;
            my $rs = $1;
            my $ns = $controller->action_namespace();

            if ( $controller->isa('App::Manoc::ControllerBase::APIv1') ) {
                # $app->debug and $app->log->debug("Registered API $ns/view for rs $rs");
                $app->_manoc_api_object_action->{$rs} = "$ns/view";
            }
            else {
                # $app->debug and $app->log->debug("Registered $ns/view for rs $rs");
                $app->_manoc_object_action->{$rs} = "$ns/view";
            }

        }
    }
}


sub manoc_uri_for_object {
    my ( $c, $obj, @args ) = @_;

    blessed($obj) or return;

    my $is_api = $c->stash->{is_api} || 0;

    if ( $obj->isa("App::Manoc::IPAddress::IPv4") ) {
        return $c->uri_for_action( 'ipaddress/view', [ $obj->address ] );
    }

    if ( $obj->can('result_source') ) {
        my $name = $obj->result_source->source_name;
        $c->log->debug("Lookup action for source $name (is_api=$is_api)");
        my $action =
            $is_api ? $c->_manoc_api_object_action->{$name} :
            $c->_manoc_object_action->{$name};
        $action and
            return $c->uri_for_action( $action, [ $obj->id ], @args );
    }
}

no Moose;
__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::CatalystRole::ObjectURL - Catalyst plugin for Manoc CSRF support

=head1 VERSION

version 2.99.4

=head1 METHODS

=head2 setup_finalize

Register to Catalyst setup_finalize in order to scan all registered controllers
for controller->resultset mapping.

=head2 manoc_uri_for_object( $c, $obj, @args )

Finds (if any) the controller which has the view action for obj and call
uri_for_action( "controller/view", [$obj->id], @args)

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
