package Shipment::FedEx::WSDL::TrackTypes::TrackServiceDescriptionDetail;
$Shipment::FedEx::WSDL::TrackTypes::TrackServiceDescriptionDetail::VERSION = '3.01';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://fedex.com/ws/track/v9'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %Type_of : ATTR(:get<Type>);
    my %Description_of : ATTR(:get<Description>);
    my %ShortDescription_of : ATTR(:get<ShortDescription>);

    __PACKAGE__->_factory(
        [   qw(        Type
              Description
              ShortDescription

              )
        ],
        {   'Type'             => \%Type_of,
            'Description'      => \%Description_of,
            'ShortDescription' => \%ShortDescription_of,
        },
        {   'Type'        => 'Shipment::FedEx::WSDL::TrackTypes::ServiceType',
            'Description' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'ShortDescription' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        },
        {

            'Type'             => 'Type',
            'Description'      => 'Description',
            'ShortDescription' => 'ShortDescription',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackServiceDescriptionDetail

=head1 VERSION

version 3.01

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TrackServiceDescriptionDetail from the namespace http://fedex.com/ws/track/v9.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Type

=item * Description

=item * ShortDescription

=back

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackServiceDescriptionDetail

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::TrackTypes::TrackServiceDescriptionDetail
   Type => $some_value, # ServiceType
   Description =>  $some_value, # string
   ShortDescription =>  $some_value, # string
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
