/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of Cabinet.xs. Do not edit this file, edit Cabinet.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "Cabinet.xs"
/*
 * Filename: Cabinet.xs
 * Author  : Brad Douglas, <rez@touchofmadness.com>
 * Created : 10 April 2005
 * Version : 1.00
 *
 *   Copyright (c) 2005 Brad Douglas. All rights reserved.
 *   This program is free software; you can redistribute it and/or
 *   modify it under the same terms as Perl itself.
 *
 *
 * Partially plundered from libmspack out of sheer laziness.
 *
 */

#define _GNU_SOURCE 1

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <utime.h>

#include <sys/types.h>
#include <sys/stat.h>

#include "mspack.h"


/***** PROTOTYPES *****/

typedef struct mscab_decompressor *Archive__Cabinet__decomp;
typedef struct mscabd_cabinet     *Archive__Cabinet__cab;
typedef struct mscabd_folder      *Archive__Cabinet__folder;
typedef struct mscabd_file        *Archive__Cabinet__file;

typedef struct cabType {
    Archive__Cabinet__decomp cabd;
    Archive__Cabinet__cab cab;
    int isunix;
    bool closed;
} cabType;
typedef struct cabType *Archive__Cabinet__cabFile;

/* Internal functions */
static void SetCabError(struct cabType *f);
static int arch_size(void);
static int unix_path_seperators(struct mscabd_file *f);
static char *create_output_name(unsigned char *fname, int isunix, int utf8);
static int ensure_filepath(char *pth);


/***** GLOBAL DATA *****/

#define CABERRNO    "Archive::Cabinet::caberrno"

#define STREQ(a, b)         (strcmp(a, b) == 0)
#define ZMALLOC(to, typ)    ((to = (typ *)safemalloc(sizeof(typ))), Zero(to,1,typ))

/* Error strings */
static char *my_cab_errmsg[] = {
    "",                           /* ERR_OK         (0) */
    "bad argument(s)",            /* ERR_ARGS       (1) */
    "open file error",            /* ERR_OPEN       (2) */
    "read file error",            /* ERR_READ       (3) */
    "write file error",           /* ERR_WRITE      (4) */
    "file seek error",            /* ERR_SEEK       (5) */
    "insufficient memory",        /* ERR_NOMEMORY   (6) */
    "invalid file signature",     /* ERR_SIGNATURE  (7) */
    "bad or corrupt file format", /* ERR_DATAFORMAT (8) */
    "bad checksum",               /* ERR_CHECKSUM   (9) */
    "compression error",          /* ERR_CRUNCH    (10) */
    "decompression error",        /* ERR_DECRUNCH  (11) */
    ""
};


/* Internal Functions */
static void
SetCabError(struct cabType *f)
{
    Archive__Cabinet__decomp cabd = f->cabd;
    SV *caberror_sv = perl_get_sv(CABERRNO, FALSE);
    int error_no;

    error_no = cabd->last_error(cabd);

    if (SvIV(caberror_sv) != error_no) {
        sv_setiv(caberror_sv, error_no);
        sv_setpv(caberror_sv, my_cab_errmsg[error_no]);
        SvIOK_on(caberror_sv);
    }
}


static int
arch_size(void)
{
    return (sizeof(off_t) == 4) ? 64 : 32;
}


static int unix_path_seperators(struct mscabd_file *f)
{
    struct mscabd_file *fi;
    char slash = 0;
    char backslash = 0;
    char *oldname;
    int oldlen;

    for (fi = f; fi; fi = fi->next) {
        char *p;

        for (p = fi->filename; *p; p++) {
            if (*p == '/')  slash     = 1;
            if (*p == '\\') backslash = 1;
        }

        if (slash && backslash)
            break;
    }

    if (slash) {
        /* slashes, but no backslashes = UNIX */
        if (!backslash)
            return 1;
    } else {
        /* no slashes = MS-DOS */
        return 0;
    }

    /* special case if there's only one file - just take the first slash */
    if (!f->next) {
        char c, *p = fi->filename;

        while ((c = *p++)) {
            if (c == '\\') return 0; /* backslash = MS-DOS */
            if (c == '/')  return 1; /* slash = UNIX */
        }

        /* should not happen - at least one slash was found! */
        return 0;
    }

    oldname = NULL;
    oldlen = 0;
    for (fi = f; fi; fi = fi->next) {
        char *name = fi->filename;
        int len = 0;

        while (name[len]) {
            if ((name[len] == '\\') || (name[len] == '/'))
                break;

            len++;
        }

        len = (!name[len]) ? 0 : len + 1;

        if (len && (len == oldlen))
            if (strncmp(name, oldname, (size_t)len) == 0)
                return (name[len-1] == '\\') ? 0 : 1;

        oldname = name;
        oldlen = len;
    }

    /* default */
    return 0;
}


static char *create_output_name(unsigned char *fname, int isunix, int utf8)
{
    unsigned char *p, *name, c, *fe, sep, slash;
    unsigned int x;

    sep   = (isunix) ? '/'  : '\\'; /* the path-seperator */
    slash = (isunix) ? '\\' : '/';  /* the other slash */

    /* length of filename */
    x = strlen((char *)fname);

    /* UTF8 worst case scenario: tolower() expands all chars from 1 to 3 bytes */
    if (utf8) x *= 3;

    if (!(name = malloc(x + 2))) {
        fprintf(stderr, "Can't allocate output filename (%u bytes)\n", x + 2);

        return NULL;
    }
  
    /* start with blank name */
    *name = '\0';

    /* remove leading slashes */
    while (*fname == sep)
        fname++;

    /* copy from fi->filename to new name, converting MS-DOS slashes to UNIX
     * slashes as we go. Also lowercases characters if needed. */
    p  = &name[strlen((char *)name)];
    fe = &fname[strlen((char *)fname)];

    if (utf8) {
        /* UTF8 translates two-byte unicode characters into 1, 2 or 3 bytes.
         * %000000000xxxxxxx -> %0xxxxxxx
         * %00000xxxxxyyyyyy -> %110xxxxx %10yyyyyy
         * %xxxxyyyyyyzzzzzz -> %1110xxxx %10yyyyyy %10zzzzzz
         *
         * Therefore, the inverse is as follows:
         * First char:
         *  0x00 - 0x7F = one byte char
         *  0x80 - 0xBF = invalid
         *  0xC0 - 0xDF = 2 byte char (next char only 0x80-0xBF is valid)
         *  0xE0 - 0xEF = 3 byte char (next 2 chars only 0x80-0xBF is valid)
         *  0xF0 - 0xFF = invalid */
        do {
            if (fname >= fe) {
                fprintf(stderr, "error in UTF-8 decode\n");
                free(name);

                return NULL;	
            }

            /* get next UTF8 char */
            if ((c = *fname++) < 0x80)
                x = c;
            else {
                if ((c >= 0xC0) && (c < 0xE0)) {
                    x  = (c & 0x1F) << 6;
                    x |= *fname++ & 0x3F;
                } else if ((c >= 0xE0) && (c < 0xF0)) {
                    x  = (c & 0xF) << 12;
                    x |= (*fname++ & 0x3F) << 6;
                    x |= *fname++ & 0x3F;
                } else x = '?';
            }

            /* whatever is the path seperator -> '/'
             * whatever is the other slash    -> '\\'
             * otherwise, if lower is set, the lowercase version */
            if      (x == sep)   x = '/';
            else if (x == slash) x = '\\';

            /* integer back to UTF8 */
            if (x < 0x80) {
                *p++ = (unsigned char)x;
            } else if (x < 0x800) {
                *p++ = 0xC0 | (x >> 6);   
                *p++ = 0x80 | (x & 0x3F);
            } else {
                *p++ = 0xE0 | (x >> 12);
                *p++ = 0x80 | ((x >> 6) & 0x3F);
                *p++ = 0x80 | (x & 0x3F);
            }
        } while (x);
    } else {
        /* regular non-utf8 version */
        do {
            c = *fname++;

            if      (c == sep)   c = '/';
            else if (c == slash) c = '\\';
        } while ((*p++ = c));
    }

    /* search for "../" in cab filename part and change to "xx/".  This
     * prevents any unintended directory traversal. */
    for (p = &name[0]; *p; p++) {
        if ((p[0] == '.') && (p[1] == '.') && (p[2] == '/')) {
            p[0] = p[1] = 'x';
            p += 2;
        }
    }

    return (char *)name;
}


static int ensure_filepath(char *pth)
{
    struct stat st_buf;
    mode_t user_umask = umask(0);
    char *p;
    int ok;

    for (p = &pth[1]; *p; p++)
    {
        if (*p != '/')
            continue;

        *p = '\0';
        ok = (stat(pth, &st_buf) == 0) && S_ISDIR(st_buf.st_mode);

        if (!ok)
            ok = (mkdir(pth, 0777 & ~user_umask) == 0);
        *p = '/';

        if (!ok)
            return 0;
    }

    return 1;
}


/***** PerlXS Section *****/

#line 328 "Cabinet.c"
XS(XS_Archive__Cabinet_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_Archive__Cabinet_new)
{
    dXSARGS;
    if (items < 1 || items > 2)
	Perl_croak(aTHX_ "Usage: Archive::Cabinet::new(Class, filename=NULL)");
    {
	Archive__Cabinet__cabFile	RETVAL;
	char *	filename;

	if (items < 2)
	    filename = NULL;
	else {
	    filename = (char *)SvPV_nolen(ST(1));
	}
#line 344 "Cabinet.xs"
    {
        Archive__Cabinet__cabFile f = NULL;

        /* If name specified, validate */
        if (filename) {
            struct stat buf;

            if (stat(filename, &buf))
                XSRETURN_UNDEF;
        }

        ZMALLOC(f, cabType);
        if (!f)
            XSRETURN_UNDEF;

        /* Start with closed file */
        f->closed = TRUE;
        f->cab = NULL;

        /* Initialize engine */
        if (f->cabd == NULL) {
            f->cabd = mspack_create_cab_decompressor(NULL);
            if (f->cabd == NULL) {
                safefree(f);
                XSRETURN_UNDEF;
            }
        }

        /* Open the cabinet if exists */
        if (filename) {
            Archive__Cabinet__decomp cabd = f->cabd;
            Archive__Cabinet__cab    cab  = NULL;

            cab = cabd->search(cabd, filename);
            if (cabd->last_error(cabd)) {
                SetCabError(f);
                safefree(f);
                XSRETURN_UNDEF;
            }

            f->cab = cab;
            f->closed = FALSE;
            f->isunix = unix_path_seperators(cab->files);
        }

        RETVAL = f;
    }
#line 392 "Cabinet.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "Archive::Cabinet::cabFile", (void*)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Archive__Cabinet_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_Archive__Cabinet_DESTROY)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Archive::Cabinet::DESTROY(f)");
    {
	Archive__Cabinet__cabFile	f;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    f = INT2PTR(Archive__Cabinet__cabFile,tmp);
	}
	else
	    Perl_croak(aTHX_ "f is not a reference");
#line 398 "Cabinet.xs"
    {
        Archive__Cabinet__decomp cabd = f->cabd;

        if (!f->closed)
            cabd->close(cabd, f->cab);

        mspack_destroy_cab_decompressor(cabd);
        safefree(f);
    }
#line 424 "Cabinet.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Archive__Cabinet__cabFile_open); /* prototype to pass -Wmissing-prototypes */
XS(XS_Archive__Cabinet__cabFile_open)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Archive::Cabinet::cabFile::open(f, name)");
    {
	Archive__Cabinet__cabFile	RETVAL;
	Archive__Cabinet__cabFile	f;
	char *	name = (char *)SvPV_nolen(ST(1));

	if (sv_derived_from(ST(0), "Archive::Cabinet::cabFile")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    f = INT2PTR(Archive__Cabinet__cabFile,tmp);
	}
	else
	    Perl_croak(aTHX_ "f is not of type Archive::Cabinet::cabFile");
#line 414 "Cabinet.xs"
    {
        Archive__Cabinet__decomp cabd = f->cabd;
        Archive__Cabinet__cab cab = NULL;

        if (!name)
            XSRETURN_UNDEF;

        /* Already open? */
        if (!f->closed) {
            warn("This archive has already been opened!\n");
            XSRETURN_UNDEF;
        }

        cab = cabd->search(cabd, name);
        f->cab = cab;
        f->closed = FALSE;
        f->isunix = unix_path_seperators(cab->files);

        RETVAL = f;
    }
#line 467 "Cabinet.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "Archive::Cabinet::cabFile", (void*)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Archive__Cabinet__cabFile_list_files); /* prototype to pass -Wmissing-prototypes */
XS(XS_Archive__Cabinet__cabFile_list_files)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Archive::Cabinet::cabFile::list_files(f)");
    {
	AV *	RETVAL;
	Archive__Cabinet__cabFile	f;

	if (sv_derived_from(ST(0), "Archive::Cabinet::cabFile")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    f = INT2PTR(Archive__Cabinet__cabFile,tmp);
	}
	else
	    Perl_croak(aTHX_ "f is not of type Archive::Cabinet::cabFile");
#line 441 "Cabinet.xs"
        AV *list;
        list = (AV *)sv_2mortal((SV *)newAV());
#line 493 "Cabinet.c"
#line 444 "Cabinet.xs"
    {
        Archive__Cabinet__file file;

        /* Exit if not opened */
        if (f->closed)
            XSRETURN_EMPTY;

        for (file = f->cab->files; file; file = file->next) {
            char *name;

            name = create_output_name((unsigned char *)file->filename,
                f->isunix, file->attribs & MSCAB_ATTRIB_UTF_NAME);

            av_push(list, newSVpvn(name, strlen(name)));
            safefree(name);
        }

        RETVAL = list;
    }
#line 514 "Cabinet.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_Archive__Cabinet__cabFile_extract); /* prototype to pass -Wmissing-prototypes */
XS(XS_Archive__Cabinet__cabFile_extract)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Archive::Cabinet::cabFile::extract(f, filename)");
    {
	SV *	RETVAL;
	Archive__Cabinet__cabFile	f;
	char *	filename = (char *)SvPV_nolen(ST(1));

	if (sv_derived_from(ST(0), "Archive::Cabinet::cabFile")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    f = INT2PTR(Archive__Cabinet__cabFile,tmp);
	}
	else
	    Perl_croak(aTHX_ "f is not of type Archive::Cabinet::cabFile");
#line 470 "Cabinet.xs"
    {
        Archive__Cabinet__decomp cabd = f->cabd;
        Archive__Cabinet__file file = f->cab->files;

        int found = 0;

        /* Exit if not opened */
        if (f->closed)
            XSRETURN_UNDEF;

        /* Find the file we're looking for */
        for (file; file; file = file->next) {
            /* This can probably be done much easier, but I'm lazy (still) */
            if (STREQ(file->filename, filename)) {
                found = 1;
                char *tmpf = tempnam(NULL, NULL);
                struct stat stat;
                int fd;
                void *ptr;
                SV *buf;

                /* Extract to temp file */
                cabd->extract(cabd, file, tmpf);

                /* Get file size and allocate memory */
                fd = open(tmpf, O_RDONLY);
                fstat(fd, &stat);
                ptr = safemalloc(stat.st_size);

                read(fd, ptr, stat.st_size);
                close(fd);

                /* Make new scalar with contents of ptr */
                buf = newSVpv(ptr, strlen(ptr));
                safefree(ptr);
                safefree(tmpf);

                /* Remove the temp file */
                unlink(tmpf);

                RETVAL = buf;
            }
        }
        if ( !found )
          RETVAL = &PL_sv_undef;
    }
#line 585 "Cabinet.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_Archive__Cabinet__cabFile_extract_to_file); /* prototype to pass -Wmissing-prototypes */
XS(XS_Archive__Cabinet__cabFile_extract_to_file)
{
    dXSARGS;
    if (items < 2 || items > 3)
	Perl_croak(aTHX_ "Usage: Archive::Cabinet::cabFile::extract_to_file(f, filename, dest=NULL)");
    {
	int	RETVAL;
	dXSTARG;
	Archive__Cabinet__cabFile	f;
	char *	filename = (char *)SvPV_nolen(ST(1));
	char *	dest;

	if (sv_derived_from(ST(0), "Archive::Cabinet::cabFile")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    f = INT2PTR(Archive__Cabinet__cabFile,tmp);
	}
	else
	    Perl_croak(aTHX_ "f is not of type Archive::Cabinet::cabFile");

	if (items < 3)
	    dest = NULL;
	else {
	    dest = (char *)SvPV_nolen(ST(2));
	}
#line 522 "Cabinet.xs"
    {
        Archive__Cabinet__decomp cabd = f->cabd;
        Archive__Cabinet__file file = f->cab->files;

        /* Exit if not opened */
        if (f->closed || !filename)
            XSRETURN_IV(0);

        /* Find the file we're looking for */
        for (file; file; file = file->next) {
            if (STREQ(file->filename, filename)) {
                int err;

                /* Extract a single file to dest */
                cabd->extract(cabd, file, dest);
                err = cabd->last_error(cabd);
                if (err) {
                    SetCabError(f);
                    XSRETURN_IV(0);
                }

                break;
            }
        }

        RETVAL = 1;
    }
#line 645 "Cabinet.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Archive__Cabinet__cabFile_extract_all); /* prototype to pass -Wmissing-prototypes */
XS(XS_Archive__Cabinet__cabFile_extract_all)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Archive::Cabinet::cabFile::extract_all(f)");
    {
	int	RETVAL;
	dXSTARG;
	Archive__Cabinet__cabFile	f;

	if (sv_derived_from(ST(0), "Archive::Cabinet::cabFile")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    f = INT2PTR(Archive__Cabinet__cabFile,tmp);
	}
	else
	    Perl_croak(aTHX_ "f is not of type Archive::Cabinet::cabFile");
#line 556 "Cabinet.xs"
    {
        Archive__Cabinet__decomp cabd = f->cabd;
        Archive__Cabinet__file file = f->cab->files;

        if (f->closed)
            XSRETURN_IV(0);

        for (file; file; file = file->next) {
            int err;
            char *name;

            name = create_output_name((unsigned char *)file->filename,
                   f->isunix, file->attribs & MSCAB_ATTRIB_UTF_NAME);

            ensure_filepath(name);

            /* Extract all files */
            cabd->extract(cabd, file, name);

            if (err = cabd->last_error(cabd)) {
                SetCabError(f);
                XSRETURN_IV(err);
            }

            safefree(name);
        }

        RETVAL = 1;
    }
#line 698 "Cabinet.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Archive__Cabinet__cabFile_get_file_attributes); /* prototype to pass -Wmissing-prototypes */
XS(XS_Archive__Cabinet__cabFile_get_file_attributes)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Archive::Cabinet::cabFile::get_file_attributes(f)");
    {
	HV *	RETVAL;
	Archive__Cabinet__cabFile	f;

	if (sv_derived_from(ST(0), "Archive::Cabinet::cabFile")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    f = INT2PTR(Archive__Cabinet__cabFile,tmp);
	}
	else
	    Perl_croak(aTHX_ "f is not of type Archive::Cabinet::cabFile");
#line 592 "Cabinet.xs"
    {
        Archive__Cabinet__decomp cabd = f->cabd;
        Archive__Cabinet__file file = f->cab->files;

        RETVAL = newHV();

        for (file; file; file = file->next) {
            HV* fattr = newHV();
            hv_store(fattr, "date", 4, newSVpvf("%02d-%02d-%02d",
                    file->date_m, file->date_d, file->date_y), 0);
            hv_store(fattr, "time", 4, newSVpvf("%02d:%02d:%02d",
                    file->time_h, file->time_m, file->time_s), 0);
            hv_store(fattr, "size", 4, newSVnv(file->length), 0);
            hv_store(RETVAL, file->filename, strlen(file->filename), 
                    newRV_inc((SV*)fattr), 0);
        }
    }
#line 738 "Cabinet.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_Archive__Cabinet__cabFile_close); /* prototype to pass -Wmissing-prototypes */
XS(XS_Archive__Cabinet__cabFile_close)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Archive::Cabinet::cabFile::close(f)");
    {
	int	RETVAL;
	dXSTARG;
	Archive__Cabinet__cabFile	f;

	if (sv_derived_from(ST(0), "Archive::Cabinet::cabFile")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    f = INT2PTR(Archive__Cabinet__cabFile,tmp);
	}
	else
	    Perl_croak(aTHX_ "f is not of type Archive::Cabinet::cabFile");
#line 616 "Cabinet.xs"
    {
        Archive__Cabinet__decomp cabd = f->cabd;

        if (!f->closed) {
            cabd->close(cabd, f->cab);

            f->closed = TRUE;
            RETVAL = cabd->last_error(cabd);
            SetCabError(f);
        } else
            RETVAL = 0;
    }
#line 775 "Cabinet.c"
	sv_setref_pv(ST(0), "Archive::Cabinet::cabFile", (void*)f);
	SvSETMAGIC(ST(0));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_Archive__Cabinet); /* prototype to pass -Wmissing-prototypes */
XS(boot_Archive__Cabinet)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("Archive::Cabinet::new", XS_Archive__Cabinet_new, file);
        newXS("Archive::Cabinet::DESTROY", XS_Archive__Cabinet_DESTROY, file);
        newXS("Archive::Cabinet::cabFile::open", XS_Archive__Cabinet__cabFile_open, file);
        newXS("Archive::Cabinet::cabFile::list_files", XS_Archive__Cabinet__cabFile_list_files, file);
        newXS("Archive::Cabinet::cabFile::extract", XS_Archive__Cabinet__cabFile_extract, file);
        newXS("Archive::Cabinet::cabFile::extract_to_file", XS_Archive__Cabinet__cabFile_extract_to_file, file);
        newXS("Archive::Cabinet::cabFile::extract_all", XS_Archive__Cabinet__cabFile_extract_all, file);
        newXS("Archive::Cabinet::cabFile::get_file_attributes", XS_Archive__Cabinet__cabFile_get_file_attributes, file);
        newXS("Archive::Cabinet::cabFile::close", XS_Archive__Cabinet__cabFile_close, file);

    /* Initialisation Section */

#line 323 "Cabinet.xs"
{
    int err;

    MSPACK_SYS_SELFTEST(err);
    if (err)
        croak("Archive::Cabinet is %d-bit and libmspack not %d-bit.\n",
                arch_size(), arch_size());

    {
        /* Create caberror scalar */
        SV *caberror_sv = perl_get_sv(CABERRNO, GV_ADDMULTI);
        sv_setiv(caberror_sv, 0);
        sv_setpv(caberror_sv, "");
        SvIOK_on(caberror_sv);
    }
}

#line 824 "Cabinet.c"

    /* End of Initialisation Section */

    XSRETURN_YES;
}

