/* automatically generated by rust-bindgen 0.60.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::std::mem::transmute(self)
    }
}
impl<T> ::std::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
pub const SHAPE_ID_NUM_BITS: u32 = 32;
pub const INTEGER_REDEFINED_OP_FLAG: u32 = 1;
pub const FLOAT_REDEFINED_OP_FLAG: u32 = 2;
pub const STRING_REDEFINED_OP_FLAG: u32 = 4;
pub const ARRAY_REDEFINED_OP_FLAG: u32 = 8;
pub const HASH_REDEFINED_OP_FLAG: u32 = 16;
pub const SYMBOL_REDEFINED_OP_FLAG: u32 = 64;
pub const TIME_REDEFINED_OP_FLAG: u32 = 128;
pub const REGEXP_REDEFINED_OP_FLAG: u32 = 256;
pub const NIL_REDEFINED_OP_FLAG: u32 = 512;
pub const TRUE_REDEFINED_OP_FLAG: u32 = 1024;
pub const FALSE_REDEFINED_OP_FLAG: u32 = 2048;
pub const PROC_REDEFINED_OP_FLAG: u32 = 4096;
pub const VM_ENV_DATA_SIZE: u32 = 3;
pub const VM_ENV_DATA_INDEX_ME_CREF: i32 = -2;
pub const VM_ENV_DATA_INDEX_SPECVAL: i32 = -1;
pub const VM_ENV_DATA_INDEX_FLAGS: u32 = 0;
pub const VM_BLOCK_HANDLER_NONE: u32 = 0;
pub type ID = ::std::os::raw::c_ulong;
extern "C" {
    pub fn rb_singleton_class(obj: VALUE) -> VALUE;
}
pub type rb_alloc_func_t = ::std::option::Option<unsafe extern "C" fn(klass: VALUE) -> VALUE>;
extern "C" {
    pub fn rb_get_alloc_func(klass: VALUE) -> rb_alloc_func_t;
}
extern "C" {
    pub fn rb_method_basic_definition_p(klass: VALUE, mid: ID) -> ::std::os::raw::c_int;
}
pub const RUBY_Qfalse: ruby_special_consts = 0;
pub const RUBY_Qnil: ruby_special_consts = 4;
pub const RUBY_Qtrue: ruby_special_consts = 20;
pub const RUBY_Qundef: ruby_special_consts = 36;
pub const RUBY_IMMEDIATE_MASK: ruby_special_consts = 7;
pub const RUBY_FIXNUM_FLAG: ruby_special_consts = 1;
pub const RUBY_FLONUM_MASK: ruby_special_consts = 3;
pub const RUBY_FLONUM_FLAG: ruby_special_consts = 2;
pub const RUBY_SYMBOL_FLAG: ruby_special_consts = 12;
pub const RUBY_SPECIAL_SHIFT: ruby_special_consts = 8;
pub type ruby_special_consts = u32;
#[repr(C)]
pub struct RBasic {
    pub flags: VALUE,
    pub klass: VALUE,
}
pub const RUBY_T_NONE: ruby_value_type = 0;
pub const RUBY_T_OBJECT: ruby_value_type = 1;
pub const RUBY_T_CLASS: ruby_value_type = 2;
pub const RUBY_T_MODULE: ruby_value_type = 3;
pub const RUBY_T_FLOAT: ruby_value_type = 4;
pub const RUBY_T_STRING: ruby_value_type = 5;
pub const RUBY_T_REGEXP: ruby_value_type = 6;
pub const RUBY_T_ARRAY: ruby_value_type = 7;
pub const RUBY_T_HASH: ruby_value_type = 8;
pub const RUBY_T_STRUCT: ruby_value_type = 9;
pub const RUBY_T_BIGNUM: ruby_value_type = 10;
pub const RUBY_T_FILE: ruby_value_type = 11;
pub const RUBY_T_DATA: ruby_value_type = 12;
pub const RUBY_T_MATCH: ruby_value_type = 13;
pub const RUBY_T_COMPLEX: ruby_value_type = 14;
pub const RUBY_T_RATIONAL: ruby_value_type = 15;
pub const RUBY_T_NIL: ruby_value_type = 17;
pub const RUBY_T_TRUE: ruby_value_type = 18;
pub const RUBY_T_FALSE: ruby_value_type = 19;
pub const RUBY_T_SYMBOL: ruby_value_type = 20;
pub const RUBY_T_FIXNUM: ruby_value_type = 21;
pub const RUBY_T_UNDEF: ruby_value_type = 22;
pub const RUBY_T_IMEMO: ruby_value_type = 26;
pub const RUBY_T_NODE: ruby_value_type = 27;
pub const RUBY_T_ICLASS: ruby_value_type = 28;
pub const RUBY_T_ZOMBIE: ruby_value_type = 29;
pub const RUBY_T_MOVED: ruby_value_type = 30;
pub const RUBY_T_MASK: ruby_value_type = 31;
pub type ruby_value_type = u32;
pub const RUBY_FL_USHIFT: ruby_fl_ushift = 12;
pub type ruby_fl_ushift = u32;
pub const RUBY_FL_WB_PROTECTED: ruby_fl_type = 32;
pub const RUBY_FL_PROMOTED0: ruby_fl_type = 32;
pub const RUBY_FL_PROMOTED1: ruby_fl_type = 64;
pub const RUBY_FL_PROMOTED: ruby_fl_type = 96;
pub const RUBY_FL_FINALIZE: ruby_fl_type = 128;
pub const RUBY_FL_TAINT: ruby_fl_type = 256;
pub const RUBY_FL_SHAREABLE: ruby_fl_type = 256;
pub const RUBY_FL_UNTRUSTED: ruby_fl_type = 256;
pub const RUBY_FL_SEEN_OBJ_ID: ruby_fl_type = 512;
pub const RUBY_FL_EXIVAR: ruby_fl_type = 1024;
pub const RUBY_FL_FREEZE: ruby_fl_type = 2048;
pub const RUBY_FL_USER0: ruby_fl_type = 4096;
pub const RUBY_FL_USER1: ruby_fl_type = 8192;
pub const RUBY_FL_USER2: ruby_fl_type = 16384;
pub const RUBY_FL_USER3: ruby_fl_type = 32768;
pub const RUBY_FL_USER4: ruby_fl_type = 65536;
pub const RUBY_FL_USER5: ruby_fl_type = 131072;
pub const RUBY_FL_USER6: ruby_fl_type = 262144;
pub const RUBY_FL_USER7: ruby_fl_type = 524288;
pub const RUBY_FL_USER8: ruby_fl_type = 1048576;
pub const RUBY_FL_USER9: ruby_fl_type = 2097152;
pub const RUBY_FL_USER10: ruby_fl_type = 4194304;
pub const RUBY_FL_USER11: ruby_fl_type = 8388608;
pub const RUBY_FL_USER12: ruby_fl_type = 16777216;
pub const RUBY_FL_USER13: ruby_fl_type = 33554432;
pub const RUBY_FL_USER14: ruby_fl_type = 67108864;
pub const RUBY_FL_USER15: ruby_fl_type = 134217728;
pub const RUBY_FL_USER16: ruby_fl_type = 268435456;
pub const RUBY_FL_USER17: ruby_fl_type = 536870912;
pub const RUBY_FL_USER18: ruby_fl_type = 1073741824;
pub const RUBY_FL_USER19: ruby_fl_type = -2147483648;
pub const RUBY_ELTS_SHARED: ruby_fl_type = 16384;
pub const RUBY_FL_SINGLETON: ruby_fl_type = 4096;
pub type ruby_fl_type = i32;
pub type st_data_t = ::std::os::raw::c_ulong;
pub type st_index_t = st_data_t;
pub const ST_CONTINUE: st_retval = 0;
pub const ST_STOP: st_retval = 1;
pub const ST_DELETE: st_retval = 2;
pub const ST_CHECK: st_retval = 3;
pub const ST_REPLACE: st_retval = 4;
pub type st_retval = u32;
pub type st_foreach_callback_func = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: st_data_t,
        arg2: st_data_t,
        arg3: st_data_t,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn rb_gc_writebarrier(old: VALUE, young: VALUE);
}
pub const RARRAY_EMBED_FLAG: ruby_rarray_flags = 8192;
pub const RARRAY_EMBED_LEN_MASK: ruby_rarray_flags = 4161536;
pub const RARRAY_TRANSIENT_FLAG: ruby_rarray_flags = 33554432;
pub type ruby_rarray_flags = u32;
pub const RARRAY_EMBED_LEN_SHIFT: ruby_rarray_consts = 15;
pub type ruby_rarray_consts = u32;
pub const RMODULE_IS_REFINEMENT: ruby_rmodule_flags = 32768;
pub type ruby_rmodule_flags = u32;
extern "C" {
    pub fn rb_class_get_superclass(klass: VALUE) -> VALUE;
}
pub const ROBJECT_EMBED: ruby_robject_flags = 8192;
pub type ruby_robject_flags = u32;
pub const ROBJECT_OFFSET_AS_HEAP_IVPTR: i32 = 16;
pub const ROBJECT_OFFSET_AS_HEAP_IV_INDEX_TBL: i32 = 24;
pub const ROBJECT_OFFSET_AS_ARY: i32 = 16;
extern "C" {
    pub static mut rb_mKernel: VALUE;
}
extern "C" {
    pub static mut rb_cBasicObject: VALUE;
}
extern "C" {
    pub static mut rb_cArray: VALUE;
}
extern "C" {
    pub static mut rb_cFalseClass: VALUE;
}
extern "C" {
    pub static mut rb_cFloat: VALUE;
}
extern "C" {
    pub static mut rb_cHash: VALUE;
}
extern "C" {
    pub static mut rb_cInteger: VALUE;
}
extern "C" {
    pub static mut rb_cModule: VALUE;
}
extern "C" {
    pub static mut rb_cNilClass: VALUE;
}
extern "C" {
    pub static mut rb_cString: VALUE;
}
extern "C" {
    pub static mut rb_cSymbol: VALUE;
}
extern "C" {
    pub static mut rb_cThread: VALUE;
}
extern "C" {
    pub static mut rb_cTrueClass: VALUE;
}
pub type rb_block_call_func = ::std::option::Option<
    unsafe extern "C" fn(
        yielded_arg: VALUE,
        callback_arg: VALUE,
        argc: ::std::os::raw::c_int,
        argv: *const VALUE,
        blockarg: VALUE,
    ) -> VALUE,
>;
pub type rb_block_call_func_t = rb_block_call_func;
extern "C" {
    pub fn rb_ary_new_capa(capa: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_ary_store(ary: VALUE, key: ::std::os::raw::c_long, val: VALUE);
}
extern "C" {
    pub fn rb_ary_resurrect(ary: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_clear(ary: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_new() -> VALUE;
}
extern "C" {
    pub fn rb_hash_aref(hash: VALUE, key: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_aset(hash: VALUE, key: VALUE, val: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_bulk_insert(argc: ::std::os::raw::c_long, argv: *const VALUE, hash: VALUE);
}
extern "C" {
    pub fn rb_sym2id(obj: VALUE) -> ID;
}
extern "C" {
    pub fn rb_id2sym(id: ID) -> VALUE;
}
extern "C" {
    pub fn rb_intern(name: *const ::std::os::raw::c_char) -> ID;
}
extern "C" {
    pub fn rb_gc_mark(obj: VALUE);
}
extern "C" {
    pub fn rb_gc_mark_movable(obj: VALUE);
}
extern "C" {
    pub fn rb_gc_location(obj: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_is_kind_of(obj: VALUE, klass: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_frozen_p(obj: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_backref_get() -> VALUE;
}
extern "C" {
    pub fn rb_range_new(beg: VALUE, end: VALUE, excl: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_reg_nth_match(n: ::std::os::raw::c_int, md: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_reg_last_match(md: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_reg_match_pre(md: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_reg_match_post(md: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_reg_match_last(md: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_utf8_str_new(
        ptr: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_str_buf_append(dst: VALUE, src: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_dup(str_: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_intern(str_: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ivar_get(obj: VALUE, name: ID) -> VALUE;
}
extern "C" {
    pub fn rb_attr_get(obj: VALUE, name: ID) -> VALUE;
}
pub const RUBY_ENCODING_INLINE_MAX: ruby_encoding_consts = 127;
pub const RUBY_ENCODING_SHIFT: ruby_encoding_consts = 22;
pub const RUBY_ENCODING_MASK: ruby_encoding_consts = 532676608;
pub const RUBY_ENCODING_MAXNAMELEN: ruby_encoding_consts = 42;
pub type ruby_encoding_consts = u32;
pub const RUBY_ENCINDEX_ASCII_8BIT: ruby_preserved_encindex = 0;
pub const RUBY_ENCINDEX_UTF_8: ruby_preserved_encindex = 1;
pub const RUBY_ENCINDEX_US_ASCII: ruby_preserved_encindex = 2;
pub const RUBY_ENCINDEX_UTF_16BE: ruby_preserved_encindex = 3;
pub const RUBY_ENCINDEX_UTF_16LE: ruby_preserved_encindex = 4;
pub const RUBY_ENCINDEX_UTF_32BE: ruby_preserved_encindex = 5;
pub const RUBY_ENCINDEX_UTF_32LE: ruby_preserved_encindex = 6;
pub const RUBY_ENCINDEX_UTF_16: ruby_preserved_encindex = 7;
pub const RUBY_ENCINDEX_UTF_32: ruby_preserved_encindex = 8;
pub const RUBY_ENCINDEX_UTF8_MAC: ruby_preserved_encindex = 9;
pub const RUBY_ENCINDEX_EUC_JP: ruby_preserved_encindex = 10;
pub const RUBY_ENCINDEX_Windows_31J: ruby_preserved_encindex = 11;
pub const RUBY_ENCINDEX_BUILTIN_MAX: ruby_preserved_encindex = 12;
pub type ruby_preserved_encindex = u32;
extern "C" {
    pub fn rb_obj_info_dump(obj: VALUE);
}
extern "C" {
    pub fn rb_reg_new_ary(ary: VALUE, options: ::std::os::raw::c_int) -> VALUE;
}
pub type attr_index_t = u32;
pub type shape_id_t = u32;
#[repr(C)]
pub struct rb_shape {
    pub edges: *mut rb_id_table,
    pub edge_name: ID,
    pub next_iv_index: attr_index_t,
    pub capacity: u32,
    pub type_: u8,
    pub size_pool_index: u8,
    pub parent_id: shape_id_t,
}
pub type rb_shape_t = rb_shape;
extern "C" {
    pub fn rb_shape_id_offset() -> i32;
}
extern "C" {
    pub fn rb_shape_get_shape_by_id(shape_id: shape_id_t) -> *mut rb_shape_t;
}
extern "C" {
    pub fn rb_shape_get_shape_id(obj: VALUE) -> shape_id_t;
}
extern "C" {
    pub fn rb_shape_transition_shape_capa(
        shape: *mut rb_shape_t,
        new_capacity: u32,
    ) -> *mut rb_shape_t;
}
extern "C" {
    pub fn rb_shape_get_next(shape: *mut rb_shape_t, obj: VALUE, id: ID) -> *mut rb_shape_t;
}
extern "C" {
    pub fn rb_shape_get_iv_index(shape: *mut rb_shape_t, id: ID, value: *mut attr_index_t) -> bool;
}
extern "C" {
    pub fn rb_shape_id(shape: *mut rb_shape_t) -> shape_id_t;
}
pub const idDot2: ruby_method_ids = 128;
pub const idDot3: ruby_method_ids = 129;
pub const idUPlus: ruby_method_ids = 132;
pub const idUMinus: ruby_method_ids = 133;
pub const idPow: ruby_method_ids = 134;
pub const idCmp: ruby_method_ids = 135;
pub const idPLUS: ruby_method_ids = 43;
pub const idMINUS: ruby_method_ids = 45;
pub const idMULT: ruby_method_ids = 42;
pub const idDIV: ruby_method_ids = 47;
pub const idMOD: ruby_method_ids = 37;
pub const idLTLT: ruby_method_ids = 136;
pub const idGTGT: ruby_method_ids = 137;
pub const idLT: ruby_method_ids = 60;
pub const idLE: ruby_method_ids = 138;
pub const idGT: ruby_method_ids = 62;
pub const idGE: ruby_method_ids = 139;
pub const idEq: ruby_method_ids = 140;
pub const idEqq: ruby_method_ids = 141;
pub const idNeq: ruby_method_ids = 142;
pub const idNot: ruby_method_ids = 33;
pub const idAnd: ruby_method_ids = 38;
pub const idOr: ruby_method_ids = 124;
pub const idBackquote: ruby_method_ids = 96;
pub const idEqTilde: ruby_method_ids = 143;
pub const idNeqTilde: ruby_method_ids = 144;
pub const idAREF: ruby_method_ids = 145;
pub const idASET: ruby_method_ids = 146;
pub const idCOLON2: ruby_method_ids = 147;
pub const idANDOP: ruby_method_ids = 148;
pub const idOROP: ruby_method_ids = 149;
pub const idANDDOT: ruby_method_ids = 150;
pub const tPRESERVED_ID_BEGIN: ruby_method_ids = 150;
pub const idNilP: ruby_method_ids = 151;
pub const idNULL: ruby_method_ids = 152;
pub const idEmptyP: ruby_method_ids = 153;
pub const idEqlP: ruby_method_ids = 154;
pub const idRespond_to: ruby_method_ids = 155;
pub const idRespond_to_missing: ruby_method_ids = 156;
pub const idIFUNC: ruby_method_ids = 157;
pub const idCFUNC: ruby_method_ids = 158;
pub const id_core_set_method_alias: ruby_method_ids = 159;
pub const id_core_set_variable_alias: ruby_method_ids = 160;
pub const id_core_undef_method: ruby_method_ids = 161;
pub const id_core_define_method: ruby_method_ids = 162;
pub const id_core_define_singleton_method: ruby_method_ids = 163;
pub const id_core_set_postexe: ruby_method_ids = 164;
pub const id_core_hash_merge_ptr: ruby_method_ids = 165;
pub const id_core_hash_merge_kwd: ruby_method_ids = 166;
pub const id_core_raise: ruby_method_ids = 167;
pub const id_core_sprintf: ruby_method_ids = 168;
pub const id_debug_created_info: ruby_method_ids = 169;
pub const tPRESERVED_ID_END: ruby_method_ids = 170;
pub const tTOKEN_LOCAL_BEGIN: ruby_method_ids = 169;
pub const tMax: ruby_method_ids = 170;
pub const tMin: ruby_method_ids = 171;
pub const tFreeze: ruby_method_ids = 172;
pub const tInspect: ruby_method_ids = 173;
pub const tIntern: ruby_method_ids = 174;
pub const tObject_id: ruby_method_ids = 175;
pub const tConst_added: ruby_method_ids = 176;
pub const tConst_missing: ruby_method_ids = 177;
pub const tMethodMissing: ruby_method_ids = 178;
pub const tMethod_added: ruby_method_ids = 179;
pub const tSingleton_method_added: ruby_method_ids = 180;
pub const tMethod_removed: ruby_method_ids = 181;
pub const tSingleton_method_removed: ruby_method_ids = 182;
pub const tMethod_undefined: ruby_method_ids = 183;
pub const tSingleton_method_undefined: ruby_method_ids = 184;
pub const tLength: ruby_method_ids = 185;
pub const tSize: ruby_method_ids = 186;
pub const tGets: ruby_method_ids = 187;
pub const tSucc: ruby_method_ids = 188;
pub const tEach: ruby_method_ids = 189;
pub const tProc: ruby_method_ids = 190;
pub const tLambda: ruby_method_ids = 191;
pub const tSend: ruby_method_ids = 192;
pub const t__send__: ruby_method_ids = 193;
pub const t__attached__: ruby_method_ids = 194;
pub const t__recursive_key__: ruby_method_ids = 195;
pub const tInitialize: ruby_method_ids = 196;
pub const tInitialize_copy: ruby_method_ids = 197;
pub const tInitialize_clone: ruby_method_ids = 198;
pub const tInitialize_dup: ruby_method_ids = 199;
pub const tTo_int: ruby_method_ids = 200;
pub const tTo_ary: ruby_method_ids = 201;
pub const tTo_str: ruby_method_ids = 202;
pub const tTo_sym: ruby_method_ids = 203;
pub const tTo_hash: ruby_method_ids = 204;
pub const tTo_proc: ruby_method_ids = 205;
pub const tTo_io: ruby_method_ids = 206;
pub const tTo_a: ruby_method_ids = 207;
pub const tTo_s: ruby_method_ids = 208;
pub const tTo_i: ruby_method_ids = 209;
pub const tTo_f: ruby_method_ids = 210;
pub const tTo_r: ruby_method_ids = 211;
pub const tBt: ruby_method_ids = 212;
pub const tBt_locations: ruby_method_ids = 213;
pub const tCall: ruby_method_ids = 214;
pub const tMesg: ruby_method_ids = 215;
pub const tException: ruby_method_ids = 216;
pub const tLocals: ruby_method_ids = 217;
pub const tNOT: ruby_method_ids = 218;
pub const tAND: ruby_method_ids = 219;
pub const tOR: ruby_method_ids = 220;
pub const tDiv: ruby_method_ids = 221;
pub const tDivmod: ruby_method_ids = 222;
pub const tFdiv: ruby_method_ids = 223;
pub const tQuo: ruby_method_ids = 224;
pub const tName: ruby_method_ids = 225;
pub const tNil: ruby_method_ids = 226;
pub const tUScore: ruby_method_ids = 227;
pub const tNUMPARAM_1: ruby_method_ids = 228;
pub const tNUMPARAM_2: ruby_method_ids = 229;
pub const tNUMPARAM_3: ruby_method_ids = 230;
pub const tNUMPARAM_4: ruby_method_ids = 231;
pub const tNUMPARAM_5: ruby_method_ids = 232;
pub const tNUMPARAM_6: ruby_method_ids = 233;
pub const tNUMPARAM_7: ruby_method_ids = 234;
pub const tNUMPARAM_8: ruby_method_ids = 235;
pub const tNUMPARAM_9: ruby_method_ids = 236;
pub const tTOKEN_LOCAL_END: ruby_method_ids = 237;
pub const tTOKEN_INSTANCE_BEGIN: ruby_method_ids = 236;
pub const tTOKEN_INSTANCE_END: ruby_method_ids = 237;
pub const tTOKEN_GLOBAL_BEGIN: ruby_method_ids = 236;
pub const tLASTLINE: ruby_method_ids = 237;
pub const tBACKREF: ruby_method_ids = 238;
pub const tERROR_INFO: ruby_method_ids = 239;
pub const tTOKEN_GLOBAL_END: ruby_method_ids = 240;
pub const tTOKEN_CONST_BEGIN: ruby_method_ids = 239;
pub const tTOKEN_CONST_END: ruby_method_ids = 240;
pub const tTOKEN_CLASS_BEGIN: ruby_method_ids = 239;
pub const tTOKEN_CLASS_END: ruby_method_ids = 240;
pub const tTOKEN_ATTRSET_BEGIN: ruby_method_ids = 239;
pub const tTOKEN_ATTRSET_END: ruby_method_ids = 240;
pub const tNEXT_ID: ruby_method_ids = 240;
pub const idMax: ruby_method_ids = 2721;
pub const idMin: ruby_method_ids = 2737;
pub const idFreeze: ruby_method_ids = 2753;
pub const idInspect: ruby_method_ids = 2769;
pub const idIntern: ruby_method_ids = 2785;
pub const idObject_id: ruby_method_ids = 2801;
pub const idConst_added: ruby_method_ids = 2817;
pub const idConst_missing: ruby_method_ids = 2833;
pub const idMethodMissing: ruby_method_ids = 2849;
pub const idMethod_added: ruby_method_ids = 2865;
pub const idSingleton_method_added: ruby_method_ids = 2881;
pub const idMethod_removed: ruby_method_ids = 2897;
pub const idSingleton_method_removed: ruby_method_ids = 2913;
pub const idMethod_undefined: ruby_method_ids = 2929;
pub const idSingleton_method_undefined: ruby_method_ids = 2945;
pub const idLength: ruby_method_ids = 2961;
pub const idSize: ruby_method_ids = 2977;
pub const idGets: ruby_method_ids = 2993;
pub const idSucc: ruby_method_ids = 3009;
pub const idEach: ruby_method_ids = 3025;
pub const idProc: ruby_method_ids = 3041;
pub const idLambda: ruby_method_ids = 3057;
pub const idSend: ruby_method_ids = 3073;
pub const id__send__: ruby_method_ids = 3089;
pub const id__attached__: ruby_method_ids = 3105;
pub const id__recursive_key__: ruby_method_ids = 3121;
pub const idInitialize: ruby_method_ids = 3137;
pub const idInitialize_copy: ruby_method_ids = 3153;
pub const idInitialize_clone: ruby_method_ids = 3169;
pub const idInitialize_dup: ruby_method_ids = 3185;
pub const idTo_int: ruby_method_ids = 3201;
pub const idTo_ary: ruby_method_ids = 3217;
pub const idTo_str: ruby_method_ids = 3233;
pub const idTo_sym: ruby_method_ids = 3249;
pub const idTo_hash: ruby_method_ids = 3265;
pub const idTo_proc: ruby_method_ids = 3281;
pub const idTo_io: ruby_method_ids = 3297;
pub const idTo_a: ruby_method_ids = 3313;
pub const idTo_s: ruby_method_ids = 3329;
pub const idTo_i: ruby_method_ids = 3345;
pub const idTo_f: ruby_method_ids = 3361;
pub const idTo_r: ruby_method_ids = 3377;
pub const idBt: ruby_method_ids = 3393;
pub const idBt_locations: ruby_method_ids = 3409;
pub const idCall: ruby_method_ids = 3425;
pub const idMesg: ruby_method_ids = 3441;
pub const idException: ruby_method_ids = 3457;
pub const idLocals: ruby_method_ids = 3473;
pub const idNOT: ruby_method_ids = 3489;
pub const idAND: ruby_method_ids = 3505;
pub const idOR: ruby_method_ids = 3521;
pub const idDiv: ruby_method_ids = 3537;
pub const idDivmod: ruby_method_ids = 3553;
pub const idFdiv: ruby_method_ids = 3569;
pub const idQuo: ruby_method_ids = 3585;
pub const idName: ruby_method_ids = 3601;
pub const idNil: ruby_method_ids = 3617;
pub const idUScore: ruby_method_ids = 3633;
pub const idNUMPARAM_1: ruby_method_ids = 3649;
pub const idNUMPARAM_2: ruby_method_ids = 3665;
pub const idNUMPARAM_3: ruby_method_ids = 3681;
pub const idNUMPARAM_4: ruby_method_ids = 3697;
pub const idNUMPARAM_5: ruby_method_ids = 3713;
pub const idNUMPARAM_6: ruby_method_ids = 3729;
pub const idNUMPARAM_7: ruby_method_ids = 3745;
pub const idNUMPARAM_8: ruby_method_ids = 3761;
pub const idNUMPARAM_9: ruby_method_ids = 3777;
pub const idLASTLINE: ruby_method_ids = 3799;
pub const idBACKREF: ruby_method_ids = 3815;
pub const idERROR_INFO: ruby_method_ids = 3831;
pub const tLAST_OP_ID: ruby_method_ids = 169;
pub const idLAST_OP_ID: ruby_method_ids = 10;
pub type ruby_method_ids = u32;
extern "C" {
    pub fn rb_ary_tmp_new_from_values(
        arg1: VALUE,
        arg2: ::std::os::raw::c_long,
        arg3: *const VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_ec_ary_new_from_values(
        ec: *mut rb_execution_context_struct,
        n: ::std::os::raw::c_long,
        elts: *const VALUE,
    ) -> VALUE;
}
pub type rb_serial_t = ::std::os::raw::c_ulonglong;
extern "C" {
    pub fn rb_class_allocate_instance(klass: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_info(obj: VALUE) -> *const ::std::os::raw::c_char;
}
pub const imemo_env: imemo_type = 0;
pub const imemo_cref: imemo_type = 1;
pub const imemo_svar: imemo_type = 2;
pub const imemo_throw_data: imemo_type = 3;
pub const imemo_ifunc: imemo_type = 4;
pub const imemo_memo: imemo_type = 5;
pub const imemo_ment: imemo_type = 6;
pub const imemo_iseq: imemo_type = 7;
pub const imemo_tmpbuf: imemo_type = 8;
pub const imemo_ast: imemo_type = 9;
pub const imemo_parser_strterm: imemo_type = 10;
pub const imemo_callinfo: imemo_type = 11;
pub const imemo_callcache: imemo_type = 12;
pub const imemo_constcache: imemo_type = 13;
pub type imemo_type = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_ifunc_argc {
    pub min: ::std::os::raw::c_int,
    pub max: ::std::os::raw::c_int,
}
#[repr(C)]
pub struct vm_ifunc {
    pub flags: VALUE,
    pub reserved: VALUE,
    pub func: rb_block_call_func_t,
    pub data: *const ::std::os::raw::c_void,
    pub argc: vm_ifunc_argc,
}
pub const METHOD_VISI_UNDEF: rb_method_visibility_t = 0;
pub const METHOD_VISI_PUBLIC: rb_method_visibility_t = 1;
pub const METHOD_VISI_PRIVATE: rb_method_visibility_t = 2;
pub const METHOD_VISI_PROTECTED: rb_method_visibility_t = 3;
pub const METHOD_VISI_MASK: rb_method_visibility_t = 3;
pub type rb_method_visibility_t = u32;
#[repr(C)]
pub struct rb_method_entry_struct {
    pub flags: VALUE,
    pub defined_class: VALUE,
    pub def: *mut rb_method_definition_struct,
    pub called_id: ID,
    pub owner: VALUE,
}
pub type rb_method_entry_t = rb_method_entry_struct;
#[repr(C)]
pub struct rb_callable_method_entry_struct {
    pub flags: VALUE,
    pub defined_class: VALUE,
    pub def: *mut rb_method_definition_struct,
    pub called_id: ID,
    pub owner: VALUE,
}
pub type rb_callable_method_entry_t = rb_callable_method_entry_struct;
pub const VM_METHOD_TYPE_ISEQ: rb_method_type_t = 0;
pub const VM_METHOD_TYPE_CFUNC: rb_method_type_t = 1;
pub const VM_METHOD_TYPE_ATTRSET: rb_method_type_t = 2;
pub const VM_METHOD_TYPE_IVAR: rb_method_type_t = 3;
pub const VM_METHOD_TYPE_BMETHOD: rb_method_type_t = 4;
pub const VM_METHOD_TYPE_ZSUPER: rb_method_type_t = 5;
pub const VM_METHOD_TYPE_ALIAS: rb_method_type_t = 6;
pub const VM_METHOD_TYPE_UNDEF: rb_method_type_t = 7;
pub const VM_METHOD_TYPE_NOTIMPLEMENTED: rb_method_type_t = 8;
pub const VM_METHOD_TYPE_OPTIMIZED: rb_method_type_t = 9;
pub const VM_METHOD_TYPE_MISSING: rb_method_type_t = 10;
pub const VM_METHOD_TYPE_REFINED: rb_method_type_t = 11;
pub type rb_method_type_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_method_cfunc_struct {
    pub func: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
    pub invoker: ::std::option::Option<
        unsafe extern "C" fn(
            recv: VALUE,
            argc: ::std::os::raw::c_int,
            argv: *const VALUE,
            func: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
        ) -> VALUE,
    >,
    pub argc: ::std::os::raw::c_int,
}
pub const OPTIMIZED_METHOD_TYPE_SEND: method_optimized_type = 0;
pub const OPTIMIZED_METHOD_TYPE_CALL: method_optimized_type = 1;
pub const OPTIMIZED_METHOD_TYPE_BLOCK_CALL: method_optimized_type = 2;
pub const OPTIMIZED_METHOD_TYPE_STRUCT_AREF: method_optimized_type = 3;
pub const OPTIMIZED_METHOD_TYPE_STRUCT_ASET: method_optimized_type = 4;
pub const OPTIMIZED_METHOD_TYPE__MAX: method_optimized_type = 5;
pub type method_optimized_type = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_id_table {
    _unused: [u8; 0],
}
extern "C" {
    pub fn rb_method_entry_at(obj: VALUE, id: ID) -> *const rb_method_entry_t;
}
extern "C" {
    pub fn rb_callable_method_entry(klass: VALUE, id: ID) -> *const rb_callable_method_entry_t;
}
extern "C" {
    pub fn rb_callable_method_entry_or_negative(
        klass: VALUE,
        id: ID,
    ) -> *const rb_callable_method_entry_t;
}
pub type rb_num_t = ::std::os::raw::c_ulong;
#[repr(C)]
pub struct iseq_inline_constant_cache_entry {
    pub flags: VALUE,
    pub value: VALUE,
    pub _unused1: VALUE,
    pub _unused2: VALUE,
    pub ic_cref: *const rb_cref_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_inline_constant_cache {
    pub entry: *mut iseq_inline_constant_cache_entry,
    pub segments: *const ID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_inline_iv_cache_entry {
    pub value: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iseq_inline_cvar_cache_entry {
    pub entry: *mut rb_cvar_class_tbl_entry,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword {
    pub num: ::std::os::raw::c_int,
    pub required_num: ::std::os::raw::c_int,
    pub bits_start: ::std::os::raw::c_int,
    pub rest_start: ::std::os::raw::c_int,
    pub table: *const ID,
    pub default_values: *mut VALUE,
}
pub const BOP_PLUS: ruby_basic_operators = 0;
pub const BOP_MINUS: ruby_basic_operators = 1;
pub const BOP_MULT: ruby_basic_operators = 2;
pub const BOP_DIV: ruby_basic_operators = 3;
pub const BOP_MOD: ruby_basic_operators = 4;
pub const BOP_EQ: ruby_basic_operators = 5;
pub const BOP_EQQ: ruby_basic_operators = 6;
pub const BOP_LT: ruby_basic_operators = 7;
pub const BOP_LE: ruby_basic_operators = 8;
pub const BOP_LTLT: ruby_basic_operators = 9;
pub const BOP_AREF: ruby_basic_operators = 10;
pub const BOP_ASET: ruby_basic_operators = 11;
pub const BOP_LENGTH: ruby_basic_operators = 12;
pub const BOP_SIZE: ruby_basic_operators = 13;
pub const BOP_EMPTY_P: ruby_basic_operators = 14;
pub const BOP_NIL_P: ruby_basic_operators = 15;
pub const BOP_SUCC: ruby_basic_operators = 16;
pub const BOP_GT: ruby_basic_operators = 17;
pub const BOP_GE: ruby_basic_operators = 18;
pub const BOP_NOT: ruby_basic_operators = 19;
pub const BOP_NEQ: ruby_basic_operators = 20;
pub const BOP_MATCH: ruby_basic_operators = 21;
pub const BOP_FREEZE: ruby_basic_operators = 22;
pub const BOP_UMINUS: ruby_basic_operators = 23;
pub const BOP_MAX: ruby_basic_operators = 24;
pub const BOP_MIN: ruby_basic_operators = 25;
pub const BOP_CALL: ruby_basic_operators = 26;
pub const BOP_AND: ruby_basic_operators = 27;
pub const BOP_OR: ruby_basic_operators = 28;
pub const BOP_LAST_: ruby_basic_operators = 29;
pub type ruby_basic_operators = u32;
#[repr(C)]
pub struct rb_captured_block {
    pub self_: VALUE,
    pub ep: *const VALUE,
    pub code: rb_captured_block__bindgen_ty_1,
}
#[repr(C)]
pub struct rb_captured_block__bindgen_ty_1 {
    pub iseq: __BindgenUnionField<*const rb_iseq_t>,
    pub ifunc: __BindgenUnionField<*const vm_ifunc>,
    pub val: __BindgenUnionField<VALUE>,
    pub bindgen_union_field: u64,
}
pub const block_type_iseq: rb_block_type = 0;
pub const block_type_ifunc: rb_block_type = 1;
pub const block_type_symbol: rb_block_type = 2;
pub const block_type_proc: rb_block_type = 3;
pub type rb_block_type = u32;
#[repr(C)]
pub struct rb_block {
    pub as_: rb_block__bindgen_ty_1,
    pub type_: rb_block_type,
}
#[repr(C)]
pub struct rb_block__bindgen_ty_1 {
    pub captured: __BindgenUnionField<rb_captured_block>,
    pub symbol: __BindgenUnionField<VALUE>,
    pub proc_: __BindgenUnionField<VALUE>,
    pub bindgen_union_field: [u64; 3usize],
}
pub type rb_control_frame_t = rb_control_frame_struct;
extern "C" {
    pub static mut rb_mRubyVMFrozenCore: VALUE;
}
extern "C" {
    pub static mut rb_block_param_proxy: VALUE;
}
#[repr(C)]
pub struct rb_proc_t {
    pub block: rb_block,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 7usize],
}
impl rb_proc_t {
    #[inline]
    pub fn is_from_method(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_from_method(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_lambda(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_lambda(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_isolated(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_isolated(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_from_method: ::std::os::raw::c_uint,
        is_lambda: ::std::os::raw::c_uint,
        is_isolated: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_from_method: u32 = unsafe { ::std::mem::transmute(is_from_method) };
            is_from_method as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_lambda: u32 = unsafe { ::std::mem::transmute(is_lambda) };
            is_lambda as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_isolated: u32 = unsafe { ::std::mem::transmute(is_isolated) };
            is_isolated as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const VM_SPECIAL_OBJECT_VMCORE: vm_special_object_type = 1;
pub const VM_SPECIAL_OBJECT_CBASE: vm_special_object_type = 2;
pub const VM_SPECIAL_OBJECT_CONST_BASE: vm_special_object_type = 3;
pub type vm_special_object_type = u32;
pub type IC = *mut iseq_inline_constant_cache;
pub type IVC = *mut iseq_inline_iv_cache_entry;
pub type ICVARC = *mut iseq_inline_cvar_cache_entry;
pub const VM_FRAME_MAGIC_METHOD: vm_frame_env_flags = 286326785;
pub const VM_FRAME_MAGIC_BLOCK: vm_frame_env_flags = 572653569;
pub const VM_FRAME_MAGIC_CLASS: vm_frame_env_flags = 858980353;
pub const VM_FRAME_MAGIC_TOP: vm_frame_env_flags = 1145307137;
pub const VM_FRAME_MAGIC_CFUNC: vm_frame_env_flags = 1431633921;
pub const VM_FRAME_MAGIC_IFUNC: vm_frame_env_flags = 1717960705;
pub const VM_FRAME_MAGIC_EVAL: vm_frame_env_flags = 2004287489;
pub const VM_FRAME_MAGIC_RESCUE: vm_frame_env_flags = 2022178817;
pub const VM_FRAME_MAGIC_DUMMY: vm_frame_env_flags = 2040070145;
pub const VM_FRAME_MAGIC_MASK: vm_frame_env_flags = 2147418113;
pub const VM_FRAME_FLAG_FINISH: vm_frame_env_flags = 32;
pub const VM_FRAME_FLAG_BMETHOD: vm_frame_env_flags = 64;
pub const VM_FRAME_FLAG_CFRAME: vm_frame_env_flags = 128;
pub const VM_FRAME_FLAG_LAMBDA: vm_frame_env_flags = 256;
pub const VM_FRAME_FLAG_MODIFIED_BLOCK_PARAM: vm_frame_env_flags = 512;
pub const VM_FRAME_FLAG_CFRAME_KW: vm_frame_env_flags = 1024;
pub const VM_FRAME_FLAG_PASSED: vm_frame_env_flags = 2048;
pub const VM_ENV_FLAG_LOCAL: vm_frame_env_flags = 2;
pub const VM_ENV_FLAG_ESCAPED: vm_frame_env_flags = 4;
pub const VM_ENV_FLAG_WB_REQUIRED: vm_frame_env_flags = 8;
pub const VM_ENV_FLAG_ISOLATED: vm_frame_env_flags = 16;
pub type vm_frame_env_flags = u32;
extern "C" {
    pub fn rb_vm_ep_local_ep(ep: *const VALUE) -> *const VALUE;
}
extern "C" {
    pub fn rb_iseq_path(iseq: *const rb_iseq_t) -> VALUE;
}
extern "C" {
    pub fn rb_vm_bh_to_procval(ec: *const rb_execution_context_t, block_handler: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_vm_frame_method_entry(
        cfp: *const rb_control_frame_t,
    ) -> *const rb_callable_method_entry_t;
}
#[repr(C)]
pub struct rb_cvar_class_tbl_entry {
    pub index: u32,
    pub global_cvar_state: rb_serial_t,
    pub class_value: VALUE,
}
pub const VM_CALL_ARGS_SPLAT_bit: vm_call_flag_bits = 0;
pub const VM_CALL_ARGS_BLOCKARG_bit: vm_call_flag_bits = 1;
pub const VM_CALL_FCALL_bit: vm_call_flag_bits = 2;
pub const VM_CALL_VCALL_bit: vm_call_flag_bits = 3;
pub const VM_CALL_ARGS_SIMPLE_bit: vm_call_flag_bits = 4;
pub const VM_CALL_BLOCKISEQ_bit: vm_call_flag_bits = 5;
pub const VM_CALL_KWARG_bit: vm_call_flag_bits = 6;
pub const VM_CALL_KW_SPLAT_bit: vm_call_flag_bits = 7;
pub const VM_CALL_TAILCALL_bit: vm_call_flag_bits = 8;
pub const VM_CALL_SUPER_bit: vm_call_flag_bits = 9;
pub const VM_CALL_ZSUPER_bit: vm_call_flag_bits = 10;
pub const VM_CALL_OPT_SEND_bit: vm_call_flag_bits = 11;
pub const VM_CALL_KW_SPLAT_MUT_bit: vm_call_flag_bits = 12;
pub const VM_CALL__END: vm_call_flag_bits = 13;
pub type vm_call_flag_bits = u32;
#[repr(C)]
pub struct rb_callinfo {
    pub flags: VALUE,
    pub kwarg: *const rb_callinfo_kwarg,
    pub mid: VALUE,
    pub flag: VALUE,
    pub argc: VALUE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_call_data {
    pub ci: *const rb_callinfo,
    pub cc: *const rb_callcache,
}
extern "C" {
    pub fn rb_obj_as_string_result(str_: VALUE, obj: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_concat_literals(num: size_t, strary: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ec_str_resurrect(ec: *mut rb_execution_context_struct, str_: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_stlike_foreach(
        hash: VALUE,
        func: st_foreach_callback_func,
        arg: st_data_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_hash_new_with_size(size: st_index_t) -> VALUE;
}
extern "C" {
    pub fn rb_hash_resurrect(hash: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_stlike_lookup(
        hash: VALUE,
        key: st_data_t,
        pval: *mut st_data_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_gvar_get(arg1: ID) -> VALUE;
}
extern "C" {
    pub fn rb_gvar_set(arg1: ID, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ensure_iv_list_size(obj: VALUE, len: u32, newsize: u32);
}
extern "C" {
    pub fn rb_vm_insn_decode(encoded: VALUE) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_builtin_function {
    pub func_ptr: *const ::std::os::raw::c_void,
    pub argc: ::std::os::raw::c_int,
    pub index: ::std::os::raw::c_int,
    pub name: *const ::std::os::raw::c_char,
    pub compiler: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: VALUE,
            arg2: ::std::os::raw::c_long,
            arg3: ::std::os::raw::c_uint,
            arg4: bool,
        ),
    >,
}
pub const YARVINSN_nop: ruby_vminsn_type = 0;
pub const YARVINSN_getlocal: ruby_vminsn_type = 1;
pub const YARVINSN_setlocal: ruby_vminsn_type = 2;
pub const YARVINSN_getblockparam: ruby_vminsn_type = 3;
pub const YARVINSN_setblockparam: ruby_vminsn_type = 4;
pub const YARVINSN_getblockparamproxy: ruby_vminsn_type = 5;
pub const YARVINSN_getspecial: ruby_vminsn_type = 6;
pub const YARVINSN_setspecial: ruby_vminsn_type = 7;
pub const YARVINSN_getinstancevariable: ruby_vminsn_type = 8;
pub const YARVINSN_setinstancevariable: ruby_vminsn_type = 9;
pub const YARVINSN_getclassvariable: ruby_vminsn_type = 10;
pub const YARVINSN_setclassvariable: ruby_vminsn_type = 11;
pub const YARVINSN_opt_getconstant_path: ruby_vminsn_type = 12;
pub const YARVINSN_getconstant: ruby_vminsn_type = 13;
pub const YARVINSN_setconstant: ruby_vminsn_type = 14;
pub const YARVINSN_getglobal: ruby_vminsn_type = 15;
pub const YARVINSN_setglobal: ruby_vminsn_type = 16;
pub const YARVINSN_putnil: ruby_vminsn_type = 17;
pub const YARVINSN_putself: ruby_vminsn_type = 18;
pub const YARVINSN_putobject: ruby_vminsn_type = 19;
pub const YARVINSN_putspecialobject: ruby_vminsn_type = 20;
pub const YARVINSN_putstring: ruby_vminsn_type = 21;
pub const YARVINSN_concatstrings: ruby_vminsn_type = 22;
pub const YARVINSN_anytostring: ruby_vminsn_type = 23;
pub const YARVINSN_toregexp: ruby_vminsn_type = 24;
pub const YARVINSN_intern: ruby_vminsn_type = 25;
pub const YARVINSN_newarray: ruby_vminsn_type = 26;
pub const YARVINSN_newarraykwsplat: ruby_vminsn_type = 27;
pub const YARVINSN_duparray: ruby_vminsn_type = 28;
pub const YARVINSN_duphash: ruby_vminsn_type = 29;
pub const YARVINSN_expandarray: ruby_vminsn_type = 30;
pub const YARVINSN_concatarray: ruby_vminsn_type = 31;
pub const YARVINSN_splatarray: ruby_vminsn_type = 32;
pub const YARVINSN_newhash: ruby_vminsn_type = 33;
pub const YARVINSN_newrange: ruby_vminsn_type = 34;
pub const YARVINSN_pop: ruby_vminsn_type = 35;
pub const YARVINSN_dup: ruby_vminsn_type = 36;
pub const YARVINSN_dupn: ruby_vminsn_type = 37;
pub const YARVINSN_swap: ruby_vminsn_type = 38;
pub const YARVINSN_opt_reverse: ruby_vminsn_type = 39;
pub const YARVINSN_topn: ruby_vminsn_type = 40;
pub const YARVINSN_setn: ruby_vminsn_type = 41;
pub const YARVINSN_adjuststack: ruby_vminsn_type = 42;
pub const YARVINSN_defined: ruby_vminsn_type = 43;
pub const YARVINSN_checkmatch: ruby_vminsn_type = 44;
pub const YARVINSN_checkkeyword: ruby_vminsn_type = 45;
pub const YARVINSN_checktype: ruby_vminsn_type = 46;
pub const YARVINSN_defineclass: ruby_vminsn_type = 47;
pub const YARVINSN_definemethod: ruby_vminsn_type = 48;
pub const YARVINSN_definesmethod: ruby_vminsn_type = 49;
pub const YARVINSN_send: ruby_vminsn_type = 50;
pub const YARVINSN_opt_send_without_block: ruby_vminsn_type = 51;
pub const YARVINSN_objtostring: ruby_vminsn_type = 52;
pub const YARVINSN_opt_str_freeze: ruby_vminsn_type = 53;
pub const YARVINSN_opt_nil_p: ruby_vminsn_type = 54;
pub const YARVINSN_opt_str_uminus: ruby_vminsn_type = 55;
pub const YARVINSN_opt_newarray_max: ruby_vminsn_type = 56;
pub const YARVINSN_opt_newarray_min: ruby_vminsn_type = 57;
pub const YARVINSN_invokesuper: ruby_vminsn_type = 58;
pub const YARVINSN_invokeblock: ruby_vminsn_type = 59;
pub const YARVINSN_leave: ruby_vminsn_type = 60;
pub const YARVINSN_throw: ruby_vminsn_type = 61;
pub const YARVINSN_jump: ruby_vminsn_type = 62;
pub const YARVINSN_branchif: ruby_vminsn_type = 63;
pub const YARVINSN_branchunless: ruby_vminsn_type = 64;
pub const YARVINSN_branchnil: ruby_vminsn_type = 65;
pub const YARVINSN_once: ruby_vminsn_type = 66;
pub const YARVINSN_opt_case_dispatch: ruby_vminsn_type = 67;
pub const YARVINSN_opt_plus: ruby_vminsn_type = 68;
pub const YARVINSN_opt_minus: ruby_vminsn_type = 69;
pub const YARVINSN_opt_mult: ruby_vminsn_type = 70;
pub const YARVINSN_opt_div: ruby_vminsn_type = 71;
pub const YARVINSN_opt_mod: ruby_vminsn_type = 72;
pub const YARVINSN_opt_eq: ruby_vminsn_type = 73;
pub const YARVINSN_opt_neq: ruby_vminsn_type = 74;
pub const YARVINSN_opt_lt: ruby_vminsn_type = 75;
pub const YARVINSN_opt_le: ruby_vminsn_type = 76;
pub const YARVINSN_opt_gt: ruby_vminsn_type = 77;
pub const YARVINSN_opt_ge: ruby_vminsn_type = 78;
pub const YARVINSN_opt_ltlt: ruby_vminsn_type = 79;
pub const YARVINSN_opt_and: ruby_vminsn_type = 80;
pub const YARVINSN_opt_or: ruby_vminsn_type = 81;
pub const YARVINSN_opt_aref: ruby_vminsn_type = 82;
pub const YARVINSN_opt_aset: ruby_vminsn_type = 83;
pub const YARVINSN_opt_aset_with: ruby_vminsn_type = 84;
pub const YARVINSN_opt_aref_with: ruby_vminsn_type = 85;
pub const YARVINSN_opt_length: ruby_vminsn_type = 86;
pub const YARVINSN_opt_size: ruby_vminsn_type = 87;
pub const YARVINSN_opt_empty_p: ruby_vminsn_type = 88;
pub const YARVINSN_opt_succ: ruby_vminsn_type = 89;
pub const YARVINSN_opt_not: ruby_vminsn_type = 90;
pub const YARVINSN_opt_regexpmatch2: ruby_vminsn_type = 91;
pub const YARVINSN_invokebuiltin: ruby_vminsn_type = 92;
pub const YARVINSN_opt_invokebuiltin_delegate: ruby_vminsn_type = 93;
pub const YARVINSN_opt_invokebuiltin_delegate_leave: ruby_vminsn_type = 94;
pub const YARVINSN_getlocal_WC_0: ruby_vminsn_type = 95;
pub const YARVINSN_getlocal_WC_1: ruby_vminsn_type = 96;
pub const YARVINSN_setlocal_WC_0: ruby_vminsn_type = 97;
pub const YARVINSN_setlocal_WC_1: ruby_vminsn_type = 98;
pub const YARVINSN_putobject_INT2FIX_0_: ruby_vminsn_type = 99;
pub const YARVINSN_putobject_INT2FIX_1_: ruby_vminsn_type = 100;
pub const YARVINSN_trace_nop: ruby_vminsn_type = 101;
pub const YARVINSN_trace_getlocal: ruby_vminsn_type = 102;
pub const YARVINSN_trace_setlocal: ruby_vminsn_type = 103;
pub const YARVINSN_trace_getblockparam: ruby_vminsn_type = 104;
pub const YARVINSN_trace_setblockparam: ruby_vminsn_type = 105;
pub const YARVINSN_trace_getblockparamproxy: ruby_vminsn_type = 106;
pub const YARVINSN_trace_getspecial: ruby_vminsn_type = 107;
pub const YARVINSN_trace_setspecial: ruby_vminsn_type = 108;
pub const YARVINSN_trace_getinstancevariable: ruby_vminsn_type = 109;
pub const YARVINSN_trace_setinstancevariable: ruby_vminsn_type = 110;
pub const YARVINSN_trace_getclassvariable: ruby_vminsn_type = 111;
pub const YARVINSN_trace_setclassvariable: ruby_vminsn_type = 112;
pub const YARVINSN_trace_opt_getconstant_path: ruby_vminsn_type = 113;
pub const YARVINSN_trace_getconstant: ruby_vminsn_type = 114;
pub const YARVINSN_trace_setconstant: ruby_vminsn_type = 115;
pub const YARVINSN_trace_getglobal: ruby_vminsn_type = 116;
pub const YARVINSN_trace_setglobal: ruby_vminsn_type = 117;
pub const YARVINSN_trace_putnil: ruby_vminsn_type = 118;
pub const YARVINSN_trace_putself: ruby_vminsn_type = 119;
pub const YARVINSN_trace_putobject: ruby_vminsn_type = 120;
pub const YARVINSN_trace_putspecialobject: ruby_vminsn_type = 121;
pub const YARVINSN_trace_putstring: ruby_vminsn_type = 122;
pub const YARVINSN_trace_concatstrings: ruby_vminsn_type = 123;
pub const YARVINSN_trace_anytostring: ruby_vminsn_type = 124;
pub const YARVINSN_trace_toregexp: ruby_vminsn_type = 125;
pub const YARVINSN_trace_intern: ruby_vminsn_type = 126;
pub const YARVINSN_trace_newarray: ruby_vminsn_type = 127;
pub const YARVINSN_trace_newarraykwsplat: ruby_vminsn_type = 128;
pub const YARVINSN_trace_duparray: ruby_vminsn_type = 129;
pub const YARVINSN_trace_duphash: ruby_vminsn_type = 130;
pub const YARVINSN_trace_expandarray: ruby_vminsn_type = 131;
pub const YARVINSN_trace_concatarray: ruby_vminsn_type = 132;
pub const YARVINSN_trace_splatarray: ruby_vminsn_type = 133;
pub const YARVINSN_trace_newhash: ruby_vminsn_type = 134;
pub const YARVINSN_trace_newrange: ruby_vminsn_type = 135;
pub const YARVINSN_trace_pop: ruby_vminsn_type = 136;
pub const YARVINSN_trace_dup: ruby_vminsn_type = 137;
pub const YARVINSN_trace_dupn: ruby_vminsn_type = 138;
pub const YARVINSN_trace_swap: ruby_vminsn_type = 139;
pub const YARVINSN_trace_opt_reverse: ruby_vminsn_type = 140;
pub const YARVINSN_trace_topn: ruby_vminsn_type = 141;
pub const YARVINSN_trace_setn: ruby_vminsn_type = 142;
pub const YARVINSN_trace_adjuststack: ruby_vminsn_type = 143;
pub const YARVINSN_trace_defined: ruby_vminsn_type = 144;
pub const YARVINSN_trace_checkmatch: ruby_vminsn_type = 145;
pub const YARVINSN_trace_checkkeyword: ruby_vminsn_type = 146;
pub const YARVINSN_trace_checktype: ruby_vminsn_type = 147;
pub const YARVINSN_trace_defineclass: ruby_vminsn_type = 148;
pub const YARVINSN_trace_definemethod: ruby_vminsn_type = 149;
pub const YARVINSN_trace_definesmethod: ruby_vminsn_type = 150;
pub const YARVINSN_trace_send: ruby_vminsn_type = 151;
pub const YARVINSN_trace_opt_send_without_block: ruby_vminsn_type = 152;
pub const YARVINSN_trace_objtostring: ruby_vminsn_type = 153;
pub const YARVINSN_trace_opt_str_freeze: ruby_vminsn_type = 154;
pub const YARVINSN_trace_opt_nil_p: ruby_vminsn_type = 155;
pub const YARVINSN_trace_opt_str_uminus: ruby_vminsn_type = 156;
pub const YARVINSN_trace_opt_newarray_max: ruby_vminsn_type = 157;
pub const YARVINSN_trace_opt_newarray_min: ruby_vminsn_type = 158;
pub const YARVINSN_trace_invokesuper: ruby_vminsn_type = 159;
pub const YARVINSN_trace_invokeblock: ruby_vminsn_type = 160;
pub const YARVINSN_trace_leave: ruby_vminsn_type = 161;
pub const YARVINSN_trace_throw: ruby_vminsn_type = 162;
pub const YARVINSN_trace_jump: ruby_vminsn_type = 163;
pub const YARVINSN_trace_branchif: ruby_vminsn_type = 164;
pub const YARVINSN_trace_branchunless: ruby_vminsn_type = 165;
pub const YARVINSN_trace_branchnil: ruby_vminsn_type = 166;
pub const YARVINSN_trace_once: ruby_vminsn_type = 167;
pub const YARVINSN_trace_opt_case_dispatch: ruby_vminsn_type = 168;
pub const YARVINSN_trace_opt_plus: ruby_vminsn_type = 169;
pub const YARVINSN_trace_opt_minus: ruby_vminsn_type = 170;
pub const YARVINSN_trace_opt_mult: ruby_vminsn_type = 171;
pub const YARVINSN_trace_opt_div: ruby_vminsn_type = 172;
pub const YARVINSN_trace_opt_mod: ruby_vminsn_type = 173;
pub const YARVINSN_trace_opt_eq: ruby_vminsn_type = 174;
pub const YARVINSN_trace_opt_neq: ruby_vminsn_type = 175;
pub const YARVINSN_trace_opt_lt: ruby_vminsn_type = 176;
pub const YARVINSN_trace_opt_le: ruby_vminsn_type = 177;
pub const YARVINSN_trace_opt_gt: ruby_vminsn_type = 178;
pub const YARVINSN_trace_opt_ge: ruby_vminsn_type = 179;
pub const YARVINSN_trace_opt_ltlt: ruby_vminsn_type = 180;
pub const YARVINSN_trace_opt_and: ruby_vminsn_type = 181;
pub const YARVINSN_trace_opt_or: ruby_vminsn_type = 182;
pub const YARVINSN_trace_opt_aref: ruby_vminsn_type = 183;
pub const YARVINSN_trace_opt_aset: ruby_vminsn_type = 184;
pub const YARVINSN_trace_opt_aset_with: ruby_vminsn_type = 185;
pub const YARVINSN_trace_opt_aref_with: ruby_vminsn_type = 186;
pub const YARVINSN_trace_opt_length: ruby_vminsn_type = 187;
pub const YARVINSN_trace_opt_size: ruby_vminsn_type = 188;
pub const YARVINSN_trace_opt_empty_p: ruby_vminsn_type = 189;
pub const YARVINSN_trace_opt_succ: ruby_vminsn_type = 190;
pub const YARVINSN_trace_opt_not: ruby_vminsn_type = 191;
pub const YARVINSN_trace_opt_regexpmatch2: ruby_vminsn_type = 192;
pub const YARVINSN_trace_invokebuiltin: ruby_vminsn_type = 193;
pub const YARVINSN_trace_opt_invokebuiltin_delegate: ruby_vminsn_type = 194;
pub const YARVINSN_trace_opt_invokebuiltin_delegate_leave: ruby_vminsn_type = 195;
pub const YARVINSN_trace_getlocal_WC_0: ruby_vminsn_type = 196;
pub const YARVINSN_trace_getlocal_WC_1: ruby_vminsn_type = 197;
pub const YARVINSN_trace_setlocal_WC_0: ruby_vminsn_type = 198;
pub const YARVINSN_trace_setlocal_WC_1: ruby_vminsn_type = 199;
pub const YARVINSN_trace_putobject_INT2FIX_0_: ruby_vminsn_type = 200;
pub const YARVINSN_trace_putobject_INT2FIX_1_: ruby_vminsn_type = 201;
pub const VM_INSTRUCTION_SIZE: ruby_vminsn_type = 202;
pub type ruby_vminsn_type = u32;
pub type rb_iseq_callback = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const rb_iseq_t, arg2: *mut ::std::os::raw::c_void),
>;
extern "C" {
    pub fn rb_vm_insn_addr2opcode(addr: *const ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_iseqw_to_iseq(iseqw: VALUE) -> *const rb_iseq_t;
}
extern "C" {
    pub fn rb_iseq_method_name(iseq: *const rb_iseq_t) -> VALUE;
}
extern "C" {
    pub fn rb_vm_barrier();
}
extern "C" {
    pub fn rb_profile_frames(
        start: ::std::os::raw::c_int,
        limit: ::std::os::raw::c_int,
        buff: *mut VALUE,
        lines: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_jit_cont_each_iseq(callback: rb_iseq_callback, data: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn rb_yjit_mark_writable(mem_block: *mut ::std::os::raw::c_void, mem_size: u32) -> bool;
}
extern "C" {
    pub fn rb_yjit_mark_executable(mem_block: *mut ::std::os::raw::c_void, mem_size: u32);
}
extern "C" {
    pub fn rb_yjit_mark_unused(mem_block: *mut ::std::os::raw::c_void, mem_size: u32) -> bool;
}
extern "C" {
    pub fn rb_yjit_icache_invalidate(
        start: *mut ::std::os::raw::c_void,
        end: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn rb_yjit_exit_locations_dict(
        yjit_raw_samples: *mut VALUE,
        yjit_line_samples: *mut ::std::os::raw::c_int,
        samples_len: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_yjit_get_page_size() -> u32;
}
extern "C" {
    pub fn rb_yjit_reserve_addr_space(mem_size: u32) -> *mut u8;
}
extern "C" {
    pub fn rb_c_method_tracing_currently_enabled(ec: *mut rb_execution_context_t) -> bool;
}
extern "C" {
    pub fn rb_full_cfunc_return(ec: *mut rb_execution_context_t, return_value: VALUE);
}
extern "C" {
    pub fn rb_iseq_encoded_size(iseq: *const rb_iseq_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn rb_iseq_get_yjit_payload(iseq: *const rb_iseq_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn rb_iseq_set_yjit_payload(iseq: *const rb_iseq_t, payload: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn rb_iseq_reset_jit_func(iseq: *const rb_iseq_t);
}
extern "C" {
    pub fn rb_iseq_pc_at_idx(iseq: *const rb_iseq_t, insn_idx: u32) -> *mut VALUE;
}
extern "C" {
    pub fn rb_iseq_opcode_at_pc(iseq: *const rb_iseq_t, pc: *const VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_RSTRING_LEN(str_: VALUE) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn rb_RSTRING_PTR(str_: VALUE) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_yjit_get_proc_ptr(procv: VALUE) -> *mut rb_proc_t;
}
pub type rb_seq_param_keyword_struct = rb_iseq_constant_body__bindgen_ty_1_rb_iseq_param_keyword;
extern "C" {
    pub fn rb_insn_name(insn: VALUE) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_insn_len(insn: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_vm_ci_argc(ci: *const rb_callinfo) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn rb_vm_ci_mid(ci: *const rb_callinfo) -> ID;
}
extern "C" {
    pub fn rb_vm_ci_flag(ci: *const rb_callinfo) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn rb_vm_ci_kwarg(ci: *const rb_callinfo) -> *const rb_callinfo_kwarg;
}
extern "C" {
    pub fn rb_get_cikw_keyword_len(cikw: *const rb_callinfo_kwarg) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_get_cikw_keywords_idx(
        cikw: *const rb_callinfo_kwarg,
        idx: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_METHOD_ENTRY_VISI(me: *const rb_callable_method_entry_t) -> rb_method_visibility_t;
}
extern "C" {
    pub fn rb_get_cme_def_type(cme: *const rb_callable_method_entry_t) -> rb_method_type_t;
}
extern "C" {
    pub fn rb_get_cme_def_body_attr_id(cme: *const rb_callable_method_entry_t) -> ID;
}
extern "C" {
    pub fn rb_get_symbol_id(namep: VALUE) -> ID;
}
extern "C" {
    pub fn rb_get_cme_def_body_optimized_type(
        cme: *const rb_callable_method_entry_t,
    ) -> method_optimized_type;
}
extern "C" {
    pub fn rb_get_cme_def_body_optimized_index(
        cme: *const rb_callable_method_entry_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn rb_get_cme_def_body_cfunc(
        cme: *const rb_callable_method_entry_t,
    ) -> *mut rb_method_cfunc_t;
}
extern "C" {
    pub fn rb_get_def_method_serial(def: *const rb_method_definition_t) -> usize;
}
extern "C" {
    pub fn rb_get_def_original_id(def: *const rb_method_definition_t) -> ID;
}
extern "C" {
    pub fn rb_get_mct_argc(mct: *const rb_method_cfunc_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_get_mct_func(mct: *const rb_method_cfunc_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn rb_get_def_iseq_ptr(def: *mut rb_method_definition_t) -> *const rb_iseq_t;
}
extern "C" {
    pub fn rb_get_def_bmethod_proc(def: *mut rb_method_definition_t) -> VALUE;
}
extern "C" {
    pub fn rb_get_iseq_body_local_iseq(iseq: *const rb_iseq_t) -> *const rb_iseq_t;
}
extern "C" {
    pub fn rb_get_iseq_body_parent_iseq(iseq: *const rb_iseq_t) -> *const rb_iseq_t;
}
extern "C" {
    pub fn rb_get_iseq_body_local_table_size(iseq: *const rb_iseq_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn rb_get_iseq_body_iseq_encoded(iseq: *const rb_iseq_t) -> *mut VALUE;
}
extern "C" {
    pub fn rb_get_iseq_body_stack_max(iseq: *const rb_iseq_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn rb_get_iseq_flags_has_lead(iseq: *const rb_iseq_t) -> bool;
}
extern "C" {
    pub fn rb_get_iseq_flags_has_opt(iseq: *const rb_iseq_t) -> bool;
}
extern "C" {
    pub fn rb_get_iseq_flags_has_kw(iseq: *const rb_iseq_t) -> bool;
}
extern "C" {
    pub fn rb_get_iseq_flags_has_post(iseq: *const rb_iseq_t) -> bool;
}
extern "C" {
    pub fn rb_get_iseq_flags_has_kwrest(iseq: *const rb_iseq_t) -> bool;
}
extern "C" {
    pub fn rb_get_iseq_flags_has_rest(iseq: *const rb_iseq_t) -> bool;
}
extern "C" {
    pub fn rb_get_iseq_flags_ruby2_keywords(iseq: *const rb_iseq_t) -> bool;
}
extern "C" {
    pub fn rb_get_iseq_flags_has_block(iseq: *const rb_iseq_t) -> bool;
}
extern "C" {
    pub fn rb_get_iseq_flags_ambiguous_param0(iseq: *const rb_iseq_t) -> bool;
}
extern "C" {
    pub fn rb_get_iseq_flags_accepts_no_kwarg(iseq: *const rb_iseq_t) -> bool;
}
extern "C" {
    pub fn rb_get_iseq_body_param_keyword(
        iseq: *const rb_iseq_t,
    ) -> *const rb_seq_param_keyword_struct;
}
extern "C" {
    pub fn rb_get_iseq_body_param_size(iseq: *const rb_iseq_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn rb_get_iseq_body_param_lead_num(iseq: *const rb_iseq_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_get_iseq_body_param_opt_num(iseq: *const rb_iseq_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_get_iseq_body_param_opt_table(iseq: *const rb_iseq_t) -> *const VALUE;
}
extern "C" {
    pub fn rb_optimized_call(
        recv: *mut VALUE,
        ec: *mut rb_execution_context_t,
        argc: ::std::os::raw::c_int,
        argv: *mut VALUE,
        kw_splat: ::std::os::raw::c_int,
        block_handler: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_leaf_invokebuiltin_iseq_p(iseq: *const rb_iseq_t) -> bool;
}
extern "C" {
    pub fn rb_leaf_builtin_function(iseq: *const rb_iseq_t) -> *const rb_builtin_function;
}
extern "C" {
    pub fn rb_yjit_str_simple_append(str1: VALUE, str2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_get_ec_cfp(ec: *const rb_execution_context_t) -> *mut rb_control_frame_struct;
}
extern "C" {
    pub fn rb_get_cfp_pc(cfp: *mut rb_control_frame_struct) -> *mut VALUE;
}
extern "C" {
    pub fn rb_get_cfp_sp(cfp: *mut rb_control_frame_struct) -> *mut VALUE;
}
extern "C" {
    pub fn rb_set_cfp_pc(cfp: *mut rb_control_frame_struct, pc: *const VALUE);
}
extern "C" {
    pub fn rb_set_cfp_sp(cfp: *mut rb_control_frame_struct, sp: *mut VALUE);
}
extern "C" {
    pub fn rb_cfp_get_iseq(cfp: *mut rb_control_frame_struct) -> *mut rb_iseq_t;
}
extern "C" {
    pub fn rb_get_cfp_self(cfp: *mut rb_control_frame_struct) -> VALUE;
}
extern "C" {
    pub fn rb_get_cfp_ep(cfp: *mut rb_control_frame_struct) -> *mut VALUE;
}
extern "C" {
    pub fn rb_get_cfp_ep_level(cfp: *mut rb_control_frame_struct, lv: u32) -> *const VALUE;
}
extern "C" {
    pub fn rb_yarv_class_of(obj: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_yarv_str_eql_internal(str1: VALUE, str2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_yarv_ary_entry_internal(ary: VALUE, offset: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_yarv_fix_mod_fix(recv: VALUE, obj: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_yjit_dump_iseq_loc(iseq: *const rb_iseq_t, insn_idx: u32);
}
extern "C" {
    pub fn rb_FL_TEST(obj: VALUE, flags: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_FL_TEST_RAW(obj: VALUE, flags: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_RB_TYPE_P(obj: VALUE, t: ruby_value_type) -> bool;
}
extern "C" {
    pub fn rb_RSTRUCT_LEN(st: VALUE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rb_RSTRUCT_SET(st: VALUE, k: ::std::os::raw::c_int, v: VALUE);
}
extern "C" {
    pub fn rb_get_call_data_ci(cd: *const rb_call_data) -> *const rb_callinfo;
}
extern "C" {
    pub fn rb_BASIC_OP_UNREDEFINED_P(bop: ruby_basic_operators, klass: u32) -> bool;
}
extern "C" {
    pub fn rb_RCLASS_ORIGIN(c: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ENCODING_GET(obj: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_yjit_multi_ractor_p() -> bool;
}
extern "C" {
    pub fn rb_assert_iseq_handle(handle: VALUE);
}
extern "C" {
    pub fn rb_IMEMO_TYPE_P(imemo: VALUE, imemo_type: imemo_type) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_assert_cme_handle(handle: VALUE);
}
extern "C" {
    pub fn rb_yjit_for_each_iseq(callback: rb_iseq_callback, data: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn rb_yjit_obj_written(
        old: VALUE,
        young: VALUE,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_yjit_vm_lock_then_barrier(
        recursive_lock_level: *mut ::std::os::raw::c_uint,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_yjit_vm_unlock(
        recursive_lock_level: *mut ::std::os::raw::c_uint,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    );
}
