###nonref

= プログラム

  * ((<プログラム/式>))
  * ((<プログラム/プログラムの終り>))

プログラムは((<プログラム/式>))を並べたものです。式と式の間はセミコロ
ン(;)または改行で区切ります。ただし、バックスラッシュに続く改行は文
の区切りにならず、次の行へ継続します。

例:

   print "hello world!\n"


== 式

例:

          true
          (1+2)*3
          foo()
          if test then ok else ng end

Ruby の式には、((<変数と定数>))、さまざまな((<リテラル>))、それらの
((<演算や代入|演算子式>))、if や while などの((<制御構造>))、
((<メソッド呼び出し>))、((<クラス／メソッドの定義>))があります。

式は括弧によってグルーピングすることができます。

空の式 () は nil を返します。

Rubyの式には値を返す式と返さない式があります。

: 値を返さない式の例

    * while, until, while 修飾式, until 修飾式

また、メソッドの引数に指定できない式と指定できる式があります(このよう
な式を「文」と呼び分ける場合があります)。

: メソッドの引数に指定できない式の例

    * and, or, not
    * if/unless/rescue 修飾式, ...

メソッドの引数に指定できない式は、括弧によるグルーピングを行うことで普
通の式として使用することができます。

== プログラムの終り

Rubyインタプリタはプログラムを読みこんでいる際に以下のものに出あうとそこ
で読みこみを終了します。

    * ファイルの終り(文字列をevalしている場合は文字列の終り)

    *  (({^D}))(コントロールD) 、(({^Z}))(コントロールZ)

    *  (({__END__}))のみの行(前後に空白があると認識されません)
