= Mutex

Mutex(Mutal Exclusion = 相互排他ロック)は共有データを並行アクセスから保護する
ためにあります。Mutex の典型的な使い方は(((|m|))を
(({Mutex}))オブジェクトとします):

  m.lock
  begin
    # mによって保護されたクリティカルセクション
  ensure
    m.unlock
  end

または、より簡単に

  m.synchronize {
    # mによって保護されたクリティカルセクション
  }

== スーパークラス:

* ((<Object>))

== クラスメソッド:

--- Mutex.new
    新しい mutex を生成して返します。

== メソッド:

--- exclusive_unlock { ... }
    ロックを開放し、ロック待ちになっているスレッドを実行可能状態に
    した後、ブロックを実行します。

    ブロックの実行が終了するまで、スレッドは切り替わりません。

    (({self})) がロックされていなければ (({nil})) を返します。そうでな
    ければ(({self})) を返します。

--- lock
    mutex オブジェクトをロックします。一度に一つのス
    レッドだけが mutex をロックできます。既にロックされている mutex 
    に対してロックを行おうとしたスレッドは mutex のロックが開放さ
    れるまで、実行が停止されます。

    (({self})) を返します。

--- locked?
    mutex がロックされている時、真を返します。

--- synchronize { ... }
    mutex をロックし、ブロックを実行します。実行後に必ず mutex のロッ
    クを開放します。

--- try_lock
    mutex をロックしようとして、ロックが成功した場合、真を返しま
    す。ロックできなかった場合にはブロックせず偽を返します。

--- unlock
    mutex のロックを開放します。mutex のロック待ちになっていたスレッ
    ドの実行は再開されます。

    (({self})) がロックされていなければ (({nil})) を返します。そうでな
    ければ(({self})) を返します。
