= OpenSSL::SSL

*((<OpenSSL::SSL::SSLContext>))
*((<OpenSSL::SSL::SSLServer>))
*((<OpenSSL::SSL::SSLSocket>))

== 定数

((<OpenSSL::SSL::SSLContext#options=|OpenSSL::SSL::SSLContext/options=>)) に指定できるもの。

--- OP_ALL
--- OP_EPHEMERAL_RSA
--- OP_NETSCAPE_CA_DN_BUG
--- OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG
--- OP_NO_SSLv2
--- OP_NO_SSLv3
--- OP_NO_TLSv1
--- OP_PKCS1_CHECK_1
--- OP_PKCS1_CHECK_2
--- OP_SINGLE_DH_USE
--- OP_TLS_ROLLBACK_BUG


((<OpenSSL::SSL::SSLContext#verify_mode=|OpenSSL::SSL::SSLContext/verify_mode=>)) に指定できるもの。サーバーモードであるかクライアントモードであるかによって意味がことなる。

--- VERIFY_CLIENT_ONCE
    サーバーモード: 最初の TLS/SSL ハンドシェイクの時だけクライアントに証明書を要求する。このフラグは VERIFY_PEER フラグとともに使われなければいけない。

    クライアントモード: 無視される。

--- VERIFY_FAIL_IF_NO_PEER_CERT
    サーバーモード: クライアントが証明書を返さない場合に TLS/SSL ハンドシェイクを即座に終了させる。このフラグは VERIFY_PEER フラグとともに使われなければいけない。

    クライアントモード: 無視される。

--- VERIFY_NONE
    サーバーモード: クライアントに証明書を要求しない。

    クライアントモード: anonymous cipher を用いない場合にサーバーは証明書を送ってくる。TLS/SSL ハンドシェイクの結果は SSL_get_verify_result を使ってチェックできる。証明書の検証の結果によらずハンドシェイクは継続する。

--- VERIFY_PEER
    サーバーモード: サーバーはクライアントに証明書を要求する。送られてきた証明書は検証される。検証が失敗した場合、TLS/SSL ハンドシェイクを即座に終了させる。

    クライアントモード: サーバーの証明書を検証する。検証が失敗した場合、TLS/SSL ハンドシェイクを即座に終了させる。サーバーが証明書を返さずに、anonymous cipher を用いる場合、VERIFY_PEER は無視される。
