= WEBrick::HTTPServlet::FileHandler

通常のファイルサーバとしての機能を提供するためのサーブレット。

== クラスメソッド

--- FileHandler.new(server, root, options={}, default=Config::FileHandler)
    FileHandler サーブレットを生成する。root はサーブレットにルートディレクトリ
    として認識させる、ローカルのファイルシステムのディレクトリを文字列で与える。

    ((|config|))は設定を保存したハッシュ、
    ((|default|))にはデフォルトの設定を保存したハッシュを与える。
    デフォルト値はそれぞれ{}と((<WEBrick::HTTPServlet::FileHandler/WEBrick::Config::FileHandler>))。
== スーパークラス

((<WEBrick::HTTPServlet::AbstractServlet>))

== WEBrick::Config::FileHandler

WEBrick::HTTPServlet::FileHandler.newに与えるオプションの初期値。

  FileHandler = {
    :NondisclosureName => [".ht*", "*~"],
    :FancyIndexing     => false,
    :HandlerTable      => {},
    :HandlerCallback   => nil,
    :DirectoryCallback => nil,
    :FileCallback      => nil,
    :UserDir           => "public_html",
    :AcceptableLanguages => []  # ["en", "ja", ... ]
  }

: :AcceptableLanguages
  コンテンツの言語を選択するオプション。設定値は文字列の配列。

  クライアントからのリクエストに含まれるAccept-Languageの内容がfrで、
  かつ:AcceptableLanguagesには['ja', 'en']が設定されている場合、
  WEBrick::HTTPServlet::FileHandlerは以下の順番でファイルを探す。
  (1) index.html
  (2) index.html.fr
  (3) index.html.ja
  (4) index.html.en
: :FancyIndexing
  クライアントがディレクトリをリクエストしたが表示するファイルが無い場合の挙動を決める。
  値は真偽値。

  trueならば、代わりにファイル一覧を表示する。
  falseならばエラー(403 Forbidden)となる。
: :DirectoryCallback
: :FileCallback
: :HandlerCallback
: :HandlerTable
: :NonDisclosureName
  インデックスに表示したくないファイルの指定。値は文字列の配列。

  表示したくないファイルをワイルドカードで指定する。
: :UserDir
  ユーザ毎のドキュメントルートのディレクトリ名。値は文字列。

  ユーザfooのホームディレクトリが/home/fooで、:UserDirにpublic_htmlを設定した場合、
  クライアントから/~foo/index.htmlがリクエストされると/home/foo/public_html/index.htmlの内容を表示される。

  この設定を有効にするには以下の条件が必要。
  * ((<Etc>))モジュールが使える状態である。
  * 環境変数SCRIPT_NAMEが空(空文字列)である。
