= enumerator.so

((<Enumerable::Enumerator>))も参照してください。

このモジュールをrequireすることによって ((<Object>)) クラスと
((<Enumerable>)) モジュールに以下のメソッドが追加されます。

== Object

--- Object#to_enum(method = :each, *args)
--- Object#enum_for(method = :each, *args)
      (({Enumerable::Enumerator.new(self, method, *args)}))を返す。

        例:
            str = "xyz"

            enum = str.enum_for(:each_byte)
            a = enum.map {|b| '%02x' % b } #=> ["78", "79", "7a"]

            # protects an array from being modified
            a = [1, 2, 3]
            some_method(a.to_enum)

== Enumerable

--- Enumerable#each_slice(n) {...}
#      Iterates the given block for each slice of <n> elements.
      n要素ずつにわけてブロックに渡して繰り返す。

        例:
            (1..10).each_slice(3) {|a| p a}
            # outputs below
            [1, 2, 3]
            [4, 5, 6]
            [7, 8, 9]
            [10]

--- Enumerable#enum_slice(n)
      (({Enumerable::Enumerator.new(self, :each_slice, n)}))を返す。

--- Enumerable#each_cons(n) {...}
#      Iterates the given block for each array of consecutive <n>
#      elements.
      連続したn要素ずつの配列をブロックに渡して繰り返す。

        例:
            (1..10).each_cons(3) {|a| p a}
            # outputs below
            [1, 2, 3]
            [2, 3, 4]
            [3, 4, 5]
            [4, 5, 6]
            [5, 6, 7]
            [6, 7, 8]
            [7, 8, 9]
            [8, 9, 10]

--- Enumerable#enum_cons(n)
      (({Enumerable::Enumerator.new(self, :each_cons, n)}))を返す。

--- Enumerable#enum_with_index
      (({Enumerable::Enumerator.new(self, :each_with_index)}))を返す。
