/*
    dal.h -- device abstraction API
    Copyright (C) 2001, 2002 Yury Umanets <torque@ukrpost.net>, see COPYING for 
    licensing and copyright details.
*/

#ifndef DAL_H
#define DAL_H

#include <sys/stat.h>
#include <sys/types.h>

typedef unsigned long blk_t;

struct dal_ops;

struct dal {
    struct dal_ops *ops;
    const void *dev;
    size_t blocksize;
    int flags;
    void *data;
    blk_t len;
};

typedef struct dal dal_t;

struct dal_ops {
    blk_t (*len)(dal_t *);
    int (*read)(dal_t *, void *, blk_t, blk_t);
    int (*write)(dal_t *, void *, blk_t, blk_t);
    int (*sync)(dal_t *);
    int (*flags)(dal_t *);
    int (*equals)(dal_t *, dal_t *);
    int (*stat)(dal_t *, struct stat *);
    dev_t (*dev)(dal_t *);
};

extern void *libdal_malloc(size_t size);
extern int libdal_realloc(void **old, size_t size);
extern void libdal_free(void *ptr);

extern dal_t *dal_create(struct dal_ops *ops, const void *dev, size_t blocksize, 
    int flags, void *data);
extern void dal_free(dal_t *dal);

extern int dal_set_block_size(dal_t *dal, size_t blocksize);
extern size_t dal_block_size(dal_t *dal);

extern void dal_realize(dal_t *dal);
extern blk_t dal_len(dal_t *dal);
extern int dal_read(dal_t *dal, void *buff, blk_t block, blk_t count);
extern int dal_write(dal_t *dal, void *buff, blk_t block, blk_t count);
extern int dal_sync(dal_t *dal);
extern int dal_flags(dal_t *dal);
extern int dal_equals(dal_t *dal1, dal_t *dal2);
extern int dal_stat(dal_t *dal, struct stat *st);
extern dev_t dal_dev(dal_t *dal);

#endif
