/*
    gauge.c -- common progs gauge functions
    Copyright (C) 2001, 2002 Yury Umanets <torque@ukrpost.net>, see COPYING for 
    licensing and copyright details.
*/

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>

#include <reiserfs/gauge.h>

#define N_(String) (String)
#if ENABLE_NLS
#	include <libintl.h>
#	define _(String) dgettext (PACKAGE, String)
#else
#	define _(String) (String)
#endif

#define GAUGE_BITS_SIZE 4

static inline void progs_gauge_blit(void) {
    static short bitc = 0;
    static const char bits[] = "|/-\\";

    putc(bits[bitc], stderr);
    putc('\b', stderr);
    fflush(stderr);
    bitc++;
    bitc %= GAUGE_BITS_SIZE;
}

static void progs_gauge_header(const char *desc) {
    if (desc)
		fprintf(stderr, "\r%s: ", desc);
}

static void progs_gauge_footer(const char *desc) {
    if (desc)
		fputs(desc, stderr);
}

static void progs_gauge_handler(const char *name, unsigned int value, void *data,
    int determined, int update_header, int update_footer)
{
    if (update_header)
		progs_gauge_header(name);
    
    if (determined) {
		unsigned int i;
		char display[10] = {0};
		
		sprintf(display, "%d%%", value);
		fputs(display, stderr);
		
		for (i = 0; i < strlen(display); i++)
			fputc('\b', stderr);
    } else    
        progs_gauge_blit();
	
    if (update_footer)
		progs_gauge_footer(_("done\n"));
    
    fflush(stderr);
}

reiserfs_gauge_t *progs_gauge_create(void) {
    return libreiserfs_gauge_create(NULL, progs_gauge_handler, NULL);
}

void progs_gauge_free(reiserfs_gauge_t *gauge) {
    if (gauge)
		libreiserfs_gauge_free(gauge);
}

