/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.transport;

import gnu.classpath.jdwp.transport.ITransport;
import gnu.classpath.jdwp.transport.TransportException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

class SocketTransport
implements ITransport {
    public static final String NAME = "dt_socket";
    private static final String _PROPERTY_ADDRESS = "address";
    private static final String _PROPERTY_SERVER = "server";
    private int _port;
    private String _host;
    private boolean _server = false;
    private Socket _socket;

    SocketTransport() {
    }

    public void configure(HashMap properties) throws TransportException {
        String p = (String)properties.get(_PROPERTY_SERVER);
        if (p != null && p.toLowerCase().equals("y")) {
            this._server = true;
        }
        if ((p = (String)properties.get(_PROPERTY_ADDRESS)) != null) {
            String[] s = p.split(":");
            if (s.length == 1) {
                this._port = Integer.parseInt(s[0]);
                this._host = "localhost";
            } else {
                this._host = s[0].length() == 0 ? "localhost" : s[0];
                this._port = Integer.parseInt(s[1]);
            }
        }
    }

    public void initialize() throws TransportException {
        try {
            if (this._server) {
                ServerSocketFactory ssf = ServerSocketFactory.getDefault();
                ServerSocket ss = ssf.createServerSocket(this._port, 1);
                this._socket = ss.accept();
            } else {
                SocketFactory sf = SocketFactory.getDefault();
                this._socket = sf.createSocket(this._host, this._port);
            }
        }
        catch (IOException ioe) {
            throw new TransportException(ioe);
        }
    }

    public void shutdown() {
        try {
            this._socket.close();
        }
        catch (Throwable throwable) {}
    }

    public InputStream getInputStream() throws IOException {
        return this._socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this._socket.getOutputStream();
    }
}

