/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.awt.java2d.ActiveEdges;
import gnu.java.awt.java2d.Pixelizer;
import gnu.java.awt.java2d.PolyEdge;
import gnu.java.awt.java2d.Scanline;
import gnu.java.awt.java2d.ScanlineCoverage;
import gnu.java.math.Fixed;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;

public final class ScanlineConverter {
    private static int FIXED_DIGITS = 6;
    private static int ONE = Fixed.fixedValue(FIXED_DIGITS, 1.0f);
    private static int Y_RESOLUTION = 4;
    private int numScanlines;
    private Scanline[] scanlines = new Scanline[10];
    private int upperBounds;
    private int resolution;
    private int halfStep;
    private float[] coords = new float[6];
    private ActiveEdges activeEdges = new ActiveEdges();
    private PolyEdge edgePool;
    private PolyEdge edgePoolLast = this.edgePool = new PolyEdge();
    private int minY;
    private int maxY;
    private int minX;
    private int maxX;
    private ScanlineCoverage scanlineCoverage = new ScanlineCoverage();

    ScanlineConverter() {
    }

    public void renderShape(Pixelizer p, Shape shape, Shape clip, AffineTransform trans, int res, RenderingHints hints) {
        this.clear();
        this.setResolution(res);
        boolean haveClip = clip != null;
        float flatness = Fixed.floatValue(FIXED_DIGITS, this.resolution / 2);
        PathIterator path = shape.getPathIterator(trans, flatness);
        this.addShape(path, false);
        if (haveClip) {
            path = clip.getPathIterator(trans, flatness);
            this.addShape(path, true);
        }
        this.setUpperBounds(this.minY);
        PolyEdge edge = this.edgePool;
        while (edge != this.edgePoolLast) {
            this.addEdge(edge);
            edge = edge.poolNext;
        }
        int y = this.upperBounds;
        this.activeEdges.clear();
        Scanline scanline = null;
        int lastRealY = Fixed.intValue(FIXED_DIGITS, y);
        while (y <= this.maxY) {
            int index = this.scanlineIndex(y);
            Scanline scanline2 = scanline = index < this.scanlines.length ? this.scanlines[index] : null;
            if (scanline != null) {
                edge = scanline.getEdges();
                while (edge != null) {
                    this.activeEdges.add(edge);
                    edge = edge.scanlineNext;
                }
            }
            this.activeEdges.intersectSortAndPack(FIXED_DIGITS, y + this.halfStep);
            int realY = Fixed.intValue(FIXED_DIGITS, y + this.resolution);
            boolean push = lastRealY != realY;
            this.doScanline(p, y, push, haveClip);
            y += this.resolution;
            lastRealY = realY;
        }
    }

    private void clear() {
        this.edgePoolLast = this.edgePool;
        int i = this.scanlines.length - 1;
        while (i >= 0) {
            Scanline sl = this.scanlines[i];
            if (sl != null) {
                sl.clear();
            }
            --i;
        }
        this.scanlineCoverage.clear();
        this.minY = Integer.MAX_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
    }

    private void doScanline(Pixelizer p, int y, boolean push, boolean haveClip) {
        this.scanlineCoverage.rewind();
        boolean inClip = !haveClip;
        boolean inShape = false;
        PolyEdge lastEdge = null;
        int numEdges = this.activeEdges.getNumActiveEdges();
        int i = 0;
        while (i < numEdges) {
            PolyEdge edge = this.activeEdges.getActiveEdge(i);
            if (inClip && inShape) {
                assert (lastEdge != null);
                int x0 = lastEdge.xIntersection;
                int x1 = edge.xIntersection;
                assert (x0 <= x1);
                int pix0 = Fixed.intValue(FIXED_DIGITS, x0);
                int pix1 = Fixed.intValue(FIXED_DIGITS, x1);
                int frac0 = ONE - Fixed.trunc(FIXED_DIGITS, x0);
                int frac1 = ONE - Fixed.trunc(FIXED_DIGITS, x1);
                this.scanlineCoverage.add(pix0, 1 * (1 << Y_RESOLUTION), frac0 >>= FIXED_DIGITS - Y_RESOLUTION);
                this.scanlineCoverage.add(pix1, -1 * (1 << Y_RESOLUTION), -(frac1 >>= FIXED_DIGITS - Y_RESOLUTION));
            }
            if (edge.isClip) {
                inClip = !inClip;
            } else {
                inShape = !inShape;
            }
            lastEdge = edge;
            ++i;
        }
        if (push && !this.scanlineCoverage.isEmpty()) {
            p.renderScanline(Fixed.intValue(FIXED_DIGITS, y), this.scanlineCoverage);
            this.scanlineCoverage.clear();
        }
    }

    private void setResolution(int res) {
        int scanlinesPerPixel = 1 << res;
        int one = Fixed.fixedValue(FIXED_DIGITS, 1.0f);
        this.resolution = one / scanlinesPerPixel;
        this.halfStep = this.resolution / 2;
        this.scanlineCoverage.setMaxCoverage(scanlinesPerPixel << Y_RESOLUTION);
    }

    private void setUpperBounds(int y0) {
        this.upperBounds = this.fit(y0);
    }

    private void addShape(PathIterator path, boolean clip) {
        int startX = 0;
        int startY = 0;
        int lastX = 0;
        int lastY = 0;
        while (!path.isDone()) {
            int type = path.currentSegment(this.coords);
            switch (type) {
                case 0: {
                    startX = lastX = Fixed.fixedValue(FIXED_DIGITS, this.coords[0]);
                    startY = lastY = Fixed.fixedValue(FIXED_DIGITS, this.coords[1]);
                    this.minY = Math.min(startY, this.minY);
                    this.maxY = Math.max(startY, this.maxY);
                    this.minX = Math.min(startX, this.minX);
                    this.maxX = Math.max(startX, this.maxX);
                    break;
                }
                case 1: {
                    int x = Fixed.fixedValue(FIXED_DIGITS, this.coords[0]);
                    int y = Fixed.fixedValue(FIXED_DIGITS, this.coords[1]);
                    this.edgePoolAdd(lastX, lastY, x, y, clip);
                    lastX = x;
                    lastY = y;
                    this.minY = Math.min(lastY, this.minY);
                    this.maxY = Math.max(lastY, this.maxY);
                    this.minX = Math.min(lastX, this.minX);
                    this.maxX = Math.max(lastX, this.maxX);
                    break;
                }
                case 4: {
                    this.edgePoolAdd(lastX, lastY, startX, startY, clip);
                    lastX = startX;
                    lastY = startY;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            path.next();
        }
    }

    private void addEdge(PolyEdge edge) {
        int upper = Math.min(edge.y0, edge.y1);
        int index = this.scanlineIndex(upper);
        if (index >= this.scanlines.length) {
            int oldSize = this.scanlines.length;
            int newSize = Math.max(oldSize + oldSize / 2 + 1, index + 10);
            Scanline[] newScanlines = new Scanline[newSize];
            System.arraycopy(this.scanlines, 0, newScanlines, 0, oldSize);
            this.scanlines = newScanlines;
        }
        if (this.scanlines[index] == null) {
            this.scanlines[index] = new Scanline();
        }
        this.scanlines[index].addEdge(edge);
    }

    private int fit(int y) {
        int val1 = Fixed.div(FIXED_DIGITS, y, this.resolution);
        int rounded = Fixed.round(FIXED_DIGITS, val1);
        return Fixed.mul(FIXED_DIGITS, rounded, this.resolution);
    }

    private int scanlineIndex(int y) {
        int fitted = this.fit(y);
        return (fitted - this.upperBounds) / this.resolution;
    }

    private void edgePoolAdd(int x0, int y0, int x1, int y1, boolean clip) {
        if (y0 != y1) {
            this.edgePoolLast.init(FIXED_DIGITS, x0, y0, x1, y1, clip);
            if (this.edgePoolLast.poolNext == null) {
                this.edgePoolLast.poolNext = new PolyEdge();
            }
            this.edgePoolLast = this.edgePoolLast.poolNext;
        }
    }
}

