/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.prefs;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class NodeWriter {
    private final Preferences prefs;
    private final BufferedWriter bw;
    private boolean subtree;

    public NodeWriter(Preferences prefs, OutputStream os) {
        OutputStreamWriter w;
        this.prefs = prefs;
        try {
            w = new OutputStreamWriter(os, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            InternalError ie = new InternalError("UTF-8 encoding missing");
            ie.initCause(uee);
            throw ie;
        }
        this.bw = new BufferedWriter(w);
    }

    public void writePrefsTree() throws BackingStoreException, IOException {
        this.subtree = true;
        this.writeHeader();
        this.writePreferences();
        this.bw.flush();
    }

    public void writePrefs() throws BackingStoreException, IOException {
        this.subtree = false;
        this.writeHeader();
        this.writePreferences();
        this.bw.flush();
    }

    private void writeHeader() throws BackingStoreException, IOException {
        this.bw.write("<?xml version=\"1.0\"?>");
        this.bw.newLine();
        this.bw.write("<!DOCTYPE preferences SYSTEM \"http://java.sun.com/dtd/preferences.dtd\">");
        this.bw.newLine();
        this.bw.newLine();
        this.bw.write("<!-- GNU Classpath java.util.prefs Preferences ");
        if (this.prefs.isUserNode()) {
            this.bw.write("user");
        } else {
            this.bw.write("system");
        }
        if (this.prefs.parent() == null) {
            this.bw.write(" root");
        }
        if (this.subtree) {
            this.bw.write(" tree");
        } else {
            this.bw.write(" node");
        }
        if (this.prefs.parent() != null) {
            this.bw.newLine();
            this.bw.write("     '");
            this.bw.write(this.prefs.absolutePath());
            this.bw.write(39);
            this.bw.newLine();
        }
        this.bw.write(" -->");
        this.bw.newLine();
        this.bw.newLine();
    }

    private void writePreferences() throws BackingStoreException, IOException {
        this.bw.write("<preferences>");
        this.bw.newLine();
        this.writeRoot();
        this.bw.write("</preferences>");
        this.bw.newLine();
    }

    private void writeRoot() throws BackingStoreException, IOException {
        this.bw.write("  <root type=\"");
        if (this.prefs.isUserNode()) {
            this.bw.write("user");
        } else {
            this.bw.write("system");
        }
        this.bw.write("\">");
        this.writeRootMap();
        this.writeNode();
        this.bw.write("  </root>");
        this.bw.newLine();
    }

    private void writeRootMap() throws BackingStoreException, IOException {
        if (this.prefs.parent() == null && this.prefs.keys().length > 0) {
            this.bw.newLine();
            this.writeMap(this.prefs, 2);
        } else {
            this.bw.write("<map/>");
            this.bw.newLine();
        }
    }

    private int writeParents() throws IOException {
        int parents;
        String path = this.prefs.absolutePath();
        int lastslash = path.lastIndexOf("/");
        if (lastslash > 0) {
            path = path.substring(1, lastslash);
            StringTokenizer st = new StringTokenizer(path);
            parents = st.countTokens();
            int i = 0;
            while (i < parents) {
                String name = st.nextToken();
                this.indent(i + 2);
                this.bw.write("<node name=\"" + name + "\">");
                this.bw.write("<map/>");
                this.bw.write("</node>");
                this.bw.newLine();
                ++i;
            }
        } else {
            parents = 0;
        }
        return parents;
    }

    private void writeCloseParents(int parents) throws IOException {
        while (parents > 0) {
            this.indent(parents + 1);
            this.bw.write("</node>");
            this.bw.newLine();
            --parents;
        }
    }

    private void writeNode() throws BackingStoreException, IOException {
        int parents = this.writeParents();
        int indent = this.prefs.parent() == null ? parents + 1 : parents + 2;
        this.writeNode(this.prefs, indent);
        this.writeCloseParents(parents);
    }

    private void writeNode(Preferences node2, int indent) throws BackingStoreException, IOException {
        if (node2.parent() != null) {
            this.indent(indent);
            this.bw.write("<node name=\"" + node2.name() + "\">");
            if (node2.keys().length > 0) {
                this.bw.newLine();
            }
            this.writeMap(node2, indent + 1);
        }
        if (this.subtree) {
            String[] children = node2.childrenNames();
            int i = 0;
            while (i < children.length) {
                Preferences child = node2.node(children[i]);
                this.writeNode(child, indent + 1);
                ++i;
            }
        }
        if (node2.parent() != null) {
            this.indent(indent);
            this.bw.write("</node>");
            this.bw.newLine();
        }
    }

    private void writeMap(Preferences node2, int indent) throws BackingStoreException, IOException {
        StringBuffer indentBuffer = new StringBuffer(2 * indent);
        int i = 0;
        while (i < indent) {
            indentBuffer.append("  ");
            ++i;
        }
        String indentString = indentBuffer.toString();
        if (node2.keys().length > 0) {
            this.bw.write(indentString);
            this.bw.write("<map>");
            this.bw.newLine();
            this.writeEntries(node2, String.valueOf(indentString) + "  ");
            this.bw.write(indentString);
            this.bw.write("</map>");
        } else {
            this.bw.write("<map/>");
        }
        this.bw.newLine();
    }

    private void writeEntries(Preferences node2, String indent) throws BackingStoreException, IOException {
        String[] keys = node2.keys();
        int i = 0;
        while (i < keys.length) {
            String value = node2.get(keys[i], null);
            if (value == null) {
                throw new BackingStoreException("null value for key '" + keys[i] + "'");
            }
            this.bw.write(indent);
            this.bw.write("<entry key=\"" + keys[i] + "\"" + " value=\"" + value + "\"/>");
            this.bw.newLine();
            ++i;
        }
    }

    private void indent(int x) throws IOException {
        int i = 0;
        while (i < x) {
            this.bw.write("  ");
            ++i;
        }
    }
}

