/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import java.io.Serializable;

abstract class REToken
implements Serializable,
Cloneable {
    protected REToken next = null;
    protected REToken uncle = null;
    protected int subIndex;
    protected boolean unicodeAware = true;

    public Object clone() {
        try {
            REToken copy = (REToken)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    protected REToken(int subIndex) {
        this.subIndex = subIndex;
    }

    int getMinimumLength() {
        return 0;
    }

    int getMaximumLength() {
        return Integer.MAX_VALUE;
    }

    void setUncle(REToken anUncle) {
        this.uncle = anUncle;
    }

    boolean match(CharIndexed input, REMatch mymatch) {
        return this.match(input, mymatch, false);
    }

    boolean matchFake(CharIndexed input, REMatch mymatch) {
        return this.match(input, mymatch, true);
    }

    private boolean match(CharIndexed input, REMatch mymatch, boolean fake) {
        REMatch m;
        if (!fake) {
            this.setHitEnd(input, mymatch);
        }
        if ((m = this.matchThis(input, mymatch)) == null) {
            return false;
        }
        if (this.next(input, m)) {
            mymatch.assignFrom(m);
            return true;
        }
        return false;
    }

    void setHitEnd(CharIndexed input, REMatch mymatch) {
        input.setHitEnd(mymatch);
    }

    REMatch matchThis(CharIndexed input, REMatch mymatch) {
        throw new UnsupportedOperationException("This REToken does not have a matchThis method");
    }

    protected boolean next(CharIndexed input, REMatch mymatch) {
        REToken nextToken = this.getNext();
        if (nextToken == null) {
            return true;
        }
        return nextToken.match(input, mymatch);
    }

    REToken getNext() {
        return this.next != null ? this.next : this.uncle;
    }

    REMatch findMatch(CharIndexed input, REMatch mymatch) {
        boolean b = this.match(input, mymatch);
        if (b) {
            return mymatch;
        }
        return null;
    }

    boolean returnsFixedLengthMatches() {
        return false;
    }

    int findFixedLengthMatches(CharIndexed input, REMatch mymatch, int max) {
        throw new UnsupportedOperationException("This token does not support findFixedLengthMatches");
    }

    REMatch backtrack(CharIndexed input, REMatch mymatch, Object param) {
        throw new IllegalStateException("This token cannot be backtracked to");
    }

    boolean chain(REToken token) {
        this.next = token;
        return true;
    }

    abstract void dump(StringBuffer var1);

    void dumpAll(StringBuffer os) {
        this.dump(os);
        if (this.next != null) {
            this.next.dumpAll(os);
        }
    }

    public String toString() {
        StringBuffer os = new StringBuffer();
        this.dump(os);
        return os.toString();
    }

    public static char toLowerCase(char ch, boolean unicodeAware) {
        if (unicodeAware) {
            return Character.toLowerCase(ch);
        }
        if (ch >= 'A' && ch <= 'Z') {
            return (char)(ch + 97 - 65);
        }
        return ch;
    }

    public static char toUpperCase(char ch, boolean unicodeAware) {
        if (unicodeAware) {
            return Character.toUpperCase(ch);
        }
        if (ch >= 'a' && ch <= 'z') {
            return (char)(ch + 65 - 97);
        }
        return ch;
    }
}

