/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.dom;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathResult;

class GnomeXPathResult
implements XPathResult {
    final Object obj;

    GnomeXPathResult(Object obj) {
        this.obj = obj;
    }

    protected void finalize() {
        this.free(this.obj);
    }

    private native void free(Object var1);

    public native short getResultType();

    public native double getNumberValue() throws XPathException;

    public native String getStringValue() throws XPathException;

    public native boolean getBooleanValue() throws XPathException;

    public native Node getSingleNodeValue() throws XPathException;

    public native boolean getInvalidIteratorState();

    public native int getSnapshotLength() throws XPathException;

    public native Node iterateNext() throws XPathException, DOMException;

    public native Node snapshotItem(int var1) throws XPathException;

    public String toString() {
        short type = this.getResultType();
        switch (type) {
            case 2: {
                return this.getStringValue();
            }
            case 1: {
                return new Double(this.getNumberValue()).toString();
            }
            case 3: {
                return Boolean.valueOf(this.getBooleanValue()).toString();
            }
            case 6: {
                int len = this.getSnapshotLength();
                switch (len) {
                    case 0: {
                        return "[no matches]";
                    }
                    case 1: {
                        return this.getSingleNodeValue().toString();
                    }
                }
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < len) {
                    if (i > 0) {
                        buffer.append(',');
                    }
                    buffer.append(this.snapshotItem(i));
                    ++i;
                }
                return buffer.toString();
            }
        }
        return String.valueOf(this.getClass().getName()) + "[type=" + type + ",length=" + this.getSnapshotLength() + ']';
    }
}

