/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.pipeline.NSFilter;
import gnu.xml.pipeline.PipelineFactory;
import gnu.xml.pipeline.TeeConsumer;
import gnu.xml.pipeline.ValidationConsumer;
import gnu.xml.pipeline.WellFormednessFilter;
import gnu.xml.util.Resolver;
import java.io.IOException;
import java.net.MalformedURLException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class DoParse {
    private static SAXParseException fatal;
    private static int errorCount;
    private static int fatalCount;

    private DoParse() {
    }

    public static void main(String[] argv) throws IOException {
        int exitStatus = 1;
        if (argv.length != 2) {
            System.err.println("Usage: DoParse [filename|URL] pipeline-spec");
            System.err.println("Example pipeline specs:");
            System.err.println("  'nsfix | validate'");
            System.err.println("       ... restore namespace syntax, validate");
            System.err.println("  'nsfix | write ( stdout )'");
            System.err.println("       ... restore namespace syntax, write to stdout as XML");
            System.exit(1);
        }
        try {
            argv[0] = Resolver.getURL(argv[0]);
            InputSource input = new InputSource(argv[0]);
            XMLReader producer = XMLReaderFactory.createXMLReader();
            EventConsumer consumer = PipelineFactory.createPipeline(argv[1]);
            producer.setErrorHandler(new MyErrorHandler());
            EventFilter.bind(producer, consumer);
            producer.parse(input);
            try {
                if (producer.getFeature("http://org.xml/sax/features/validation")) {
                    exitStatus = errorCount + fatalCount > 0 ? 1 : 0;
                } else if (fatalCount == 0) {
                    exitStatus = 0;
                }
            }
            catch (SAXException sAXException) {
                if (DoParse.hasValidator(consumer)) {
                    exitStatus = errorCount + fatalCount > 0 ? 1 : 0;
                } else if (fatalCount == 0) {
                    exitStatus = 0;
                }
            }
        }
        catch (MalformedURLException e) {
            System.err.println("** Malformed URL: " + e.getMessage());
            System.err.println("Is '" + argv[0] + "' a non-existent file?");
            e.printStackTrace();
        }
        catch (SAXParseException e) {
            if (e != fatal) {
                System.err.print(DoParse.printParseException("Parsing Aborted", e));
                e.printStackTrace();
                if (e.getException() != null) {
                    System.err.println("++ Wrapped exception:");
                    e.getException().printStackTrace();
                }
            }
        }
        catch (SAXException e) {
            Exception x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            x.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(exitStatus);
    }

    private static boolean hasValidator(EventConsumer e) {
        if (e == null) {
            return false;
        }
        if (e instanceof ValidationConsumer) {
            return true;
        }
        if (e instanceof TeeConsumer) {
            TeeConsumer t = (TeeConsumer)e;
            return DoParse.hasValidator(t.getFirst()) || DoParse.hasValidator(t.getRest());
        }
        if (e instanceof WellFormednessFilter || e instanceof NSFilter) {
            return DoParse.hasValidator(((EventFilter)e).getNext());
        }
        return false;
    }

    private static String printParseException(String label, SAXParseException e) {
        int temp;
        StringBuffer buf = new StringBuffer();
        buf.append("** ");
        buf.append(label);
        buf.append(": ");
        buf.append(e.getMessage());
        buf.append('\n');
        if (e.getSystemId() != null) {
            buf.append("   URI:  ");
            buf.append(e.getSystemId());
            buf.append('\n');
        }
        if ((temp = e.getLineNumber()) != -1) {
            buf.append("   line: ");
            buf.append(temp);
            buf.append('\n');
        }
        if ((temp = e.getColumnNumber()) != -1) {
            buf.append("   char: ");
            buf.append(temp);
            buf.append('\n');
        }
        return buf.toString();
    }

    static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler() {
        }

        public void error(SAXParseException e) throws SAXParseException {
            errorCount = errorCount + 1;
            System.err.print(DoParse.printParseException("Error", e));
        }

        public void warning(SAXParseException e) throws SAXParseException {
        }

        public void fatalError(SAXParseException e) throws SAXParseException {
            fatalCount = fatalCount + 1;
            if (fatal == null) {
                fatal = e;
            }
            System.err.print(DoParse.printParseException("Nonrecoverable Error", e));
        }
    }
}

