/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;

public final class SocketPermission
extends Permission
implements Serializable {
    static final long serialVersionUID = -7204263841984476862L;
    private transient String hostname = null;
    private transient InetAddress address = null;
    private transient int minport;
    private transient int maxport;
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = Integer.MAX_VALUE;
    private String actions;
    private transient int actionmask;
    private static final String[] ACTIONS = new String[]{"connect", "listen", "accept", "resolve"};

    public SocketPermission(String hostport, String actions) {
        super(SocketPermission.processHostport(hostport));
        this.setHostPort(this.getName());
        this.setActions(actions);
    }

    private static String processHostport(String hostport) {
        if (hostport.length() == 0) {
            return "localhost";
        }
        if (hostport.charAt(0) == '[') {
            return hostport;
        }
        int colons = 0;
        boolean colon_allowed = true;
        int i = 0;
        while (i < hostport.length()) {
            if (hostport.charAt(i) == ':') {
                if (!colon_allowed) {
                    throw new IllegalArgumentException("Ambiguous hostport part");
                }
                ++colons;
                colon_allowed = false;
            } else {
                colon_allowed = true;
            }
            ++i;
        }
        switch (colons) {
            case 0: 
            case 1: {
                return hostport;
            }
            case 7: {
                return "[" + hostport + "]";
            }
            case 8: {
                int last_colon = hostport.lastIndexOf(58);
                return "[" + hostport.substring(0, last_colon) + "]" + hostport.substring(last_colon);
            }
        }
        throw new IllegalArgumentException("Ambiguous hostport part");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setHostPort(String hostport) {
        int sep;
        String ports;
        if (hostport.charAt(0) == '[') {
            int end = hostport.indexOf("]");
            if (end == -1) {
                throw new IllegalArgumentException("Unmatched '['");
            }
            String host = hostport.substring(1, end);
            this.address = InetAddress.getByLiteral(host);
            if (this.address == null) {
                throw new IllegalArgumentException("Bad IPv6 address");
            }
            if (end == hostport.length() - 1) {
                ports = "";
            } else {
                if (hostport.charAt(end + 1) != ':') throw new IllegalArgumentException("Bad character after ']'");
                ports = hostport.substring(end + 2);
            }
        } else {
            String host;
            sep = hostport.indexOf(":");
            if (sep == -1) {
                host = hostport;
                ports = "";
            } else {
                host = hostport.substring(0, sep);
                ports = hostport.substring(sep + 1);
            }
            this.address = InetAddress.getByLiteral(host);
            if (this.address == null) {
                if (host.lastIndexOf(42) > 0) {
                    throw new IllegalArgumentException("Bad hostname");
                }
                this.hostname = host;
            }
        }
        if (ports.length() == 0) {
            this.minport = 0;
            this.maxport = Integer.MAX_VALUE;
            return;
        } else {
            sep = ports.indexOf("-");
            if (sep == -1) {
                this.minport = this.maxport = Integer.parseInt(ports);
                return;
            } else {
                if (ports.indexOf("-", sep + 1) != -1) {
                    throw new IllegalArgumentException("Unexpected '-'");
                }
                if (sep == 0) {
                    this.minport = 0;
                    this.maxport = Integer.parseInt(ports.substring(1));
                    return;
                } else if (sep == ports.length() - 1) {
                    this.minport = Integer.parseInt(ports.substring(0, ports.length() - 1));
                    this.maxport = Integer.MAX_VALUE;
                    return;
                } else {
                    this.minport = Integer.parseInt(ports.substring(0, sep));
                    this.maxport = Integer.parseInt(ports.substring(sep + 1));
                }
            }
        }
    }

    private void setActions(String actionstring) {
        this.actionmask = 0;
        boolean resolve_needed = false;
        boolean resolve_present = false;
        StringTokenizer t = new StringTokenizer(actionstring, ",");
        while (t.hasMoreTokens()) {
            String action = t.nextToken();
            action = action.trim().toLowerCase();
            this.setAction(action);
            if (action.equals("resolve")) {
                resolve_present = true;
                continue;
            }
            resolve_needed = true;
        }
        if (resolve_needed && !resolve_present) {
            this.setAction("resolve");
        }
    }

    private void setAction(String action) {
        int i = 0;
        while (i < ACTIONS.length) {
            if (action.equals(ACTIONS[i])) {
                this.actionmask |= 1 << i;
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown action " + action);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SocketPermission)) {
            return false;
        }
        SocketPermission p = (SocketPermission)obj;
        if (p.actionmask != this.actionmask || p.minport != this.minport || p.maxport != this.maxport) {
            return false;
        }
        if (this.address != null) {
            if (p.address == null) {
                return false;
            }
            return p.address.equals(this.address);
        }
        if (p.hostname == null) {
            return false;
        }
        return p.hostname.equals(this.hostname);
    }

    public int hashCode() {
        int code = this.actionmask + this.minport + this.maxport;
        code = this.address != null ? (code += this.address.hashCode()) : (code += this.hostname.hashCode());
        return code;
    }

    public String getActions() {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < ACTIONS.length) {
            if ((this.actionmask & 1 << i) != 0) {
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(ACTIONS[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }

    private InetAddress[] getAddresses() {
        if (this.address != null) {
            return new InetAddress[]{this.address};
        }
        try {
            return InetAddress.getAllByName(this.hostname);
        }
        catch (UnknownHostException unknownHostException) {
            return new InetAddress[0];
        }
    }

    private String getCanonicalHostName() {
        if (this.address != null) {
            return this.address.internalGetCanonicalHostName();
        }
        if (this.hostname.charAt(0) == '*') {
            return null;
        }
        try {
            return InetAddress.getByName(this.hostname).internalGetCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public boolean implies(Permission perm) {
        String canon;
        InetAddress[] addrs;
        if (!(perm instanceof SocketPermission)) {
            return false;
        }
        SocketPermission p = (SocketPermission)perm;
        if (p.hostname != null && p.hostname.length() == 0) {
            return false;
        }
        if ((p.actionmask & this.actionmask) != p.actionmask) {
            return false;
        }
        if (p.minport < this.minport || p.maxport > this.maxport) {
            return false;
        }
        String p_canon = null;
        if (this.address != null) {
            addrs = p.getAddresses();
            int i = 0;
            while (i < addrs.length) {
                if (this.address.equals(addrs[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (this.hostname != null && this.hostname.charAt(0) == '*' && (p_canon = p.getCanonicalHostName()) != null && p_canon.endsWith(this.hostname.substring(1))) {
            return true;
        }
        if (this.address == null) {
            addrs = p.getAddresses();
            InetAddress[] p_addrs = p.getAddresses();
            int i = 0;
            while (i < addrs.length) {
                int j = 0;
                while (j < p_addrs.length) {
                    if (addrs[i].equals(p_addrs[j])) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if ((canon = this.getCanonicalHostName()) != null) {
            if (p_canon == null) {
                p_canon = p.getCanonicalHostName();
            }
            if (p_canon != null && canon.equals(p_canon)) {
                return true;
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.setHostPort(this.getName());
        this.setActions(this.actions);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        this.actions = this.getActions();
        output.defaultWriteObject();
    }
}

