/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteBufferImpl;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBufferImpl;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteBuffer
extends Buffer
implements Comparable<ByteBuffer> {
    ByteOrder endian = ByteOrder.BIG_ENDIAN;
    int array_offset;
    byte[] backing_buffer;

    ByteBuffer(int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
    }

    public static ByteBuffer allocateDirect(int capacity) {
        return DirectByteBufferImpl.allocate(capacity);
    }

    public static ByteBuffer allocate(int capacity) {
        return ByteBuffer.wrap(new byte[capacity], 0, capacity);
    }

    public static final ByteBuffer wrap(byte[] array, int offset, int length) {
        return new ByteBufferImpl(array, 0, array.length, offset + length, offset, -1, false);
    }

    public static final ByteBuffer wrap(byte[] array) {
        return ByteBuffer.wrap(array, 0, array.length);
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        ByteBuffer.checkArraySize(dst.length, offset, length);
        this.checkForUnderflow(length);
        int i = offset;
        while (i < offset + length) {
            dst[i] = this.get();
            ++i;
        }
        return this;
    }

    public ByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public ByteBuffer put(ByteBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(src.remaining());
        if (src.remaining() > 0) {
            byte[] toPut = new byte[src.remaining()];
            src.get(toPut);
            this.put(toPut);
        }
        return this;
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        ByteBuffer.checkArraySize(src.length, offset, length);
        this.checkForOverflow(length);
        int i = offset;
        while (i < offset + length) {
            this.put(src[i]);
            ++i;
        }
        return this;
    }

    public final ByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final byte[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int hashCode = this.get(this.position()) + 31;
        int multiplier = 1;
        int i = this.position() + 1;
        while (i < this.limit()) {
            hashCode += (this.get(i) + 30) * (multiplier *= 31);
            ++i;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteBuffer) {
            return this.compareTo((ByteBuffer)obj) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(ByteBuffer other) {
        int num = Math.min(this.remaining(), other.remaining());
        int pos_this = this.position();
        int pos_other = other.position();
        int count = 0;
        while (count < num) {
            byte b;
            byte a;
            if ((a = this.get(pos_this++)) != (b = other.get(pos_other++))) {
                if (a < b) {
                    return -1;
                }
                return 1;
            }
            ++count;
        }
        return this.remaining() - other.remaining();
    }

    public final ByteOrder order() {
        return this.endian;
    }

    public final ByteBuffer order(ByteOrder endian) {
        this.endian = endian;
        return this;
    }

    public abstract byte get();

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract ByteBuffer put(int var1, byte var2);

    public abstract ByteBuffer compact();

    void shiftDown(int dst_offset, int src_offset, int count) {
        int i = 0;
        while (i < count) {
            this.put(dst_offset + i, this.get(src_offset + i));
            ++i;
        }
    }

    public abstract boolean isDirect();

    public abstract ByteBuffer slice();

    public abstract ByteBuffer duplicate();

    public abstract ByteBuffer asReadOnlyBuffer();

    public abstract ShortBuffer asShortBuffer();

    public abstract CharBuffer asCharBuffer();

    public abstract IntBuffer asIntBuffer();

    public abstract LongBuffer asLongBuffer();

    public abstract FloatBuffer asFloatBuffer();

    public abstract DoubleBuffer asDoubleBuffer();

    public abstract char getChar();

    public abstract ByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract short getShort();

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract int getInt();

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract long getLong();

    public abstract ByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract double getDouble();

    public abstract ByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + "]";
    }
}

