/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.gcj.RawData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.CharBuffer;
import java.nio.CharViewBufferImpl;
import java.nio.DirectByteBufferImpl;
import java.nio.DoubleBuffer;
import java.nio.DoubleViewBufferImpl;
import java.nio.FloatBuffer;
import java.nio.FloatViewBufferImpl;
import java.nio.IntBuffer;
import java.nio.IntViewBufferImpl;
import java.nio.LongBuffer;
import java.nio.LongViewBufferImpl;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.ShortViewBufferImpl;
import java.nio.VMDirectByteBuffer;

final class MappedByteBufferImpl
extends MappedByteBuffer {
    boolean readOnly;
    public RawData implPtr;
    public long implLen;

    public MappedByteBufferImpl(RawData address, int size, boolean readOnly) throws IOException {
        super(size, size, 0, -1);
        this.address = address;
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public byte get() {
        this.checkForUnderflow();
        int pos = this.position();
        byte result = VMDirectByteBuffer.get(this.address, pos);
        this.position(pos + 1);
        return result;
    }

    public ByteBuffer put(byte value) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        int pos = this.position();
        VMDirectByteBuffer.put(this.address, pos, value);
        this.position(pos + 1);
        return this;
    }

    public byte get(int index) {
        this.checkIndex(index);
        return VMDirectByteBuffer.get(this.address, index);
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        MappedByteBufferImpl.checkArraySize(dst.length, offset, length);
        this.checkForUnderflow(length);
        int index = this.position();
        VMDirectByteBuffer.get(this.address, index, dst, offset, length);
        this.position(index + length);
        return this;
    }

    public ByteBuffer put(int index, byte value) {
        this.checkIfReadOnly();
        this.checkIndex(index);
        VMDirectByteBuffer.put(this.address, index, value);
        return this;
    }

    public ByteBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int pos = this.position();
        if (pos > 0) {
            int count = this.remaining();
            VMDirectByteBuffer.shiftDown(this.address, 0, pos, count);
            this.position(count);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public ByteBuffer slice() {
        int rem = this.remaining();
        if (this.isReadOnly()) {
            return new DirectByteBufferImpl.ReadOnly(this, VMDirectByteBuffer.adjustAddress(this.address, this.position()), rem, rem, 0);
        }
        return new DirectByteBufferImpl.ReadWrite(this, VMDirectByteBuffer.adjustAddress(this.address, this.position()), rem, rem, 0);
    }

    private ByteBuffer duplicate(boolean readOnly) {
        int pos = this.position();
        this.reset();
        int mark = this.position();
        this.position(pos);
        DirectByteBufferImpl result = readOnly ? new DirectByteBufferImpl.ReadOnly(this, this.address, this.capacity(), this.limit(), pos) : new DirectByteBufferImpl.ReadWrite(this, this.address, this.capacity(), this.limit(), pos);
        if (mark != pos) {
            result.position(mark);
            result.mark();
            result.position(pos);
        }
        return result;
    }

    public ByteBuffer duplicate() {
        return this.duplicate(this.isReadOnly());
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public CharBuffer asCharBuffer() {
        return new CharViewBufferImpl(this, this.remaining() >> 1);
    }

    public ShortBuffer asShortBuffer() {
        return new ShortViewBufferImpl(this, this.remaining() >> 1);
    }

    public IntBuffer asIntBuffer() {
        return new IntViewBufferImpl(this, this.remaining() >> 2);
    }

    public LongBuffer asLongBuffer() {
        return new LongViewBufferImpl(this, this.remaining() >> 3);
    }

    public FloatBuffer asFloatBuffer() {
        return new FloatViewBufferImpl(this, this.remaining() >> 2);
    }

    public DoubleBuffer asDoubleBuffer() {
        return new DoubleViewBufferImpl(this, this.remaining() >> 3);
    }

    public char getChar() {
        return ByteBufferHelper.getChar(this, this.order());
    }

    public ByteBuffer putChar(char value) {
        ByteBufferHelper.putChar(this, value, this.order());
        return this;
    }

    public char getChar(int index) {
        return ByteBufferHelper.getChar(this, index, this.order());
    }

    public ByteBuffer putChar(int index, char value) {
        ByteBufferHelper.putChar(this, index, value, this.order());
        return this;
    }

    public short getShort() {
        return ByteBufferHelper.getShort(this, this.order());
    }

    public ByteBuffer putShort(short value) {
        ByteBufferHelper.putShort(this, value, this.order());
        return this;
    }

    public short getShort(int index) {
        return ByteBufferHelper.getShort(this, index, this.order());
    }

    public ByteBuffer putShort(int index, short value) {
        ByteBufferHelper.putShort(this, index, value, this.order());
        return this;
    }

    public int getInt() {
        return ByteBufferHelper.getInt(this, this.order());
    }

    public ByteBuffer putInt(int value) {
        ByteBufferHelper.putInt(this, value, this.order());
        return this;
    }

    public int getInt(int index) {
        return ByteBufferHelper.getInt(this, index, this.order());
    }

    public ByteBuffer putInt(int index, int value) {
        ByteBufferHelper.putInt(this, index, value, this.order());
        return this;
    }

    public long getLong() {
        return ByteBufferHelper.getLong(this, this.order());
    }

    public ByteBuffer putLong(long value) {
        ByteBufferHelper.putLong(this, value, this.order());
        return this;
    }

    public long getLong(int index) {
        return ByteBufferHelper.getLong(this, index, this.order());
    }

    public ByteBuffer putLong(int index, long value) {
        ByteBufferHelper.putLong(this, index, value, this.order());
        return this;
    }

    public float getFloat() {
        return ByteBufferHelper.getFloat(this, this.order());
    }

    public ByteBuffer putFloat(float value) {
        ByteBufferHelper.putFloat(this, value, this.order());
        return this;
    }

    public float getFloat(int index) {
        return ByteBufferHelper.getFloat(this, index, this.order());
    }

    public ByteBuffer putFloat(int index, float value) {
        ByteBufferHelper.putFloat(this, index, value, this.order());
        return this;
    }

    public double getDouble() {
        return ByteBufferHelper.getDouble(this, this.order());
    }

    public ByteBuffer putDouble(double value) {
        ByteBufferHelper.putDouble(this, value, this.order());
        return this;
    }

    public double getDouble(int index) {
        return ByteBufferHelper.getDouble(this, index, this.order());
    }

    public ByteBuffer putDouble(int index, double value) {
        ByteBufferHelper.putDouble(this, index, value, this.order());
        return this;
    }

    native void unmapImpl();

    native boolean isLoadedImpl();

    native void loadImpl();

    native void forceImpl();
}

