/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.logging.XMLFormatter;

public class FileHandler
extends StreamHandler {
    private static final String PROPERTY_PREFIX = "java.util.logging.FileHandler";
    private static final String PATTERN_KEY = "java.util.logging.FileHandler.pattern";
    private static final String DEFAULT_PATTERN = "%h/java%u.log";
    private static final String LIMIT_KEY = "java.util.logging.FileHandler.limit";
    private static final int DEFAULT_LIMIT = 0;
    private static final String COUNT_KEY = "java.util.logging.FileHandler.count";
    private static final int DEFAULT_COUNT = 1;
    private static final String APPEND_KEY = "java.util.logging.FileHandler.append";
    private static final boolean DEFAULT_APPEND = false;
    private final int limit;
    private final int count;
    private final String pattern;
    private final boolean append;
    long written;
    private LinkedList logFiles;

    public FileHandler() throws IOException, SecurityException {
        this(LogManager.getLogManager().getProperty(PATTERN_KEY), LogManager.getIntProperty(LIMIT_KEY, 0), LogManager.getIntProperty(COUNT_KEY, 1), LogManager.getBooleanProperty(APPEND_KEY, false));
    }

    public FileHandler(String pattern2) throws IOException, SecurityException {
        this(pattern2, 0, 1, false);
    }

    public FileHandler(String pattern2, boolean append) throws IOException, SecurityException {
        this(pattern2, 0, 1, append);
    }

    public FileHandler(String pattern2, int limit, int count) throws IOException, SecurityException {
        this(pattern2, limit, count, LogManager.getBooleanProperty(APPEND_KEY, false));
    }

    public FileHandler(String pattern2, int limit, int count, boolean append) throws IOException, SecurityException {
        super(null, PROPERTY_PREFIX, Level.ALL, null, XMLFormatter.class);
        if (limit < 0 || count < 1) {
            throw new IllegalArgumentException();
        }
        this.pattern = pattern2 != null ? pattern2 : DEFAULT_PATTERN;
        this.limit = limit;
        this.count = count;
        this.append = append;
        this.written = 0L;
        this.logFiles = new LinkedList();
        this.setOutputStream(this.createFileStream(this.pattern, limit, count, append, 0));
    }

    private OutputStream createFileStream(String pattern2, int limit, int count, boolean append, int generation) {
        int unique = 0;
        LogManager.getLogManager().checkAccess();
        if (pattern2 == null) {
            pattern2 = LogManager.getLogManager().getProperty(PATTERN_KEY);
        }
        if (pattern2 == null) {
            pattern2 = DEFAULT_PATTERN;
        }
        if (count > 1 && !FileHandler.has(pattern2, 'g')) {
            pattern2 = String.valueOf(pattern2) + ".%g";
        }
        while (true) {
            String path = FileHandler.replaceFileNameEscapes(pattern2, generation, unique, count);
            try {
                File file = new File(path);
                if (!file.exists() || append) {
                    FileOutputStream fout = new FileOutputStream(file, append);
                    if (this.logFiles.isEmpty()) {
                        this.logFiles.addFirst(path);
                    }
                    return new ostr(fout);
                }
            }
            catch (Exception ex) {
                this.reportError(null, ex, 4);
            }
            ++unique;
            if (FileHandler.has(pattern2, 'u')) continue;
            pattern2 = String.valueOf(pattern2) + ".%u";
        }
    }

    private static String replaceFileNameEscapes(String pattern2, int generation, int uniqueNumber, int count) {
        StringBuffer buf = new StringBuffer(pattern2);
        boolean foundGeneration = false;
        int pos = 0;
        do {
            String replaceWith;
            if (buf.charAt(pos) == '/') {
                replaceWith = System.getProperty("file.separator");
                buf.replace(pos, pos + 1, replaceWith);
                pos = pos + replaceWith.length() - 1;
                continue;
            }
            if (buf.charAt(pos) != '%') continue;
            switch (buf.charAt(pos + 1)) {
                case 't': {
                    replaceWith = System.getProperty("java.io.tmpdir");
                    break;
                }
                case 'h': {
                    replaceWith = System.getProperty("user.home");
                    break;
                }
                case 'g': {
                    replaceWith = Integer.toString(generation);
                    foundGeneration = true;
                    break;
                }
                case 'u': {
                    replaceWith = Integer.toString(uniqueNumber);
                    break;
                }
                case '%': {
                    replaceWith = "%";
                    break;
                }
                default: {
                    replaceWith = "??";
                }
            }
            buf.replace(pos, pos + 2, replaceWith);
            pos = pos + replaceWith.length() - 1;
        } while (++pos < buf.length() - 1);
        if (!foundGeneration && count > 1) {
            buf.append('.');
            buf.append(generation);
        }
        return buf.toString();
    }

    public void publish(LogRecord record) {
        if (this.limit > 0 && this.written >= (long)this.limit) {
            this.rotate();
        }
        super.publish(record);
        this.flush();
    }

    private synchronized void rotate() {
        if (this.logFiles.size() > 0) {
            File f1 = null;
            ListIterator lit = null;
            if (this.logFiles.size() == this.count) {
                f1 = new File((String)this.logFiles.getLast());
                f1.delete();
                lit = this.logFiles.listIterator(this.logFiles.size() - 1);
            } else {
                String path = FileHandler.replaceFileNameEscapes(this.pattern, this.logFiles.size(), 0, this.count);
                f1 = new File(path);
                this.logFiles.addLast(path);
                lit = this.logFiles.listIterator(this.logFiles.size() - 1);
            }
            while (lit.hasPrevious()) {
                String s = (String)lit.previous();
                File f2 = new File(s);
                f2.renameTo(f1);
                f1 = f2;
            }
        }
        this.setOutputStream(this.createFileStream(this.pattern, this.limit, this.count, this.append, 0));
        this.written = 0L;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean has(String pattern, char escape) {
        len = pattern.length();
        sawPercent = false;
        i = 0;
        while (i < len) {
            c = pattern.charAt(i);
            if (!sawPercent) ** GOTO lbl-1000
            if (c == escape) {
                return true;
            }
            if (c == '%') {
                sawPercent = false;
            } else lbl-1000:
            // 2 sources

            {
                sawPercent = c == '%';
            }
            ++i;
        }
        return false;
    }

    private final class ostr
    extends FilterOutputStream {
        private ostr(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++FileHandler.this.written;
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int offset, int length) throws IOException {
            this.out.write(b, offset, length);
            FileHandler.this.written += (long)length;
        }
    }
}

