/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.swing.ProgressMonitor;

public class ProgressMonitorInputStream
extends FilterInputStream {
    private ProgressMonitor monitor;
    private int read;

    public ProgressMonitorInputStream(Component component, Object message, InputStream stream) {
        super(stream);
        int max = 0;
        try {
            max = stream.available();
        }
        catch (IOException iOException) {}
        this.monitor = new ProgressMonitor(component, message, null, 0, max);
    }

    public void reset() throws IOException {
        super.reset();
        this.checkMonitorCanceled();
    }

    public int read() throws IOException {
        int t = super.read();
        this.monitor.setProgress(++this.read);
        this.checkMonitorCanceled();
        return t;
    }

    public int read(byte[] data) throws IOException {
        int t = super.read(data);
        if (t > 0) {
            this.read += t;
            this.monitor.setProgress(this.read);
            this.checkMonitorCanceled();
        } else {
            this.monitor.close();
        }
        return t;
    }

    public int read(byte[] data, int offset, int length) throws IOException {
        int t = super.read(data, offset, length);
        if (t > 0) {
            this.read += t;
            this.monitor.setProgress(this.read);
            this.checkMonitorCanceled();
        } else {
            this.monitor.close();
        }
        return t;
    }

    public long skip(long length) throws IOException {
        long t = super.skip(length);
        assert ((long)this.read + t <= Integer.MAX_VALUE);
        this.read += (int)t;
        this.monitor.setProgress(this.read);
        this.checkMonitorCanceled();
        return t;
    }

    public void close() throws IOException {
        super.close();
        this.monitor.close();
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    private void checkMonitorCanceled() throws InterruptedIOException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedIOException("ProgressMonitor was canceled");
        }
    }
}

