/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class UIManager
implements Serializable {
    private static final long serialVersionUID = -5547433830339189365L;
    static LookAndFeelInfo[] installed = new LookAndFeelInfo[]{new LookAndFeelInfo("Metal", "javax.swing.plaf.metal.MetalLookAndFeel"), new LookAndFeelInfo("GNU", "gnu.javax.swing.plaf.gnu.GNULookAndFeel")};
    static LookAndFeel[] auxLookAndFeels;
    static LookAndFeel currentLookAndFeel;
    static MultiplexUIDefaults currentUIDefaults;
    static UIDefaults lookAndFeelDefaults;
    static PropertyChangeSupport listeners;

    static {
        listeners = new PropertyChangeSupport(UIManager.class);
        String defaultlaf = System.getProperty("swing.defaultlaf");
        try {
            if (defaultlaf != null) {
                UIManager.setLookAndFeel(defaultlaf);
            } else {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
        }
        catch (Exception ex) {
            System.err.println("cannot initialize Look and Feel: " + defaultlaf);
            System.err.println("error: " + ex.toString());
            ex.printStackTrace();
            System.err.println("falling back to Metal Look and Feel");
            try {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
            catch (Exception ex2) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"There must be no problem installing the MetalLookAndFeel."))).initCause(ex2);
            }
        }
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        listeners.addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        listeners.removePropertyChangeListener(listener);
    }

    public static PropertyChangeListener[] getPropertyChangeListeners() {
        return listeners.getPropertyChangeListeners();
    }

    public static void addAuxiliaryLookAndFeel(LookAndFeel laf) {
        if (laf == null) {
            throw new NullPointerException("Null 'laf' argument.");
        }
        if (auxLookAndFeels == null) {
            auxLookAndFeels = new LookAndFeel[1];
            UIManager.auxLookAndFeels[0] = laf;
            return;
        }
        LookAndFeel[] temp = new LookAndFeel[auxLookAndFeels.length + 1];
        System.arraycopy(auxLookAndFeels, 0, temp, 0, auxLookAndFeels.length);
        auxLookAndFeels = temp;
        UIManager.auxLookAndFeels[UIManager.auxLookAndFeels.length - 1] = laf;
    }

    public static boolean removeAuxiliaryLookAndFeel(LookAndFeel laf) {
        if (auxLookAndFeels == null) {
            return false;
        }
        int count = auxLookAndFeels.length;
        if (count == 1 && auxLookAndFeels[0] == laf) {
            auxLookAndFeels = null;
            return true;
        }
        int i = 0;
        while (i < count) {
            if (auxLookAndFeels[i] == laf) {
                LookAndFeel[] temp = new LookAndFeel[auxLookAndFeels.length - 1];
                if (i == 0) {
                    System.arraycopy(auxLookAndFeels, 1, temp, 0, count - 1);
                } else if (i == count - 1) {
                    System.arraycopy(auxLookAndFeels, 0, temp, 0, count - 1);
                } else {
                    System.arraycopy(auxLookAndFeels, 0, temp, 0, i);
                    System.arraycopy(auxLookAndFeels, i + 1, temp, i, count - i - 1);
                }
                auxLookAndFeels = temp;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static LookAndFeel[] getAuxiliaryLookAndFeels() {
        return auxLookAndFeels;
    }

    public static Object get(Object key) {
        return UIManager.getDefaults().get(key);
    }

    public static Object get(Object key, Locale locale) {
        return UIManager.getDefaults().get(key, locale);
    }

    public static boolean getBoolean(Object key) {
        Object value = UIManager.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public static boolean getBoolean(Object key, Locale locale) {
        Object value = UIManager.get(key, locale);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public static Border getBorder(Object key) {
        Object value = UIManager.get(key);
        if (value instanceof Border) {
            return (Border)value;
        }
        return null;
    }

    public static Border getBorder(Object key, Locale locale) {
        Object value = UIManager.get(key, locale);
        if (value instanceof Border) {
            return (Border)value;
        }
        return null;
    }

    public static Color getColor(Object key) {
        Object value = UIManager.get(key);
        if (value instanceof Color) {
            return (Color)value;
        }
        return null;
    }

    public static Color getColor(Object key, Locale locale) {
        Object value = UIManager.get(key, locale);
        if (value instanceof Color) {
            return (Color)value;
        }
        return null;
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    public static UIDefaults getDefaults() {
        if (currentUIDefaults == null) {
            currentUIDefaults = new MultiplexUIDefaults(new UIDefaults());
        }
        return currentUIDefaults;
    }

    public static Dimension getDimension(Object key) {
        Object value = UIManager.get(key);
        if (value instanceof Dimension) {
            return (Dimension)value;
        }
        return null;
    }

    public static Dimension getDimension(Object key, Locale locale) {
        Object value = UIManager.get(key, locale);
        if (value instanceof Dimension) {
            return (Dimension)value;
        }
        return null;
    }

    public static Font getFont(Object key) {
        Object value = UIManager.get(key);
        if (value instanceof Font) {
            return (Font)value;
        }
        return null;
    }

    public static Font getFont(Object key, Locale locale) {
        Object value = UIManager.get(key, locale);
        if (value instanceof Font) {
            return (Font)value;
        }
        return null;
    }

    public static Icon getIcon(Object key) {
        Object value = UIManager.get(key);
        if (value instanceof Icon) {
            return (Icon)value;
        }
        return null;
    }

    public static Icon getIcon(Object key, Locale locale) {
        Object value = UIManager.get(key, locale);
        if (value instanceof Icon) {
            return (Icon)value;
        }
        return null;
    }

    public static Insets getInsets(Object key) {
        Object o = UIManager.get(key);
        if (o instanceof Insets) {
            return (Insets)o;
        }
        return null;
    }

    public static Insets getInsets(Object key, Locale locale) {
        Object o = UIManager.get(key, locale);
        if (o instanceof Insets) {
            return (Insets)o;
        }
        return null;
    }

    public static LookAndFeelInfo[] getInstalledLookAndFeels() {
        return installed;
    }

    public static int getInt(Object key) {
        Object x = UIManager.get(key);
        if (x instanceof Integer) {
            return (Integer)x;
        }
        return 0;
    }

    public static int getInt(Object key, Locale locale) {
        Object x = UIManager.get(key, locale);
        if (x instanceof Integer) {
            return (Integer)x;
        }
        return 0;
    }

    public static LookAndFeel getLookAndFeel() {
        return currentLookAndFeel;
    }

    public static UIDefaults getLookAndFeelDefaults() {
        return lookAndFeelDefaults;
    }

    public static String getString(Object key) {
        Object s = UIManager.get(key);
        if (s instanceof String) {
            return (String)s;
        }
        return null;
    }

    public static String getString(Object key, Locale locale) {
        Object s = UIManager.get(key, locale);
        if (s instanceof String) {
            return (String)s;
        }
        return null;
    }

    public static String getSystemLookAndFeelClassName() {
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static ComponentUI getUI(JComponent target) {
        return UIManager.getDefaults().getUI(target);
    }

    public static void installLookAndFeel(String name, String className) {
        UIManager.installLookAndFeel(new LookAndFeelInfo(name, className));
    }

    public static void installLookAndFeel(LookAndFeelInfo info) {
        LookAndFeelInfo[] newInstalled = new LookAndFeelInfo[installed.length + 1];
        System.arraycopy(installed, 0, newInstalled, 0, installed.length);
        newInstalled[newInstalled.length - 1] = info;
        UIManager.setInstalledLookAndFeels(newInstalled);
    }

    public static Object put(Object key, Object value) {
        return UIManager.getDefaults().put(key, value);
    }

    public static void setInstalledLookAndFeels(LookAndFeelInfo[] infos) {
        installed = infos;
    }

    public static void setLookAndFeel(LookAndFeel newLookAndFeel) throws UnsupportedLookAndFeelException {
        if (newLookAndFeel != null && !newLookAndFeel.isSupportedLookAndFeel()) {
            throw new UnsupportedLookAndFeelException(String.valueOf(newLookAndFeel.getName()) + " not supported on this platform");
        }
        LookAndFeel oldLookAndFeel = currentLookAndFeel;
        if (oldLookAndFeel != null) {
            oldLookAndFeel.uninitialize();
        }
        currentLookAndFeel = newLookAndFeel;
        if (newLookAndFeel != null) {
            newLookAndFeel.initialize();
            lookAndFeelDefaults = newLookAndFeel.getDefaults();
            if (currentUIDefaults == null) {
                currentUIDefaults = new MultiplexUIDefaults(lookAndFeelDefaults);
            } else {
                UIManager.currentUIDefaults.fallback = lookAndFeelDefaults;
            }
        } else {
            currentUIDefaults = null;
        }
        listeners.firePropertyChange("lookAndFeel", oldLookAndFeel, newLookAndFeel);
    }

    public static void setLookAndFeel(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        Class<?> c = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        LookAndFeel a = (LookAndFeel)c.newInstance();
        UIManager.setLookAndFeel(a);
    }

    public static class LookAndFeelInfo {
        String name;
        String clazz;

        public LookAndFeelInfo(String name, String clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.clazz;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append(this.getClass().getName());
            s.append('[');
            s.append(this.getName());
            s.append(' ');
            s.append(this.getClassName());
            s.append(']');
            return s.toString();
        }
    }

    private static class MultiplexUIDefaults
    extends UIDefaults {
        UIDefaults fallback;

        MultiplexUIDefaults(UIDefaults d) {
            if (d == null) {
                throw new NullPointerException();
            }
            this.fallback = d;
        }

        public Object get(Object key) {
            Object val = super.get(key);
            if (val == null) {
                val = this.fallback.get(key);
            }
            return val;
        }

        public Object get(Object key, Locale l) {
            Object val = super.get(key, l);
            if (val == null) {
                val = this.fallback.get(key, l);
            }
            return val;
        }

        public Object remove(Object key) {
            Object val = super.remove(key);
            if (val == null) {
                val = this.fallback.remove(key);
            }
            return val;
        }

        public int size() {
            return super.size() + this.fallback.size();
        }

        public Enumeration keys() {
            return new MultiplexEnumeration(super.keys(), this.fallback.keys());
        }

        public Enumeration elements() {
            return new MultiplexEnumeration(super.elements(), this.fallback.elements());
        }

        private class MultiplexEnumeration
        implements Enumeration {
            Enumeration[] enums;
            int i;

            MultiplexEnumeration(Enumeration e1, Enumeration e2) {
                this.enums = new Enumeration[]{e1, e2};
                this.i = 0;
            }

            public boolean hasMoreElements() {
                return this.enums[this.i].hasMoreElements() || this.i < this.enums.length - 1;
            }

            public Object nextElement() {
                Object val = this.enums[this.i].nextElement();
                if (!this.enums[this.i].hasMoreElements() && this.i < this.enums.length - 1) {
                    ++this.i;
                }
                return val;
            }
        }
    }
}

