/* <<< Start of information >>>                                             */
/* This file is part of the xplot program, a plot program for               */
/* tabulated functions which works under X.                                 */
/*                                                                          */
/* Copyright (c) ICCE / Karel Kubat 1995. All rights reserved.              */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include <errno.h>
#include <ctype.h>
#include <X11/forms.h>
#include <fli.h> 
#include <stdarg.h> 
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "plot.h"

/* macro section */ 
#define LINETYPE_GUESS	   -1                       /* guess line types ? */

#define GUESS_X		    0                       /* guess X range ? */
#define GUESS_Y		    1                       /* guess Y range ? */

#define SET_MINX	    0                       /* set boundary lowest X */
#define SET_MAXX	    1                       /*  highest X */
#define SET_MINY	    2                       /*  lowest Y */
#define SET_MAXY	    3                       /*  highest Y */

#define VERYTINY	    0.01                    /*  smallest resolution */

#define HIDDEN_BLOWUP       0                       /* removed from screen */
#define STATIC_BLOWUP       1                       /* redrawing: does it */
#define DYNAMIC_BLOWUP      2                       /* or doesn't it change */

#ifndef HELPFILE
#   define HELPFILE	"/usr/local/share/xplot/xplot.help" /* file with help text */
#endif

/* representation of data */
typedef struct
{
    int npoints;			/* # of x/y points */ 
    float *x;				/* vector of x */ 
    float *y;				/* vector of y */ 
    int color;				/* color code */
    int active;				/* on screen? */
} Data;

/* blowup representation */
typedef struct      
{
    FL_FORM *form;                      /* the form */
    FL_OBJECT *ob;                      /* the xy_plot object */
    int type;                           /* type: dynamic or static */
} Blowup;

/* global variables */
extern Data
    *data;
extern int
    verbose,
    linetype,
    ndata,
    autoredraw,
    ylimits_set;
extern double
    minx, maxx, miny, maxy,
    curminx, curmaxx, curminy, curmaxy;
extern char
    formatstring [],
    titlestring [];

extern Blowup
    *blowups;
extern int
    nblowups;

/* function prototypes */
extern void boundaries (void);
extern void checkranges (void);
extern void create_form_activator (void);
extern void create_form_blowup (void);
extern void create_form_help (void);
extern void create_form_plot (void);
extern void error (char *fmt, ...);
extern char *fgetline (char *buf, int max, FILE *f);
extern void hideform (FL_FORM *form);
extern void usage (void);
extern void redraw (FL_OBJECT *xyplot, FL_FORM *form);
extern void readfile (FILE *f, char *name);
extern void setinputstrings (void);
extern void showform (FL_FORM *form, int placing, char *title);
extern void warning (char *fmt, ...);
