/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfCell;
import com.lowagie.text.rtf.RtfField;
import com.lowagie.text.rtf.RtfHeaderFooter;
import com.lowagie.text.rtf.RtfHeaderFooters;
import com.lowagie.text.rtf.RtfPageNumber;
import com.lowagie.text.rtf.RtfTOC;
import com.lowagie.text.rtf.RtfTOCEntry;
import com.lowagie.text.rtf.RtfTable;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;

public class RtfWriter
extends DocWriter
implements DocListener {
    public static final byte escape = 92;
    private static final byte[] extendedEscape = "\\*\\".getBytes();
    protected static final byte delimiter = 32;
    private static final byte commaDelimiter = 59;
    public static final byte openGroup = 123;
    public static final byte closeGroup = 125;
    private static final byte[] docBegin = "rtf1".getBytes();
    private static final byte[] ansi = "ansi".getBytes();
    private static final byte[] ansiCodepage = "ansicpg".getBytes();
    private static final byte[] fontTable = "fonttbl".getBytes();
    protected static final byte fontNumber = 102;
    protected static final byte[] fontSize = "fs".getBytes();
    protected static final byte[] fontColor = "cf".getBytes();
    private static final byte[] fontModern = "fmodern".getBytes();
    private static final byte[] fontSwiss = "fswiss".getBytes();
    private static final byte[] fontRoman = "froman".getBytes();
    private static final byte[] fontTech = "ftech".getBytes();
    private static final byte[] fontCharset = "fcharset".getBytes();
    private static final byte[] fontCourier = "Courier".getBytes();
    private static final byte[] fontArial = "Arial".getBytes();
    private static final byte[] fontSymbol = "Symbol".getBytes();
    private static final byte[] fontTimesNewRoman = "Times New Roman".getBytes();
    private static final byte[] fontWindings = "Windings".getBytes();
    private static final byte[] defaultFont = "deff".getBytes();
    private static final byte[] firstIndent = "fi".getBytes();
    private static final byte[] listIndent = "li".getBytes();
    private static final byte[] sectionDefaults = "sectd".getBytes();
    private static final byte[] section = "sect".getBytes();
    public static final byte[] paragraphDefaults = "pard".getBytes();
    public static final byte[] paragraph = "par".getBytes();
    private static final byte[] listtableGroup = "listtable".getBytes();
    private static final byte[] listoverridetableGroup = "listoverridetable".getBytes();
    private static final byte[] listDefinition = "list".getBytes();
    private static final byte[] listTemplateID = "listtemplateid".getBytes();
    private static final byte[] hybridList = "hybrid".getBytes();
    private static final byte[] listLevelDefinition = "listlevel".getBytes();
    private static final byte[] listLevelTypeOld = "levelnfc".getBytes();
    private static final byte[] listLevelTypeNew = "levelnfcn".getBytes();
    private static final byte[] listLevelAlignOld = "leveljc".getBytes();
    private static final byte[] listLevelAlignNew = "leveljcn".getBytes();
    private static final byte[] listLevelStartAt = "levelstartat".getBytes();
    private static final byte[] listLevelTextDefinition = "leveltext".getBytes();
    private static final byte[] listLevelTextLength = "'0".getBytes();
    private static final byte[] listLevelTextStyleNumbers = "'00.".getBytes();
    private static final byte[] listLevelTextStyleBullet = "u-3913 ?".getBytes();
    private static final byte[] listLevelNumbersDefinition = "levelnumbers".getBytes();
    private static final byte[] listLevelNumbers = "\\'0".getBytes();
    private static final byte[] tabStop = "tx".getBytes();
    private static final byte[] listBegin = "ls".getBytes();
    private static final byte[] listCurrentLevel = "ilvl".getBytes();
    private static final byte[] listTextOld = "listtext".getBytes();
    private static final byte[] tab = "tab".getBytes();
    private static final byte[] listBulletOld = "'b7".getBytes();
    private static final byte[] listID = "listid".getBytes();
    private static final byte[] listOverride = "listoverride".getBytes();
    private static final byte[] listOverrideCount = "listoverridecount".getBytes();
    protected static final byte bold = 98;
    protected static final byte italic = 105;
    protected static final byte[] underline = "ul".getBytes();
    protected static final byte[] strikethrough = "strike".getBytes();
    public static final byte[] alignLeft = "ql".getBytes();
    private static final byte[] alignCenter = "qc".getBytes();
    private static final byte[] alignRight = "qr".getBytes();
    private static final byte[] alignJustify = "qj".getBytes();
    private static final byte[] colorTable = "colortbl".getBytes();
    private static final byte[] colorRed = "red".getBytes();
    private static final byte[] colorGreen = "green".getBytes();
    private static final byte[] colorBlue = "blue".getBytes();
    private static final byte[] infoBegin = "info".getBytes();
    private static final byte[] metaAuthor = "author".getBytes();
    private static final byte[] metaSubject = "subject".getBytes();
    private static final byte[] metaKeywords = "keywords".getBytes();
    private static final byte[] metaTitle = "title".getBytes();
    private static final byte[] metaProducer = "operator".getBytes();
    private static final byte[] metaCreationDate = "creationdate".getBytes();
    private static final byte[] year = "yr".getBytes();
    private static final byte[] month = "mo".getBytes();
    private static final byte[] day = "dy".getBytes();
    private static final byte[] hour = "hr".getBytes();
    private static final byte[] minute = "min".getBytes();
    private static final byte[] second = "sec".getBytes();
    private static final byte[] startSuper = "super".getBytes();
    private static final byte[] startSub = "sub".getBytes();
    private static final byte[] endSuperSub = "nosupersub".getBytes();
    private static final byte[] titlePage = "titlepg".getBytes();
    private static final byte[] facingPages = "facingp".getBytes();
    private static final byte[] headerBegin = "header".getBytes();
    private static final byte[] footerBegin = "footer".getBytes();
    private static final byte[] headerlBegin = "headerl".getBytes();
    private static final byte[] footerlBegin = "footerl".getBytes();
    private static final byte[] headerrBegin = "headerr".getBytes();
    private static final byte[] footerrBegin = "footerr".getBytes();
    private static final byte[] headerfBegin = "headerf".getBytes();
    private static final byte[] footerfBegin = "footerf".getBytes();
    private static final byte[] rtfPaperWidth = "paperw".getBytes();
    private static final byte[] rtfPaperHeight = "paperh".getBytes();
    private static final byte[] rtfMarginLeft = "margl".getBytes();
    private static final byte[] rtfMarginRight = "margr".getBytes();
    private static final byte[] rtfMarginTop = "margt".getBytes();
    private static final byte[] rtfMarginBottom = "margb".getBytes();
    private static final byte[] newPage = "page".getBytes();
    private static final byte[] landscapeTag1 = "landscape".getBytes();
    private static final byte[] landscapeTag2 = "lndscpsxn".getBytes();
    private static final byte[] annotationID = "atnid".getBytes();
    private static final byte[] annotationAuthor = "atnauthor".getBytes();
    private static final byte[] annotation = "annotation".getBytes();
    private static final byte[] pictureGroup = "shppict".getBytes();
    private static final byte[] picture = "pict".getBytes();
    private static final byte[] picturePNG = "pngblip".getBytes();
    private static final byte[] pictureJPEG = "jpegblip".getBytes();
    private static final byte[] pictureWidth = "picw".getBytes();
    private static final byte[] pictureHeight = "pich".getBytes();
    private static final byte[] pictureScaleX = "picscalex".getBytes();
    private static final byte[] pictureScaleY = "picscaley".getBytes();
    protected static final byte[] field = "field".getBytes();
    protected static final byte[] fieldContent = "fldinst".getBytes();
    protected static final byte[] fieldPage = "PAGE".getBytes();
    protected static final byte[] fieldHyperlink = "HYPERLINK".getBytes();
    protected static final byte[] fieldDisplay = "fldrslt".getBytes();
    private Vector fontList = new Vector();
    private Vector colorList = new Vector();
    private ByteArrayOutputStream content = null;
    private ByteArrayOutputStream info = null;
    private ByteArrayOutputStream listtable = null;
    private ByteArrayOutputStream listoverride = null;
    private HeaderFooter header = null;
    private HeaderFooter footer = null;
    private int marginLeft = 1800;
    private int marginRight = 1800;
    private int marginTop = 1440;
    private int marginBottom = 1440;
    private int pageWidth = 11906;
    private int pageHeight = 16838;
    public static final double twipsFactor = 20.0;
    private int currentListID = 1;
    private Vector listIds = null;
    private int listLevel = 0;
    private int maxListLevel = 0;
    private boolean writeTOC = false;
    private boolean hasTitlePage = false;
    private boolean inHeaderFooter = false;
    private boolean inTable = false;
    private boolean landscape = false;

    protected RtfWriter(Document document, OutputStream outputStream) {
        super(document, outputStream);
        this.document.addDocListener(this);
        this.initDefaults();
    }

    public void setGenerateTOCEntries(boolean bl) {
        this.writeTOC = bl;
    }

    public boolean getGeneratingTOCEntries() {
        return this.writeTOC;
    }

    public void setHasTitlePage(boolean bl) {
        this.hasTitlePage = bl;
    }

    public boolean getHasTitlePage() {
        return this.hasTitlePage;
    }

    public void setLandscape(boolean bl) {
        this.landscape = bl;
    }

    public boolean getLandscape() {
        return this.landscape;
    }

    public static RtfWriter getInstance(Document document, OutputStream outputStream) {
        return new RtfWriter(document, outputStream);
    }

    public void open() {
        super.open();
    }

    public void close() {
        this.writeDocument();
        super.close();
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
    }

    public void resetFooter() {
        this.setFooter(null);
    }

    public void resetHeader() {
        this.setHeader(null);
    }

    public boolean newPage() throws DocumentException {
        try {
            this.content.write(92);
            this.content.write(newPage);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean setMargins(float f, float f2, float f3, float f4) {
        this.marginLeft = (int)((double)f * 20.0);
        this.marginRight = (int)((double)f2 * 20.0);
        this.marginTop = (int)((double)f3 * 20.0);
        this.marginBottom = (int)((double)f4 * 20.0);
        return true;
    }

    public boolean setPageSize(Rectangle rectangle) {
        if (!this.parseFormat(rectangle, false)) {
            this.pageWidth = (int)((double)rectangle.width() * 20.0);
            this.pageHeight = (int)((double)rectangle.height() * 20.0);
            this.landscape = this.pageWidth > this.pageHeight;
        }
        return true;
    }

    public boolean writeTOC(String string, Font font, boolean bl, Font font2) {
        try {
            RtfTOC rtfTOC = new RtfTOC(string, font);
            if (bl) {
                rtfTOC.addTOCAsTOCEntry(string, font2);
            }
            this.add(new Paragraph(rtfTOC));
        }
        catch (DocumentException documentException) {
            return false;
        }
        return true;
    }

    public boolean add(Element element) throws DocumentException {
        return this.addElement(element, this.content);
    }

    protected boolean addElement(Element element, ByteArrayOutputStream byteArrayOutputStream) throws DocumentException {
        try {
            switch (element.type()) {
                case 10: {
                    this.writeChunk((Chunk)element, byteArrayOutputStream);
                    break;
                }
                case 12: {
                    this.writeParagraph((Paragraph)element, byteArrayOutputStream);
                    break;
                }
                case 17: {
                    this.writeAnchor((Anchor)element, byteArrayOutputStream);
                    break;
                }
                case 11: {
                    this.writePhrase((Phrase)element, byteArrayOutputStream);
                    break;
                }
                case 13: 
                case 16: {
                    this.writeSection((Section)element, byteArrayOutputStream);
                    break;
                }
                case 14: {
                    this.writeList((List)element, byteArrayOutputStream);
                    break;
                }
                case 22: {
                    this.writeTable((Table)element, byteArrayOutputStream);
                    break;
                }
                case 29: {
                    this.writeAnnotation((Annotation)element, byteArrayOutputStream);
                    break;
                }
                case 32: 
                case 33: {
                    this.writeImage((Image)element, byteArrayOutputStream);
                    break;
                }
                case 4: {
                    this.writeMeta(metaAuthor, (Meta)element);
                    break;
                }
                case 2: {
                    this.writeMeta(metaSubject, (Meta)element);
                    break;
                }
                case 3: {
                    this.writeMeta(metaKeywords, (Meta)element);
                    break;
                }
                case 1: {
                    this.writeMeta(metaTitle, (Meta)element);
                    break;
                }
                case 5: {
                    this.writeMeta(metaProducer, (Meta)element);
                    break;
                }
                case 6: {
                    this.writeMeta(metaCreationDate, (Meta)element);
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void writeSection(Section section, ByteArrayOutputStream byteArrayOutputStream) throws IOException, DocumentException {
        if (section.type() == 16) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(sectionDefaults);
            this.writeSectionDefaults(byteArrayOutputStream);
        }
        if (section.title() != null) {
            if (this.writeTOC) {
                StringBuffer stringBuffer = new StringBuffer("");
                ListIterator listIterator = ((AbstractList)section.title().getChunks()).listIterator();
                while (listIterator.hasNext()) {
                    stringBuffer.append(((Chunk)listIterator.next()).content());
                }
                this.add(new RtfTOCEntry(stringBuffer.toString(), section.title().font()));
            } else {
                section.title().process(this);
            }
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(paragraph);
        }
        section.process(this);
        if (section.type() == 16) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfWriter.section);
        }
        if (section.type() == 13) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(paragraph);
        }
    }

    private void writeParagraph(Paragraph paragraph, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        Object object;
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(paragraphDefaults);
        if (this.inTable) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfCell.cellInTable);
        }
        switch (paragraph.alignment()) {
            case 0: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(alignLeft);
                break;
            }
            case 2: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(alignRight);
                break;
            }
            case 1: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(alignCenter);
                break;
            }
            case 3: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(alignJustify);
            }
        }
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(listIndent);
        RtfWriter.writeInt(byteArrayOutputStream, (int)((double)paragraph.indentationLeft() * 20.0));
        Iterator iterator = ((AbstractList)paragraph.getChunks()).iterator();
        while (iterator.hasNext()) {
            object = (Chunk)iterator.next();
            ((Chunk)object).setFont(((Chunk)object).font().difference(paragraph.font()));
        }
        object = this.content;
        this.content = byteArrayOutputStream;
        paragraph.process(this);
        this.content = object;
        if (!this.inTable) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfWriter.paragraph);
        }
    }

    private void writePhrase(Phrase phrase, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        Object object;
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(paragraphDefaults);
        if (this.inTable) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfCell.cellInTable);
        }
        Iterator iterator = ((AbstractList)phrase.getChunks()).iterator();
        while (iterator.hasNext()) {
            object = (Chunk)iterator.next();
            ((Chunk)object).setFont(((Chunk)object).font().difference(phrase.font()));
        }
        object = this.content;
        this.content = byteArrayOutputStream;
        phrase.process(this);
        this.content = object;
    }

    private void writeAnchor(Anchor anchor, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        if (anchor.url() != null) {
            byteArrayOutputStream.write(123);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(field);
            byteArrayOutputStream.write(123);
            byteArrayOutputStream.write(extendedEscape);
            byteArrayOutputStream.write(fieldContent);
            byteArrayOutputStream.write(123);
            byteArrayOutputStream.write(fieldHyperlink);
            byteArrayOutputStream.write(32);
            byteArrayOutputStream.write(anchor.url().toString().getBytes());
            byteArrayOutputStream.write(125);
            byteArrayOutputStream.write(125);
            byteArrayOutputStream.write(123);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(fieldDisplay);
            byteArrayOutputStream.write(32);
            this.writePhrase(anchor, byteArrayOutputStream);
            byteArrayOutputStream.write(125);
            byteArrayOutputStream.write(125);
        } else {
            this.writePhrase(anchor, byteArrayOutputStream);
        }
    }

    private void writeChunk(Chunk chunk, ByteArrayOutputStream byteArrayOutputStream) throws IOException, DocumentException {
        if (chunk instanceof RtfField) {
            ((RtfField)((Object)chunk)).write(this, byteArrayOutputStream);
        } else if (chunk.getImage() != null) {
            this.writeImage(chunk.getImage(), byteArrayOutputStream);
        } else {
            this.writeInitialFontSignature(byteArrayOutputStream, chunk);
            byteArrayOutputStream.write(RtfWriter.filterSpecialChar(chunk.content()).getBytes());
            this.writeFinishingFontSignature(byteArrayOutputStream, chunk);
        }
    }

    protected void writeInitialFontSignature(OutputStream outputStream, Chunk chunk) throws IOException {
        Float f;
        Font font = chunk.font();
        outputStream.write(92);
        outputStream.write(102);
        if (!font.getFamilyname().equalsIgnoreCase("unknown")) {
            RtfWriter.writeInt(outputStream, this.addFont(font));
        } else {
            RtfWriter.writeInt(outputStream, 0);
        }
        outputStream.write(92);
        outputStream.write(fontSize);
        if (font.size() > 0.0f) {
            RtfWriter.writeInt(outputStream, (int)(font.size() * 2.0f));
        } else {
            RtfWriter.writeInt(outputStream, 20);
        }
        outputStream.write(92);
        outputStream.write(fontColor);
        RtfWriter.writeInt(outputStream, this.addColor(font.color()));
        if (font.isBold()) {
            outputStream.write(92);
            outputStream.write(98);
        }
        if (font.isItalic()) {
            outputStream.write(92);
            outputStream.write(105);
        }
        if (font.isUnderlined()) {
            outputStream.write(92);
            outputStream.write(underline);
        }
        if (font.isStrikethru()) {
            outputStream.write(92);
            outputStream.write(strikethrough);
        }
        if (chunk.getAttributes() != null && (f = (Float)chunk.getAttributes().get("SUBSUPSCRIPT")) != null) {
            if (f.floatValue() > 0.0f) {
                outputStream.write(92);
                outputStream.write(startSuper);
            } else if (f.floatValue() < 0.0f) {
                outputStream.write(92);
                outputStream.write(startSub);
            }
        }
        outputStream.write(32);
    }

    protected void writeFinishingFontSignature(OutputStream outputStream, Chunk chunk) throws IOException {
        Float f;
        Font font = chunk.font();
        if (font.isBold()) {
            outputStream.write(92);
            outputStream.write(98);
            RtfWriter.writeInt(outputStream, 0);
        }
        if (font.isItalic()) {
            outputStream.write(92);
            outputStream.write(105);
            RtfWriter.writeInt(outputStream, 0);
        }
        if (font.isUnderlined()) {
            outputStream.write(92);
            outputStream.write(underline);
            RtfWriter.writeInt(outputStream, 0);
        }
        if (font.isStrikethru()) {
            outputStream.write(92);
            outputStream.write(strikethrough);
            RtfWriter.writeInt(outputStream, 0);
        }
        if (chunk.getAttributes() != null && (f = (Float)chunk.getAttributes().get("SUBSUPSCRIPT")) != null && f.floatValue() != 0.0f) {
            outputStream.write(92);
            outputStream.write(endSuperSub);
        }
    }

    private void writeListElement(ListItem listItem, ByteArrayOutputStream byteArrayOutputStream) throws IOException, DocumentException {
        Iterator iterator = ((AbstractList)listItem.getChunks()).iterator();
        while (iterator.hasNext()) {
            Chunk chunk = (Chunk)iterator.next();
            this.addElement(chunk, byteArrayOutputStream);
        }
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(paragraph);
    }

    private void writeList(List list, ByteArrayOutputStream byteArrayOutputStream) throws IOException, DocumentException {
        int n = 0;
        int n2 = 0;
        int n3 = this.addFont(new Font(3, 10.0f, 0, new Color(0, 0, 0)));
        if (!list.isNumbered()) {
            n = 23;
        }
        if (this.listLevel == 0) {
            this.maxListLevel = 0;
            this.listtable.write(123);
            this.listtable.write(92);
            this.listtable.write(listDefinition);
            int n4 = this.getRandomInt();
            this.listtable.write(92);
            this.listtable.write(listTemplateID);
            RtfWriter.writeInt(this.listtable, n4);
            this.listtable.write(92);
            this.listtable.write(hybridList);
            this.listtable.write(10);
        }
        if (this.listLevel >= this.maxListLevel) {
            ++this.maxListLevel;
            this.listtable.write(123);
            this.listtable.write(92);
            this.listtable.write(listLevelDefinition);
            this.listtable.write(92);
            this.listtable.write(listLevelTypeOld);
            RtfWriter.writeInt(this.listtable, n);
            this.listtable.write(92);
            this.listtable.write(listLevelTypeNew);
            RtfWriter.writeInt(this.listtable, n);
            this.listtable.write(92);
            this.listtable.write(listLevelAlignOld);
            RtfWriter.writeInt(this.listtable, n2);
            this.listtable.write(92);
            this.listtable.write(listLevelAlignNew);
            RtfWriter.writeInt(this.listtable, n2);
            this.listtable.write(92);
            this.listtable.write(listLevelStartAt);
            RtfWriter.writeInt(this.listtable, 1);
            this.listtable.write(123);
            this.listtable.write(92);
            this.listtable.write(listLevelTextDefinition);
            this.listtable.write(92);
            this.listtable.write(listLevelTextLength);
            if (list.isNumbered()) {
                RtfWriter.writeInt(this.listtable, 2);
            } else {
                RtfWriter.writeInt(this.listtable, 1);
            }
            this.listtable.write(92);
            if (list.isNumbered()) {
                this.listtable.write(listLevelTextStyleNumbers);
            } else {
                this.listtable.write(listLevelTextStyleBullet);
            }
            this.listtable.write(59);
            this.listtable.write(125);
            this.listtable.write(123);
            this.listtable.write(92);
            this.listtable.write(listLevelNumbersDefinition);
            if (list.isNumbered()) {
                this.listtable.write(32);
                this.listtable.write(listLevelNumbers);
                RtfWriter.writeInt(this.listtable, this.listLevel + 1);
            }
            this.listtable.write(59);
            this.listtable.write(125);
            if (!list.isNumbered()) {
                this.listtable.write(92);
                this.listtable.write(102);
                RtfWriter.writeInt(this.listtable, n3);
            }
            this.listtable.write(92);
            this.listtable.write(firstIndent);
            RtfWriter.writeInt(this.listtable, (int)((double)list.indentationLeft() * 20.0 * -1.0));
            this.listtable.write(92);
            this.listtable.write(listIndent);
            RtfWriter.writeInt(this.listtable, (int)((double)(list.indentationLeft() + (float)list.symbolIndent()) * 20.0));
            this.listtable.write(92);
            this.listtable.write(tabStop);
            RtfWriter.writeInt(this.listtable, (int)((double)list.symbolIndent() * 20.0));
            this.listtable.write(125);
            this.listtable.write(10);
        }
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(paragraphDefaults);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(alignLeft);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(firstIndent);
        RtfWriter.writeInt(byteArrayOutputStream, (int)((double)list.indentationLeft() * 20.0 * -1.0));
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(listIndent);
        RtfWriter.writeInt(byteArrayOutputStream, (int)((double)(list.indentationLeft() + (float)list.symbolIndent()) * 20.0));
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(fontSize);
        RtfWriter.writeInt(byteArrayOutputStream, 20);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(listBegin);
        RtfWriter.writeInt(byteArrayOutputStream, this.currentListID);
        if (this.listLevel > 0) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(listCurrentLevel);
            RtfWriter.writeInt(byteArrayOutputStream, this.listLevel);
        }
        byteArrayOutputStream.write(123);
        ListIterator listIterator = ((AbstractList)list.getItems()).listIterator();
        int n5 = 1;
        while (listIterator.hasNext()) {
            Element element = (Element)listIterator.next();
            if (element.type() == 10) {
                element = new ListItem((Chunk)element);
            }
            if (element.type() == 15) {
                byteArrayOutputStream.write(123);
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(listTextOld);
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(paragraphDefaults);
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(102);
                if (list.isNumbered()) {
                    RtfWriter.writeInt(byteArrayOutputStream, this.addFont(new Font(2, 0.0f, 10, new Color(0, 0, 0))));
                } else {
                    RtfWriter.writeInt(byteArrayOutputStream, n3);
                }
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(firstIndent);
                RtfWriter.writeInt(byteArrayOutputStream, (int)((double)list.indentationLeft() * 20.0 * -1.0));
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(listIndent);
                RtfWriter.writeInt(byteArrayOutputStream, (int)((double)(list.indentationLeft() + (float)list.symbolIndent()) * 20.0));
                byteArrayOutputStream.write(32);
                if (list.isNumbered()) {
                    RtfWriter.writeInt(byteArrayOutputStream, n5);
                    byteArrayOutputStream.write(".".getBytes());
                } else {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(listBulletOld);
                }
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(tab);
                byteArrayOutputStream.write(125);
                this.writeListElement((ListItem)element, byteArrayOutputStream);
                ++n5;
            } else if (element.type() == 14) {
                ++this.listLevel;
                this.writeList((List)element, byteArrayOutputStream);
                --this.listLevel;
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(paragraphDefaults);
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(alignLeft);
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(firstIndent);
                RtfWriter.writeInt(byteArrayOutputStream, (int)((double)list.indentationLeft() * 20.0 * -1.0));
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(listIndent);
                RtfWriter.writeInt(byteArrayOutputStream, (int)((double)(list.indentationLeft() + (float)list.symbolIndent()) * 20.0));
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(fontSize);
                RtfWriter.writeInt(byteArrayOutputStream, 20);
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(listBegin);
                RtfWriter.writeInt(byteArrayOutputStream, this.currentListID);
                if (this.listLevel > 0) {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(listCurrentLevel);
                    RtfWriter.writeInt(byteArrayOutputStream, this.listLevel);
                }
            }
            byteArrayOutputStream.write(10);
        }
        byteArrayOutputStream.write(125);
        if (this.listLevel == 0) {
            int n6 = this.getRandomInt();
            this.listtable.write(92);
            this.listtable.write(listID);
            RtfWriter.writeInt(this.listtable, n6);
            this.listtable.write(125);
            this.listtable.write(10);
            this.listoverride.write(123);
            this.listoverride.write(92);
            this.listoverride.write(listOverride);
            this.listoverride.write(92);
            this.listoverride.write(listID);
            RtfWriter.writeInt(this.listoverride, n6);
            this.listoverride.write(92);
            this.listoverride.write(listOverrideCount);
            RtfWriter.writeInt(this.listoverride, 0);
            this.listoverride.write(92);
            this.listoverride.write(listBegin);
            RtfWriter.writeInt(this.listoverride, this.currentListID);
            ++this.currentListID;
            this.listoverride.write(125);
            this.listoverride.write(10);
        }
    }

    private void writeTable(Table table, ByteArrayOutputStream byteArrayOutputStream) throws IOException, DocumentException {
        this.inTable = true;
        table.complete();
        RtfTable rtfTable = new RtfTable(this);
        rtfTable.importTable(table, this.pageWidth);
        rtfTable.writeTable(byteArrayOutputStream);
        this.inTable = false;
    }

    private void writeImage(Image image, ByteArrayOutputStream byteArrayOutputStream) throws IOException, DocumentException {
        if (!image.isPng() && !image.isJpeg()) {
            throw new DocumentException("Only PNG and JPEG images are supported by the RTF Writer");
        }
        switch (image.alignment()) {
            case 0: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(alignLeft);
                break;
            }
            case 2: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(alignRight);
                break;
            }
            case 1: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(alignCenter);
                break;
            }
            case 3: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(alignJustify);
            }
        }
        byteArrayOutputStream.write(123);
        byteArrayOutputStream.write(extendedEscape);
        byteArrayOutputStream.write(pictureGroup);
        byteArrayOutputStream.write(123);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(picture);
        byteArrayOutputStream.write(92);
        if (image.isPng()) {
            byteArrayOutputStream.write(picturePNG);
        }
        if (image.isJpeg()) {
            byteArrayOutputStream.write(pictureJPEG);
        }
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(pictureWidth);
        RtfWriter.writeInt(byteArrayOutputStream, (int)((double)image.plainWidth() * 20.0));
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(pictureHeight);
        RtfWriter.writeInt(byteArrayOutputStream, (int)((double)image.plainHeight() * 20.0));
        if (image.width() > 0.0f) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(pictureScaleX);
            RtfWriter.writeInt(byteArrayOutputStream, (int)(100.0f / image.width() * image.plainWidth()));
        }
        if (image.height() > 0.0f) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(pictureScaleY);
            RtfWriter.writeInt(byteArrayOutputStream, (int)(100.0f / image.height() * image.plainHeight()));
        }
        byteArrayOutputStream.write(32);
        InputStream inputStream = image.rawData() == null ? image.url().openStream() : new ByteArrayInputStream(image.rawData());
        int n = -1;
        int n2 = 0;
        byteArrayOutputStream.write(10);
        while ((n = inputStream.read()) != -1) {
            String string = Integer.toHexString(n);
            if (string.length() < 2) {
                string = "0" + string;
            }
            byteArrayOutputStream.write(string.getBytes());
            if (++n2 != 64) continue;
            byteArrayOutputStream.write(10);
            n2 = 0;
        }
        byteArrayOutputStream.write(125);
        byteArrayOutputStream.write(125);
        byteArrayOutputStream.write(10);
    }

    private void writeAnnotation(Annotation annotation, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n = this.getRandomInt();
        byteArrayOutputStream.write(123);
        byteArrayOutputStream.write(extendedEscape);
        byteArrayOutputStream.write(annotationID);
        byteArrayOutputStream.write(32);
        RtfWriter.writeInt(byteArrayOutputStream, n);
        byteArrayOutputStream.write(125);
        byteArrayOutputStream.write(123);
        byteArrayOutputStream.write(extendedEscape);
        byteArrayOutputStream.write(annotationAuthor);
        byteArrayOutputStream.write(32);
        byteArrayOutputStream.write(annotation.title().getBytes());
        byteArrayOutputStream.write(125);
        byteArrayOutputStream.write(123);
        byteArrayOutputStream.write(extendedEscape);
        byteArrayOutputStream.write(RtfWriter.annotation);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(paragraphDefaults);
        byteArrayOutputStream.write(32);
        byteArrayOutputStream.write(annotation.content().getBytes());
        byteArrayOutputStream.write(125);
    }

    private void writeMeta(byte[] byArray, Meta meta) throws IOException {
        this.info.write(123);
        try {
            this.info.write(92);
            this.info.write(byArray);
            this.info.write(32);
            if (meta.type() == 6) {
                this.writeFormatedDateTime(meta.content());
            } else {
                this.info.write(meta.content().getBytes());
            }
            Object var4_3 = null;
            this.info.write(125);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.info.write(125);
            throw throwable;
        }
    }

    private void writeFormatedDateTime(String string) throws IOException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        if (date == null) {
            date = new Date();
        }
        calendar.setTime(date);
        this.info.write(92);
        this.info.write(year);
        RtfWriter.writeInt(this.info, calendar.get(1));
        this.info.write(92);
        this.info.write(month);
        RtfWriter.writeInt(this.info, calendar.get(2));
        this.info.write(92);
        this.info.write(day);
        RtfWriter.writeInt(this.info, calendar.get(5));
        this.info.write(92);
        this.info.write(hour);
        RtfWriter.writeInt(this.info, calendar.get(11));
        this.info.write(92);
        this.info.write(minute);
        RtfWriter.writeInt(this.info, calendar.get(12));
        this.info.write(92);
        this.info.write(second);
        RtfWriter.writeInt(this.info, calendar.get(13));
    }

    protected int addFont(Font font) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.fontList.size()) {
            if (font.getFamilyname().equals(((Font)this.fontList.get(n2)).getFamilyname())) {
                n = n2;
            }
            ++n2;
        }
        if (n == -1) {
            this.fontList.add(font);
            return this.fontList.size() - 1;
        }
        return n;
    }

    protected int addColor(Color color) {
        int n = 0;
        if (color == null) {
            return n;
        }
        n = this.colorList.indexOf(color);
        if (n == -1) {
            this.colorList.add(color);
            return this.colorList.size() - 1;
        }
        return n;
    }

    private boolean writeDocument() {
        try {
            this.writeDocumentIntro();
            this.os.write(10);
            this.writeFontList();
            this.os.write(10);
            this.writeColorList();
            this.os.write(10);
            this.writeList();
            this.os.write(10);
            this.writeInfoGroup();
            this.os.write(10);
            this.writeDocumentFormat();
            this.os.write(10);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeSectionDefaults(byteArrayOutputStream);
            byteArrayOutputStream.writeTo(this.os);
            this.content.writeTo(this.os);
            this.os.write(125);
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            return false;
        }
    }

    private void writeDocumentIntro() throws IOException {
        this.os.write(123);
        this.os.write(92);
        this.os.write(docBegin);
        this.os.write(92);
        this.os.write(ansi);
        this.os.write(92);
        this.os.write(ansiCodepage);
        RtfWriter.writeInt(this.os, 1252);
        this.os.write(92);
        this.os.write(defaultFont);
        RtfWriter.writeInt(this.os, 0);
    }

    private void writeFontList() throws IOException {
        this.os.write(123);
        this.os.write(92);
        this.os.write(fontTable);
        int n = 0;
        while (n < this.fontList.size()) {
            Font font = (Font)this.fontList.get(n);
            this.os.write(123);
            this.os.write(92);
            this.os.write(102);
            RtfWriter.writeInt(this.os, n);
            this.os.write(92);
            switch (Font.getFamilyIndex(font.getFamilyname())) {
                case 0: {
                    this.os.write(fontModern);
                    this.os.write(92);
                    this.os.write(fontCharset);
                    RtfWriter.writeInt(this.os, 0);
                    this.os.write(32);
                    this.os.write(fontCourier);
                    break;
                }
                case 1: {
                    this.os.write(fontSwiss);
                    this.os.write(92);
                    this.os.write(fontCharset);
                    RtfWriter.writeInt(this.os, 0);
                    this.os.write(32);
                    this.os.write(fontArial);
                    break;
                }
                case 3: {
                    this.os.write(fontRoman);
                    this.os.write(92);
                    this.os.write(fontCharset);
                    RtfWriter.writeInt(this.os, 2);
                    this.os.write(32);
                    this.os.write(fontSymbol);
                    break;
                }
                case 2: {
                    this.os.write(fontRoman);
                    this.os.write(92);
                    this.os.write(fontCharset);
                    RtfWriter.writeInt(this.os, 0);
                    this.os.write(32);
                    this.os.write(fontTimesNewRoman);
                    break;
                }
                case 4: {
                    this.os.write(fontTech);
                    this.os.write(92);
                    this.os.write(fontCharset);
                    RtfWriter.writeInt(this.os, 0);
                    this.os.write(32);
                    this.os.write(fontWindings);
                    break;
                }
                default: {
                    this.os.write(font.getFamilyname().getBytes());
                    this.os.write(92);
                    this.os.write(fontCharset);
                    RtfWriter.writeInt(this.os, 0);
                    this.os.write(32);
                    this.os.write(font.getFamilyname().getBytes());
                }
            }
            this.os.write(59);
            this.os.write(125);
            ++n;
        }
        this.os.write(125);
    }

    private void writeColorList() throws IOException {
        Color color = null;
        this.os.write(123);
        this.os.write(92);
        this.os.write(colorTable);
        int n = 0;
        while (n < this.colorList.size()) {
            color = (Color)this.colorList.get(n);
            this.os.write(92);
            this.os.write(colorRed);
            RtfWriter.writeInt(this.os, color.getRed());
            this.os.write(92);
            this.os.write(colorGreen);
            RtfWriter.writeInt(this.os, color.getGreen());
            this.os.write(92);
            this.os.write(colorBlue);
            RtfWriter.writeInt(this.os, color.getBlue());
            this.os.write(59);
            ++n;
        }
        this.os.write(125);
    }

    private void writeInfoGroup() throws IOException {
        this.os.write(123);
        this.os.write(92);
        this.os.write(infoBegin);
        this.info.writeTo(this.os);
        this.os.write(125);
    }

    private void writeList() throws IOException {
        this.listtable.write(125);
        this.listoverride.write(125);
        this.listtable.writeTo(this.os);
        this.os.write(10);
        this.listoverride.writeTo(this.os);
    }

    public static final void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(Integer.toString(n).getBytes());
    }

    private int getRandomInt() {
        boolean bl = false;
        Integer n = null;
        Integer n2 = null;
        while (!bl) {
            n = new Integer((int)(Math.random() * 2.147483647E9));
            bl = true;
            int n3 = 0;
            while (n3 < this.listIds.size()) {
                n2 = (Integer)this.listIds.get(n3);
                if (n2.equals(n)) {
                    bl = true;
                }
                ++n3;
            }
        }
        this.listIds.add(n);
        return n;
    }

    public void writeHeadersFooters(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        HeaderFooter headerFooter;
        RtfHeaderFooters rtfHeaderFooters;
        if (this.footer instanceof RtfHeaderFooters) {
            rtfHeaderFooters = (RtfHeaderFooters)this.footer;
            headerFooter = rtfHeaderFooters.get(0);
            if (headerFooter != null) {
                this.writeHeaderFooter(headerFooter, footerBegin, byteArrayOutputStream);
            }
            if ((headerFooter = rtfHeaderFooters.get(1)) != null) {
                this.writeHeaderFooter(headerFooter, footerlBegin, byteArrayOutputStream);
            }
            if ((headerFooter = rtfHeaderFooters.get(2)) != null) {
                this.writeHeaderFooter(headerFooter, footerrBegin, byteArrayOutputStream);
            }
            if ((headerFooter = rtfHeaderFooters.get(3)) != null) {
                this.writeHeaderFooter(headerFooter, footerfBegin, byteArrayOutputStream);
            }
        } else {
            this.writeHeaderFooter(this.footer, footerBegin, byteArrayOutputStream);
        }
        if (this.header instanceof RtfHeaderFooters) {
            rtfHeaderFooters = (RtfHeaderFooters)this.header;
            headerFooter = rtfHeaderFooters.get(0);
            if (headerFooter != null) {
                this.writeHeaderFooter(headerFooter, headerBegin, byteArrayOutputStream);
            }
            if ((headerFooter = rtfHeaderFooters.get(1)) != null) {
                this.writeHeaderFooter(headerFooter, headerlBegin, byteArrayOutputStream);
            }
            if ((headerFooter = rtfHeaderFooters.get(2)) != null) {
                this.writeHeaderFooter(headerFooter, headerrBegin, byteArrayOutputStream);
            }
            if ((headerFooter = rtfHeaderFooters.get(3)) != null) {
                this.writeHeaderFooter(headerFooter, headerfBegin, byteArrayOutputStream);
            }
        } else {
            this.writeHeaderFooter(this.header, headerBegin, byteArrayOutputStream);
        }
    }

    private void writeHeaderFooter(HeaderFooter headerFooter, byte[] byArray, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        this.inHeaderFooter = true;
        try {
            byteArrayOutputStream.write(123);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(32);
            if (headerFooter != null) {
                if (headerFooter instanceof RtfHeaderFooter && ((RtfHeaderFooter)headerFooter).content() != null) {
                    this.addElement(((RtfHeaderFooter)headerFooter).content(), byteArrayOutputStream);
                } else {
                    if (headerFooter.getBefore() != null) {
                        this.addElement(headerFooter.getBefore(), byteArrayOutputStream);
                    }
                    if (headerFooter.isNumbered()) {
                        this.addElement(new RtfPageNumber("", headerFooter.getBefore().font()), byteArrayOutputStream);
                    }
                    if (headerFooter.getAfter() != null) {
                        this.addElement(headerFooter.getAfter(), byteArrayOutputStream);
                    }
                }
            }
            byteArrayOutputStream.write(125);
        }
        catch (DocumentException documentException) {
            throw new IOException("DocumentException - " + documentException.getMessage());
        }
        this.inHeaderFooter = false;
    }

    private void writeDocumentFormat() throws IOException {
        this.os.write(92);
        this.os.write(rtfPaperWidth);
        RtfWriter.writeInt(this.os, this.pageWidth);
        this.os.write(92);
        this.os.write(rtfPaperHeight);
        RtfWriter.writeInt(this.os, this.pageHeight);
        this.os.write(92);
        this.os.write(rtfMarginLeft);
        RtfWriter.writeInt(this.os, this.marginLeft);
        this.os.write(92);
        this.os.write(rtfMarginRight);
        RtfWriter.writeInt(this.os, this.marginRight);
        this.os.write(92);
        this.os.write(rtfMarginTop);
        RtfWriter.writeInt(this.os, this.marginTop);
        this.os.write(92);
        this.os.write(rtfMarginBottom);
        RtfWriter.writeInt(this.os, this.marginBottom);
    }

    private void initDefaults() {
        this.fontList.clear();
        this.colorList.clear();
        this.info = new ByteArrayOutputStream();
        this.content = new ByteArrayOutputStream();
        this.listtable = new ByteArrayOutputStream();
        this.listoverride = new ByteArrayOutputStream();
        this.document.addProducer();
        this.document.addCreationDate();
        this.addFont(new Font(2, 10.0f, 0));
        this.addColor(new Color(0, 0, 0));
        this.addColor(new Color(255, 255, 255));
        this.listIds = new Vector();
        try {
            this.listtable.write(123);
            this.listtable.write(extendedEscape);
            this.listtable.write(listtableGroup);
            this.listtable.write(10);
            this.listoverride.write(123);
            this.listoverride.write(extendedEscape);
            this.listoverride.write(listoverridetableGroup);
            this.listoverride.write(10);
        }
        catch (IOException iOException) {
            System.err.println("InitDefaultsError" + iOException);
        }
    }

    private void writeSectionDefaults(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        if (this.header instanceof RtfHeaderFooters || this.footer instanceof RtfHeaderFooters) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(facingPages);
        }
        if (this.hasTitlePage) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(titlePage);
        }
        this.writeHeadersFooters(byteArrayOutputStream);
        if (this.landscape) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(landscapeTag1);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(landscapeTag2);
        }
    }

    private boolean parseFormat(Rectangle rectangle, boolean bl) {
        if (bl) {
            rectangle = rectangle.rotate();
        }
        if (this.rectEquals(rectangle, PageSize.A3)) {
            this.pageWidth = 16837;
            this.pageHeight = 23811;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.A4)) {
            this.pageWidth = 11907;
            this.pageHeight = 16840;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.A5)) {
            this.pageWidth = 8391;
            this.pageHeight = 11907;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.A6)) {
            this.pageWidth = 5959;
            this.pageHeight = 8420;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.B4)) {
            this.pageWidth = 14570;
            this.pageHeight = 20636;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.B5)) {
            this.pageWidth = 10319;
            this.pageHeight = 14572;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.HALFLETTER)) {
            this.pageWidth = 7927;
            this.pageHeight = 12247;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.LETTER)) {
            this.pageWidth = 12242;
            this.pageHeight = 15842;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.LEGAL)) {
            this.pageWidth = 12252;
            this.pageHeight = 20163;
            this.landscape = bl;
            return true;
        }
        if (!bl && this.parseFormat(rectangle, true)) {
            int n = this.pageWidth;
            this.pageWidth = this.pageHeight;
            this.pageHeight = n;
            return true;
        }
        return false;
    }

    private boolean rectEquals(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.width() == rectangle2.width() && rectangle.height() == rectangle2.height();
    }

    public boolean writingHeaderFooter() {
        return this.inHeaderFooter;
    }

    public static final String filterSpecialChar(String string) {
        int n = string.length();
        char c = 'z';
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (c2 == '\\') {
                stringBuffer.append("\\\\");
            } else if (c2 == '\n') {
                stringBuffer.append("\\par ");
            } else if (c2 > c) {
                stringBuffer.append("\\u").append((long)c2).append('G');
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

