/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Model;
import org.jmol.adapter.smarter.ModelReader;

class HinReader
extends ModelReader {
    String errorMessage;
    int modelNumber;
    int atomIndex;
    int baseAtomIndex;
    String[] tokens;
    static final int MAX_TOKENS = 40;

    HinReader() {
    }

    Model readModel(BufferedReader reader) throws Exception {
        this.model = new Model("hin");
        this.readAtoms(reader);
        if (this.errorMessage != null) {
            this.model.errorMessage = this.errorMessage;
        } else if (this.model.atomCount == 0) {
            this.model.errorMessage = "No atoms in file";
        }
        return this.model;
    }

    void readAtoms(BufferedReader reader) throws Exception {
        String line;
        this.modelNumber = 0;
        this.tokens = new String[40];
        this.errorMessage = null;
        while (this.errorMessage == null && (line = reader.readLine()) != null) {
            if (line.length() == 0 || line.charAt(0) == ';') continue;
            if (line.startsWith("mol ")) {
                this.processMol(line);
                continue;
            }
            if (line.startsWith("atom ")) {
                this.processAtom(line);
                continue;
            }
            if (!line.startsWith("endmol ")) continue;
            this.processEndmol(line);
        }
        this.tokens = null;
    }

    void processMol(String line) {
        this.model.setModelName(this.getMolName(line));
        this.atomIndex = 0;
        this.baseAtomIndex = this.model.atomCount;
        ++this.modelNumber;
    }

    String getMolName(String line) {
        this.parseToken(line);
        this.parseToken(line, this.ichNextParse);
        return this.parseToken(line, this.ichNextParse);
    }

    /*
     * WARNING - void declaration
     */
    void processAtom(String line) {
        int fileAtomNumber = this.parseInt(line, 5);
        if (fileAtomNumber - 1 != this.atomIndex) {
            this.errorMessage = "bad atom number sequence ... expected:" + (this.atomIndex + 1) + " found:" + fileAtomNumber;
            return;
        }
        Atom atom = this.model.addNewAtom();
        atom.modelNumber = this.modelNumber;
        this.parseToken(line, this.ichNextParse);
        atom.elementSymbol = this.parseToken(line, this.ichNextParse);
        this.parseToken(line, this.ichNextParse);
        this.parseToken(line, this.ichNextParse);
        atom.partialCharge = this.parseFloat(line, this.ichNextParse);
        atom.x = this.parseFloat(line, this.ichNextParse);
        atom.y = this.parseFloat(line, this.ichNextParse);
        atom.z = this.parseFloat(line, this.ichNextParse);
        int bondCount = this.parseInt(line, this.ichNextParse);
        for (int i = 0; i < bondCount; ++i) {
            void var8_8;
            int otherAtomNumber = this.parseInt(line, this.ichNextParse);
            String bondTypeToken = this.parseToken(line, this.ichNextParse);
            if (otherAtomNumber > this.atomIndex) continue;
            switch (bondTypeToken.charAt(0)) {
                case 's': {
                    int bondOrder = 1;
                    break;
                }
                case 'd': {
                    int bondOrder = 2;
                    break;
                }
                case 't': {
                    int bondOrder = 3;
                    break;
                }
                case 'a': {
                    int bondOrder = 4;
                    break;
                }
                default: {
                    this.errorMessage = "unrecognized bond type:" + bondTypeToken + " atom #" + fileAtomNumber;
                    return;
                }
            }
            this.model.addNewBond(this.baseAtomIndex + this.atomIndex, this.baseAtomIndex + otherAtomNumber - 1, (int)var8_8);
        }
        ++this.atomIndex;
    }

    void processEndmol(String line) {
    }
}

