/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Color;
import org.jmol.g3d.Shade3D;

class Colix {
    private static short colixMax = 1;
    private static int[] argbs = new int[128];
    private static Color[] colors = new Color[128];
    private static int[][] ashades = new int[128][];

    Colix() {
    }

    static short getColix(int argb) {
        if (argb == 0) {
            return 0;
        }
        argb |= 0xFF000000;
        int i = colixMax;
        while (--i >= 0) {
            if (argb != argbs[i]) continue;
            return (short)i;
        }
        if (colixMax == argbs.length) {
            int oldSize = argbs.length;
            int[] t0 = new int[oldSize * 2];
            System.arraycopy(argbs, 0, t0, 0, oldSize);
            argbs = t0;
            Color[] t1 = new Color[oldSize * 2];
            System.arraycopy(colors, 0, t1, 0, oldSize);
            colors = t1;
            int[][] t2 = new int[oldSize * 2][];
            System.arraycopy(ashades, 0, t2, 0, oldSize);
            ashades = t2;
        }
        Colix.argbs[Colix.colixMax] = argb;
        short s = colixMax;
        colixMax = (short)(s + 1);
        return s;
    }

    static short getColix(Color color) {
        if (color == null) {
            return 0;
        }
        int argb = color.getRGB();
        short colix = Colix.getColix(argb);
        if (colors[colix] == null && (argb & 0xFF000000) == -16777216) {
            Colix.colors[colix] = color;
        }
        return colix;
    }

    static Color getColor(short colix) {
        if (colix == 0) {
            return null;
        }
        Color color = colors[colix];
        if (color == null) {
            color = Colix.colors[colix] = new Color(argbs[colix]);
        }
        return colors[colix];
    }

    static int getArgb(short colix) {
        return argbs[colix];
    }

    static int[] getShades(short colix) {
        int[] shades = ashades[colix];
        if (shades == null) {
            Colix.ashades[colix] = Shade3D.getShades(argbs[colix]);
            shades = Colix.ashades[colix];
        }
        return shades;
    }

    static void flushShades() {
        int i = colixMax;
        while (--i >= 0) {
            Colix.ashades[i] = null;
        }
    }
}

