/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.Isotope;

public class AtomType
extends Isotope
implements Serializable,
Cloneable {
    String id = null;
    double maxBondOrder;
    double bondOrderSum;
    double vanderwaalsRadius;
    double covalentRadius;
    protected int formalCharge;
    protected int hybridization;

    public AtomType(String elementSymbol) {
        super(elementSymbol);
    }

    public AtomType(String id, String elementSymbol) {
        this(elementSymbol);
        this.setAtomTypeName(id);
    }

    public void setAtomTypeName(String id) {
        this.id = id;
    }

    public void setMaxBondOrder(double maxBondOrder) {
        this.maxBondOrder = maxBondOrder;
    }

    public void setBondOrderSum(double bondOrderSum) {
        this.bondOrderSum = bondOrderSum;
    }

    public String getAtomTypeName() {
        return this.id;
    }

    public double getMaxBondOrder() {
        return this.maxBondOrder;
    }

    public double getBondOrderSum() {
        return this.bondOrderSum;
    }

    public void setFormalCharge(int charge) {
        this.formalCharge = charge;
    }

    public int getFormalCharge() {
        return this.formalCharge;
    }

    public void setHybridization(int hybridization) {
        this.hybridization = hybridization;
    }

    public int getHybridization() {
        return this.hybridization;
    }

    public boolean compare(Object object) {
        if (!(object instanceof AtomType)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        AtomType type = (AtomType)object;
        return this.getAtomTypeName() == type.getAtomTypeName() && this.maxBondOrder == type.maxBondOrder && this.bondOrderSum == type.bondOrderSum;
    }

    public void setVanderwaalsRadius(double radius) {
        this.vanderwaalsRadius = radius;
    }

    public double getVanderwaalsRadius() {
        return this.vanderwaalsRadius;
    }

    public void setCovalentRadius(double radius) {
        this.covalentRadius = radius;
    }

    public double getCovalentRadius() {
        return this.covalentRadius;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AtomType(");
        sb.append(this.getAtomTypeName() + ", ");
        sb.append("MBO:" + this.getMaxBondOrder() + ", ");
        sb.append("BOS:" + this.getBondOrderSum() + ", ");
        sb.append(super.toString());
        sb.append(")");
        return sb.toString();
    }
}

