/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.tools.IDCreator;
import org.openscience.cdk.tools.LoggingTool;

public class CDKSourceCodeWriter
extends DefaultChemObjectWriter {
    private BufferedWriter writer;
    private LoggingTool logger;

    public CDKSourceCodeWriter(Writer out) {
        this.writer = new BufferedWriter(out);
        this.logger = new LoggingTool(this);
    }

    public String getFormatName() {
        return "CDK Source Code Fragment";
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void write(ChemObject object) throws CDKException {
        if (object instanceof Molecule) {
            try {
                this.writeMolecule((Molecule)object);
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage());
                this.logger.debug(ex);
            }
        } else {
            throw new CDKException("Only supported is writing of Molecule objects.");
        }
    }

    public ChemObject highestSupportedChemObject() {
        return new Molecule();
    }

    public void writeMolecule(Molecule molecule) throws Exception {
        this.writer.write("{\n");
        this.writer.write("  Molecule mol = new Molecule();\n");
        IDCreator idCreator = new IDCreator();
        idCreator.createIDs((AtomContainer)molecule);
        Atom[] atoms = molecule.getAtoms();
        for (int i = 0; i < atoms.length; ++i) {
            Atom atom = atoms[i];
            this.writeAtom(atom);
            this.writer.write("  mol.addAtom(" + atom.getID() + ");\n");
        }
        Bond[] bonds = molecule.getBonds();
        for (int i = 0; i < bonds.length; ++i) {
            Bond bond = bonds[i];
            this.writeBond(bond);
            this.writer.write("  mol.addBond(" + bond.getID() + ");\n");
        }
        this.writer.write("}\n");
    }

    public void writeAtom(Atom atom) throws Exception {
        this.writer.write("  Atom " + atom.getID() + " = new Atom(\"" + atom.getSymbol() + "\");\n");
    }

    public void writeBond(Bond bond) throws Exception {
        this.writer.write("  Bond " + bond.getID() + " = new Bond(" + bond.getAtomAt(0).getID() + ", " + bond.getAtomAt(1).getID() + ", " + bond.getOrder() + ");\n");
    }
}

