/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectWriter;

public class HINWriter
extends DefaultChemObjectWriter {
    private static BufferedWriter writer;

    public HINWriter(Writer out) {
        writer = new BufferedWriter(out);
    }

    public String getFormatName() {
        return "HIN";
    }

    public void close() throws IOException {
        writer.close();
    }

    public void write(ChemObject object) throws CDKException {
        if (object instanceof Molecule) {
            try {
                SetOfMolecules som = new SetOfMolecules();
                som.addMolecule((Molecule)object);
                this.writeMolecule(som);
            }
            catch (Exception ex) {
                throw new CDKException("Error while writing HIN file: " + ex.getMessage());
            }
        } else if (object instanceof SetOfMolecules) {
            try {
                this.writeMolecule((SetOfMolecules)object);
            }
            catch (IOException iOException) {}
        } else {
            throw new CDKException("HINWriter only supports output of Molecule or SetOfMolecule classes.");
        }
    }

    public ChemObject highestSupportedChemObject() {
        return new SetOfMolecules();
    }

    private void writeMolecule(SetOfMolecules som) throws IOException {
        boolean na = false;
        String info = "";
        String sym = "";
        double chrg = 0.0;
        boolean writecharge = true;
        for (int molnum = 0; molnum < som.getMoleculeCount(); ++molnum) {
            Molecule mol = som.getMolecule(molnum);
            int natom = mol.getAtomCount();
            int nbond = mol.getBondCount();
            String molname = "mol " + (molnum + 1) + " " + (String)mol.getProperty("Title");
            writer.write(molname, 0, molname.length());
            writer.newLine();
            Atom[] atoms = mol.getAtoms();
            Bond[] bonds = mol.getBonds();
            for (int i = 0; i < natom; ++i) {
                String line = "atom ";
                Atom a = atoms[i];
                sym = a.getSymbol();
                chrg = a.getCharge();
                Point3d p3 = a.getPoint3d();
                line = line + new Integer(i + 1).toString() + " - " + sym + " ** - " + new Double(chrg).toString() + " " + new Double(p3.x).toString() + " " + new Double(p3.y).toString() + " " + new Double(p3.z).toString() + " ";
                String buf = "";
                int ncon = 0;
                for (int j = 0; j < nbond; ++j) {
                    Bond b = bonds[j];
                    if (!b.contains(a)) continue;
                    Atom ca = b.getConnectedAtom(a);
                    double bo = b.getOrder();
                    int serial = -1;
                    String bt = "";
                    serial = mol.getAtomNumber(ca);
                    if (bo == 1.0) {
                        bt = new String("s");
                    } else if (bo == 2.0) {
                        bt = new String("d");
                    } else if (bo == 3.0) {
                        bt = new String("t");
                    } else if (bo == 1.5) {
                        bt = new String("a");
                    }
                    buf = buf + new Integer(serial + 1).toString() + " " + bt + " ";
                    ++ncon;
                }
                line = line + " " + new Integer(ncon).toString() + " " + buf;
                writer.write(line, 0, line.length());
                writer.newLine();
            }
            String buf = "endmol " + (molnum + 1);
            writer.write(buf, 0, buf.length());
            writer.newLine();
            continue;
        }
    }
}

