/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.LoggingTool;

public class MDLV3000Reader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private LoggingTool logger = new LoggingTool(this.getClass().getName());
    private IsotopeFactory isotopeFactory = null;
    private Pattern keyValueTuple;
    private Pattern keyValueTuple2;

    public MDLV3000Reader(Reader in) {
        this.input = new BufferedReader(in);
        this.initIOSettings();
        try {
            this.isotopeFactory = IsotopeFactory.getInstance();
        }
        catch (Exception exception) {
            this.logger.error("Failed to initiate isotope factory: " + exception.getMessage());
            this.logger.debug(exception);
        }
        this.keyValueTuple = Pattern.compile("\\s*(\\w+)=([^\\s]*)(.*)");
        this.keyValueTuple2 = Pattern.compile("\\s*(\\w+)=\\(([^\\)]*)\\)(.*)");
    }

    public MDLV3000Reader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "MDL Mol/SDF V3000";
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public boolean matches(int lineNumber, String line) {
        return lineNumber == 4 && (line.indexOf("v3000") >= 0 || line.indexOf("V3000") >= 0);
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof Molecule) {
            return this.readMolecule();
        }
        return null;
    }

    public Molecule readMolecule() throws CDKException {
        return new Molecule(this.readConnectionTable());
    }

    public AtomContainer readConnectionTable() throws CDKException {
        AtomContainer readData = new AtomContainer();
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String command = this.readCommand();
            if ("END CTAB".equals(command)) {
                foundEND = true;
                continue;
            }
            if ("BEGIN CTAB".equals(command) || "COUNTS".equals(command)) continue;
            if ("BEGIN ATOM".equals(command)) {
                this.readAtomBlock(readData);
                continue;
            }
            if ("BEGIN BOND".equals(command)) {
                this.readBondBlock(readData);
                continue;
            }
            if ("BEGIN SGROUP".equals(command)) {
                this.readSGroup(readData);
                continue;
            }
            this.logger.warn("Unrecognized command: " + command);
        }
        return readData;
    }

    public void readAtomBlock(AtomContainer readData) throws CDKException {
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String error;
            String command = this.readCommand();
            if ("END ATOM".equals(command)) {
                foundEND = true;
                continue;
            }
            this.logger.debug("Parsing atom from: " + command);
            StringTokenizer tokenizer = new StringTokenizer(command);
            Atom atom = new Atom("C");
            try {
                String indexString = tokenizer.nextToken();
                atom.setID(indexString);
            }
            catch (Exception exception) {
                error = "Error while parsing atom index";
                this.logger.error(error);
                this.logger.debug(exception);
                throw new CDKException(error);
            }
            String element = tokenizer.nextToken();
            if (this.isPseudoAtom(element)) {
                atom = new PseudoAtom(atom);
            } else if (this.isotopeFactory.isElement(element)) {
                atom.setSymbol(element);
            } else {
                error = "Cannot parse element of type: " + element;
                this.logger.error(error);
                throw new CDKException("(Possible CDK bug) " + error);
            }
            try {
                String xString = tokenizer.nextToken();
                String yString = tokenizer.nextToken();
                String zString = tokenizer.nextToken();
                double x = Double.parseDouble(xString);
                double y = Double.parseDouble(yString);
                double z = Double.parseDouble(zString);
                atom.setPoint3d(new Point3d(x, y, z));
                atom.setPoint2d(new Point2d(x, y));
            }
            catch (Exception exception) {
                String error2 = "Error while parsing atom coordinates";
                this.logger.error(error2);
                this.logger.debug(exception);
                throw new CDKException(error2);
            }
            String mapping = tokenizer.nextToken();
            if (!mapping.equals("0")) {
                this.logger.warn("Skipping atom-atom mapping: " + mapping);
            }
            if (command.indexOf("=") != -1) {
                Hashtable options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
                Enumeration keys = options.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)options.get(key);
                    try {
                        if (key.equals("CHG")) {
                            int charge = Integer.parseInt(value);
                            if (charge == 0) continue;
                            atom.setFormalCharge(charge);
                            continue;
                        }
                        this.logger.warn("Not parsing key: " + key);
                    }
                    catch (Exception exception) {
                        String error3 = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        this.logger.error(error3);
                        this.logger.debug(exception);
                        throw new CDKException(error3);
                    }
                }
            }
            readData.addAtom(atom);
            this.logger.debug("Added atom: " + atom);
        }
    }

    public void readBondBlock(AtomContainer readData) throws CDKException {
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String command = this.readCommand();
            if ("END BOND".equals(command)) {
                foundEND = true;
                continue;
            }
            this.logger.debug("Parsing bond from: " + command);
            StringTokenizer tokenizer = new StringTokenizer(command);
            Bond bond = new Bond();
            try {
                String indexString = tokenizer.nextToken();
                bond.setID(indexString);
            }
            catch (Exception exception) {
                String error = "Error while parsing bond index";
                this.logger.error(error);
                this.logger.debug(exception);
                throw new CDKException(error);
            }
            try {
                String orderString = tokenizer.nextToken();
                int order = Integer.parseInt(orderString);
                if (order >= 4) {
                    this.logger.warn("Query order types are not supported (yet). File a bug if you need it");
                } else {
                    bond.setOrder(order);
                }
            }
            catch (Exception exception) {
                String error = "Error while parsing bond index";
                this.logger.error(error);
                this.logger.debug(exception);
                throw new CDKException(error);
            }
            try {
                String indexAtom1String = tokenizer.nextToken();
                int indexAtom1 = Integer.parseInt(indexAtom1String);
                Atom atom1 = readData.getAtomAt(indexAtom1 - 1);
                bond.setAtomAt(atom1, 0);
            }
            catch (Exception exception) {
                String error = "Error while parsing index atom 1 in bond";
                this.logger.error(error);
                this.logger.debug(exception);
                throw new CDKException(error);
            }
            try {
                String indexAtom2String = tokenizer.nextToken();
                int indexAtom2 = Integer.parseInt(indexAtom2String);
                Atom atom2 = readData.getAtomAt(indexAtom2 - 1);
                bond.setAtomAt(atom2, 1);
            }
            catch (Exception exception) {
                String error = "Error while parsing index atom 2 in bond";
                this.logger.error(error);
                this.logger.debug(exception);
                throw new CDKException(error);
            }
            if (command.indexOf("=") != -1) {
                Hashtable options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
                Enumeration keys = options.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)options.get(key);
                    try {
                        if (key.equals("CFG")) {
                            int configuration = Integer.parseInt(value);
                            if (configuration == 0) {
                                bond.setStereo(0);
                                continue;
                            }
                            if (configuration == 1) {
                                bond.setStereo(1);
                                continue;
                            }
                            if (configuration == 2) {
                                bond.setStereo(4);
                                continue;
                            }
                            if (configuration != 3) continue;
                            bond.setStereo(-1);
                            continue;
                        }
                        this.logger.warn("Not parsing key: " + key);
                    }
                    catch (Exception exception) {
                        String error = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        this.logger.error(error);
                        this.logger.debug(exception);
                        throw new CDKException(error);
                    }
                }
            }
            readData.addBond(bond);
            this.logger.debug("Added bond: " + bond);
        }
    }

    public void readSGroup(AtomContainer readData) throws CDKException {
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String command = this.readCommand();
            if ("END SGROUP".equals(command)) {
                foundEND = true;
                continue;
            }
            this.logger.debug("Parsing Sgroup line: " + command);
            StringTokenizer tokenizer = new StringTokenizer(command);
            String indexString = tokenizer.nextToken();
            this.logger.warn("Skipping external index: " + indexString);
            String type = tokenizer.nextToken();
            String externalIndexString = tokenizer.nextToken();
            this.logger.warn("Skipping external index: " + externalIndexString);
            Hashtable options = new Hashtable();
            if (command.indexOf("=") != -1) {
                options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
            }
            if (type.startsWith("SUP")) {
                Enumeration keys = options.keys();
                int atomID = -1;
                String label = "";
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)options.get(key);
                    try {
                        if (key.equals("ATOMS")) {
                            StringTokenizer atomsTokenizer = new StringTokenizer(value);
                            int atomCount = Integer.parseInt(atomsTokenizer.nextToken());
                            atomID = Integer.parseInt(atomsTokenizer.nextToken());
                        } else if (key.equals("LABEL")) {
                            label = value;
                        } else {
                            this.logger.warn("Not parsing key: " + key);
                        }
                    }
                    catch (Exception exception) {
                        String error = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        this.logger.error(error);
                        this.logger.debug(exception);
                        throw new CDKException(error);
                    }
                    if (atomID == -1 || label.length() <= 0) continue;
                    Atom atom = readData.getAtomAt(atomID - 1);
                    if (!(atom instanceof PseudoAtom)) {
                        atom = new PseudoAtom(atom);
                    }
                    ((PseudoAtom)atom).setLabel(label);
                    readData.setAtomAt(atomID - 1, atom);
                }
                continue;
            }
            this.logger.warn("Skipping unrecognized SGROUP type: " + type);
        }
    }

    private String readCommand() throws CDKException {
        String line = this.readLine();
        if (line.startsWith("M  V30 ")) {
            String command = line.substring(7);
            if (command.endsWith("-")) {
                command = command.substring(0, command.length() - 1);
                command = command + this.readCommand();
            }
            return command;
        }
        throw new CDKException("Could not read MDL file: unexpected line: " + line);
    }

    private Hashtable parseOptions(String string) throws CDKException {
        Hashtable<String, String> keyValueTuples = new Hashtable<String, String>();
        while (string.length() >= 3) {
            this.logger.debug("Matching remaining option string: " + string);
            Matcher tuple1Matcher = this.keyValueTuple2.matcher(string);
            if (tuple1Matcher.matches()) {
                String key = tuple1Matcher.group(1);
                String value = tuple1Matcher.group(2);
                string = tuple1Matcher.group(3);
                this.logger.debug("Found key: " + key);
                this.logger.debug("Found value: " + value);
                keyValueTuples.put(key, value);
                continue;
            }
            Matcher tuple2Matcher = this.keyValueTuple.matcher(string);
            if (tuple2Matcher.matches()) {
                String key = tuple2Matcher.group(1);
                String value = tuple2Matcher.group(2);
                string = tuple2Matcher.group(3);
                this.logger.debug("Found key: " + key);
                this.logger.debug("Found value: " + value);
                keyValueTuples.put(key, value);
                continue;
            }
            this.logger.warn("Quiting; could not parse: " + string + ".");
            string = "";
        }
        return keyValueTuples;
    }

    public String exhaustStringTokenizer(StringTokenizer tokenizer) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public String readLine() throws CDKException {
        String line = null;
        try {
            line = this.input.readLine();
            this.logger.debug("read line: " + line);
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            this.logger.error(error);
            this.logger.debug(exception);
            throw new CDKException(error);
        }
        return line;
    }

    public boolean isReady() throws CDKException {
        try {
            return this.input.ready();
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            this.logger.error(error);
            this.logger.debug(exception);
            throw new CDKException(error);
        }
    }

    private boolean isPseudoAtom(String element) {
        return element.equals("R#") || element.equals("Q") || element.equals("A") || element.equals("*");
    }

    public boolean accepts(ChemObject object) {
        return object instanceof Molecule;
    }

    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
    }

    private void customizeJob() {
    }

    public IOSetting[] getIOSettings() {
        return new IOSetting[0];
    }
}

