/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectWriter;

public class XYZWriter
extends DefaultChemObjectWriter {
    static BufferedWriter writer;

    public XYZWriter(Writer out) {
        writer = new BufferedWriter(out);
    }

    public String getFormatName() {
        return "XYZ";
    }

    public void close() throws IOException {
        writer.close();
    }

    public void write(ChemObject object) throws CDKException {
        if (object instanceof Molecule) {
            try {
                this.writeMolecule((Molecule)object);
            }
            catch (Exception ex) {
                throw new CDKException("Error while writing XYZ file: " + ex.getMessage());
            }
        } else {
            throw new CDKException("XYZWriter only supports output of Molecule classes.");
        }
    }

    public ChemObject highestSupportedChemObject() {
        return new Molecule();
    }

    public void writeMolecule(Molecule mol) throws IOException {
        boolean na = false;
        String info = "";
        String st = "";
        boolean writecharge = true;
        String s1 = new Integer(mol.getAtomCount()).toString();
        writer.write(s1, 0, s1.length());
        writer.newLine();
        String s2 = null;
        if (s2 != null) {
            writer.write(s2, 0, s2.length());
        }
        writer.newLine();
        Atom[] atoms = mol.getAtoms();
        for (int i = 0; i < atoms.length; ++i) {
            Atom a = atoms[i];
            st = a.getSymbol();
            Point3d p3 = a.getPoint3d();
            if (p3 != null) {
                st = st + "\t" + new Double(p3.x).toString() + "\t" + new Double(p3.y).toString() + "\t" + new Double(p3.z).toString();
            }
            if (writecharge) {
                double ct = a.getCharge();
                st = st + "\t" + ct;
            }
            writer.write(st, 0, st.length());
            writer.newLine();
        }
    }
}

