/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.chemrss;

import java.io.StringReader;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.io.CMLReader;
import org.openscience.cdk.tools.LoggingTool;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class RSSHandler
extends DefaultHandler {
    private LoggingTool logger = new LoggingTool(this);
    private ChemSequence channelSequence;
    private String cmlString;
    private String cData;
    private boolean readdedNamespace;
    private String objectTitle;
    private String objectDesc;
    private String objectDate;
    private String objectLink;
    private String dcCreator;
    private String dcPublisher;

    public ChemSequence getChemSequence() {
        return this.channelSequence;
    }

    public void characters(char[] ch, int start, int length) {
        if (this.cData == null) {
            this.cData = new String();
        }
        this.cData = this.cData + new String(ch, start, length);
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
    }

    public void startDocument() {
        this.channelSequence = new ChemSequence();
        this.cmlString = "";
        this.readdedNamespace = false;
        this.resetStrings();
    }

    public void endDocument() {
    }

    public void endElement(String uri, String local, String raw) {
        this.logger.debug("</" + raw + ">");
        if (uri.equals("http://www.xml-cml.org/schema/cml2/core")) {
            this.cmlString = this.cmlString + this.cData;
            this.cmlString = this.cmlString + this.toEndTag(raw);
        } else if (uri.equals("http://purl.org/dc/elements/1.1/")) {
            if (local.equals("publisher")) {
                this.dcPublisher = this.cData;
            } else if (local.equals("creator")) {
                this.dcCreator = this.cData;
            } else if (local.equals("date")) {
                this.objectDate = this.cData;
            }
        } else if (uri.equals("http://purl.org/rss/1.0/")) {
            if (local.equals("item")) {
                ChemObject model = null;
                if (this.cmlString.length() > 0) {
                    StringReader reader = new StringReader(this.cmlString);
                    this.logger.debug((Object)"Parsing CML String: ", this.cmlString);
                    CMLReader cmlReader = new CMLReader(reader);
                    try {
                        ChemFile file = (ChemFile)cmlReader.read(new ChemFile());
                        if (file.getChemSequenceCount() > 0) {
                            ChemSequence sequence = file.getChemSequence(0);
                            if (sequence.getChemModelCount() > 0) {
                                model = sequence.getChemModel(0);
                            } else {
                                this.logger.warn("ChemSequence contains no ChemModel");
                            }
                        } else {
                            this.logger.warn("ChemFile contains no ChemSequene");
                        }
                    }
                    catch (Exception exception) {
                        this.logger.error("Error while parsing CML");
                        this.logger.debug(exception);
                    }
                    model.setProperty("org.openscience.cdk.io.chemrss.ITEM_SOURCE", this.cmlString);
                } else {
                    this.logger.warn("No CML content found");
                }
                if (model == null) {
                    this.logger.warn("Read empty model");
                    model = new ChemModel();
                }
                model.setProperty("org.openscience.cdk.io.chemrss.ITEM_TITLE", this.objectTitle);
                model.setProperty("org.openscience.cdk.io.chemrss.ITEM_DATE", this.objectDate);
                model.setProperty("org.openscience.cdk.io.chemrss.ITEM_LINK", this.objectLink);
                model.setProperty("org.openscience.cdk.io.chemrss.ITEM_DESCRIPTION", this.objectDesc);
                model.setProperty("org.openscience.cdk.io.chemrss.ITEM_CREATOR", this.dcCreator);
                this.channelSequence.addChemModel((ChemModel)model);
                this.cmlString = "";
            } else if (local.equals("title")) {
                this.objectTitle = this.cData;
            } else if (local.equals("link")) {
                this.objectLink = this.cData;
            } else if (local.equals("description")) {
                this.objectDesc = this.cData;
            } else if (local.equals("channel")) {
                this.channelSequence.setProperty("org.openscience.cdk.io.chemrss.CHANNEL_TITLE", this.objectTitle);
                this.channelSequence.setProperty("org.openscience.cdk.io.chemrss.CHANNEL_WEBSITE", this.objectLink);
                this.channelSequence.setProperty("org.openscience.cdk.io.chemrss.CHANNEL_DESCRIPTION", this.objectDesc);
                this.channelSequence.setProperty("org.openscience.cdk.io.chemrss.CHANNEL_PUBLISHER", this.dcPublisher);
                this.channelSequence.setProperty("org.openscience.cdk.io.chemrss.CHANNEL_CREATOR", this.dcCreator);
            } else {
                this.logger.debug("Unparsed RSS element: " + local);
            }
        } else {
            this.logger.debug("Unparsed element: " + local);
            this.logger.debug("  uri: " + uri);
        }
        this.cData = "";
    }

    public void startElement(String uri, String local, String raw, Attributes atts) {
        this.logger.debug("<" + raw + ">");
        if (uri.equals("http://www.xml-cml.org/schema/cml2/core")) {
            this.cmlString = this.readdedNamespace ? this.cmlString + this.toStartTag(raw, atts) : this.cmlString + this.toStartTag(raw, atts, uri);
        } else if (local.equals("item") || local.equals("channel")) {
            this.resetStrings();
        }
        this.cData = "";
    }

    private void resetStrings() {
        this.objectTitle = "";
        this.objectDesc = "";
        this.objectDate = "";
        this.objectLink = "";
        this.dcCreator = "";
        this.dcPublisher = "";
    }

    private String toStartTag(String raw, Attributes atts) {
        return this.toStartTag(raw, atts, null);
    }

    private String toStartTag(String raw, Attributes atts, String uri) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(raw);
        for (int i = 0; i < atts.getLength(); ++i) {
            buffer.append(" ");
            String qName = atts.getQName(i);
            buffer.append(qName);
            buffer.append("=\"");
            String value = atts.getValue(i);
            buffer.append(value);
            buffer.append("\"");
        }
        if (uri != null) {
            buffer.append(" ");
            if (raw.indexOf(":") != -1) {
                buffer.append("xmlns:");
                String namespace = raw.substring(0, raw.indexOf(":"));
                buffer.append(namespace);
            } else {
                buffer.append("xmlns");
            }
            buffer.append("=\"");
            buffer.append(uri);
            buffer.append("\"");
        }
        buffer.append(">");
        return buffer.toString();
    }

    private String toEndTag(String raw) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("</");
        buffer.append(raw);
        buffer.append(">");
        return buffer.toString();
    }
}

