/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.listener;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.ReaderEvent;
import org.openscience.cdk.io.listener.ReaderListener;
import org.openscience.cdk.io.listener.WriterListener;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.OptionIOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;

public class SwingGUIListener
implements ReaderListener,
WriterListener {
    private BufferedReader in;
    private Component frame = null;
    private int level = 0;

    public SwingGUIListener(Component frame, int level) {
        this.level = level;
        this.frame = frame;
        this.setInputReader(new InputStreamReader(System.in));
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setInputReader(Reader reader) {
        this.in = reader instanceof BufferedReader ? (BufferedReader)reader : (reader == null ? null : new BufferedReader(reader));
    }

    public void frameRead(ReaderEvent event) {
    }

    public void processIOSettingQuestion(IOSetting setting) {
        if (setting.getLevel() < this.level) {
            String answer = setting.getSetting();
            if (setting instanceof BooleanIOSetting) {
                BooleanIOSetting boolSet = (BooleanIOSetting)setting;
                int n = JOptionPane.showConfirmDialog(this.frame, setting.getQuestion(), setting.getName(), 0);
                if (n == 0) {
                    answer = "true";
                } else if (n == 1) {
                    answer = "false";
                }
            } else if (setting instanceof OptionIOSetting) {
                OptionIOSetting optionSetting = (OptionIOSetting)setting;
                Vector settings = optionSetting.getOptions();
                Enumeration elements = settings.elements();
                Object[] options = new Object[settings.size()];
                for (int i = 0; i < options.length; ++i) {
                    options[i] = elements.nextElement();
                }
                int n = JOptionPane.showOptionDialog(this.frame, setting.getQuestion(), setting.getName(), -1, 3, null, options, setting.getSetting());
                answer = (String)options[n];
            } else if (setting instanceof StringIOSetting) {
                StringIOSetting stringSetting = (StringIOSetting)setting;
                answer = JOptionPane.showInputDialog(this.frame, setting.getQuestion(), setting.getName(), 3, null, null, setting.getSetting()).toString();
            } else {
                answer = JOptionPane.showInputDialog(this.frame, setting.getQuestion(), setting.getName(), 3, null, null, setting.getSetting()).toString();
            }
            try {
                setting.setSetting(answer);
            }
            catch (CDKException cDKException) {
                // empty catch block
            }
        }
    }
}

