/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.Enumeration;
import java.util.Vector;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class ChemSequenceManipulator {
    public static AtomContainer getAllInOneContainer(ChemSequence sequence) {
        AtomContainer container = new AtomContainer();
        for (int i = 0; i < sequence.getChemModelCount(); ++i) {
            ChemModel model = sequence.getChemModel(i);
            container.add(ChemModelManipulator.getAllInOneContainer(model));
        }
        return container;
    }

    public static AtomContainer[] getAllAtomContainers(ChemSequence sequence) {
        ChemModel[] models = sequence.getChemModels();
        int acCount = 0;
        Vector<AtomContainer[]> acArrays = new Vector<AtomContainer[]>();
        for (int i = 0; i < models.length; ++i) {
            AtomContainer[] modelContainers = ChemModelManipulator.getAllAtomContainers(models[i]);
            acArrays.addElement(modelContainers);
            acCount += modelContainers.length;
        }
        AtomContainer[] containers = new AtomContainer[acCount];
        int arrayOffset = 0;
        Enumeration acArraysElements = acArrays.elements();
        while (acArraysElements.hasMoreElements()) {
            AtomContainer[] modelContainers = (AtomContainer[])acArraysElements.nextElement();
            System.arraycopy(modelContainers, 0, containers, arrayOffset, modelContainers.length);
            arrayOffset += modelContainers.length;
        }
        return containers;
    }
}

