/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openscience.jmol.app.GuiMap;
import org.openscience.jmol.app.Jmol;
import org.openscience.jmol.app.StatusBar;
import org.openscience.jmol.viewer.JmolViewer;

public class DisplayPanel
extends JPanel
implements ComponentListener,
Printable {
    private StatusBar status;
    private GuiMap guimap;
    private JmolViewer viewer;
    private String displaySpeed;
    private boolean showPaintTime = true;
    private final Dimension dimSize = new Dimension();
    private final Rectangle rectClip = new Rectangle();
    private DeleteAction deleteAction = new DeleteAction();
    private PickAction pickAction = new PickAction();
    private RotateAction rotateAction = new RotateAction();
    private ZoomAction zoomAction = new ZoomAction();
    private XlateAction xlateAction = new XlateAction();
    private HomeAction homeAction = new HomeAction();
    private FrontAction frontAction = new FrontAction();
    private TopAction topAction = new TopAction();
    private BottomAction bottomAction = new BottomAction();
    private RightAction rightAction = new RightAction();
    private LeftAction leftAction = new LeftAction();
    private DefineCenterAction defineCenterAction = new DefineCenterAction();
    private aChargeColorAction acchargeAction = new aChargeColorAction();
    private aAtomTypeColorAction actypeAction = new aAtomTypeColorAction();
    private HydrogensAction hydrogensAction = new HydrogensAction();
    private MeasurementsAction measurementsAction = new MeasurementsAction();
    private SelectallAction selectallAction = new SelectallAction();
    private DeselectallAction deselectallAction = new DeselectallAction();
    private WireFrameRotationAction wireframerotationAction = new WireFrameRotationAction();
    private PerspectiveAction perspectiveAction = new PerspectiveAction();
    private AxesAction axesAction = new AxesAction();
    private BoundboxAction boundboxAction = new BoundboxAction();
    MenuListener menuListener = new MenuListener(){

        public void menuSelected(MenuEvent e) {
            String menuKey = DisplayPanel.this.guimap.getKey(e.getSource());
            if (menuKey.equals("display")) {
                DisplayPanel.this.setDisplayMenuState();
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    };
    private static int timeLast = 0;
    private static int timeCount;
    private static int timeTotal;
    private long timeBegin;
    private int lastMotionEventNumber;
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public static final int Z_AXIS = 3;

    public DisplayPanel(StatusBar status, GuiMap guimap) {
        this.status = status;
        this.guimap = guimap;
        if (System.getProperty("painttime", "false").equals("true")) {
            this.showPaintTime = true;
        }
        this.displaySpeed = System.getProperty("display.speed");
        if (this.displaySpeed == null) {
            this.displaySpeed = "ms";
        }
        this.setDoubleBuffered(false);
    }

    public void setViewer(JmolViewer viewer) {
        this.viewer = viewer;
        viewer.setScreenDimension(this.getSize(this.dimSize));
    }

    public void start() {
        this.addComponentListener(this);
    }

    private void setRotateMode() {
        Jmol.setRotateButton();
        this.viewer.setModeMouse(0);
        this.viewer.setSelectionHaloEnabled(false);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.updateSize();
    }

    public void componentShown(ComponentEvent e) {
        this.updateSize();
    }

    private void updateSize() {
        this.viewer.setScreenDimension(this.getSize(this.dimSize));
        this.setRotateMode();
    }

    public void paint(Graphics g) {
        if (this.showPaintTime) {
            this.startPaintClock();
        }
        g.getClipBounds(this.rectClip);
        this.viewer.renderScreenImage(g, this.dimSize, this.rectClip);
        if (this.showPaintTime) {
            this.stopPaintClock();
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        int pageHeight;
        float scaleHeight;
        float scale;
        Graphics2D g2 = (Graphics2D)g;
        if (pageIndex > 0) {
            return 1;
        }
        this.rectClip.y = 0;
        this.rectClip.x = 0;
        int screenWidth = this.rectClip.width = this.viewer.getScreenWidth();
        int screenHeight = this.rectClip.height = this.viewer.getScreenHeight();
        Image image = this.viewer.getScreenImage();
        int pageX = (int)pf.getImageableX();
        int pageY = (int)pf.getImageableY();
        int pageWidth = (int)pf.getImageableWidth();
        float scaleWidth = (float)pageWidth / (float)screenWidth;
        float f = scale = scaleWidth < (scaleHeight = (float)(pageHeight = (int)pf.getImageableHeight()) / (float)screenHeight) ? scaleWidth : scaleHeight;
        if (scale < 1.0f) {
            int width = (int)((float)screenWidth * scale);
            int height = (int)((float)screenHeight * scale);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(image, pageX, pageY, width, height, null);
        } else {
            g2.drawImage(image, pageX, pageY, null);
        }
        this.viewer.releaseScreenImage();
        return 0;
    }

    public MenuListener getMenuListener() {
        return this.menuListener;
    }

    private void setDisplayMenuState() {
        this.guimap.setSelected("perspectiveCheck", this.viewer.getPerspectiveDepth());
        this.guimap.setSelected("hydrogensCheck", this.viewer.getShowHydrogens());
        this.guimap.setSelected("measurementsCheck", this.viewer.getShowMeasurements());
        this.guimap.setSelected("axesCheck", this.viewer.getShapeShow(15));
        this.guimap.setSelected("boundboxCheck", this.viewer.getShapeShow(16));
    }

    public Action[] getActions() {
        Action[] defaultActions = new Action[]{this.deleteAction, this.pickAction, this.rotateAction, this.zoomAction, this.xlateAction, this.frontAction, this.topAction, this.bottomAction, this.rightAction, this.leftAction, this.defineCenterAction, this.hydrogensAction, this.measurementsAction, this.selectallAction, this.deselectallAction, this.homeAction, this.wireframerotationAction, this.perspectiveAction, this.axesAction, this.boundboxAction, this.acchargeAction, this.actypeAction};
        return defaultActions;
    }

    private void resetTimes() {
        timeTotal = 0;
        timeCount = 0;
        timeLast = -1;
    }

    private void recordTime(int time) {
        if (timeLast != -1) {
            timeTotal += timeLast;
            ++timeCount;
        }
        timeLast = time;
    }

    private void startPaintClock() {
        this.timeBegin = System.currentTimeMillis();
        int motionEventNumber = this.viewer.motionEventNumber;
        if (this.lastMotionEventNumber != motionEventNumber) {
            this.lastMotionEventNumber = motionEventNumber;
            this.resetTimes();
        }
    }

    private void stopPaintClock() {
        int time = (int)(System.currentTimeMillis() - this.timeBegin);
        this.recordTime(time);
        this.showTimes();
    }

    private String fmt(int num) {
        if (num < 0) {
            return "---";
        }
        if (num < 10) {
            return "  " + num;
        }
        if (num < 100) {
            return " " + num;
        }
        return "" + num;
    }

    private void showTimes() {
        int timeAverage;
        int n = timeAverage = timeCount == 0 ? -1 : (timeTotal + timeCount / 2) / timeCount;
        if (this.displaySpeed.equalsIgnoreCase("fps")) {
            this.status.setStatus(3, this.fmt(1000 / timeLast) + "FPS : " + this.fmt(1000 / timeAverage) + "FPS");
        } else {
            this.status.setStatus(3, this.fmt(timeLast) + "ms : " + this.fmt(timeAverage) + "ms");
        }
    }

    public void rotate(int axis, double angle) {
        if (axis == 1) {
            this.viewer.rotateToX((float)Math.toRadians(angle));
        } else if (axis == 2) {
            this.viewer.rotateToY((float)Math.toRadians(angle));
        } else if (axis == 3) {
            this.viewer.rotateToZ((float)Math.toRadians(angle));
        }
    }

    class BoundboxAction
    extends AbstractAction {
        public BoundboxAction() {
            super("boundboxCheck");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
            DisplayPanel.this.viewer.setShapeShow(16, cbmi.isSelected());
        }
    }

    class AxesAction
    extends AbstractAction {
        public AxesAction() {
            super("axesCheck");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
            DisplayPanel.this.viewer.setShapeShow(15, cbmi.isSelected());
        }
    }

    class PerspectiveAction
    extends AbstractAction {
        public PerspectiveAction() {
            super("perspectiveCheck");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
            DisplayPanel.this.viewer.setPerspectiveDepth(cbmi.isSelected());
        }
    }

    class WireFrameRotationAction
    extends AbstractAction {
        public WireFrameRotationAction() {
            super("wireframerotationCheck");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
            DisplayPanel.this.viewer.setWireframeRotation(cbmi.isSelected());
        }
    }

    class HomeAction
    extends AbstractAction {
        public HomeAction() {
            super("home");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.homePosition();
            DisplayPanel.this.setRotateMode();
        }
    }

    class DefineCenterAction
    extends AbstractAction {
        public DefineCenterAction() {
            super("definecenter");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.setCenterBitSet(DisplayPanel.this.viewer.getBitSetSelection());
            DisplayPanel.this.setRotateMode();
            DisplayPanel.this.viewer.setSelectionHaloEnabled(false);
        }
    }

    class LeftAction
    extends AbstractAction {
        public LeftAction() {
            super("left");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.rotateToY(-90);
        }
    }

    class RightAction
    extends AbstractAction {
        public RightAction() {
            super("right");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.rotateToY(90);
        }
    }

    class BottomAction
    extends AbstractAction {
        public BottomAction() {
            super("bottom");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.rotateToX(-90);
        }
    }

    class TopAction
    extends AbstractAction {
        public TopAction() {
            super("top");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.rotateToX(90);
        }
    }

    class FrontAction
    extends AbstractAction {
        public FrontAction() {
            super("front");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.rotateFront();
        }
    }

    class XlateAction
    extends AbstractAction {
        public XlateAction() {
            super("xlate");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.setModeMouse(2);
            DisplayPanel.this.viewer.setSelectionHaloEnabled(false);
            DisplayPanel.this.status.setStatus(1, ((JComponent)e.getSource()).getToolTipText());
        }
    }

    class ZoomAction
    extends AbstractAction {
        public ZoomAction() {
            super("zoom");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.setModeMouse(1);
            DisplayPanel.this.viewer.setSelectionHaloEnabled(false);
            DisplayPanel.this.status.setStatus(1, ((JComponent)e.getSource()).getToolTipText());
        }
    }

    class RotateAction
    extends AbstractAction {
        public RotateAction() {
            super("rotate");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.setModeMouse(0);
            DisplayPanel.this.viewer.setSelectionHaloEnabled(false);
            DisplayPanel.this.status.setStatus(1, ((JComponent)e.getSource()).getToolTipText());
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("delete");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.setModeMouse(4);
            DisplayPanel.this.viewer.setSelectionHaloEnabled(false);
            DisplayPanel.this.status.setStatus(1, "Delete Atoms");
        }
    }

    class PickAction
    extends AbstractAction {
        public PickAction() {
            super("pick");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.setModeMouse(3);
            DisplayPanel.this.viewer.setSelectionHaloEnabled(true);
            DisplayPanel.this.status.setStatus(1, "Select Atoms");
        }
    }

    class aAtomTypeColorAction
    extends AbstractAction {
        public aAtomTypeColorAction() {
            super("actype");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.setModeAtomColorProfile((byte)0);
        }
    }

    class aChargeColorAction
    extends AbstractAction {
        public aChargeColorAction() {
            super("accharge");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.viewer.setModeAtomColorProfile((byte)1);
        }
    }

    class DeselectallAction
    extends AbstractAction {
        public DeselectallAction() {
            super("deselectall");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (DisplayPanel.this.viewer.haveFrame()) {
                DisplayPanel.this.viewer.clearSelection();
            }
        }
    }

    class SelectallAction
    extends AbstractAction {
        public SelectallAction() {
            super("selectall");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (DisplayPanel.this.viewer.haveFrame()) {
                DisplayPanel.this.viewer.selectAll();
            }
        }
    }

    class MeasurementsAction
    extends AbstractAction {
        public MeasurementsAction() {
            super("measurementsCheck");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
            DisplayPanel.this.viewer.setShowMeasurements(cbmi.isSelected());
        }
    }

    class HydrogensAction
    extends AbstractAction {
        public HydrogensAction() {
            super("hydrogensCheck");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
            DisplayPanel.this.viewer.setShowHydrogens(cbmi.isSelected());
        }
    }
}

